package litifer.com.sdk.data.local;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.preference.PreferenceManager;


import static android.content.Context.MODE_PRIVATE;

/**
 * Created by kishlaykishore on 11/04/17.
 */

public class LitiferSharedPreferences {
    private static final String MY_PREFS_NAME = "MyPrefsFile";

    Context pref;
    private static SharedPreferences mSharedPreferences;
    private static LitiferSharedPreferences litiferSharedPreferences;

    private LitiferSharedPreferences(){
    }


    public static LitiferSharedPreferences getInstance(Context context) {
        if (litiferSharedPreferences ==null){
            litiferSharedPreferences=new LitiferSharedPreferences();
        }
        mSharedPreferences = PreferenceManager.getDefaultSharedPreferences(context);

        return litiferSharedPreferences;
    }

    public void storeKey(String key,String value) {
        Editor mEditor=mSharedPreferences.edit();
        mEditor.putString(key, value).apply();
    }

    public String retrieveKey(String key) {
        return mSharedPreferences.getString(key, null);
    }

    public static void storeGlobalkeys(Context context, Intent intent){
        Editor mEditor  = context.getSharedPreferences("GLOBAL_VARIABLES",MODE_PRIVATE).edit();
        mEditor.commit();

        System.out.println("Global Key Stored.");
    }

    public static String retrieveGlobalKey(Context context,String key){
        android.content.SharedPreferences mSharedPreferences= context.getSharedPreferences("GLOBAL_VARIABLES",MODE_PRIVATE);
        return mSharedPreferences.getString(key,"Value Not Set Yet");
    }
}
