package litifer.com.sdk.data.exeption;

import android.content.Context;

import litifer.com.sdk.data.exeption.NetworkConnectionException;
import litifer.com.sdk.data.exeption.UserNotFoundException;

/**
 * Created by kishlaykishore on 08/03/17.
 */

public class ErrorMessageFactory {
    private ErrorMessageFactory() {
        //empty
    }

    /**
     * Creates a String representing an error message.
     *
     * @param context Context needed to retrieve string resources.
     * @param exception An exception used as a condition to retrieve the correct error message.
     * @return {@link String} an error message.
     */
    public static String create(Context context, Exception exception) {
        String message = "";

        if (exception instanceof NetworkConnectionException) {
            message = "No internet connection exception";
        } else if (exception instanceof UserNotFoundException) {
            message = "User not found check internet connection";
        } else if (exception instanceof ApplicationNotSetException){
            message = "Please provide both Application Id and Application Secret.";
        }

        return message;
    }
}
