/*
 * Decompiled with CFR 0.152.
 */
package lighttunnel.openapi.ext;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import lighttunnel.base.util.HttpUtil;
import lighttunnel.openapi.TunnelRequest;
import lighttunnel.openapi.ext.TunnelRequestKt;
import lighttunnel.openapi.http.HttpTunnelRequestInterceptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0080\u0001\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2A\u0010\u0011\u001a=\u0012\u0004\u0012\u00020\u0013\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\n0\u0012\u00a2\u0006\u0002\b\u0017H\u0082\bJ(\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J(\u0010\u0019\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\"\u0010\u001a\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u001e"}, d2={"Llighttunnel/openapi/ext/HttpTunnelRequestInterceptorDefaultImpl;", "Llighttunnel/openapi/http/HttpTunnelRequestInterceptor;", "()V", "handleHttpBasicAuth", "Lio/netty/handler/codec/http/FullHttpResponse;", "tunnelRequest", "Llighttunnel/openapi/TunnelRequest;", "httpRequest", "Lio/netty/handler/codec/http/FullHttpRequest;", "handleProxyHttpHeaders", "", "pxyHeaders", "", "", "localAddress", "Ljava/net/SocketAddress;", "remoteAddress", "apply", "Lkotlin/Function3;", "Lio/netty/handler/codec/http/HttpHeaders;", "Lkotlin/ParameterName;", "name", "value", "Lkotlin/ExtensionFunctionType;", "handleRewriteHttpHeaders", "handleWriteHttpHeaders", "intercept", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "Companion", "server"})
public final class HttpTunnelRequestInterceptorDefaultImpl
implements HttpTunnelRequestInterceptor {
    private static final String MAGIC_VALUE_REMOTE_ADDR = "$remote_addr";
    public static final Companion Companion = new Companion(null);

    @Nullable
    public FullHttpResponse intercept(@NotNull ChannelHandlerContext ctx, @NotNull TunnelRequest tunnelRequest, @NotNull FullHttpRequest httpRequest) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Intrinsics.checkParameterIsNotNull((Object)tunnelRequest, (String)"tunnelRequest");
        Intrinsics.checkParameterIsNotNull((Object)httpRequest, (String)"httpRequest");
        SocketAddress localAddress = ctx.channel().localAddress();
        SocketAddress remoteAddress = ctx.channel().remoteAddress();
        SocketAddress socketAddress = localAddress;
        Intrinsics.checkExpressionValueIsNotNull((Object)socketAddress, (String)"localAddress");
        SocketAddress socketAddress2 = remoteAddress;
        Intrinsics.checkExpressionValueIsNotNull((Object)socketAddress2, (String)"remoteAddress");
        this.handleRewriteHttpHeaders(socketAddress, socketAddress2, tunnelRequest, httpRequest);
        this.handleWriteHttpHeaders(localAddress, remoteAddress, tunnelRequest, httpRequest);
        return TunnelRequestKt.getEnableBasicAuth((TunnelRequest)tunnelRequest) ? this.handleHttpBasicAuth(tunnelRequest, httpRequest) : null;
    }

    private final FullHttpResponse handleHttpBasicAuth(TunnelRequest tunnelRequest, FullHttpRequest httpRequest) {
        String[] account = HttpUtil.INSTANCE.getBasicAuthorization((HttpRequest)httpRequest);
        String username = TunnelRequestKt.getBasicAuthUsername((TunnelRequest)tunnelRequest);
        String password = TunnelRequestKt.getBasicAuthPassword((TunnelRequest)tunnelRequest);
        if (account == null || Intrinsics.areEqual((Object)username, (Object)account[0]) ^ true || Intrinsics.areEqual((Object)password, (Object)account[1]) ^ true) {
            DefaultFullHttpResponse httpResponse = new DefaultFullHttpResponse(httpRequest.protocolVersion(), HttpResponseStatus.UNAUTHORIZED);
            String string = HttpResponseStatus.UNAUTHORIZED.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"HttpResponseStatus.UNAUTHORIZED.toString()");
            String string2 = string;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
            Charset charset2 = charset;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string3.getBytes(charset2);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] content = byArray;
            httpResponse.headers().add((CharSequence)HttpHeaderNames.WWW_AUTHENTICATE, (Object)("Basic realm=\"" + TunnelRequestKt.getBasicAuthRealm((TunnelRequest)tunnelRequest) + '\"'));
            httpResponse.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)"keep-alive");
            httpResponse.headers().add((CharSequence)HttpHeaderNames.ACCEPT_RANGES, (Object)"bytes");
            httpResponse.headers().add((CharSequence)HttpHeaderNames.DATE, (Object)new Date().toString());
            httpResponse.headers().add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)content.length);
            httpResponse.content().writeBytes(content);
            return (FullHttpResponse)httpResponse;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final void handleRewriteHttpHeaders(SocketAddress localAddress, SocketAddress remoteAddress, TunnelRequest tunnelRequest, FullHttpRequest httpRequest) {
        HttpTunnelRequestInterceptorDefaultImpl httpTunnelRequestInterceptorDefaultImpl = this;
        Map pxyHeaders$iv = TunnelRequestKt.getPxyAddHeaders((TunnelRequest)tunnelRequest);
        boolean $i$f$handleProxyHttpHeaders = false;
        if (!pxyHeaders$iv.isEmpty()) {
            for (Map.Entry it$iv : pxyHeaders$iv.entrySet()) {
                void value;
                void name;
                HttpHeaders $this$handleProxyHttpHeaders;
                String string;
                String name$iv = (String)it$iv.getKey();
                String string2 = (String)it$iv.getValue();
                switch (string2.hashCode()) {
                    case -1717118554: {
                        if (string2.equals(MAGIC_VALUE_REMOTE_ADDR)) {
                            if (remoteAddress instanceof InetSocketAddress) {
                                string = ((InetSocketAddress)remoteAddress).getAddress().toString();
                                break;
                            }
                            string = null;
                            break;
                        }
                    }
                    default: {
                        string = (String)it$iv.getValue();
                    }
                }
                if (string == null) {
                    continue;
                }
                String value$iv = string;
                Intrinsics.checkExpressionValueIsNotNull((Object)httpRequest.headers(), (String)"httpRequest.headers()");
                String string3 = value$iv;
                String string4 = name$iv;
                boolean bl = false;
                $this$handleProxyHttpHeaders.add((String)name, (Object)value);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleWriteHttpHeaders(SocketAddress localAddress, SocketAddress remoteAddress, TunnelRequest tunnelRequest, FullHttpRequest httpRequest) {
        HttpTunnelRequestInterceptorDefaultImpl httpTunnelRequestInterceptorDefaultImpl = this;
        Map pxyHeaders$iv = TunnelRequestKt.getPxySetHeaders((TunnelRequest)tunnelRequest);
        boolean $i$f$handleProxyHttpHeaders = false;
        if (!pxyHeaders$iv.isEmpty()) {
            for (Map.Entry it$iv : pxyHeaders$iv.entrySet()) {
                void value;
                void name;
                HttpHeaders $this$handleProxyHttpHeaders;
                String string;
                String name$iv = (String)it$iv.getKey();
                String string2 = (String)it$iv.getValue();
                switch (string2.hashCode()) {
                    case -1717118554: {
                        if (string2.equals(MAGIC_VALUE_REMOTE_ADDR)) {
                            if (remoteAddress instanceof InetSocketAddress) {
                                string = ((InetSocketAddress)remoteAddress).getAddress().toString();
                                break;
                            }
                            string = null;
                            break;
                        }
                    }
                    default: {
                        string = (String)it$iv.getValue();
                    }
                }
                if (string == null) {
                    continue;
                }
                String value$iv = string;
                Intrinsics.checkExpressionValueIsNotNull((Object)httpRequest.headers(), (String)"httpRequest.headers()");
                String string3 = value$iv;
                String string4 = name$iv;
                boolean bl = false;
                if (!$this$handleProxyHttpHeaders.contains((String)name)) continue;
                $this$handleProxyHttpHeaders.set((String)name, (Object)value);
            }
        }
    }

    private final void handleProxyHttpHeaders(Map<String, String> pxyHeaders, SocketAddress localAddress, SocketAddress remoteAddress, TunnelRequest tunnelRequest, FullHttpRequest httpRequest, Function3<? super HttpHeaders, ? super String, ? super String, Unit> apply) {
        int $i$f$handleProxyHttpHeaders = 0;
        if (pxyHeaders.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> it : pxyHeaders.entrySet()) {
            String string;
            String name = it.getKey();
            String string2 = it.getValue();
            switch (string2.hashCode()) {
                case -1717118554: {
                    if (string2.equals(MAGIC_VALUE_REMOTE_ADDR)) {
                        if (remoteAddress instanceof InetSocketAddress) {
                            string = ((InetSocketAddress)remoteAddress).getAddress().toString();
                            break;
                        }
                        string = null;
                        break;
                    }
                }
                default: {
                    string = it.getValue();
                }
            }
            if (string == null) {
                continue;
            }
            String value = string;
            HttpHeaders httpHeaders = httpRequest.headers();
            Intrinsics.checkExpressionValueIsNotNull((Object)httpHeaders, (String)"httpRequest.headers()");
            apply.invoke((Object)httpHeaders, (Object)name, (Object)value);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Llighttunnel/openapi/ext/HttpTunnelRequestInterceptorDefaultImpl$Companion;", "", "()V", "MAGIC_VALUE_REMOTE_ADDR", "", "server"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

