/*
 * Decompiled with CFR 0.152.
 */
package lighttunnel.openapi.ext;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import lighttunnel.base.util.-HttpUtilKt;
import lighttunnel.openapi.TunnelRequest;
import lighttunnel.openapi.ext.TunnelRequestKt;
import lighttunnel.openapi.http.HttpContext;
import lighttunnel.openapi.http.HttpTunnelRequestInterceptor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0080\u0001\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2A\u0010\u0015\u001a=\u0012\u0004\u0012\u00020\u0017\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u0019\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u000e0\u0016\u00a2\u0006\u0002\b\u001bH\u0082\bJ(\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J(\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u001f"}, d2={"Llighttunnel/openapi/ext/HttpTunnelRequestInterceptorDefaultImpl;", "Llighttunnel/openapi/http/HttpTunnelRequestInterceptor;", "()V", "doHttpRequest", "", "ctx", "Llighttunnel/openapi/http/HttpContext;", "httpRequest", "Lio/netty/handler/codec/http/HttpRequest;", "tunnelRequest", "Llighttunnel/openapi/TunnelRequest;", "handleHttpBasicAuth", "chain", "handleProxyHttpHeaders", "", "pxyHeaders", "", "", "localAddress", "Ljava/net/SocketAddress;", "remoteAddress", "apply", "Lkotlin/Function3;", "Lio/netty/handler/codec/http/HttpHeaders;", "Lkotlin/ParameterName;", "name", "value", "Lkotlin/ExtensionFunctionType;", "handleRewriteHttpHeaders", "handleWriteHttpHeaders", "Companion", "server"})
public final class HttpTunnelRequestInterceptorDefaultImpl
implements HttpTunnelRequestInterceptor {
    private static final String MAGIC_VALUE_REMOTE_ADDR = "$remote_addr";
    public static final Companion Companion = new Companion(null);

    public boolean doHttpRequest(@NotNull HttpContext ctx, @NotNull HttpRequest httpRequest, @NotNull TunnelRequest tunnelRequest) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        Intrinsics.checkNotNullParameter((Object)tunnelRequest, (String)"tunnelRequest");
        SocketAddress socketAddress = ctx.getLocalAddress();
        if (socketAddress == null) {
            return false;
        }
        SocketAddress localAddress = socketAddress;
        SocketAddress socketAddress2 = ctx.getRemoteAddress();
        if (socketAddress2 == null) {
            return false;
        }
        SocketAddress remoteAddress = socketAddress2;
        this.handleRewriteHttpHeaders(localAddress, remoteAddress, tunnelRequest, httpRequest);
        this.handleWriteHttpHeaders(localAddress, remoteAddress, tunnelRequest, httpRequest);
        return TunnelRequestKt.getEnableBasicAuth((TunnelRequest)tunnelRequest) && this.handleHttpBasicAuth(ctx, tunnelRequest, httpRequest);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean handleHttpBasicAuth(HttpContext chain, TunnelRequest tunnelRequest, HttpRequest httpRequest) {
        Pair account = -HttpUtilKt.getBasicAuthorization((HttpRequest)httpRequest);
        String username = TunnelRequestKt.getBasicAuthUsername((TunnelRequest)tunnelRequest);
        String password = TunnelRequestKt.getBasicAuthPassword((TunnelRequest)tunnelRequest);
        if (account == null || Intrinsics.areEqual((Object)username, (Object)((String)account.getFirst())) ^ true || Intrinsics.areEqual((Object)password, (Object)((String)account.getSecond())) ^ true) {
            void $this$apply;
            String string = HttpResponseStatus.UNAUTHORIZED.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"HttpResponseStatus.UNAUTHORIZED.toString()");
            String string2 = string;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"StandardCharsets.UTF_8");
            Charset charset2 = charset;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string3.getBytes(charset2);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] content = byArray;
            string2 = new DefaultHttpResponse(httpRequest.protocolVersion(), HttpResponseStatus.UNAUTHORIZED);
            boolean bl2 = false;
            bl = false;
            String string4 = string2;
            HttpContext httpContext = chain;
            boolean bl3 = false;
            $this$apply.headers().add((CharSequence)HttpHeaderNames.WWW_AUTHENTICATE, (Object)("Basic realm=\"" + TunnelRequestKt.getBasicAuthRealm((TunnelRequest)tunnelRequest) + '\"'));
            $this$apply.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            $this$apply.headers().add((CharSequence)HttpHeaderNames.ACCEPT_RANGES, (Object)HttpHeaderValues.BYTES);
            $this$apply.headers().add((CharSequence)HttpHeaderNames.DATE, (Object)new Date().toString());
            $this$apply.headers().add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)content.length);
            Unit unit = Unit.INSTANCE;
            HttpContext.DefaultImpls.write$default((HttpContext)httpContext, (HttpResponse)((HttpResponse)string2), (boolean)false, null, (int)6, null);
            HttpContext.DefaultImpls.write$default((HttpContext)chain, (HttpContent)((HttpContent)new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])content))), (boolean)false, null, (int)6, null);
            LastHttpContent lastHttpContent = LastHttpContent.EMPTY_LAST_CONTENT;
            Intrinsics.checkNotNullExpressionValue((Object)lastHttpContent, (String)"LastHttpContent.EMPTY_LAST_CONTENT");
            HttpContext.DefaultImpls.write$default((HttpContext)chain, (HttpContent)((HttpContent)lastHttpContent), (boolean)true, null, (int)4, null);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final void handleRewriteHttpHeaders(SocketAddress localAddress, SocketAddress remoteAddress, TunnelRequest tunnelRequest, HttpRequest httpRequest) {
        HttpTunnelRequestInterceptorDefaultImpl httpTunnelRequestInterceptorDefaultImpl = this;
        Map pxyHeaders$iv = TunnelRequestKt.getPxyAddHeaders((TunnelRequest)tunnelRequest);
        boolean $i$f$handleProxyHttpHeaders = false;
        if (!pxyHeaders$iv.isEmpty()) {
            for (Map.Entry it$iv : pxyHeaders$iv.entrySet()) {
                void value;
                void name;
                HttpHeaders $this$handleProxyHttpHeaders;
                String string;
                String name$iv = (String)it$iv.getKey();
                String string2 = (String)it$iv.getValue();
                switch (string2.hashCode()) {
                    case -1717118554: {
                        if (string2.equals(MAGIC_VALUE_REMOTE_ADDR)) {
                            if (remoteAddress instanceof InetSocketAddress) {
                                string = ((InetSocketAddress)remoteAddress).getAddress().toString();
                                break;
                            }
                            string = null;
                            break;
                        }
                    }
                    default: {
                        string = (String)it$iv.getValue();
                    }
                }
                if (string == null) {
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"when (it.value) {\n      \u2026            } ?: continue");
                String value$iv = string;
                Intrinsics.checkNotNullExpressionValue((Object)httpRequest.headers(), (String)"httpRequest.headers()");
                String string3 = value$iv;
                String string4 = name$iv;
                boolean bl = false;
                $this$handleProxyHttpHeaders.add((String)name, (Object)value);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleWriteHttpHeaders(SocketAddress localAddress, SocketAddress remoteAddress, TunnelRequest tunnelRequest, HttpRequest httpRequest) {
        HttpTunnelRequestInterceptorDefaultImpl httpTunnelRequestInterceptorDefaultImpl = this;
        Map pxyHeaders$iv = TunnelRequestKt.getPxySetHeaders((TunnelRequest)tunnelRequest);
        boolean $i$f$handleProxyHttpHeaders = false;
        if (!pxyHeaders$iv.isEmpty()) {
            for (Map.Entry it$iv : pxyHeaders$iv.entrySet()) {
                void value;
                void name;
                HttpHeaders $this$handleProxyHttpHeaders;
                String string;
                String name$iv = (String)it$iv.getKey();
                String string2 = (String)it$iv.getValue();
                switch (string2.hashCode()) {
                    case -1717118554: {
                        if (string2.equals(MAGIC_VALUE_REMOTE_ADDR)) {
                            if (remoteAddress instanceof InetSocketAddress) {
                                string = ((InetSocketAddress)remoteAddress).getAddress().toString();
                                break;
                            }
                            string = null;
                            break;
                        }
                    }
                    default: {
                        string = (String)it$iv.getValue();
                    }
                }
                if (string == null) {
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"when (it.value) {\n      \u2026            } ?: continue");
                String value$iv = string;
                Intrinsics.checkNotNullExpressionValue((Object)httpRequest.headers(), (String)"httpRequest.headers()");
                String string3 = value$iv;
                String string4 = name$iv;
                boolean bl = false;
                if (!$this$handleProxyHttpHeaders.contains((String)name)) continue;
                $this$handleProxyHttpHeaders.set((String)name, (Object)value);
            }
        }
    }

    private final void handleProxyHttpHeaders(Map<String, String> pxyHeaders, SocketAddress localAddress, SocketAddress remoteAddress, TunnelRequest tunnelRequest, HttpRequest httpRequest, Function3<? super HttpHeaders, ? super String, ? super String, Unit> apply) {
        int $i$f$handleProxyHttpHeaders = 0;
        if (pxyHeaders.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> it : pxyHeaders.entrySet()) {
            String string;
            String name = it.getKey();
            String string2 = it.getValue();
            switch (string2.hashCode()) {
                case -1717118554: {
                    if (string2.equals(MAGIC_VALUE_REMOTE_ADDR)) {
                        if (remoteAddress instanceof InetSocketAddress) {
                            string = ((InetSocketAddress)remoteAddress).getAddress().toString();
                            break;
                        }
                        string = null;
                        break;
                    }
                }
                default: {
                    string = it.getValue();
                }
            }
            if (string == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"when (it.value) {\n      \u2026            } ?: continue");
            String value = string;
            HttpHeaders httpHeaders = httpRequest.headers();
            Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"httpRequest.headers()");
            apply.invoke((Object)httpHeaders, (Object)name, (Object)value);
        }
    }

    public void doHttpContent(@NotNull HttpContext ctx, @NotNull HttpContent httpContent, @NotNull TunnelRequest tunnelRequest) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)httpContent, (String)"httpContent");
        Intrinsics.checkNotNullParameter((Object)tunnelRequest, (String)"tunnelRequest");
        HttpTunnelRequestInterceptor.DefaultImpls.doHttpContent((HttpTunnelRequestInterceptor)this, (HttpContext)ctx, (HttpContent)httpContent, (TunnelRequest)tunnelRequest);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Llighttunnel/openapi/ext/HttpTunnelRequestInterceptorDefaultImpl$Companion;", "", "()V", "MAGIC_VALUE_REMOTE_ADDR", "", "server"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

