/*
 * Decompiled with CFR 0.152.
 */
package lighttunnel.openapi.ext;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import lighttunnel.base.util.-HttpUtilKt;
import lighttunnel.openapi.TunnelRequest;
import lighttunnel.openapi.ext.TunnelRequestKt;
import lighttunnel.openapi.http.HttpContext;
import lighttunnel.openapi.http.HttpTunnelRequestInterceptor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 !2\u00020\u0001:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0080\u0001\u0010\u0011\u001a\u00020\u00042\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2A\u0010\u0018\u001a=\u0012\u0004\u0012\u00020\u001a\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001c\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d\u0012\u0004\u0012\u00020\u00040\u0019\u00a2\u0006\u0002\b\u001eH\u0082\bJ(\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J(\u0010 \u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\""}, d2={"Llighttunnel/openapi/ext/HttpTunnelRequestInterceptorDefaultImpl;", "Llighttunnel/openapi/http/HttpTunnelRequestInterceptor;", "()V", "doHttpContent", "", "ctx", "Llighttunnel/openapi/http/HttpContext;", "httpContent", "Lio/netty/handler/codec/http/HttpContent;", "tunnelRequest", "Llighttunnel/openapi/TunnelRequest;", "doHttpRequest", "", "httpRequest", "Lio/netty/handler/codec/http/HttpRequest;", "handleHttpBasicAuth", "chain", "handleProxyHttpHeaders", "pxyHeaders", "", "", "localAddress", "Ljava/net/SocketAddress;", "remoteAddress", "apply", "Lkotlin/Function3;", "Lio/netty/handler/codec/http/HttpHeaders;", "Lkotlin/ParameterName;", "name", "value", "Lkotlin/ExtensionFunctionType;", "handleRewriteHttpHeaders", "handleWriteHttpHeaders", "Companion", "server"})
public final class HttpTunnelRequestInterceptorDefaultImpl
implements HttpTunnelRequestInterceptor {
    private static final String MAGIC_VALUE_REMOTE_ADDR = "$remote_addr";
    public static final Companion Companion = new Companion(null);

    public boolean doHttpRequest(@NotNull HttpContext ctx, @NotNull HttpRequest httpRequest, @NotNull TunnelRequest tunnelRequest) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Intrinsics.checkParameterIsNotNull((Object)httpRequest, (String)"httpRequest");
        Intrinsics.checkParameterIsNotNull((Object)tunnelRequest, (String)"tunnelRequest");
        SocketAddress socketAddress = ctx.getLocalAddress();
        if (socketAddress == null) {
            return false;
        }
        SocketAddress localAddress = socketAddress;
        SocketAddress socketAddress2 = ctx.getRemoteAddress();
        if (socketAddress2 == null) {
            return false;
        }
        SocketAddress remoteAddress = socketAddress2;
        this.handleRewriteHttpHeaders(localAddress, remoteAddress, tunnelRequest, httpRequest);
        this.handleWriteHttpHeaders(localAddress, remoteAddress, tunnelRequest, httpRequest);
        return TunnelRequestKt.getEnableBasicAuth((TunnelRequest)tunnelRequest) && this.handleHttpBasicAuth(ctx, tunnelRequest, httpRequest);
    }

    public void doHttpContent(@NotNull HttpContext ctx, @NotNull HttpContent httpContent, @NotNull TunnelRequest tunnelRequest) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Intrinsics.checkParameterIsNotNull((Object)httpContent, (String)"httpContent");
        Intrinsics.checkParameterIsNotNull((Object)tunnelRequest, (String)"tunnelRequest");
    }

    private final boolean handleHttpBasicAuth(HttpContext chain, TunnelRequest tunnelRequest, HttpRequest httpRequest) {
        Pair account = -HttpUtilKt.getBasicAuthorization((HttpRequest)httpRequest);
        String username = TunnelRequestKt.getBasicAuthUsername((TunnelRequest)tunnelRequest);
        String password = TunnelRequestKt.getBasicAuthPassword((TunnelRequest)tunnelRequest);
        if (account == null || Intrinsics.areEqual((Object)username, (Object)((String)account.getFirst())) ^ true || Intrinsics.areEqual((Object)password, (Object)((String)account.getSecond())) ^ true) {
            String string = HttpResponseStatus.UNAUTHORIZED.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"HttpResponseStatus.UNAUTHORIZED.toString()");
            String string2 = string;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
            Charset charset2 = charset;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string3.getBytes(charset2);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] content = byArray;
            string2 = new DefaultHttpResponse(httpRequest.protocolVersion(), HttpResponseStatus.UNAUTHORIZED);
            HttpContext httpContext = chain;
            boolean bl2 = false;
            bl = false;
            String $this$apply = string2;
            boolean bl3 = false;
            $this$apply.headers().add((CharSequence)HttpHeaderNames.WWW_AUTHENTICATE, (Object)("Basic realm=\"" + TunnelRequestKt.getBasicAuthRealm((TunnelRequest)tunnelRequest) + '\"'));
            $this$apply.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            $this$apply.headers().add((CharSequence)HttpHeaderNames.ACCEPT_RANGES, (Object)HttpHeaderValues.BYTES);
            $this$apply.headers().add((CharSequence)HttpHeaderNames.DATE, (Object)new Date().toString());
            $this$apply.headers().add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)content.length);
            String string4 = string2;
            HttpContext.DefaultImpls.writeHttpResponse$default((HttpContext)httpContext, (HttpResponse)((HttpResponse)string4), (boolean)false, null, (int)6, null);
            HttpContext.DefaultImpls.writeHttpContent$default((HttpContext)chain, (HttpContent)((HttpContent)new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])content))), (boolean)false, null, (int)6, null);
            LastHttpContent lastHttpContent = LastHttpContent.EMPTY_LAST_CONTENT;
            Intrinsics.checkExpressionValueIsNotNull((Object)lastHttpContent, (String)"LastHttpContent.EMPTY_LAST_CONTENT");
            HttpContext.DefaultImpls.writeHttpContent$default((HttpContext)chain, (HttpContent)((HttpContent)lastHttpContent), (boolean)true, null, (int)4, null);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final void handleRewriteHttpHeaders(SocketAddress localAddress, SocketAddress remoteAddress, TunnelRequest tunnelRequest, HttpRequest httpRequest) {
        HttpTunnelRequestInterceptorDefaultImpl httpTunnelRequestInterceptorDefaultImpl = this;
        Map pxyHeaders$iv = TunnelRequestKt.getPxyAddHeaders((TunnelRequest)tunnelRequest);
        boolean $i$f$handleProxyHttpHeaders = false;
        if (!pxyHeaders$iv.isEmpty()) {
            for (Map.Entry it$iv : pxyHeaders$iv.entrySet()) {
                void value;
                void name;
                HttpHeaders $this$handleProxyHttpHeaders;
                String string;
                String name$iv = (String)it$iv.getKey();
                String string2 = (String)it$iv.getValue();
                switch (string2.hashCode()) {
                    case -1717118554: {
                        if (string2.equals(MAGIC_VALUE_REMOTE_ADDR)) {
                            if (remoteAddress instanceof InetSocketAddress) {
                                string = ((InetSocketAddress)remoteAddress).getAddress().toString();
                                break;
                            }
                            string = null;
                            break;
                        }
                    }
                    default: {
                        string = (String)it$iv.getValue();
                    }
                }
                if (string == null) {
                    continue;
                }
                String value$iv = string;
                Intrinsics.checkExpressionValueIsNotNull((Object)httpRequest.headers(), (String)"httpRequest.headers()");
                String string3 = value$iv;
                String string4 = name$iv;
                boolean bl = false;
                $this$handleProxyHttpHeaders.add((String)name, (Object)value);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleWriteHttpHeaders(SocketAddress localAddress, SocketAddress remoteAddress, TunnelRequest tunnelRequest, HttpRequest httpRequest) {
        HttpTunnelRequestInterceptorDefaultImpl httpTunnelRequestInterceptorDefaultImpl = this;
        Map pxyHeaders$iv = TunnelRequestKt.getPxySetHeaders((TunnelRequest)tunnelRequest);
        boolean $i$f$handleProxyHttpHeaders = false;
        if (!pxyHeaders$iv.isEmpty()) {
            for (Map.Entry it$iv : pxyHeaders$iv.entrySet()) {
                void value;
                void name;
                HttpHeaders $this$handleProxyHttpHeaders;
                String string;
                String name$iv = (String)it$iv.getKey();
                String string2 = (String)it$iv.getValue();
                switch (string2.hashCode()) {
                    case -1717118554: {
                        if (string2.equals(MAGIC_VALUE_REMOTE_ADDR)) {
                            if (remoteAddress instanceof InetSocketAddress) {
                                string = ((InetSocketAddress)remoteAddress).getAddress().toString();
                                break;
                            }
                            string = null;
                            break;
                        }
                    }
                    default: {
                        string = (String)it$iv.getValue();
                    }
                }
                if (string == null) {
                    continue;
                }
                String value$iv = string;
                Intrinsics.checkExpressionValueIsNotNull((Object)httpRequest.headers(), (String)"httpRequest.headers()");
                String string3 = value$iv;
                String string4 = name$iv;
                boolean bl = false;
                if (!$this$handleProxyHttpHeaders.contains((String)name)) continue;
                $this$handleProxyHttpHeaders.set((String)name, (Object)value);
            }
        }
    }

    private final void handleProxyHttpHeaders(Map<String, String> pxyHeaders, SocketAddress localAddress, SocketAddress remoteAddress, TunnelRequest tunnelRequest, HttpRequest httpRequest, Function3<? super HttpHeaders, ? super String, ? super String, Unit> apply) {
        int $i$f$handleProxyHttpHeaders = 0;
        if (pxyHeaders.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> it : pxyHeaders.entrySet()) {
            String string;
            String name = it.getKey();
            String string2 = it.getValue();
            switch (string2.hashCode()) {
                case -1717118554: {
                    if (string2.equals(MAGIC_VALUE_REMOTE_ADDR)) {
                        if (remoteAddress instanceof InetSocketAddress) {
                            string = ((InetSocketAddress)remoteAddress).getAddress().toString();
                            break;
                        }
                        string = null;
                        break;
                    }
                }
                default: {
                    string = it.getValue();
                }
            }
            if (string == null) {
                continue;
            }
            String value = string;
            HttpHeaders httpHeaders = httpRequest.headers();
            Intrinsics.checkExpressionValueIsNotNull((Object)httpHeaders, (String)"httpRequest.headers()");
            apply.invoke((Object)httpHeaders, (Object)name, (Object)value);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Llighttunnel/openapi/ext/HttpTunnelRequestInterceptorDefaultImpl$Companion;", "", "()V", "MAGIC_VALUE_REMOTE_ADDR", "", "server"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

