/*
 * Decompiled with CFR 0.152.
 */
package lighttunnel.openapi.ext.httpclient;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AttributeKey;
import java.net.URI;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import lighttunnel.openapi.ext.httpclient.HttpClientChannelHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJC\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122!\u0010\u0013\u001a\u001d\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\f0\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Llighttunnel/openapi/ext/httpclient/HttpClient;", "", "workerGroup", "Lio/netty/channel/nio/NioEventLoopGroup;", "sslContext", "Lio/netty/handler/ssl/SslContext;", "maxContentLength", "", "(Lio/netty/channel/nio/NioEventLoopGroup;Lio/netty/handler/ssl/SslContext;I)V", "bootstrap", "Lio/netty/bootstrap/Bootstrap;", "request", "", "url", "", "method", "Lio/netty/handler/codec/http/HttpMethod;", "content", "Lio/netty/buffer/ByteBuf;", "callback", "Lkotlin/Function1;", "Lio/netty/handler/codec/http/FullHttpResponse;", "Lkotlin/ParameterName;", "name", "response", "Companion", "base"})
public final class HttpClient {
    private final Bootstrap bootstrap;
    private final SslContext sslContext;
    private final int maxContentLength;
    @NotNull
    private static final AttributeKey<Function1<FullHttpResponse, Unit>> REQUEST_CALLBACK;
    public static final Companion Companion;

    public final void request(@NotNull String url, @NotNull HttpMethod method, @NotNull ByteBuf content, @NotNull Function1<? super FullHttpResponse, Unit> callback) throws Exception {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        URI uri = URI.create(url);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, url, content);
        URI uRI = uri;
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"uri");
        Channel channel = this.bootstrap.connect(uRI.getPath(), uri.getPort() == -1 ? (StringsKt.equals((String)"https", (String)uri.getScheme(), (boolean)true) ? 443 : 80) : uri.getPort()).sync().channel();
        boolean bl = false;
        boolean bl2 = false;
        Channel it = channel;
        boolean bl3 = false;
        it.attr(REQUEST_CALLBACK).set(callback);
        channel.writeAndFlush((Object)request);
    }

    public static /* synthetic */ void request$default(HttpClient httpClient, String string, HttpMethod httpMethod, ByteBuf byteBuf, Function1 function1, int n, Object object) throws Exception {
        if ((n & 4) != 0) {
            ByteBuf byteBuf2 = Unpooled.EMPTY_BUFFER;
            Intrinsics.checkNotNullExpressionValue((Object)byteBuf2, (String)"Unpooled.EMPTY_BUFFER");
            byteBuf = byteBuf2;
        }
        httpClient.request(string, httpMethod, byteBuf, (Function1<? super FullHttpResponse, Unit>)function1);
    }

    public HttpClient(@NotNull NioEventLoopGroup workerGroup, @Nullable SslContext sslContext, int maxContentLength) {
        Intrinsics.checkNotNullParameter((Object)workerGroup, (String)"workerGroup");
        this.sslContext = sslContext;
        this.maxContentLength = maxContentLength;
        this.bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group((EventLoopGroup)workerGroup)).channel(NioSocketChannel.class)).option(ChannelOption.AUTO_READ, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(@Nullable SocketChannel ch) {
                if (ch == null) {
                    return;
                }
                if (sslContext != null) {
                    ch.pipeline().addFirst("ssl", (ChannelHandler)new SslHandler(sslContext.newEngine(ch.alloc())));
                }
                ch.pipeline().addLast("codec", (ChannelHandler)new HttpClientCodec()).addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(maxContentLength)).addLast("handler", (ChannelHandler)new HttpClientChannelHandler());
            }
        });
    }

    public /* synthetic */ HttpClient(NioEventLoopGroup nioEventLoopGroup, SslContext sslContext, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            sslContext = null;
        }
        if ((n2 & 4) != 0) {
            n = 0x800000;
        }
        this(nioEventLoopGroup, sslContext, n);
    }

    static {
        Companion = new Companion(null);
        AttributeKey attributeKey = AttributeKey.newInstance((String)"lighttunnel.openapi.ext.httpclient.REQUEST_CALLBACK");
        Intrinsics.checkNotNullExpressionValue((Object)attributeKey, (String)"AttributeKey.newInstance\u2026client.REQUEST_CALLBACK\")");
        REQUEST_CALLBACK = attributeKey;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R5\u0010\u0003\u001a#\u0012\u001f\u0012\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u00050\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Llighttunnel/openapi/ext/httpclient/HttpClient$Companion;", "", "()V", "REQUEST_CALLBACK", "Lio/netty/util/AttributeKey;", "Lkotlin/Function1;", "Lio/netty/handler/codec/http/FullHttpResponse;", "Lkotlin/ParameterName;", "name", "response", "", "getREQUEST_CALLBACK$base", "()Lio/netty/util/AttributeKey;", "base"})
    public static final class Companion {
        @NotNull
        public final AttributeKey<Function1<FullHttpResponse, Unit>> getREQUEST_CALLBACK$base() {
            return REQUEST_CALLBACK;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

