/*
 * Decompiled with CFR 0.152.
 */
package lighttunnel.server.tcp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import lighttunnel.base.openapi.RemoteConnection;
import lighttunnel.base.proto.ProtoMessage;
import lighttunnel.base.proto.ProtoMessageType;
import lighttunnel.base.util.LongUtil;
import lighttunnel.server.tcp.TcpFdDefaultImpl;
import lighttunnel.server.tcp.TcpRegistry;
import lighttunnel.server.tcp.TcpTunnelChannelHandler$$special$;
import lighttunnel.server.util.-ConstsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010\u0014\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u000eH\u0016J\u001c\u0010\u0015\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0002H\u0014J\u001c\u0010\u0017\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0004\u0018\u00010\r*\u0004\u0018\u00010\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Llighttunnel/server/tcp/TcpTunnelChannelHandler;", "Lio/netty/channel/SimpleChannelInboundHandler;", "Lio/netty/buffer/ByteBuf;", "registry", "Llighttunnel/server/tcp/TcpRegistry;", "(Llighttunnel/server/tcp/TcpRegistry;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "logger$delegate", "Lkotlin/Lazy;", "tcpFd", "Llighttunnel/server/tcp/TcpFdDefaultImpl;", "Lio/netty/channel/ChannelHandlerContext;", "getTcpFd", "(Lio/netty/channel/ChannelHandlerContext;)Llighttunnel/server/tcp/TcpFdDefaultImpl;", "channelActive", "", "ctx", "channelInactive", "channelRead0", "msg", "exceptionCaught", "cause", "", "server"})
public final class TcpTunnelChannelHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private final Lazy logger$delegate;
    private final TcpRegistry registry;

    private final Logger getLogger() {
        Lazy lazy = this.logger$delegate;
        TcpTunnelChannelHandler tcpTunnelChannelHandler = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    public void channelActive(@Nullable ChannelHandlerContext ctx) {
        this.getLogger().trace("channelActive: {}", (Object)ctx);
        if (ctx != null) {
            TcpFdDefaultImpl tcpFd = this.getTcpFd(ctx);
            if (tcpFd != null) {
                Long sessionId = (Long)ctx.channel().attr(-ConstsKt.getAK_SESSION_ID()).get();
                if (sessionId == null) {
                    Channel channel = ctx.channel();
                    Intrinsics.checkExpressionValueIsNotNull((Object)channel, (String)"ctx.channel()");
                    sessionId = tcpFd.putChannel(channel);
                    ctx.channel().attr(-ConstsKt.getAK_SESSION_ID()).set((Object)sessionId);
                }
                byte[] head = LongUtil.INSTANCE.toBytes(new long[]{tcpFd.getTunnelId(), sessionId});
                Channel channel = tcpFd.getTunnelChannel();
                SocketAddress socketAddress = ctx.channel().remoteAddress();
                Intrinsics.checkExpressionValueIsNotNull((Object)socketAddress, (String)"ctx.channel().remoteAddress()");
                channel.writeAndFlush((Object)new ProtoMessage(ProtoMessageType.REMOTE_CONNECTED, head, new RemoteConnection(socketAddress).toBytes()));
            } else {
                ctx.channel().writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }
        super.channelActive(ctx);
    }

    public void channelInactive(@Nullable ChannelHandlerContext ctx) {
        this.getLogger().trace("channelInactive: {}", (Object)ctx);
        if (ctx != null) {
            TcpFdDefaultImpl tcpFd = this.getTcpFd(ctx);
            if (tcpFd != null) {
                Channel sessionChannel;
                Channel channel;
                Long sessionId = (Long)ctx.channel().attr(-ConstsKt.getAK_SESSION_ID()).get();
                if (sessionId != null && (channel = (sessionChannel = tcpFd.removeChannel(sessionId))) != null && (channel = channel.writeAndFlush((Object)Unpooled.EMPTY_BUFFER)) != null) {
                    channel.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                }
                ctx.channel().writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(tcpFd, sessionId, ctx){
                    final /* synthetic */ TcpFdDefaultImpl $tcpFd;
                    final /* synthetic */ Long $sessionId;
                    final /* synthetic */ ChannelHandlerContext $ctx;

                    public final void operationComplete(Future<? super Void> it) {
                        long[] lArray = new long[2];
                        lArray[0] = this.$tcpFd.getTunnelId();
                        Long l = this.$sessionId;
                        lArray[1] = l != null ? l : 0L;
                        byte[] head = LongUtil.INSTANCE.toBytes(lArray);
                        Channel channel = this.$tcpFd.getTunnelChannel();
                        SocketAddress socketAddress = this.$ctx.channel().remoteAddress();
                        Intrinsics.checkExpressionValueIsNotNull((Object)socketAddress, (String)"ctx.channel().remoteAddress()");
                        channel.writeAndFlush((Object)new ProtoMessage(ProtoMessageType.REMOTE_DISCONNECT, head, new RemoteConnection(socketAddress).toBytes()));
                    }
                    {
                        this.$tcpFd = tcpFdDefaultImpl;
                        this.$sessionId = l;
                        this.$ctx = channelHandlerContext;
                    }
                });
            }
            ctx.channel().writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        super.channelInactive(ctx);
    }

    public void exceptionCaught(@Nullable ChannelHandlerContext ctx, @Nullable Throwable cause) {
        block0: {
            this.getLogger().trace("exceptionCaught: {}", (Object)ctx, (Object)cause);
            ChannelHandlerContext channelHandlerContext = ctx;
            if (channelHandlerContext == null || (channelHandlerContext = channelHandlerContext.channel()) == null || (channelHandlerContext = channelHandlerContext.writeAndFlush((Object)Unpooled.EMPTY_BUFFER)) == null) break block0;
            channelHandlerContext.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    protected void channelRead0(@Nullable ChannelHandlerContext ctx, @Nullable ByteBuf msg) {
        this.getLogger().trace("channelRead0: {}", (Object)ctx);
        if (ctx == null) {
            return;
        }
        if (msg == null) {
            return;
        }
        Long l = (Long)ctx.channel().attr(-ConstsKt.getAK_SESSION_ID()).get();
        if (l == null) {
            return;
        }
        long sessionId = l;
        TcpFdDefaultImpl tcpFdDefaultImpl = this.getTcpFd(ctx);
        if (tcpFdDefaultImpl == null) {
            return;
        }
        TcpFdDefaultImpl tcpFd = tcpFdDefaultImpl;
        byte[] head = LongUtil.INSTANCE.toBytes(new long[]{tcpFd.getTunnelId(), sessionId});
        byte[] data = ByteBufUtil.getBytes((ByteBuf)msg);
        Channel channel = tcpFd.getTunnelChannel();
        Intrinsics.checkExpressionValueIsNotNull((Object)data, (String)"data");
        channel.writeAndFlush((Object)new ProtoMessage(ProtoMessageType.TRANSFER, head, data));
    }

    private final TcpFdDefaultImpl getTcpFd(@Nullable ChannelHandlerContext $this$tcpFd) {
        if ($this$tcpFd == null) {
            return null;
        }
        SocketAddress sa = $this$tcpFd.channel().localAddress();
        return sa instanceof InetSocketAddress ? this.registry.getTcpFd(((InetSocketAddress)sa).getPort()) : null;
    }

    public TcpTunnelChannelHandler(@NotNull TcpRegistry registry) {
        Lazy lazy;
        Intrinsics.checkParameterIsNotNull((Object)registry, (String)"registry");
        this.registry = registry;
        TcpTunnelChannelHandler tcpTunnelChannelHandler = this;
        TcpTunnelChannelHandler tcpTunnelChannelHandler2 = this;
        boolean $i$f$loggerDelegate = false;
        tcpTunnelChannelHandler2.logger$delegate = lazy = LazyKt.lazy((Function0)$special$$inlined$loggerDelegate$1.INSTANCE);
    }
}

