/*
 * Decompiled with CFR 0.152.
 */
package lighttunnel.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.ssl.SslContext;
import java.nio.charset.Charset;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import lighttunnel.base.http.server.HttpServer;
import lighttunnel.base.http.server.RouterMappings;
import lighttunnel.base.proto.HeartbeatHandler;
import lighttunnel.base.proto.ProtoMessageDecoder;
import lighttunnel.base.proto.ProtoMessageEncoder;
import lighttunnel.base.util.IncIds;
import lighttunnel.server.TunnelServerDaemon;
import lighttunnel.server.TunnelServerDaemon$$special$;
import lighttunnel.server.TunnelServerDaemonChannelHandler;
import lighttunnel.server.http.HttpFdDefaultImpl;
import lighttunnel.server.http.HttpRegistry;
import lighttunnel.server.http.HttpTunnel;
import lighttunnel.server.openapi.TunnelRequestInterceptor;
import lighttunnel.server.openapi.args.HttpRpcServerArgs;
import lighttunnel.server.openapi.args.HttpTunnelArgs;
import lighttunnel.server.openapi.args.HttpsTunnelArgs;
import lighttunnel.server.openapi.args.SslTunnelDaemonArgs;
import lighttunnel.server.openapi.args.TunnelDaemonArgs;
import lighttunnel.server.openapi.http.HttpPlugin;
import lighttunnel.server.openapi.http.HttpRequestInterceptor;
import lighttunnel.server.openapi.listener.OnHttpTunnelStateListener;
import lighttunnel.server.openapi.listener.OnTcpTunnelStateListener;
import lighttunnel.server.tcp.TcpFdDefaultImpl;
import lighttunnel.server.tcp.TcpRegistry;
import lighttunnel.server.tcp.TcpTunnel;
import lighttunnel.server.traffic.TrafficHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001:\u0001=BY\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0002\u0010\u0013J\u0006\u00102\u001a\u000203J\u0012\u00104\u001a\u0004\u0018\u00010\u001b2\u0006\u00105\u001a\u00020\u000eH\u0002J\u001a\u00106\u001a\u0004\u0018\u00010\u001d2\u0006\u00107\u001a\u00020\u00172\u0006\u00105\u001a\u00020\nH\u0002J\u001a\u00108\u001a\u0004\u0018\u00010\u001d2\u0006\u00107\u001a\u00020\u00172\u0006\u00105\u001a\u00020\fH\u0002J\u0010\u00109\u001a\u00020.2\u0006\u00107\u001a\u00020*H\u0002J\u0006\u0010:\u001a\u000203J\u0010\u0010;\u001a\u0002032\u0006\u00105\u001a\u00020\bH\u0002J\u0010\u0010<\u001a\u0002032\u0006\u00105\u001a\u00020\u0006H\u0002R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0019R\u0010\u0010 \u001a\u0004\u0018\u00010\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010#\u001a\u00020$8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b%\u0010&R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Llighttunnel/server/TunnelServerDaemon;", "", "bossThreads", "", "workerThreads", "tunnelDaemonArgs", "Llighttunnel/server/openapi/args/TunnelDaemonArgs;", "sslTunnelDaemonArgs", "Llighttunnel/server/openapi/args/SslTunnelDaemonArgs;", "httpTunnelArgs", "Llighttunnel/server/openapi/args/HttpTunnelArgs;", "httpsTunnelArgs", "Llighttunnel/server/openapi/args/HttpsTunnelArgs;", "httpRpcServerArgs", "Llighttunnel/server/openapi/args/HttpRpcServerArgs;", "onTcpTunnelStateListener", "Llighttunnel/server/openapi/listener/OnTcpTunnelStateListener;", "onHttpTunnelStateListener", "Llighttunnel/server/openapi/listener/OnHttpTunnelStateListener;", "(IILlighttunnel/server/openapi/args/TunnelDaemonArgs;Llighttunnel/server/openapi/args/SslTunnelDaemonArgs;Llighttunnel/server/openapi/args/HttpTunnelArgs;Llighttunnel/server/openapi/args/HttpsTunnelArgs;Llighttunnel/server/openapi/args/HttpRpcServerArgs;Llighttunnel/server/openapi/listener/OnTcpTunnelStateListener;Llighttunnel/server/openapi/listener/OnHttpTunnelStateListener;)V", "bossGroup", "Lio/netty/channel/nio/NioEventLoopGroup;", "httpRegistry", "Llighttunnel/server/http/HttpRegistry;", "getHttpRegistry", "()Llighttunnel/server/http/HttpRegistry;", "httpRpcServer", "Llighttunnel/base/http/server/HttpServer;", "httpTunnel", "Llighttunnel/server/http/HttpTunnel;", "httpsRegistry", "getHttpsRegistry", "httpsTunnel", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "logger$delegate", "Lkotlin/Lazy;", "tcpRegistry", "Llighttunnel/server/tcp/TcpRegistry;", "getTcpRegistry", "()Llighttunnel/server/tcp/TcpRegistry;", "tcpTunnel", "Llighttunnel/server/tcp/TcpTunnel;", "tunnelIds", "Llighttunnel/base/util/IncIds;", "workerGroup", "depose", "", "getHttpRpcServer", "args", "getHttpTunnel", "registry", "getHttpsTunnel", "getTcpTunnel", "start", "startSslTunnelDaemon", "startTunnelDaemon", "InnerTunnelServerChannelHandler", "server"})
public final class TunnelServerDaemon {
    private final Lazy logger$delegate;
    private final ReentrantLock lock;
    private final IncIds tunnelIds;
    private final NioEventLoopGroup bossGroup;
    private final NioEventLoopGroup workerGroup;
    @NotNull
    private final TcpRegistry tcpRegistry;
    @NotNull
    private final HttpRegistry httpRegistry;
    @NotNull
    private final HttpRegistry httpsRegistry;
    private final TcpTunnel tcpTunnel;
    private final HttpTunnel httpTunnel;
    private final HttpTunnel httpsTunnel;
    private final HttpServer httpRpcServer;
    private final TunnelDaemonArgs tunnelDaemonArgs;
    private final SslTunnelDaemonArgs sslTunnelDaemonArgs;
    private final OnTcpTunnelStateListener onTcpTunnelStateListener;
    private final OnHttpTunnelStateListener onHttpTunnelStateListener;

    private final Logger getLogger() {
        Lazy lazy = this.logger$delegate;
        TunnelServerDaemon tunnelServerDaemon = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    @NotNull
    public final TcpRegistry getTcpRegistry() {
        return this.tcpRegistry;
    }

    @NotNull
    public final HttpRegistry getHttpRegistry() {
        return this.httpRegistry;
    }

    @NotNull
    public final HttpRegistry getHttpsRegistry() {
        return this.httpsRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() throws Exception {
        Lock lock = this.lock;
        boolean bl = false;
        lock.lock();
        try {
            boolean bl2 = false;
            HttpTunnel httpTunnel = this.httpTunnel;
            if (httpTunnel != null) {
                httpTunnel.start();
            }
            HttpTunnel httpTunnel2 = this.httpsTunnel;
            if (httpTunnel2 != null) {
                httpTunnel2.start();
            }
            HttpServer httpServer = this.httpRpcServer;
            if (httpServer != null) {
                httpServer.start();
            }
            this.startTunnelDaemon(this.tunnelDaemonArgs);
            SslTunnelDaemonArgs sslTunnelDaemonArgs = this.sslTunnelDaemonArgs;
            if (sslTunnelDaemonArgs != null) {
                SslTunnelDaemonArgs sslTunnelDaemonArgs2 = sslTunnelDaemonArgs;
                boolean bl3 = false;
                boolean bl4 = false;
                SslTunnelDaemonArgs it = sslTunnelDaemonArgs2;
                boolean bl5 = false;
                this.startSslTunnelDaemon(it);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void depose() {
        Lock lock = this.lock;
        boolean bl = false;
        lock.lock();
        try {
            boolean bl2 = false;
            this.tcpRegistry.depose();
            this.httpRegistry.depose();
            this.httpsRegistry.depose();
            HttpServer httpServer = this.httpRpcServer;
            if (httpServer != null) {
                httpServer.depose();
            }
            this.bossGroup.shutdownGracefully();
            this.workerGroup.shutdownGracefully();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private final void startTunnelDaemon(TunnelDaemonArgs args) {
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        ((ServerBootstrap)serverBootstrap.group((EventLoopGroup)this.bossGroup, (EventLoopGroup)this.workerGroup).channel(NioServerSocketChannel.class)).childOption(ChannelOption.AUTO_READ, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(this, args){
            final /* synthetic */ TunnelServerDaemon this$0;
            final /* synthetic */ TunnelDaemonArgs $args;

            protected void initChannel(@Nullable SocketChannel ch) {
                if (ch == null) {
                    return;
                }
                ch.pipeline().addLast("traffic", (ChannelHandler)new TrafficHandler()).addLast("heartbeat", (ChannelHandler)new HeartbeatHandler(false, 0L, 0L, 0L, null, 31, null)).addLast("decoder", (ChannelHandler)new ProtoMessageDecoder()).addLast("encoder", (ChannelHandler)new ProtoMessageEncoder()).addLast("handler", (ChannelHandler)this.this$0.new InnerTunnelServerChannelHandler(this.$args.getTunnelRequestInterceptor()));
            }
            {
                this.this$0 = $outer;
                this.$args = $captured_local_variable$1;
            }
        });
        if (args.getBindAddr() == null) {
            serverBootstrap.bind(args.getBindPort()).get();
        } else {
            serverBootstrap.bind(args.getBindAddr(), args.getBindPort()).get();
        }
        Logger logger = this.getLogger();
        String string = args.getBindAddr();
        if (string == null) {
            string = "::";
        }
        logger.info("Serving tunnel on {} port {}", (Object)string, (Object)args.getBindPort());
    }

    private final void startSslTunnelDaemon(SslTunnelDaemonArgs args) {
        if (args.getBindPort() == null) {
            return;
        }
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        ((ServerBootstrap)serverBootstrap.group((EventLoopGroup)this.bossGroup, (EventLoopGroup)this.workerGroup).channel(NioServerSocketChannel.class)).childOption(ChannelOption.AUTO_READ, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(this, args){
            final /* synthetic */ TunnelServerDaemon this$0;
            final /* synthetic */ SslTunnelDaemonArgs $args;

            protected void initChannel(@Nullable SocketChannel ch) {
                if (ch == null) {
                    return;
                }
                ch.pipeline().addFirst("ssl", (ChannelHandler)this.$args.getSslContext().newHandler(ch.alloc())).addLast("traffic", (ChannelHandler)new TrafficHandler()).addLast("heartbeat", (ChannelHandler)new HeartbeatHandler(false, 0L, 0L, 0L, null, 31, null)).addLast("decoder", (ChannelHandler)new ProtoMessageDecoder()).addLast("encoder", (ChannelHandler)new ProtoMessageEncoder()).addLast("handler", (ChannelHandler)this.this$0.new InnerTunnelServerChannelHandler(this.$args.getTunnelRequestInterceptor()));
            }
            {
                this.this$0 = $outer;
                this.$args = $captured_local_variable$1;
            }
        });
        if (args.getBindAddr() == null) {
            serverBootstrap.bind(args.getBindPort().intValue()).get();
        } else {
            serverBootstrap.bind(args.getBindAddr(), args.getBindPort().intValue()).get();
        }
        Logger logger = this.getLogger();
        String string = args.getBindAddr();
        if (string == null) {
            string = "::";
        }
        logger.info("Serving tunnel with ssl on {} port {}", (Object)string, (Object)args.getBindPort());
    }

    private final TcpTunnel getTcpTunnel(TcpRegistry registry) {
        return new TcpTunnel(this.bossGroup, this.workerGroup, registry);
    }

    private final HttpTunnel getHttpTunnel(HttpRegistry registry, HttpTunnelArgs args) {
        if (args.getBindPort() == null) {
            return null;
        }
        HttpRegistry httpRegistry = registry;
        HttpPlugin httpPlugin = args.getHttpPlugin();
        int n = 0;
        HttpRequestInterceptor httpRequestInterceptor = args.getHttpRequestInterceptor();
        SslContext sslContext = null;
        int n2 = args.getBindPort();
        String string = args.getBindAddr();
        return new HttpTunnel(this.bossGroup, this.workerGroup, httpRegistry, string, n2, sslContext, n, httpPlugin, httpRequestInterceptor, 64, null);
    }

    private final HttpTunnel getHttpsTunnel(HttpRegistry registry, HttpsTunnelArgs args) {
        if (args.getBindPort() == null) {
            return null;
        }
        HttpRegistry httpRegistry = registry;
        HttpPlugin httpPlugin = args.getHttpPlugin();
        int n = 0;
        HttpRequestInterceptor httpRequestInterceptor = args.getHttpRequestInterceptor();
        SslContext sslContext = args.getSslContext();
        int n2 = args.getBindPort();
        String string = args.getBindAddr();
        return new HttpTunnel(this.bossGroup, this.workerGroup, httpRegistry, string, n2, sslContext, n, httpPlugin, httpRequestInterceptor, 64, null);
    }

    private final HttpServer getHttpRpcServer(HttpRpcServerArgs args) {
        if (args.getBindPort() == null) {
            return null;
        }
        return new HttpServer(this.bossGroup, this.workerGroup, args.getBindAddr(), args.getBindPort().intValue(), null, 0, (Function1)new Function1<RouterMappings, Unit>(this){
            final /* synthetic */ TunnelServerDaemon this$0;

            public final void invoke(@NotNull RouterMappings $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                $receiver.route("/api/version", (Function1)getHttpRpcServer.1.INSTANCE);
                $receiver.route("/api/snapshot", (Function1)new Function1<FullHttpRequest, DefaultFullHttpResponse>(this){
                    final /* synthetic */ getHttpRpcServer.1 this$0;

                    @NotNull
                    public final DefaultFullHttpResponse invoke(@NotNull FullHttpRequest it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        JSONObject jSONObject = new JSONObject();
                        boolean bl = false;
                        boolean bl2 = false;
                        JSONObject $this$apply = jSONObject;
                        boolean bl3 = false;
                        $this$apply.put("tcp", (Object)this.this$0.this$0.getTcpRegistry().toJson());
                        $this$apply.put("http", (Object)this.this$0.this$0.getHttpRegistry().toJson());
                        $this$apply.put("https", (Object)this.this$0.this$0.getHttpsRegistry().toJson());
                        bl = false;
                        bl2 = false;
                        JSONObject it2 = jSONObject;
                        boolean bl4 = false;
                        ByteBuf content = Unpooled.copiedBuffer((CharSequence)it2.toString(2), (Charset)Charsets.UTF_8);
                        jSONObject = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, content);
                        bl = false;
                        bl2 = false;
                        $this$apply = jSONObject;
                        boolean bl5 = false;
                        $this$apply.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_JSON).set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)content.readableBytes());
                        return jSONObject;
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = tunnelServerDaemon;
                super(1);
            }
        }, 48, null);
    }

    public TunnelServerDaemon(int bossThreads, int workerThreads, @NotNull TunnelDaemonArgs tunnelDaemonArgs, @Nullable SslTunnelDaemonArgs sslTunnelDaemonArgs, @Nullable HttpTunnelArgs httpTunnelArgs, @Nullable HttpsTunnelArgs httpsTunnelArgs, @Nullable HttpRpcServerArgs httpRpcServerArgs, @Nullable OnTcpTunnelStateListener onTcpTunnelStateListener, @Nullable OnHttpTunnelStateListener onHttpTunnelStateListener) {
        Object object;
        Object object2;
        Object object3;
        Object it;
        boolean bl;
        boolean bl2;
        Object object4;
        Intrinsics.checkParameterIsNotNull((Object)tunnelDaemonArgs, (String)"tunnelDaemonArgs");
        this.tunnelDaemonArgs = tunnelDaemonArgs;
        this.sslTunnelDaemonArgs = sslTunnelDaemonArgs;
        this.onTcpTunnelStateListener = onTcpTunnelStateListener;
        this.onHttpTunnelStateListener = onHttpTunnelStateListener;
        Object object5 = this;
        TunnelServerDaemon tunnelServerDaemon = this;
        boolean $i$f$loggerDelegate = false;
        tunnelServerDaemon.logger$delegate = object4 = LazyKt.lazy((Function0)$special$$inlined$loggerDelegate$1.INSTANCE);
        this.lock = new ReentrantLock();
        this.tunnelIds = new IncIds();
        this.bossGroup = bossThreads >= 0 ? new NioEventLoopGroup(bossThreads) : new NioEventLoopGroup();
        this.workerGroup = workerThreads >= 0 ? new NioEventLoopGroup(workerThreads) : new NioEventLoopGroup();
        this.tcpRegistry = new TcpRegistry();
        this.httpRegistry = new HttpRegistry();
        this.httpsRegistry = new HttpRegistry();
        this.tcpTunnel = this.getTcpTunnel(this.tcpRegistry);
        TunnelServerDaemon tunnelServerDaemon2 = this;
        HttpTunnelArgs httpTunnelArgs2 = httpTunnelArgs;
        if (httpTunnelArgs2 != null) {
            object5 = httpTunnelArgs2;
            tunnelServerDaemon = tunnelServerDaemon2;
            bl2 = false;
            bl = false;
            it = object5;
            boolean bl3 = false;
            object4 = this.getHttpTunnel(this.httpRegistry, (HttpTunnelArgs)it);
            tunnelServerDaemon2 = tunnelServerDaemon;
            object3 = object4;
        } else {
            object3 = null;
        }
        tunnelServerDaemon2.httpTunnel = object3;
        TunnelServerDaemon tunnelServerDaemon3 = this;
        HttpsTunnelArgs httpsTunnelArgs2 = httpsTunnelArgs;
        if (httpsTunnelArgs2 != null) {
            object5 = httpsTunnelArgs2;
            tunnelServerDaemon = tunnelServerDaemon3;
            bl2 = false;
            bl = false;
            it = object5;
            boolean bl4 = false;
            object4 = this.getHttpsTunnel(this.httpsRegistry, (HttpsTunnelArgs)it);
            tunnelServerDaemon3 = tunnelServerDaemon;
            object2 = object4;
        } else {
            object2 = null;
        }
        tunnelServerDaemon3.httpsTunnel = object2;
        TunnelServerDaemon tunnelServerDaemon4 = this;
        HttpRpcServerArgs httpRpcServerArgs2 = httpRpcServerArgs;
        if (httpRpcServerArgs2 != null) {
            object5 = httpRpcServerArgs2;
            tunnelServerDaemon = tunnelServerDaemon4;
            bl2 = false;
            bl = false;
            it = object5;
            boolean bl5 = false;
            object4 = this.getHttpRpcServer((HttpRpcServerArgs)it);
            tunnelServerDaemon4 = tunnelServerDaemon;
            object = object4;
        } else {
            object = null;
        }
        tunnelServerDaemon4.httpRpcServer = object;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u001a\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u001a\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016\u00a8\u0006\u000e"}, d2={"Llighttunnel/server/TunnelServerDaemon$InnerTunnelServerChannelHandler;", "Llighttunnel/server/TunnelServerDaemonChannelHandler;", "tunnelRequestInterceptor", "Llighttunnel/server/openapi/TunnelRequestInterceptor;", "(Llighttunnel/server/TunnelServerDaemon;Llighttunnel/server/openapi/TunnelRequestInterceptor;)V", "onChannelConnected", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "httpFd", "Llighttunnel/server/http/HttpFdDefaultImpl;", "tcpFd", "Llighttunnel/server/tcp/TcpFdDefaultImpl;", "onChannelInactive", "server"})
    private final class InnerTunnelServerChannelHandler
    extends TunnelServerDaemonChannelHandler {
        @Override
        public void onChannelConnected(@NotNull ChannelHandlerContext ctx, @Nullable TcpFdDefaultImpl tcpFd) {
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
                if (tcpFd == null) break block1;
                OnTcpTunnelStateListener onTcpTunnelStateListener = TunnelServerDaemon.this.onTcpTunnelStateListener;
                if (onTcpTunnelStateListener != null) {
                    onTcpTunnelStateListener.onTcpTunnelConnected(tcpFd);
                }
            }
        }

        @Override
        public void onChannelInactive(@NotNull ChannelHandlerContext ctx, @Nullable TcpFdDefaultImpl tcpFd) {
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
                if (tcpFd == null) break block1;
                OnTcpTunnelStateListener onTcpTunnelStateListener = TunnelServerDaemon.this.onTcpTunnelStateListener;
                if (onTcpTunnelStateListener != null) {
                    onTcpTunnelStateListener.onTcpTunnelDisconnect(tcpFd);
                }
            }
        }

        @Override
        public void onChannelConnected(@NotNull ChannelHandlerContext ctx, @Nullable HttpFdDefaultImpl httpFd) {
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
                if (httpFd == null) break block1;
                OnHttpTunnelStateListener onHttpTunnelStateListener = TunnelServerDaemon.this.onHttpTunnelStateListener;
                if (onHttpTunnelStateListener != null) {
                    onHttpTunnelStateListener.onHttpTunnelConnected(httpFd);
                }
            }
        }

        @Override
        public void onChannelInactive(@NotNull ChannelHandlerContext ctx, @Nullable HttpFdDefaultImpl httpFd) {
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
                if (httpFd == null) break block1;
                OnHttpTunnelStateListener onHttpTunnelStateListener = TunnelServerDaemon.this.onHttpTunnelStateListener;
                if (onHttpTunnelStateListener != null) {
                    onHttpTunnelStateListener.onHttpTunnelDisconnect(httpFd);
                }
            }
        }

        public InnerTunnelServerChannelHandler(TunnelRequestInterceptor tunnelRequestInterceptor) {
            Intrinsics.checkParameterIsNotNull((Object)tunnelRequestInterceptor, (String)"tunnelRequestInterceptor");
            super(tunnelRequestInterceptor, TunnelServerDaemon.this.tunnelIds, TunnelServerDaemon.this.tcpTunnel, TunnelServerDaemon.this.httpTunnel, TunnelServerDaemon.this.httpsTunnel);
        }
    }
}

