/*
 * Decompiled with CFR 0.152.
 */
package lighttunnel.server.util;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import lighttunnel.proto.ProtoMessage;
import lighttunnel.proto.ProtoMessageType;
import lighttunnel.proto.TunnelRequest;
import lighttunnel.server.util.Statistics;
import lighttunnel.util.IncIds;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u001fJ\u0010\u0010!\u001a\u0004\u0018\u00010\u00072\u0006\u0010\"\u001a\u00020\u0003J\u000e\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u0007J\u0010\u0010%\u001a\u0004\u0018\u00010\u00072\u0006\u0010\"\u001a\u00020\u0003R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u000ej\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0007`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006&"}, d2={"Llighttunnel/server/util/SessionChannels;", "", "tunnelId", "", "tunnelRequest", "Llighttunnel/proto/TunnelRequest;", "tunnelChannel", "Lio/netty/channel/Channel;", "(JLlighttunnel/proto/TunnelRequest;Lio/netty/channel/Channel;)V", "cachedChannelCount", "", "getCachedChannelCount", "()I", "cachedSessionIdChannels", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "ids", "Llighttunnel/util/IncIds;", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "statistics", "Llighttunnel/server/util/Statistics;", "getStatistics", "()Llighttunnel/server/util/Statistics;", "getTunnelChannel", "()Lio/netty/channel/Channel;", "getTunnelId", "()J", "getTunnelRequest", "()Llighttunnel/proto/TunnelRequest;", "depose", "", "forceOff", "getChannel", "sessionId", "putChannel", "channel", "removeChannel", "server"})
public final class SessionChannels {
    private final IncIds ids;
    private final HashMap<Long, Channel> cachedSessionIdChannels;
    private final ReentrantReadWriteLock lock;
    @NotNull
    private final Statistics statistics;
    private final long tunnelId;
    @NotNull
    private final TunnelRequest tunnelRequest;
    @NotNull
    private final Channel tunnelChannel;

    @NotNull
    public final Statistics getStatistics() {
        return this.statistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getCachedChannelCount() {
        int n;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        boolean bl = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            boolean bl2 = false;
            Map map = this.cachedSessionIdChannels;
            boolean bl3 = false;
            n = map.size();
        }
        finally {
            readLock.unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long putChannel(@NotNull Channel channel) {
        int n;
        int n2;
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        long sessionId = this.ids.getNextId();
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        boolean bl = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        boolean bl2 = false;
        int n4 = 0;
        n4 = 0;
        int n5 = n3;
        while (n4 < n5) {
            n2 = n4++;
            n = 0;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl3 = false;
            ((Map)this.cachedSessionIdChannels).put(sessionId, channel);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            n5 = 0;
            n2 = 0;
            n2 = 0;
            n = n3;
            while (n2 < n) {
                int n6 = n2++;
                boolean bl4 = false;
                readLock.lock();
            }
            writeLock.unlock();
        }
        return sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Channel getChannel(long sessionId) {
        Channel channel;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        boolean bl = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            boolean bl2 = false;
            channel = this.cachedSessionIdChannels.get(sessionId);
        }
        finally {
            readLock.unlock();
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Channel removeChannel(long sessionId) {
        Channel channel;
        int n;
        int n2;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        boolean bl = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        boolean bl2 = false;
        int n4 = 0;
        n4 = 0;
        int n5 = n3;
        while (n4 < n5) {
            n2 = n4++;
            n = 0;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl3 = false;
            channel = this.cachedSessionIdChannels.remove(sessionId);
        }
        finally {
            n5 = 0;
            n2 = 0;
            n2 = 0;
            n = n3;
            while (n2 < n) {
                int n6 = n2++;
                boolean bl4 = false;
                readLock.lock();
            }
            writeLock.unlock();
        }
        return channel;
    }

    public final void forceOff() {
        this.tunnelChannel.writeAndFlush((Object)new ProtoMessage(ProtoMessageType.FORCE_OFF, null, null, 6, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void depose() {
        int n;
        int n2;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        boolean bl = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        boolean bl2 = false;
        int n4 = 0;
        n4 = 0;
        int n5 = n3;
        while (n4 < n5) {
            n2 = n4++;
            n = 0;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl3 = false;
            Map $this$forEach$iv = this.cachedSessionIdChannels;
            boolean $i$f$forEach = false;
            Map map = $this$forEach$iv;
            boolean bl4 = false;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry $dstr$_u24__u24$ch = element$iv = iterator.next();
                boolean bl5 = false;
                Map.Entry entry = $dstr$_u24__u24$ch;
                boolean bl6 = false;
                Channel ch = (Channel)entry.getValue();
                ch.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
            this.cachedSessionIdChannels.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            n5 = 0;
            n2 = 0;
            n2 = 0;
            n = n3;
            while (n2 < n) {
                int n6 = n2++;
                boolean bl7 = false;
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    public final long getTunnelId() {
        return this.tunnelId;
    }

    @NotNull
    public final TunnelRequest getTunnelRequest() {
        return this.tunnelRequest;
    }

    @NotNull
    public final Channel getTunnelChannel() {
        return this.tunnelChannel;
    }

    public SessionChannels(long tunnelId, @NotNull TunnelRequest tunnelRequest, @NotNull Channel tunnelChannel) {
        Intrinsics.checkParameterIsNotNull((Object)tunnelRequest, (String)"tunnelRequest");
        Intrinsics.checkParameterIsNotNull((Object)tunnelChannel, (String)"tunnelChannel");
        this.tunnelId = tunnelId;
        this.tunnelRequest = tunnelRequest;
        this.tunnelChannel = tunnelChannel;
        this.ids = new IncIds();
        SessionChannels sessionChannels = this;
        boolean bl = false;
        HashMap hashMap = new HashMap();
        sessionChannels.cachedSessionIdChannels = hashMap;
        this.lock = new ReentrantReadWriteLock();
        this.statistics = Statistics.-Companion.newInstance();
    }
}

