/*
 * Decompiled with CFR 0.152.
 */
package lighttunnel.server;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import lighttunnel.proto.ProtoException;
import lighttunnel.proto.ProtoMessage;
import lighttunnel.proto.ProtoMessageType;
import lighttunnel.proto.TunnelRequest;
import lighttunnel.server.TunnelRequestInterceptor;
import lighttunnel.server.TunnelServerChannelHandler$$special$;
import lighttunnel.server.TunnelServerChannelHandler$WhenMappings;
import lighttunnel.server.http.HttpFd;
import lighttunnel.server.http.HttpTunnel;
import lighttunnel.server.tcp.TcpFd;
import lighttunnel.server.tcp.TcpTunnel;
import lighttunnel.server.util.-ConstsKt;
import lighttunnel.server.util.SessionChannels;
import lighttunnel.util.IncIds;
import lighttunnel.util.LongUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B9\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u001c\u0010\u0017\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u0002H\u0014J\u0018\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0002H\u0002J\u0018\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0002H\u0002J\u0018\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0002H\u0002J\u0018\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0002H\u0002J\u0018\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0002H\u0002J\u0018\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0002H\u0002J\u001c\u0010\u001f\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010 \u001a\u0004\u0018\u00010!H\u0016J\u001a\u0010\"\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010#\u001a\u0004\u0018\u00010$H&J\u001a\u0010\"\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010%\u001a\u0004\u0018\u00010&H&J\u001a\u0010'\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010#\u001a\u0004\u0018\u00010$H&J\u001a\u0010'\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010%\u001a\u0004\u0018\u00010&H&J\u001c\u0010(\u001a\u00020\u0014*\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010)\u001a\u00020*H\u0002J\u001c\u0010+\u001a\u00020\u0014*\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010)\u001a\u00020*H\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Llighttunnel/server/TunnelServerChannelHandler;", "Lio/netty/channel/SimpleChannelInboundHandler;", "Llighttunnel/proto/ProtoMessage;", "tunnelRequestInterceptor", "Llighttunnel/server/TunnelRequestInterceptor;", "tunnelIds", "Llighttunnel/util/IncIds;", "tcpTunnel", "Llighttunnel/server/tcp/TcpTunnel;", "httpTunnel", "Llighttunnel/server/http/HttpTunnel;", "httpsTunnel", "(Llighttunnel/server/TunnelRequestInterceptor;Llighttunnel/util/IncIds;Llighttunnel/server/tcp/TcpTunnel;Llighttunnel/server/http/HttpTunnel;Llighttunnel/server/http/HttpTunnel;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "logger$delegate", "Lkotlin/Lazy;", "channelInactive", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "channelRead0", "msg", "doHandleForcedOfflineReplyMessage", "doHandleLocalConnectedMessage", "doHandleLocalDisconnectMessage", "doHandlePingMessage", "doHandleRequestMessage", "doHandleTransferMessage", "exceptionCaught", "cause", "", "onChannelConnected", "httpFd", "Llighttunnel/server/http/HttpFd;", "tcpFd", "Llighttunnel/server/tcp/TcpFd;", "onChannelInactive", "handleHttpRequestMessage", "tunnelRequest", "Llighttunnel/proto/TunnelRequest;", "handleTcpRequestMessage", "server"})
public abstract class TunnelServerChannelHandler
extends SimpleChannelInboundHandler<ProtoMessage> {
    private final Lazy logger$delegate;
    private final TunnelRequestInterceptor tunnelRequestInterceptor;
    private final IncIds tunnelIds;
    private final TcpTunnel tcpTunnel;
    private final HttpTunnel httpTunnel;
    private final HttpTunnel httpsTunnel;

    private final Logger getLogger() {
        Lazy lazy = this.logger$delegate;
        TunnelServerChannelHandler tunnelServerChannelHandler = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    public void channelInactive(@Nullable ChannelHandlerContext ctx) {
        this.getLogger().trace("channelInactive: {}", (Object)ctx);
        if (ctx == null) {
            super.channelInactive(ctx);
            return;
        }
        SessionChannels sessionChannels = (SessionChannels)ctx.channel().attr(-ConstsKt.getAK_SESSION_CHANNELS()).get();
        if (sessionChannels != null) {
            SessionChannels sessionChannels2 = sessionChannels;
            boolean bl = false;
            boolean bl2 = false;
            SessionChannels sc = sessionChannels2;
            boolean bl3 = false;
            switch (TunnelServerChannelHandler$WhenMappings.$EnumSwitchMapping$0[sc.getTunnelRequest().getType().ordinal()]) {
                case 1: {
                    TcpTunnel tcpTunnel = this.tcpTunnel;
                    this.onChannelInactive(ctx, tcpTunnel != null ? tcpTunnel.stopTunnel(sc.getTunnelRequest().getRemotePort()) : null);
                    break;
                }
                case 2: {
                    HttpTunnel httpTunnel = this.httpTunnel;
                    this.onChannelInactive(ctx, httpTunnel != null ? httpTunnel.stopTunnel(sc.getTunnelRequest().getHost()) : null);
                    break;
                }
                case 3: {
                    HttpTunnel httpTunnel = this.httpsTunnel;
                    this.onChannelInactive(ctx, httpTunnel != null ? httpTunnel.stopTunnel(sc.getTunnelRequest().getHost()) : null);
                    break;
                }
            }
        }
        ctx.channel().attr(-ConstsKt.getAK_SESSION_CHANNELS()).set(null);
        super.channelInactive(ctx);
    }

    public void exceptionCaught(@Nullable ChannelHandlerContext ctx, @Nullable Throwable cause) {
        block0: {
            this.getLogger().trace("exceptionCaught: {}", (Object)ctx, (Object)cause);
            ChannelHandlerContext channelHandlerContext = ctx;
            if (channelHandlerContext == null) break block0;
            ChannelHandlerContext channelHandlerContext2 = channelHandlerContext;
            boolean bl = false;
            boolean bl2 = false;
            ChannelHandlerContext $this$apply = channelHandlerContext2;
            boolean bl3 = false;
            $this$apply.channel().writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    protected void channelRead0(@Nullable ChannelHandlerContext ctx, @Nullable ProtoMessage msg) {
        this.getLogger().trace("channelRead0: {}", (Object)ctx);
        if (ctx == null) {
            return;
        }
        if (msg == null) {
            return;
        }
        switch (TunnelServerChannelHandler$WhenMappings.$EnumSwitchMapping$1[msg.getType().ordinal()]) {
            case 1: {
                this.doHandlePingMessage(ctx, msg);
                break;
            }
            case 2: {
                this.doHandleRequestMessage(ctx, msg);
                break;
            }
            case 3: {
                this.doHandleTransferMessage(ctx, msg);
                break;
            }
            case 4: {
                this.doHandleLocalConnectedMessage(ctx, msg);
                break;
            }
            case 5: {
                this.doHandleLocalDisconnectMessage(ctx, msg);
                break;
            }
            case 6: {
                this.doHandleForcedOfflineReplyMessage(ctx, msg);
                break;
            }
        }
    }

    private final void doHandlePingMessage(ChannelHandlerContext ctx, ProtoMessage msg) throws Exception {
        this.getLogger().trace("doHandlePingMessage# {}, {}", (Object)ctx, (Object)msg);
        ctx.writeAndFlush((Object)new ProtoMessage(ProtoMessageType.PONG, null, null, 6, null));
    }

    private final void doHandleRequestMessage(ChannelHandlerContext ctx, ProtoMessage msg) throws Exception {
        this.getLogger().trace("doHandleRequestMessage# {}, {}", (Object)ctx, (Object)msg);
        try {
            TunnelRequest originalTunnelRequest = TunnelRequest.Companion.fromBytes(msg.getHead());
            TunnelRequest finalTunnelRequest = this.tunnelRequestInterceptor.handleTunnelRequest(originalTunnelRequest);
            this.getLogger().trace("TunnelRequest=> original: {}, final: {}", (Object)originalTunnelRequest, (Object)finalTunnelRequest);
            switch (TunnelServerChannelHandler$WhenMappings.$EnumSwitchMapping$2[finalTunnelRequest.getType().ordinal()]) {
                case 1: {
                    TcpTunnel tcpTunnel = this.tcpTunnel;
                    if (tcpTunnel == null) {
                        throw (Throwable)new ProtoException("TCP\u534f\u8bae\u96a7\u9053\u672a\u5f00\u542f", null, 2, null);
                    }
                    TcpTunnel tcpTunnel2 = tcpTunnel;
                    this.handleTcpRequestMessage(tcpTunnel2, ctx, finalTunnelRequest);
                    break;
                }
                case 2: {
                    HttpTunnel httpTunnel = this.httpTunnel;
                    if (httpTunnel == null) {
                        throw (Throwable)new ProtoException("HTTP\u534f\u8bae\u96a7\u9053\u672a\u5f00\u542f", null, 2, null);
                    }
                    HttpTunnel httpTunnel2 = httpTunnel;
                    this.handleHttpRequestMessage(httpTunnel2, ctx, finalTunnelRequest);
                    break;
                }
                case 3: {
                    HttpTunnel httpTunnel = this.httpsTunnel;
                    if (httpTunnel == null) {
                        throw (Throwable)new ProtoException("HTTPS\u534f\u8bae\u96a7\u9053\u672a\u5f00\u542f", null, 2, null);
                    }
                    HttpTunnel httpsTunnel = httpTunnel;
                    this.handleHttpRequestMessage(httpsTunnel, ctx, finalTunnelRequest);
                    break;
                }
                default: {
                    throw (Throwable)new ProtoException("\u4e0d\u652f\u6301\u7684\u96a7\u9053\u7c7b\u578b", null, 2, null);
                }
            }
        }
        catch (Exception e) {
            String string = String.valueOf(e.getMessage());
            ProtoMessageType protoMessageType = ProtoMessageType.RESPONSE_ERR;
            Channel channel = ctx.channel();
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = byArray;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 4;
            byte[] byArray3 = null;
            byte[] byArray4 = byArray2;
            ProtoMessageType protoMessageType2 = protoMessageType;
            channel.writeAndFlush((Object)new ProtoMessage(protoMessageType2, byArray4, byArray3, n, defaultConstructorMarker)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private final void doHandleTransferMessage(ChannelHandlerContext ctx, ProtoMessage msg) throws Exception {
        block1: {
            Channel sessionChannel;
            this.getLogger().trace("doHandleTransferMessage# {}, {}", (Object)ctx, (Object)msg);
            SessionChannels sessionChannels = (SessionChannels)ctx.channel().attr(-ConstsKt.getAK_SESSION_CHANNELS()).get();
            if (sessionChannels == null) {
                return;
            }
            SessionChannels sessionChannels2 = sessionChannels;
            Channel channel = sessionChannel = sessionChannels2.getChannel(msg.getSessionId());
            if (channel == null) break block1;
            channel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])msg.getData()));
        }
    }

    private final void doHandleLocalConnectedMessage(ChannelHandlerContext ctx, ProtoMessage msg) throws Exception {
        this.getLogger().trace("doHandleLocalConnectedMessage# {}, {}", (Object)ctx, (Object)msg);
    }

    private final void doHandleLocalDisconnectMessage(ChannelHandlerContext ctx, ProtoMessage msg) throws Exception {
        block1: {
            this.getLogger().trace("doHandleLocalDisconnectMessage# {}, {}", (Object)ctx, (Object)msg);
            SessionChannels sessionChannels = (SessionChannels)ctx.channel().attr(-ConstsKt.getAK_SESSION_CHANNELS()).get();
            if (sessionChannels == null) {
                return;
            }
            SessionChannels sessionChannels2 = sessionChannels;
            Channel sessionChannel = sessionChannels2.removeChannel(msg.getSessionId());
            Channel channel = sessionChannel;
            if (channel == null || (channel = channel.writeAndFlush((Object)Unpooled.EMPTY_BUFFER)) == null) break block1;
            channel.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private final void doHandleForcedOfflineReplyMessage(ChannelHandlerContext ctx, ProtoMessage msg) throws Exception {
        block0: {
            this.getLogger().trace("doHandleForcedOfflineReplyMessage# {}, {}", (Object)ctx, (Object)msg);
            Channel channel = ctx.channel();
            if (channel == null) break block0;
            channel.close();
        }
    }

    private final void handleTcpRequestMessage(@NotNull TcpTunnel $this$handleTcpRequestMessage, ChannelHandlerContext ctx, TunnelRequest tunnelRequest) throws Exception {
        $this$handleTcpRequestMessage.requireNotRegistered(tunnelRequest.getRemotePort());
        long tunnelId = this.tunnelIds.getNextId();
        Channel channel = ctx.channel();
        Intrinsics.checkExpressionValueIsNotNull((Object)channel, (String)"ctx.channel()");
        SessionChannels sessionChannels = new SessionChannels(tunnelId, tunnelRequest, channel);
        ctx.channel().attr(-ConstsKt.getAK_SESSION_CHANNELS()).set((Object)sessionChannels);
        this.onChannelConnected(ctx, $this$handleTcpRequestMessage.startTunnel(null, tunnelRequest.getRemotePort(), sessionChannels));
        byte[] head = LongUtil.INSTANCE.toBytes(new long[]{tunnelId, 0L});
        byte[] data = tunnelRequest.toBytes();
        ctx.channel().writeAndFlush((Object)new ProtoMessage(ProtoMessageType.RESPONSE_OK, head, data));
    }

    private final void handleHttpRequestMessage(@NotNull HttpTunnel $this$handleHttpRequestMessage, ChannelHandlerContext ctx, TunnelRequest tunnelRequest) throws Exception {
        $this$handleHttpRequestMessage.requireNotRegistered(tunnelRequest.getHost());
        long tunnelId = this.tunnelIds.getNextId();
        Channel channel = ctx.channel();
        Intrinsics.checkExpressionValueIsNotNull((Object)channel, (String)"ctx.channel()");
        SessionChannels sessionChannels = new SessionChannels(tunnelId, tunnelRequest, channel);
        ctx.channel().attr(-ConstsKt.getAK_SESSION_CHANNELS()).set((Object)sessionChannels);
        this.onChannelConnected(ctx, $this$handleHttpRequestMessage.startTunnel(tunnelRequest.getHost(), sessionChannels));
        byte[] head = LongUtil.INSTANCE.toBytes(new long[]{tunnelId, 0L});
        byte[] data = tunnelRequest.toBytes();
        ctx.channel().writeAndFlush((Object)new ProtoMessage(ProtoMessageType.RESPONSE_OK, head, data));
    }

    public abstract void onChannelInactive(@NotNull ChannelHandlerContext var1, @Nullable TcpFd var2);

    public abstract void onChannelInactive(@NotNull ChannelHandlerContext var1, @Nullable HttpFd var2);

    public abstract void onChannelConnected(@NotNull ChannelHandlerContext var1, @Nullable TcpFd var2);

    public abstract void onChannelConnected(@NotNull ChannelHandlerContext var1, @Nullable HttpFd var2);

    public TunnelServerChannelHandler(@NotNull TunnelRequestInterceptor tunnelRequestInterceptor, @NotNull IncIds tunnelIds, @Nullable TcpTunnel tcpTunnel, @Nullable HttpTunnel httpTunnel, @Nullable HttpTunnel httpsTunnel) {
        Lazy lazy;
        Intrinsics.checkParameterIsNotNull((Object)tunnelRequestInterceptor, (String)"tunnelRequestInterceptor");
        Intrinsics.checkParameterIsNotNull((Object)tunnelIds, (String)"tunnelIds");
        this.tunnelRequestInterceptor = tunnelRequestInterceptor;
        this.tunnelIds = tunnelIds;
        this.tcpTunnel = tcpTunnel;
        this.httpTunnel = httpTunnel;
        this.httpsTunnel = httpsTunnel;
        TunnelServerChannelHandler tunnelServerChannelHandler = this;
        TunnelServerChannelHandler tunnelServerChannelHandler2 = this;
        boolean $i$f$loggerDelegate = false;
        tunnelServerChannelHandler2.logger$delegate = lazy = LazyKt.lazy((Function0)$special$$inlined$loggerDelegate$1.INSTANCE);
    }

    public /* synthetic */ TunnelServerChannelHandler(TunnelRequestInterceptor tunnelRequestInterceptor, IncIds incIds, TcpTunnel tcpTunnel, HttpTunnel httpTunnel, HttpTunnel httpTunnel2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            tcpTunnel = null;
        }
        if ((n & 8) != 0) {
            httpTunnel = null;
        }
        if ((n & 0x10) != 0) {
            httpTunnel2 = null;
        }
        this(tunnelRequestInterceptor, incIds, tcpTunnel, httpTunnel, httpTunnel2);
    }
}

