/*
 * Decompiled with CFR 0.152.
 */
package lighttunnel.server.http;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import lighttunnel.proto.ProtoException;
import lighttunnel.server.http.HttpFd;
import lighttunnel.server.http.HttpRegistry$$special$;
import lighttunnel.server.util.-ConstsKt;
import lighttunnel.server.util.SessionChannels;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0015\u001a\u00020\u0005J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0015\u001a\u00020\u0005J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0018J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0005J\u0016\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0012\u0010 \u001a\u0004\u0018\u00010\u00062\b\u0010\u0015\u001a\u0004\u0018\u00010\u0005J\u0012\u0010!\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u0002R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Llighttunnel/server/http/HttpRegistry;", "", "()V", "hostHttpFds", "Ljava/util/HashMap;", "", "Llighttunnel/server/http/HttpFd;", "Lkotlin/collections/HashMap;", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "logger$delegate", "Lkotlin/Lazy;", "sdf", "Ljava/text/SimpleDateFormat;", "depose", "", "forceOff", "host", "getHttpFd", "httpFds", "", "isRegistered", "", "register", "sessionChannels", "Llighttunnel/server/util/SessionChannels;", "toJson", "Lorg/json/JSONArray;", "unregister", "unsafeUnregister", "server"})
public final class HttpRegistry {
    private final Lazy logger$delegate;
    private final HashMap<String, HttpFd> hostHttpFds;
    private final ReentrantReadWriteLock lock;
    private final SimpleDateFormat sdf;

    private final Logger getLogger() {
        Lazy lazy = this.logger$delegate;
        HttpRegistry httpRegistry = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final HttpFd register(@NotNull String host, @NotNull SessionChannels sessionChannels) throws ProtoException {
        int n;
        int n2;
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        Intrinsics.checkParameterIsNotNull((Object)sessionChannels, (String)"sessionChannels");
        if (this.isRegistered(host)) {
            throw (Throwable)new ProtoException("host(" + host + ") already used", null, 2, null);
        }
        HttpFd httpFd = new HttpFd(host, sessionChannels);
        boolean bl = false;
        boolean bl2 = false;
        HttpFd fd = httpFd;
        boolean bl3 = false;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        boolean bl4 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        boolean bl5 = false;
        int n4 = 0;
        n4 = 0;
        int n5 = n3;
        while (n4 < n5) {
            n2 = n4++;
            n = 0;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl6 = false;
            ((Map)this.hostHttpFds).put(host, fd);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            n5 = 0;
            n2 = 0;
            n2 = 0;
            n = n3;
            while (n2 < n) {
                int n6 = n2++;
                boolean bl7 = false;
                readLock.lock();
            }
            writeLock.unlock();
        }
        this.getLogger().debug("Start Tunnel: {}, Options: {}", (Object)sessionChannels.getTunnelRequest(), (Object)sessionChannels.getTunnelRequest().getOptionsString());
        return httpFd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final HttpFd unregister(@Nullable String host) {
        HttpFd httpFd;
        int n;
        int n2;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        boolean bl = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        boolean bl2 = false;
        int n4 = 0;
        n4 = 0;
        int n5 = n3;
        while (n4 < n5) {
            n2 = n4++;
            n = 0;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl3 = false;
            this.unsafeUnregister(host);
            Map map = this.hostHttpFds;
            String string = host;
            boolean bl4 = false;
            Map map2 = map;
            if (map2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<K, V>");
            }
            httpFd = (HttpFd)TypeIntrinsics.asMutableMap((Object)map2).remove(string);
        }
        finally {
            n5 = 0;
            n2 = 0;
            n2 = 0;
            n = n3;
            while (n2 < n) {
                int n6 = n2++;
                boolean bl5 = false;
                readLock.lock();
            }
            writeLock.unlock();
        }
        return httpFd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void depose() {
        int n;
        int n2;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        boolean bl = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        boolean bl2 = false;
        int n4 = 0;
        n4 = 0;
        int n5 = n3;
        while (n4 < n5) {
            n2 = n4++;
            n = 0;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl3 = false;
            Map $this$forEach$iv = this.hostHttpFds;
            boolean $i$f$forEach = false;
            Map map = $this$forEach$iv;
            boolean bl4 = false;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry $dstr$host$_u24__u24 = element$iv = iterator.next();
                boolean bl5 = false;
                Map.Entry entry = $dstr$host$_u24__u24;
                boolean bl6 = false;
                String host = (String)entry.getKey();
                this.unsafeUnregister(host);
            }
            this.hostHttpFds.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            n5 = 0;
            n2 = 0;
            n2 = 0;
            n = n3;
            while (n2 < n) {
                int n6 = n2++;
                boolean bl7 = false;
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isRegistered(@NotNull String host) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            boolean bl3 = false;
            Map map = this.hostHttpFds;
            String string = host;
            boolean bl4 = false;
            Map map2 = map;
            boolean bl5 = false;
            bl = map2.containsKey(string);
        }
        finally {
            readLock.unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final HttpFd getHttpFd(@NotNull String host) {
        HttpFd httpFd;
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        boolean bl = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            boolean bl2 = false;
            httpFd = this.hostHttpFds.get(host);
        }
        finally {
            readLock.unlock();
        }
        return httpFd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<HttpFd> httpFds() {
        List list;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        boolean bl = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            boolean bl2 = false;
            Collection<HttpFd> collection = this.hostHttpFds.values();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"hostHttpFds.values");
            list = CollectionsKt.toList((Iterable)collection);
        }
        finally {
            readLock.unlock();
        }
        return list;
    }

    @Nullable
    public final HttpFd forceOff(@NotNull String host) {
        HttpFd httpFd;
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        HttpFd httpFd2 = this.getHttpFd(host);
        if (httpFd2 != null) {
            HttpFd httpFd3 = httpFd2;
            boolean bl = false;
            boolean bl2 = false;
            HttpFd $this$apply = httpFd3;
            boolean bl3 = false;
            $this$apply.forceOff$server();
            httpFd = httpFd3;
        } else {
            httpFd = null;
        }
        return httpFd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final JSONArray toJson() {
        JSONArray jSONArray;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        boolean bl = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            JSONArray jSONArray2;
            boolean bl2 = false;
            if (this.hostHttpFds.isEmpty()) {
                jSONArray2 = -ConstsKt.getEMPTY_JSON_ARRAY();
            } else {
                Collection<JSONObject> collection;
                void $this$mapTo$iv$iv;
                Collection<HttpFd> collection2 = this.hostHttpFds.values();
                Intrinsics.checkExpressionValueIsNotNull(collection2, (String)"hostHttpFds.values");
                Iterable $this$map$iv = collection2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void fd;
                    HttpFd httpFd = (HttpFd)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    JSONObject jSONObject = new JSONObject();
                    boolean bl4 = false;
                    boolean bl5 = false;
                    JSONObject $this$apply = jSONObject;
                    boolean bl6 = false;
                    $this$apply.put("host", (Object)fd.getHost$server());
                    $this$apply.put("conns", fd.getSessionChannels$server().getCachedChannelCount());
                    $this$apply.put("name", (Object)fd.getSessionChannels$server().getTunnelRequest().getName());
                    $this$apply.put("localAddr", (Object)fd.getSessionChannels$server().getTunnelRequest().getLocalAddr());
                    $this$apply.put("localPort", fd.getSessionChannels$server().getTunnelRequest().getLocalPort());
                    $this$apply.put("createAt", (Object)this.sdf.format(fd.getSessionChannels$server().getCreateAt()));
                    $this$apply.put("updateAt", (Object)this.sdf.format(fd.getSessionChannels$server().getUpdateAt()));
                    $this$apply.put("inboundBytes", fd.getSessionChannels$server().getInboundBytes().get());
                    $this$apply.put("outboundBytes", fd.getSessionChannels$server().getOutboundBytes().get());
                    JSONObject jSONObject2 = jSONObject;
                    collection.add(jSONObject2);
                }
                collection = (List)destination$iv$iv;
                Collection collection3 = collection;
                jSONArray2 = new JSONArray(collection3);
            }
            jSONArray = jSONArray2;
        }
        finally {
            readLock.unlock();
        }
        return jSONArray;
    }

    private final void unsafeUnregister(String host) {
        block1: {
            if (host == null) {
                return;
            }
            HttpFd httpFd = this.hostHttpFds.get(host);
            if (httpFd == null) break block1;
            HttpFd httpFd2 = httpFd;
            boolean bl = false;
            boolean bl2 = false;
            HttpFd $this$apply = httpFd2;
            boolean bl3 = false;
            $this$apply.close$server();
            this.getLogger().debug("Shutdown Tunnel: {}", (Object)$this$apply.getSessionChannels$server().getTunnelRequest());
        }
    }

    public HttpRegistry() {
        Object object;
        HttpRegistry $this$loggerDelegate$iv = this;
        HttpRegistry httpRegistry = this;
        boolean $i$f$loggerDelegate = false;
        httpRegistry.logger$delegate = object = LazyKt.lazy((Function0)$special$$inlined$loggerDelegate$1.INSTANCE);
        httpRegistry = this;
        boolean bl = false;
        httpRegistry.hostHttpFds = object = new HashMap();
        this.lock = new ReentrantReadWriteLock();
        this.sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }
}

