/*
 * Decompiled with CFR 0.152.
 */
package lighttunnel.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.ssl.SslContext;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import lighttunnel.http.server.HttpServer;
import lighttunnel.http.server.RouterMappings;
import lighttunnel.proto.HeartbeatHandler;
import lighttunnel.proto.ProtoMessageDecoder;
import lighttunnel.proto.ProtoMessageEncoder;
import lighttunnel.proto.TunnelRequest;
import lighttunnel.server.TunnelRequestInterceptor;
import lighttunnel.server.TunnelServer;
import lighttunnel.server.TunnelServer$$special$;
import lighttunnel.server.TunnelServerChannelHandler;
import lighttunnel.server.http.HttpFd;
import lighttunnel.server.http.HttpPlugin;
import lighttunnel.server.http.HttpRegistry;
import lighttunnel.server.http.HttpRequestInterceptor;
import lighttunnel.server.http.HttpTunnel;
import lighttunnel.server.tcp.TcpFd;
import lighttunnel.server.tcp.TcpRegistry;
import lighttunnel.server.tcp.TcpTunnel;
import lighttunnel.server.traffic.TrafficHandler;
import lighttunnel.util.IncIds;
import lighttunnel.util.SslContextUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u000e\u0018\u00002\u00020\u0001:\bEFGHIJKLBk\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0002\u0010\u0013J\u0006\u0010-\u001a\u00020.J\u0018\u0010/\u001a\u0004\u0018\u0001002\u0006\u00101\u001a\u0002002\u0006\u00102\u001a\u000203J\u0010\u0010/\u001a\u0004\u0018\u0001042\u0006\u00101\u001a\u000204J\u000e\u00105\u001a\u0002062\u0006\u00101\u001a\u000200J\u0012\u00107\u001a\u0004\u0018\u00010\u00192\u0006\u00108\u001a\u00020\u000eH\u0002J\u001a\u00109\u001a\u0004\u0018\u00010\u001b2\u0006\u0010:\u001a\u00020\u00172\u0006\u00108\u001a\u00020\nH\u0002J\u001a\u0010;\u001a\u0004\u0018\u00010\u001b2\u0006\u0010:\u001a\u00020\u00172\u0006\u00108\u001a\u00020\fH\u0002J\u000e\u0010<\u001a\u0002062\u0006\u00101\u001a\u000204J\u0010\u0010=\u001a\u00020)2\u0006\u0010:\u001a\u00020'H\u0002J\f\u0010>\u001a\b\u0012\u0004\u0012\u0002000?J\f\u0010@\u001a\b\u0012\u0004\u0012\u0002000?J\u0006\u0010A\u001a\u00020.J\u0010\u0010B\u001a\u00020.2\u0006\u00108\u001a\u00020\bH\u0002J\u0010\u0010C\u001a\u00020.2\u0006\u00108\u001a\u00020\u0006H\u0002J\f\u0010D\u001a\b\u0012\u0004\u0012\u0002040?R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010 \u001a\u00020!8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b\"\u0010#R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Llighttunnel/server/TunnelServer;", "", "bossThreads", "", "workerThreads", "tunnelDaemonArgs", "Llighttunnel/server/TunnelServer$TunnelDaemonArgs;", "sslTunnelDaemonArgs", "Llighttunnel/server/TunnelServer$SslTunnelDaemonArgs;", "httpTunnelArgs", "Llighttunnel/server/TunnelServer$HttpTunnelArgs;", "httpsTunnelArgs", "Llighttunnel/server/TunnelServer$HttpsTunnelArgs;", "httpRpcServerArgs", "Llighttunnel/server/TunnelServer$HttpRpcServerArgs;", "onTcpTunnelStateListener", "Llighttunnel/server/TunnelServer$OnTcpTunnelStateListener;", "onHttpTunnelStateListener", "Llighttunnel/server/TunnelServer$OnHttpTunnelStateListener;", "(IILlighttunnel/server/TunnelServer$TunnelDaemonArgs;Llighttunnel/server/TunnelServer$SslTunnelDaemonArgs;Llighttunnel/server/TunnelServer$HttpTunnelArgs;Llighttunnel/server/TunnelServer$HttpsTunnelArgs;Llighttunnel/server/TunnelServer$HttpRpcServerArgs;Llighttunnel/server/TunnelServer$OnTcpTunnelStateListener;Llighttunnel/server/TunnelServer$OnHttpTunnelStateListener;)V", "bossGroup", "Lio/netty/channel/nio/NioEventLoopGroup;", "httpRegistry", "Llighttunnel/server/http/HttpRegistry;", "httpRpcServer", "Llighttunnel/http/server/HttpServer;", "httpTunnel", "Llighttunnel/server/http/HttpTunnel;", "httpsRegistry", "httpsTunnel", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "logger$delegate", "Lkotlin/Lazy;", "tcpRegistry", "Llighttunnel/server/tcp/TcpRegistry;", "tcpTunnel", "Llighttunnel/server/tcp/TcpTunnel;", "tunnelIds", "Llighttunnel/util/IncIds;", "workerGroup", "depose", "", "forceOff", "Llighttunnel/server/http/HttpFd;", "fd", "https", "", "Llighttunnel/server/tcp/TcpFd;", "getHttpFdRequest", "Llighttunnel/proto/TunnelRequest;", "getHttpRpcServer", "args", "getHttpTunnel", "registry", "getHttpsTunnel", "getTcpFdRequest", "getTcpTunnel", "httpFds", "", "httpsFds", "start", "startSslTunnelDaemon", "startTunnelDaemon", "tcpFds", "HttpRpcServerArgs", "HttpTunnelArgs", "HttpsTunnelArgs", "InnerTunnelServerChannelHandler", "OnHttpTunnelStateListener", "OnTcpTunnelStateListener", "SslTunnelDaemonArgs", "TunnelDaemonArgs", "server"})
public final class TunnelServer {
    private final Lazy logger$delegate;
    private final ReentrantLock lock;
    private final IncIds tunnelIds;
    private final NioEventLoopGroup bossGroup;
    private final NioEventLoopGroup workerGroup;
    private final TcpRegistry tcpRegistry;
    private final TcpTunnel tcpTunnel;
    private final HttpRegistry httpRegistry;
    private final HttpTunnel httpTunnel;
    private final HttpRegistry httpsRegistry;
    private final HttpTunnel httpsTunnel;
    private final HttpServer httpRpcServer;
    private final TunnelDaemonArgs tunnelDaemonArgs;
    private final SslTunnelDaemonArgs sslTunnelDaemonArgs;
    private final OnTcpTunnelStateListener onTcpTunnelStateListener;
    private final OnHttpTunnelStateListener onHttpTunnelStateListener;

    private final Logger getLogger() {
        Lazy lazy = this.logger$delegate;
        TunnelServer tunnelServer = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() throws Exception {
        Lock lock = this.lock;
        boolean bl = false;
        lock.lock();
        try {
            boolean bl2 = false;
            HttpTunnel httpTunnel = this.httpTunnel;
            if (httpTunnel != null) {
                httpTunnel.start();
            }
            HttpTunnel httpTunnel2 = this.httpsTunnel;
            if (httpTunnel2 != null) {
                httpTunnel2.start();
            }
            HttpServer httpServer = this.httpRpcServer;
            if (httpServer != null) {
                httpServer.start();
            }
            this.startTunnelDaemon(this.tunnelDaemonArgs);
            SslTunnelDaemonArgs sslTunnelDaemonArgs = this.sslTunnelDaemonArgs;
            if (sslTunnelDaemonArgs != null) {
                SslTunnelDaemonArgs sslTunnelDaemonArgs2 = sslTunnelDaemonArgs;
                boolean bl3 = false;
                boolean bl4 = false;
                SslTunnelDaemonArgs it = sslTunnelDaemonArgs2;
                boolean bl5 = false;
                this.startSslTunnelDaemon(it);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void depose() {
        Lock lock = this.lock;
        boolean bl = false;
        lock.lock();
        try {
            boolean bl2 = false;
            this.tcpRegistry.depose();
            this.httpRegistry.depose();
            this.httpsRegistry.depose();
            HttpServer httpServer = this.httpRpcServer;
            if (httpServer != null) {
                httpServer.depose();
            }
            this.bossGroup.shutdownGracefully();
            this.workerGroup.shutdownGracefully();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @NotNull
    public final List<TcpFd> tcpFds() {
        return this.tcpRegistry.tcpFds();
    }

    @NotNull
    public final List<HttpFd> httpFds() {
        return this.httpRegistry.httpFds();
    }

    @NotNull
    public final List<HttpFd> httpsFds() {
        return this.httpsRegistry.httpFds();
    }

    @Nullable
    public final TcpFd forceOff(@NotNull TcpFd fd) {
        Intrinsics.checkParameterIsNotNull((Object)fd, (String)"fd");
        return this.tcpRegistry.forceOff(fd.getPort$server());
    }

    @Nullable
    public final HttpFd forceOff(@NotNull HttpFd fd, boolean https) {
        Intrinsics.checkParameterIsNotNull((Object)fd, (String)"fd");
        return (https ? this.httpsRegistry : this.httpRegistry).forceOff(fd.getHost$server());
    }

    @NotNull
    public final TunnelRequest getTcpFdRequest(@NotNull TcpFd fd) {
        Intrinsics.checkParameterIsNotNull((Object)fd, (String)"fd");
        return fd.getSessionChannels$server().getTunnelRequest();
    }

    @NotNull
    public final TunnelRequest getHttpFdRequest(@NotNull HttpFd fd) {
        Intrinsics.checkParameterIsNotNull((Object)fd, (String)"fd");
        return fd.getSessionChannels$server().getTunnelRequest();
    }

    private final void startTunnelDaemon(TunnelDaemonArgs args) {
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        ((ServerBootstrap)serverBootstrap.group((EventLoopGroup)this.bossGroup, (EventLoopGroup)this.workerGroup).channel(NioServerSocketChannel.class)).childOption(ChannelOption.AUTO_READ, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(this, args){
            final /* synthetic */ TunnelServer this$0;
            final /* synthetic */ TunnelDaemonArgs $args;

            protected void initChannel(@Nullable SocketChannel ch) {
                if (ch == null) {
                    return;
                }
                ch.pipeline().addLast("traffic", (ChannelHandler)new TrafficHandler()).addLast("heartbeat", (ChannelHandler)new HeartbeatHandler(false, 0L, 0L, 0L, null, 31, null)).addLast("decoder", (ChannelHandler)new ProtoMessageDecoder()).addLast("encoder", (ChannelHandler)new ProtoMessageEncoder()).addLast("handler", (ChannelHandler)this.this$0.new InnerTunnelServerChannelHandler(this.$args.getTunnelRequestInterceptor()));
            }
            {
                this.this$0 = $outer;
                this.$args = $captured_local_variable$1;
            }
        });
        if (args.getBindAddr() == null) {
            serverBootstrap.bind(args.getBindPort()).get();
        } else {
            serverBootstrap.bind(args.getBindAddr(), args.getBindPort()).get();
        }
        Logger logger = this.getLogger();
        String string = args.getBindAddr();
        if (string == null) {
            string = "::";
        }
        logger.info("Serving tunnel on {} port {}", (Object)string, (Object)args.getBindPort());
    }

    private final void startSslTunnelDaemon(SslTunnelDaemonArgs args) {
        if (args.getBindPort() == null) {
            return;
        }
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        ((ServerBootstrap)serverBootstrap.group((EventLoopGroup)this.bossGroup, (EventLoopGroup)this.workerGroup).channel(NioServerSocketChannel.class)).childOption(ChannelOption.AUTO_READ, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(this, args){
            final /* synthetic */ TunnelServer this$0;
            final /* synthetic */ SslTunnelDaemonArgs $args;

            protected void initChannel(@Nullable SocketChannel ch) {
                if (ch == null) {
                    return;
                }
                ch.pipeline().addFirst("ssl", (ChannelHandler)this.$args.getSslContext().newHandler(ch.alloc())).addLast("traffic", (ChannelHandler)new TrafficHandler()).addLast("heartbeat", (ChannelHandler)new HeartbeatHandler(false, 0L, 0L, 0L, null, 31, null)).addLast("decoder", (ChannelHandler)new ProtoMessageDecoder()).addLast("encoder", (ChannelHandler)new ProtoMessageEncoder()).addLast("handler", (ChannelHandler)this.this$0.new InnerTunnelServerChannelHandler(this.$args.getTunnelRequestInterceptor()));
            }
            {
                this.this$0 = $outer;
                this.$args = $captured_local_variable$1;
            }
        });
        if (args.getBindAddr() == null) {
            serverBootstrap.bind(args.getBindPort().intValue()).get();
        } else {
            serverBootstrap.bind(args.getBindAddr(), args.getBindPort().intValue()).get();
        }
        Logger logger = this.getLogger();
        String string = args.getBindAddr();
        if (string == null) {
            string = "::";
        }
        logger.info("Serving tunnel with ssl on {} port {}", (Object)string, (Object)args.getBindPort());
    }

    private final TcpTunnel getTcpTunnel(TcpRegistry registry) {
        return new TcpTunnel(this.bossGroup, this.workerGroup, registry);
    }

    private final HttpTunnel getHttpTunnel(HttpRegistry registry, HttpTunnelArgs args) {
        if (args.getBindPort() == null) {
            return null;
        }
        HttpRegistry httpRegistry = registry;
        HttpPlugin httpPlugin = args.getHttpPlugin();
        int n = 0;
        HttpRequestInterceptor httpRequestInterceptor = args.getHttpRequestInterceptor();
        SslContext sslContext = null;
        int n2 = args.getBindPort();
        String string = args.getBindAddr();
        return new HttpTunnel(this.bossGroup, this.workerGroup, httpRegistry, string, n2, sslContext, n, httpPlugin, httpRequestInterceptor, 64, null);
    }

    private final HttpTunnel getHttpsTunnel(HttpRegistry registry, HttpsTunnelArgs args) {
        if (args.getBindPort() == null) {
            return null;
        }
        HttpRegistry httpRegistry = registry;
        HttpPlugin httpPlugin = args.getHttpPlugin();
        int n = 0;
        HttpRequestInterceptor httpRequestInterceptor = args.getHttpRequestInterceptor();
        SslContext sslContext = args.getSslContext();
        int n2 = args.getBindPort();
        String string = args.getBindAddr();
        return new HttpTunnel(this.bossGroup, this.workerGroup, httpRegistry, string, n2, sslContext, n, httpPlugin, httpRequestInterceptor, 64, null);
    }

    private final HttpServer getHttpRpcServer(HttpRpcServerArgs args) {
        if (args.getBindPort() == null) {
            return null;
        }
        return new HttpServer(this.bossGroup, this.workerGroup, args.getBindAddr(), args.getBindPort().intValue(), null, 0, (Function1)new Function1<RouterMappings, Unit>(this){
            final /* synthetic */ TunnelServer this$0;

            public final void invoke(@NotNull RouterMappings $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                $receiver.route("/api/snapshot", (Function1)new Function1<FullHttpRequest, DefaultFullHttpResponse>(this){
                    final /* synthetic */ getHttpRpcServer.1 this$0;

                    @NotNull
                    public final DefaultFullHttpResponse invoke(@NotNull FullHttpRequest it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        JSONObject obj = new JSONObject();
                        obj.put("tcp", (Object)TunnelServer.access$getTcpRegistry$p(this.this$0.this$0).toJson());
                        obj.put("http", (Object)TunnelServer.access$getHttpRegistry$p(this.this$0.this$0).toJson());
                        obj.put("https", (Object)TunnelServer.access$getHttpsRegistry$p(this.this$0.this$0).toJson());
                        ByteBuf content = Unpooled.copiedBuffer((CharSequence)obj.toString(2), (Charset)Charsets.UTF_8);
                        DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, content);
                        boolean bl = false;
                        boolean bl2 = false;
                        DefaultFullHttpResponse $this$apply = defaultFullHttpResponse;
                        boolean bl3 = false;
                        $this$apply.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_JSON).set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)content.readableBytes());
                        return defaultFullHttpResponse;
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = tunnelServer;
                super(1);
            }
        }, 48, null);
    }

    public TunnelServer(int bossThreads, int workerThreads, @NotNull TunnelDaemonArgs tunnelDaemonArgs, @Nullable SslTunnelDaemonArgs sslTunnelDaemonArgs, @Nullable HttpTunnelArgs httpTunnelArgs, @Nullable HttpsTunnelArgs httpsTunnelArgs, @Nullable HttpRpcServerArgs httpRpcServerArgs, @Nullable OnTcpTunnelStateListener onTcpTunnelStateListener, @Nullable OnHttpTunnelStateListener onHttpTunnelStateListener) {
        Object object;
        Object object2;
        Object object3;
        Object it;
        boolean bl;
        boolean bl2;
        Object object4;
        Intrinsics.checkParameterIsNotNull((Object)tunnelDaemonArgs, (String)"tunnelDaemonArgs");
        this.tunnelDaemonArgs = tunnelDaemonArgs;
        this.sslTunnelDaemonArgs = sslTunnelDaemonArgs;
        this.onTcpTunnelStateListener = onTcpTunnelStateListener;
        this.onHttpTunnelStateListener = onHttpTunnelStateListener;
        Object object5 = this;
        TunnelServer tunnelServer = this;
        boolean $i$f$loggerDelegate = false;
        tunnelServer.logger$delegate = object4 = LazyKt.lazy((Function0)$special$$inlined$loggerDelegate$1.INSTANCE);
        this.lock = new ReentrantLock();
        this.tunnelIds = new IncIds();
        this.bossGroup = bossThreads >= 0 ? new NioEventLoopGroup(bossThreads) : new NioEventLoopGroup();
        this.workerGroup = workerThreads >= 0 ? new NioEventLoopGroup(workerThreads) : new NioEventLoopGroup();
        this.tcpRegistry = new TcpRegistry();
        this.tcpTunnel = this.getTcpTunnel(this.tcpRegistry);
        this.httpRegistry = new HttpRegistry();
        TunnelServer tunnelServer2 = this;
        HttpTunnelArgs httpTunnelArgs2 = httpTunnelArgs;
        if (httpTunnelArgs2 != null) {
            object5 = httpTunnelArgs2;
            tunnelServer = tunnelServer2;
            bl2 = false;
            bl = false;
            it = object5;
            boolean bl3 = false;
            object4 = this.getHttpTunnel(this.httpRegistry, (HttpTunnelArgs)it);
            tunnelServer2 = tunnelServer;
            object3 = object4;
        } else {
            object3 = null;
        }
        tunnelServer2.httpTunnel = object3;
        this.httpsRegistry = new HttpRegistry();
        TunnelServer tunnelServer3 = this;
        HttpsTunnelArgs httpsTunnelArgs2 = httpsTunnelArgs;
        if (httpsTunnelArgs2 != null) {
            object5 = httpsTunnelArgs2;
            tunnelServer = tunnelServer3;
            bl2 = false;
            bl = false;
            it = object5;
            boolean bl4 = false;
            object4 = this.getHttpsTunnel(this.httpsRegistry, (HttpsTunnelArgs)it);
            tunnelServer3 = tunnelServer;
            object2 = object4;
        } else {
            object2 = null;
        }
        tunnelServer3.httpsTunnel = object2;
        TunnelServer tunnelServer4 = this;
        HttpRpcServerArgs httpRpcServerArgs2 = httpRpcServerArgs;
        if (httpRpcServerArgs2 != null) {
            object5 = httpRpcServerArgs2;
            tunnelServer = tunnelServer4;
            bl2 = false;
            bl = false;
            it = object5;
            boolean bl5 = false;
            object4 = this.getHttpRpcServer((HttpRpcServerArgs)it);
            tunnelServer4 = tunnelServer;
            object = object4;
        } else {
            object = null;
        }
        tunnelServer4.httpRpcServer = object;
    }

    public /* synthetic */ TunnelServer(int n, int n2, TunnelDaemonArgs tunnelDaemonArgs, SslTunnelDaemonArgs sslTunnelDaemonArgs, HttpTunnelArgs httpTunnelArgs, HttpsTunnelArgs httpsTunnelArgs, HttpRpcServerArgs httpRpcServerArgs, OnTcpTunnelStateListener onTcpTunnelStateListener, OnHttpTunnelStateListener onHttpTunnelStateListener, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = -1;
        }
        if ((n3 & 2) != 0) {
            n2 = -1;
        }
        if ((n3 & 4) != 0) {
            tunnelDaemonArgs = new TunnelDaemonArgs(null, 0, null, 7, null);
        }
        if ((n3 & 8) != 0) {
            sslTunnelDaemonArgs = null;
        }
        if ((n3 & 0x10) != 0) {
            httpTunnelArgs = null;
        }
        if ((n3 & 0x20) != 0) {
            httpsTunnelArgs = null;
        }
        if ((n3 & 0x40) != 0) {
            httpRpcServerArgs = null;
        }
        if ((n3 & 0x80) != 0) {
            onTcpTunnelStateListener = null;
        }
        if ((n3 & 0x100) != 0) {
            onHttpTunnelStateListener = null;
        }
        this(n, n2, tunnelDaemonArgs, sslTunnelDaemonArgs, httpTunnelArgs, httpsTunnelArgs, httpRpcServerArgs, onTcpTunnelStateListener, onHttpTunnelStateListener);
    }

    public TunnelServer() {
        this(0, 0, null, null, null, null, null, null, null, 511, null);
    }

    public static final /* synthetic */ TcpRegistry access$getTcpRegistry$p(TunnelServer $this) {
        return $this.tcpRegistry;
    }

    public static final /* synthetic */ HttpRegistry access$getHttpRegistry$p(TunnelServer $this) {
        return $this.httpRegistry;
    }

    public static final /* synthetic */ HttpRegistry access$getHttpsRegistry$p(TunnelServer $this) {
        return $this.httpsRegistry;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B%\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Llighttunnel/server/TunnelServer$TunnelDaemonArgs;", "", "bindAddr", "", "bindPort", "", "tunnelRequestInterceptor", "Llighttunnel/server/TunnelRequestInterceptor;", "(Ljava/lang/String;ILlighttunnel/server/TunnelRequestInterceptor;)V", "getBindAddr", "()Ljava/lang/String;", "getBindPort", "()I", "getTunnelRequestInterceptor", "()Llighttunnel/server/TunnelRequestInterceptor;", "server"})
    public static final class TunnelDaemonArgs {
        @Nullable
        private final String bindAddr;
        private final int bindPort;
        @NotNull
        private final TunnelRequestInterceptor tunnelRequestInterceptor;

        @Nullable
        public final String getBindAddr() {
            return this.bindAddr;
        }

        public final int getBindPort() {
            return this.bindPort;
        }

        @NotNull
        public final TunnelRequestInterceptor getTunnelRequestInterceptor() {
            return this.tunnelRequestInterceptor;
        }

        public TunnelDaemonArgs(@Nullable String bindAddr, int bindPort, @NotNull TunnelRequestInterceptor tunnelRequestInterceptor) {
            Intrinsics.checkParameterIsNotNull((Object)tunnelRequestInterceptor, (String)"tunnelRequestInterceptor");
            this.bindAddr = bindAddr;
            this.bindPort = bindPort;
            this.tunnelRequestInterceptor = tunnelRequestInterceptor;
        }

        public /* synthetic */ TunnelDaemonArgs(String string, int n, TunnelRequestInterceptor tunnelRequestInterceptor, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                string = null;
            }
            if ((n2 & 2) != 0) {
                n = 5080;
            }
            if ((n2 & 4) != 0) {
                tunnelRequestInterceptor = TunnelRequestInterceptor.Companion.getEmptyImpl();
            }
            this(string, n, tunnelRequestInterceptor);
        }

        public TunnelDaemonArgs() {
            this(null, 0, null, 7, null);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B1\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Llighttunnel/server/TunnelServer$SslTunnelDaemonArgs;", "", "bindAddr", "", "bindPort", "", "tunnelRequestInterceptor", "Llighttunnel/server/TunnelRequestInterceptor;", "sslContext", "Lio/netty/handler/ssl/SslContext;", "(Ljava/lang/String;Ljava/lang/Integer;Llighttunnel/server/TunnelRequestInterceptor;Lio/netty/handler/ssl/SslContext;)V", "getBindAddr", "()Ljava/lang/String;", "getBindPort", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getSslContext", "()Lio/netty/handler/ssl/SslContext;", "getTunnelRequestInterceptor", "()Llighttunnel/server/TunnelRequestInterceptor;", "server"})
    public static final class SslTunnelDaemonArgs {
        @Nullable
        private final String bindAddr;
        @Nullable
        private final Integer bindPort;
        @NotNull
        private final TunnelRequestInterceptor tunnelRequestInterceptor;
        @NotNull
        private final SslContext sslContext;

        @Nullable
        public final String getBindAddr() {
            return this.bindAddr;
        }

        @Nullable
        public final Integer getBindPort() {
            return this.bindPort;
        }

        @NotNull
        public final TunnelRequestInterceptor getTunnelRequestInterceptor() {
            return this.tunnelRequestInterceptor;
        }

        @NotNull
        public final SslContext getSslContext() {
            return this.sslContext;
        }

        public SslTunnelDaemonArgs(@Nullable String bindAddr, @Nullable Integer bindPort, @NotNull TunnelRequestInterceptor tunnelRequestInterceptor, @NotNull SslContext sslContext) {
            Intrinsics.checkParameterIsNotNull((Object)tunnelRequestInterceptor, (String)"tunnelRequestInterceptor");
            Intrinsics.checkParameterIsNotNull((Object)sslContext, (String)"sslContext");
            this.bindAddr = bindAddr;
            this.bindPort = bindPort;
            this.tunnelRequestInterceptor = tunnelRequestInterceptor;
            this.sslContext = sslContext;
        }

        public /* synthetic */ SslTunnelDaemonArgs(String string, Integer n, TunnelRequestInterceptor tunnelRequestInterceptor, SslContext sslContext, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                string = null;
            }
            if ((n2 & 2) != 0) {
                n = null;
            }
            if ((n2 & 4) != 0) {
                tunnelRequestInterceptor = TunnelRequestInterceptor.Companion.getEmptyImpl();
            }
            if ((n2 & 8) != 0) {
                sslContext = SslContextUtil.INSTANCE.forBuiltinServer();
            }
            this(string, n, tunnelRequestInterceptor, sslContext);
        }

        public SslTunnelDaemonArgs() {
            this(null, null, null, null, 15, null);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B3\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Llighttunnel/server/TunnelServer$HttpTunnelArgs;", "", "bindAddr", "", "bindPort", "", "httpRequestInterceptor", "Llighttunnel/server/http/HttpRequestInterceptor;", "httpPlugin", "Llighttunnel/server/http/HttpPlugin;", "(Ljava/lang/String;Ljava/lang/Integer;Llighttunnel/server/http/HttpRequestInterceptor;Llighttunnel/server/http/HttpPlugin;)V", "getBindAddr", "()Ljava/lang/String;", "getBindPort", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getHttpPlugin", "()Llighttunnel/server/http/HttpPlugin;", "getHttpRequestInterceptor", "()Llighttunnel/server/http/HttpRequestInterceptor;", "server"})
    public static final class HttpTunnelArgs {
        @Nullable
        private final String bindAddr;
        @Nullable
        private final Integer bindPort;
        @NotNull
        private final HttpRequestInterceptor httpRequestInterceptor;
        @Nullable
        private final HttpPlugin httpPlugin;

        @Nullable
        public final String getBindAddr() {
            return this.bindAddr;
        }

        @Nullable
        public final Integer getBindPort() {
            return this.bindPort;
        }

        @NotNull
        public final HttpRequestInterceptor getHttpRequestInterceptor() {
            return this.httpRequestInterceptor;
        }

        @Nullable
        public final HttpPlugin getHttpPlugin() {
            return this.httpPlugin;
        }

        public HttpTunnelArgs(@Nullable String bindAddr, @Nullable Integer bindPort, @NotNull HttpRequestInterceptor httpRequestInterceptor, @Nullable HttpPlugin httpPlugin) {
            Intrinsics.checkParameterIsNotNull((Object)httpRequestInterceptor, (String)"httpRequestInterceptor");
            this.bindAddr = bindAddr;
            this.bindPort = bindPort;
            this.httpRequestInterceptor = httpRequestInterceptor;
            this.httpPlugin = httpPlugin;
        }

        public /* synthetic */ HttpTunnelArgs(String string, Integer n, HttpRequestInterceptor httpRequestInterceptor, HttpPlugin httpPlugin, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                string = null;
            }
            if ((n2 & 2) != 0) {
                n = null;
            }
            if ((n2 & 4) != 0) {
                httpRequestInterceptor = HttpRequestInterceptor.Companion.getDefaultImpl();
            }
            if ((n2 & 8) != 0) {
                httpPlugin = null;
            }
            this(string, n, httpRequestInterceptor, httpPlugin);
        }

        public HttpTunnelArgs() {
            this(null, null, null, null, 15, null);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B=\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Llighttunnel/server/TunnelServer$HttpsTunnelArgs;", "", "bindAddr", "", "bindPort", "", "httpRequestInterceptor", "Llighttunnel/server/http/HttpRequestInterceptor;", "httpPlugin", "Llighttunnel/server/http/HttpPlugin;", "sslContext", "Lio/netty/handler/ssl/SslContext;", "(Ljava/lang/String;Ljava/lang/Integer;Llighttunnel/server/http/HttpRequestInterceptor;Llighttunnel/server/http/HttpPlugin;Lio/netty/handler/ssl/SslContext;)V", "getBindAddr", "()Ljava/lang/String;", "getBindPort", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getHttpPlugin", "()Llighttunnel/server/http/HttpPlugin;", "getHttpRequestInterceptor", "()Llighttunnel/server/http/HttpRequestInterceptor;", "getSslContext", "()Lio/netty/handler/ssl/SslContext;", "server"})
    public static final class HttpsTunnelArgs {
        @Nullable
        private final String bindAddr;
        @Nullable
        private final Integer bindPort;
        @NotNull
        private final HttpRequestInterceptor httpRequestInterceptor;
        @Nullable
        private final HttpPlugin httpPlugin;
        @NotNull
        private final SslContext sslContext;

        @Nullable
        public final String getBindAddr() {
            return this.bindAddr;
        }

        @Nullable
        public final Integer getBindPort() {
            return this.bindPort;
        }

        @NotNull
        public final HttpRequestInterceptor getHttpRequestInterceptor() {
            return this.httpRequestInterceptor;
        }

        @Nullable
        public final HttpPlugin getHttpPlugin() {
            return this.httpPlugin;
        }

        @NotNull
        public final SslContext getSslContext() {
            return this.sslContext;
        }

        public HttpsTunnelArgs(@Nullable String bindAddr, @Nullable Integer bindPort, @NotNull HttpRequestInterceptor httpRequestInterceptor, @Nullable HttpPlugin httpPlugin, @NotNull SslContext sslContext) {
            Intrinsics.checkParameterIsNotNull((Object)httpRequestInterceptor, (String)"httpRequestInterceptor");
            Intrinsics.checkParameterIsNotNull((Object)sslContext, (String)"sslContext");
            this.bindAddr = bindAddr;
            this.bindPort = bindPort;
            this.httpRequestInterceptor = httpRequestInterceptor;
            this.httpPlugin = httpPlugin;
            this.sslContext = sslContext;
        }

        public /* synthetic */ HttpsTunnelArgs(String string, Integer n, HttpRequestInterceptor httpRequestInterceptor, HttpPlugin httpPlugin, SslContext sslContext, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                string = null;
            }
            if ((n2 & 2) != 0) {
                n = null;
            }
            if ((n2 & 4) != 0) {
                httpRequestInterceptor = HttpRequestInterceptor.Companion.getDefaultImpl();
            }
            if ((n2 & 8) != 0) {
                httpPlugin = null;
            }
            if ((n2 & 0x10) != 0) {
                sslContext = SslContextUtil.INSTANCE.forBuiltinServer();
            }
            this(string, n, httpRequestInterceptor, httpPlugin, sslContext);
        }

        public HttpsTunnelArgs() {
            this(null, null, null, null, null, 31, null);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Llighttunnel/server/TunnelServer$HttpRpcServerArgs;", "", "bindAddr", "", "bindPort", "", "(Ljava/lang/String;Ljava/lang/Integer;)V", "getBindAddr", "()Ljava/lang/String;", "getBindPort", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "server"})
    public static final class HttpRpcServerArgs {
        @Nullable
        private final String bindAddr;
        @Nullable
        private final Integer bindPort;

        @Nullable
        public final String getBindAddr() {
            return this.bindAddr;
        }

        @Nullable
        public final Integer getBindPort() {
            return this.bindPort;
        }

        public HttpRpcServerArgs(@Nullable String bindAddr, @Nullable Integer bindPort) {
            this.bindAddr = bindAddr;
            this.bindPort = bindPort;
        }

        public /* synthetic */ HttpRpcServerArgs(String string, Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                string = null;
            }
            if ((n2 & 2) != 0) {
                n = null;
            }
            this(string, n);
        }

        public HttpRpcServerArgs() {
            this(null, null, 3, null);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u001a\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u001a\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016\u00a8\u0006\u000e"}, d2={"Llighttunnel/server/TunnelServer$InnerTunnelServerChannelHandler;", "Llighttunnel/server/TunnelServerChannelHandler;", "tunnelRequestInterceptor", "Llighttunnel/server/TunnelRequestInterceptor;", "(Llighttunnel/server/TunnelServer;Llighttunnel/server/TunnelRequestInterceptor;)V", "onChannelConnected", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "httpFd", "Llighttunnel/server/http/HttpFd;", "tcpFd", "Llighttunnel/server/tcp/TcpFd;", "onChannelInactive", "server"})
    private final class InnerTunnelServerChannelHandler
    extends TunnelServerChannelHandler {
        @Override
        public void onChannelConnected(@NotNull ChannelHandlerContext ctx, @Nullable TcpFd tcpFd) {
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
                if (tcpFd == null) break block1;
                OnTcpTunnelStateListener onTcpTunnelStateListener = TunnelServer.this.onTcpTunnelStateListener;
                if (onTcpTunnelStateListener != null) {
                    onTcpTunnelStateListener.onTcpTunnelConnected(tcpFd);
                }
            }
        }

        @Override
        public void onChannelInactive(@NotNull ChannelHandlerContext ctx, @Nullable TcpFd tcpFd) {
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
                if (tcpFd == null) break block1;
                OnTcpTunnelStateListener onTcpTunnelStateListener = TunnelServer.this.onTcpTunnelStateListener;
                if (onTcpTunnelStateListener != null) {
                    onTcpTunnelStateListener.onTcpTunnelDisconnect(tcpFd);
                }
            }
        }

        @Override
        public void onChannelConnected(@NotNull ChannelHandlerContext ctx, @Nullable HttpFd httpFd) {
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
                if (httpFd == null) break block1;
                OnHttpTunnelStateListener onHttpTunnelStateListener = TunnelServer.this.onHttpTunnelStateListener;
                if (onHttpTunnelStateListener != null) {
                    onHttpTunnelStateListener.onHttpTunnelConnected(httpFd);
                }
            }
        }

        @Override
        public void onChannelInactive(@NotNull ChannelHandlerContext ctx, @Nullable HttpFd httpFd) {
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
                if (httpFd == null) break block1;
                OnHttpTunnelStateListener onHttpTunnelStateListener = TunnelServer.this.onHttpTunnelStateListener;
                if (onHttpTunnelStateListener != null) {
                    onHttpTunnelStateListener.onHttpTunnelDisconnect(httpFd);
                }
            }
        }

        public InnerTunnelServerChannelHandler(TunnelRequestInterceptor tunnelRequestInterceptor) {
            Intrinsics.checkParameterIsNotNull((Object)tunnelRequestInterceptor, (String)"tunnelRequestInterceptor");
            super(tunnelRequestInterceptor, TunnelServer.this.tunnelIds, TunnelServer.this.tcpTunnel, TunnelServer.this.httpTunnel, TunnelServer.this.httpsTunnel);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Llighttunnel/server/TunnelServer$OnTcpTunnelStateListener;", "", "onTcpTunnelConnected", "", "fd", "Llighttunnel/server/tcp/TcpFd;", "onTcpTunnelDisconnect", "server"})
    public static interface OnTcpTunnelStateListener {
        public void onTcpTunnelConnected(@NotNull TcpFd var1);

        public void onTcpTunnelDisconnect(@NotNull TcpFd var1);

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            public static void onTcpTunnelConnected(OnTcpTunnelStateListener $this, @NotNull TcpFd fd) {
                Intrinsics.checkParameterIsNotNull((Object)fd, (String)"fd");
            }

            public static void onTcpTunnelDisconnect(OnTcpTunnelStateListener $this, @NotNull TcpFd fd) {
                Intrinsics.checkParameterIsNotNull((Object)fd, (String)"fd");
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Llighttunnel/server/TunnelServer$OnHttpTunnelStateListener;", "", "onHttpTunnelConnected", "", "fd", "Llighttunnel/server/http/HttpFd;", "onHttpTunnelDisconnect", "server"})
    public static interface OnHttpTunnelStateListener {
        public void onHttpTunnelConnected(@NotNull HttpFd var1);

        public void onHttpTunnelDisconnect(@NotNull HttpFd var1);

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            public static void onHttpTunnelConnected(OnHttpTunnelStateListener $this, @NotNull HttpFd fd) {
                Intrinsics.checkParameterIsNotNull((Object)fd, (String)"fd");
            }

            public static void onHttpTunnelDisconnect(OnHttpTunnelStateListener $this, @NotNull HttpFd fd) {
                Intrinsics.checkParameterIsNotNull((Object)fd, (String)"fd");
            }
        }
    }
}

