/*
 * Decompiled with CFR 0.152.
 */
package lighttunnel.server.tcp;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import lighttunnel.proto.ProtoException;
import lighttunnel.server.tcp.TcpFd;
import lighttunnel.server.tcp.TcpRegistry;
import lighttunnel.server.tcp.TcpServerChannelHandler;
import lighttunnel.server.util.SessionChannels;
import lighttunnel.util.PortUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J \u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Llighttunnel/server/tcp/TcpServer;", "", "bossGroup", "Lio/netty/channel/nio/NioEventLoopGroup;", "workerGroup", "registry", "Llighttunnel/server/tcp/TcpRegistry;", "(Lio/netty/channel/nio/NioEventLoopGroup;Lio/netty/channel/nio/NioEventLoopGroup;Llighttunnel/server/tcp/TcpRegistry;)V", "serverBootstrap", "Lio/netty/bootstrap/ServerBootstrap;", "startTunnel", "Llighttunnel/server/tcp/TcpFd;", "addr", "", "port", "", "sessionChannels", "Llighttunnel/server/util/SessionChannels;", "stopTunnel", "server"})
public final class TcpServer {
    private final ServerBootstrap serverBootstrap;
    private final TcpRegistry registry;

    @Nullable
    public final TcpFd stopTunnel(int port) {
        return this.registry.unregister$server(port);
    }

    @NotNull
    public final TcpFd startTunnel(@Nullable String addr, int port, @NotNull SessionChannels sessionChannels) throws Exception {
        ChannelFuture bindChannelFuture;
        Intrinsics.checkParameterIsNotNull((Object)sessionChannels, (String)"sessionChannels");
        if (this.registry.isRegistered$server(port) || !PortUtil.INSTANCE.isAvailablePort(port)) {
            throw (Throwable)new ProtoException("port(" + port + ") already used", null, 2, null);
        }
        ChannelFuture channelFuture = bindChannelFuture = addr == null ? this.serverBootstrap.bind(port) : this.serverBootstrap.bind(addr, port);
        Intrinsics.checkExpressionValueIsNotNull((Object)channelFuture, (String)"bindChannelFuture");
        TcpFd fd = new TcpFd(addr, port, sessionChannels, channelFuture);
        this.registry.register$server(port, sessionChannels, fd);
        return fd;
    }

    public TcpServer(@NotNull NioEventLoopGroup bossGroup, @NotNull NioEventLoopGroup workerGroup, @NotNull TcpRegistry registry) {
        Intrinsics.checkParameterIsNotNull((Object)bossGroup, (String)"bossGroup");
        Intrinsics.checkParameterIsNotNull((Object)workerGroup, (String)"workerGroup");
        Intrinsics.checkParameterIsNotNull((Object)registry, (String)"registry");
        this.registry = registry;
        this.serverBootstrap = new ServerBootstrap();
        ((ServerBootstrap)this.serverBootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childOption(ChannelOption.AUTO_READ, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(@Nullable SocketChannel ch) {
                if (ch == null) {
                    return;
                }
                ch.pipeline().addLast("handler", (ChannelHandler)new TcpServerChannelHandler(registry));
            }
        });
    }
}

