/*
 * Decompiled with CFR 0.152.
 */
package lighttunnel.server.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import lighttunnel.proto.ProtoMessage;
import lighttunnel.proto.ProtoMessageType;
import lighttunnel.proto.RemoteInfo;
import lighttunnel.server.http.HttpFd;
import lighttunnel.server.http.HttpPlugin;
import lighttunnel.server.http.HttpRegistry;
import lighttunnel.server.http.HttpRequestInterceptor;
import lighttunnel.server.http.HttpServerChannelHandler$$special$;
import lighttunnel.server.util.-ConstsKt;
import lighttunnel.util.HttpUtil;
import lighttunnel.util.LongUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0012\u0010\u0014\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u001c\u0010\u0015\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u0002H\u0014J\u001c\u0010\u0017\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Llighttunnel/server/http/HttpServerChannelHandler;", "Lio/netty/channel/SimpleChannelInboundHandler;", "Lio/netty/handler/codec/http/FullHttpRequest;", "registry", "Llighttunnel/server/http/HttpRegistry;", "interceptor", "Llighttunnel/server/http/HttpRequestInterceptor;", "httpPlugin", "Llighttunnel/server/http/HttpPlugin;", "(Llighttunnel/server/http/HttpRegistry;Llighttunnel/server/http/HttpRequestInterceptor;Llighttunnel/server/http/HttpPlugin;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "logger$delegate", "Lkotlin/Lazy;", "channelActive", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "channelInactive", "channelRead0", "msg", "exceptionCaught", "cause", "", "server"})
public final class HttpServerChannelHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private final Lazy logger$delegate;
    private final HttpRegistry registry;
    private final HttpRequestInterceptor interceptor;
    private final HttpPlugin httpPlugin;

    private final Logger getLogger() {
        Lazy lazy = this.logger$delegate;
        HttpServerChannelHandler httpServerChannelHandler = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    public void channelActive(@Nullable ChannelHandlerContext ctx) throws Exception {
        this.getLogger().trace("channelActive: {}", (Object)ctx);
        super.channelActive(ctx);
    }

    public void channelInactive(@Nullable ChannelHandlerContext ctx) throws Exception {
        this.getLogger().trace("channelInactive: {}", (Object)ctx);
        if (ctx == null) {
            super.channelInactive(ctx);
            return;
        }
        String httpHost = (String)ctx.channel().attr(-ConstsKt.getAK_HTTP_HOST()).get();
        Long sessionId = (Long)ctx.channel().attr(-ConstsKt.getAK_SESSION_ID()).get();
        if (httpHost != null && sessionId != null) {
            HttpFd httpFd = this.registry.getHttpFd$server(httpHost);
            if (httpFd != null) {
                byte[] head = LongUtil.INSTANCE.toBytes(new long[]{httpFd.getTunnelId(), sessionId});
                Channel channel = httpFd.getTunnelChannel$server();
                SocketAddress socketAddress = ctx.channel().remoteAddress();
                Intrinsics.checkExpressionValueIsNotNull((Object)socketAddress, (String)"ctx.channel().remoteAddress()");
                channel.writeAndFlush((Object)new ProtoMessage(ProtoMessageType.REMOTE_DISCONNECT, head, new RemoteInfo(socketAddress).toBytes()));
            }
            ctx.channel().attr(-ConstsKt.getAK_HTTP_HOST()).set(null);
            ctx.channel().attr(-ConstsKt.getAK_SESSION_ID()).set(null);
        }
        super.channelInactive(ctx);
    }

    public void exceptionCaught(@Nullable ChannelHandlerContext ctx, @Nullable Throwable cause) throws Exception {
        this.getLogger().trace("exceptionCaught: {}", (Object)ctx, (Object)cause);
        if (ctx == null) {
            return;
        }
        ctx.channel().writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    protected void channelRead0(@Nullable ChannelHandlerContext ctx, @Nullable FullHttpRequest msg) {
        String httpHost;
        FullHttpResponse httpPluginResponse;
        this.getLogger().trace("channelRead0: {}", (Object)ctx);
        if (ctx == null) {
            return;
        }
        if (msg == null) {
            return;
        }
        HttpPlugin httpPlugin = this.httpPlugin;
        Object object = httpPluginResponse = httpPlugin != null ? httpPlugin.doHandle(msg) : null;
        if (httpPluginResponse != null) {
            ctx.channel().writeAndFlush((Object)HttpUtil.INSTANCE.toByteBuf((HttpResponse)httpPluginResponse)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        if ((httpHost = HttpUtil.INSTANCE.getHostWithoutPort((HttpRequest)msg)) == null) {
            ctx.channel().writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        }
        ctx.channel().attr(-ConstsKt.getAK_HTTP_HOST()).set((Object)httpHost);
        HttpFd httpFd = this.registry.getHttpFd$server(httpHost);
        if (httpFd == null) {
            ctx.channel().writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        }
        FullHttpResponse httpInterceptorResponse = this.interceptor.handleHttpRequest(ctx, httpFd.getTunnelRequest(), msg);
        if (httpInterceptorResponse != null) {
            ctx.channel().writeAndFlush((Object)HttpUtil.INSTANCE.toByteBuf((HttpResponse)httpInterceptorResponse));
            return;
        }
        Channel channel = ctx.channel();
        Intrinsics.checkExpressionValueIsNotNull((Object)channel, (String)"ctx.channel()");
        long sessionId = httpFd.putChannel$server(channel);
        ctx.channel().attr(-ConstsKt.getAK_SESSION_ID()).set((Object)sessionId);
        byte[] head = LongUtil.INSTANCE.toBytes(new long[]{httpFd.getTunnelId(), sessionId});
        Channel channel2 = httpFd.getTunnelChannel$server();
        SocketAddress socketAddress = ctx.channel().remoteAddress();
        Intrinsics.checkExpressionValueIsNotNull((Object)socketAddress, (String)"ctx.channel().remoteAddress()");
        channel2.writeAndFlush((Object)new ProtoMessage(ProtoMessageType.REMOTE_CONNECTED, head, new RemoteInfo(socketAddress).toBytes()));
        byte[] data = ByteBufUtil.getBytes((ByteBuf)HttpUtil.INSTANCE.toByteBuf((HttpRequest)msg));
        Channel channel3 = httpFd.getTunnelChannel$server();
        Intrinsics.checkExpressionValueIsNotNull((Object)data, (String)"data");
        channel3.writeAndFlush((Object)new ProtoMessage(ProtoMessageType.TRANSFER, head, data));
    }

    public HttpServerChannelHandler(@NotNull HttpRegistry registry, @NotNull HttpRequestInterceptor interceptor, @Nullable HttpPlugin httpPlugin) {
        Lazy lazy;
        Intrinsics.checkParameterIsNotNull((Object)registry, (String)"registry");
        Intrinsics.checkParameterIsNotNull((Object)interceptor, (String)"interceptor");
        this.registry = registry;
        this.interceptor = interceptor;
        this.httpPlugin = httpPlugin;
        HttpServerChannelHandler httpServerChannelHandler = this;
        HttpServerChannelHandler httpServerChannelHandler2 = this;
        boolean $i$f$loggerDelegate = false;
        httpServerChannelHandler2.logger$delegate = lazy = LazyKt.lazy((Function0)$special$$inlined$loggerDelegate$1.INSTANCE);
    }

    public /* synthetic */ HttpServerChannelHandler(HttpRegistry httpRegistry, HttpRequestInterceptor httpRequestInterceptor, HttpPlugin httpPlugin, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            httpPlugin = null;
        }
        this(httpRegistry, httpRequestInterceptor, httpPlugin);
    }
}

