/*
 * Decompiled with CFR 0.152.
 */
package lighttunnel.server;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import lighttunnel.proto.ProtoException;
import lighttunnel.proto.ProtoMessage;
import lighttunnel.proto.ProtoMessageType;
import lighttunnel.proto.TunnelRequest;
import lighttunnel.server.TunnelRequestInterceptor;
import lighttunnel.server.TunnelServerChannelHandler$$special$;
import lighttunnel.server.TunnelServerChannelHandler$WhenMappings;
import lighttunnel.server.http.HttpFd;
import lighttunnel.server.http.HttpServer;
import lighttunnel.server.tcp.TcpFd;
import lighttunnel.server.tcp.TcpServer;
import lighttunnel.server.util.-ConstsKt;
import lighttunnel.server.util.SessionChannels;
import lighttunnel.util.IncIds;
import lighttunnel.util.LongUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001(BE\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u001c\u0010\u0019\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u0002H\u0014J\u0018\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0002H\u0002J\u0018\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0002H\u0002J\u0018\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0002H\u0002J\u0018\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0002H\u0002J\u0018\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0002H\u0002J\u0018\u0010 \u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0002H\u0002J\u001c\u0010!\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u001c\u0010$\u001a\u00020\u0016*\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&H\u0002J\u001c\u0010'\u001a\u00020\u0016*\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&H\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Llighttunnel/server/TunnelServerChannelHandler;", "Lio/netty/channel/SimpleChannelInboundHandler;", "Llighttunnel/proto/ProtoMessage;", "tunnelRequestInterceptor", "Llighttunnel/server/TunnelRequestInterceptor;", "tunnelIds", "Llighttunnel/util/IncIds;", "tcpServer", "Llighttunnel/server/tcp/TcpServer;", "httpServer", "Llighttunnel/server/http/HttpServer;", "httpsServer", "onChannelStateListener", "Llighttunnel/server/TunnelServerChannelHandler$OnChannelStateListener;", "(Llighttunnel/server/TunnelRequestInterceptor;Llighttunnel/util/IncIds;Llighttunnel/server/tcp/TcpServer;Llighttunnel/server/http/HttpServer;Llighttunnel/server/http/HttpServer;Llighttunnel/server/TunnelServerChannelHandler$OnChannelStateListener;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "logger$delegate", "Lkotlin/Lazy;", "channelInactive", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "channelRead0", "msg", "doHandleForcedOfflineReplyMessage", "doHandleLocalConnectedMessage", "doHandleLocalDisconnectMessage", "doHandlePingMessage", "doHandleRequestMessage", "doHandleTransferMessage", "exceptionCaught", "cause", "", "handleHttpRequestMessage", "tunnelRequest", "Llighttunnel/proto/TunnelRequest;", "handleTcpRequestMessage", "OnChannelStateListener", "server"})
public final class TunnelServerChannelHandler
extends SimpleChannelInboundHandler<ProtoMessage> {
    private final Lazy logger$delegate;
    private final TunnelRequestInterceptor tunnelRequestInterceptor;
    private final IncIds tunnelIds;
    private final TcpServer tcpServer;
    private final HttpServer httpServer;
    private final HttpServer httpsServer;
    private final OnChannelStateListener onChannelStateListener;

    private final Logger getLogger() {
        Lazy lazy = this.logger$delegate;
        TunnelServerChannelHandler tunnelServerChannelHandler = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    public void channelInactive(@Nullable ChannelHandlerContext ctx) {
        this.getLogger().trace("channelInactive: {}", (Object)ctx);
        if (ctx == null) {
            super.channelInactive(ctx);
            return;
        }
        SessionChannels sessionChannels = (SessionChannels)ctx.channel().attr(-ConstsKt.getAK_SESSION_CHANNELS()).get();
        if (sessionChannels != null) {
            SessionChannels sessionChannels2 = sessionChannels;
            boolean bl = false;
            boolean bl2 = false;
            SessionChannels sc = sessionChannels2;
            boolean bl3 = false;
            switch (TunnelServerChannelHandler$WhenMappings.$EnumSwitchMapping$0[sc.getTunnelRequest().getType().ordinal()]) {
                case 1: {
                    TcpServer tcpServer = this.tcpServer;
                    TcpFd fd = tcpServer != null ? tcpServer.stopTunnel(sc.getTunnelRequest().getRemotePort()) : null;
                    OnChannelStateListener onChannelStateListener = this.onChannelStateListener;
                    if (onChannelStateListener != null) {
                        onChannelStateListener.onChannelInactive(ctx, fd);
                    }
                    break;
                }
                case 2: {
                    HttpServer httpServer = this.httpServer;
                    HttpFd fd = httpServer != null ? httpServer.stopTunnel(sc.getTunnelRequest().getHost()) : null;
                    OnChannelStateListener onChannelStateListener = this.onChannelStateListener;
                    if (onChannelStateListener != null) {
                        onChannelStateListener.onChannelInactive(ctx, fd);
                    }
                    break;
                }
                case 3: {
                    HttpServer httpServer = this.httpsServer;
                    HttpFd fd = httpServer != null ? httpServer.stopTunnel(sc.getTunnelRequest().getHost()) : null;
                    OnChannelStateListener onChannelStateListener = this.onChannelStateListener;
                    if (onChannelStateListener != null) {
                        onChannelStateListener.onChannelInactive(ctx, fd);
                    }
                    break;
                }
            }
        }
        ctx.channel().attr(-ConstsKt.getAK_SESSION_CHANNELS()).set(null);
        super.channelInactive(ctx);
    }

    public void exceptionCaught(@Nullable ChannelHandlerContext ctx, @Nullable Throwable cause) {
        this.getLogger().trace("exceptionCaught: {}", (Object)ctx, (Object)cause);
        if (ctx == null) {
            return;
        }
        ctx.channel().writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    protected void channelRead0(@Nullable ChannelHandlerContext ctx, @Nullable ProtoMessage msg) {
        this.getLogger().trace("channelRead0: {}", (Object)ctx);
        if (ctx == null) {
            return;
        }
        if (msg == null) {
            return;
        }
        switch (TunnelServerChannelHandler$WhenMappings.$EnumSwitchMapping$1[msg.getType().ordinal()]) {
            case 1: {
                this.doHandlePingMessage(ctx, msg);
                break;
            }
            case 2: {
                this.doHandleRequestMessage(ctx, msg);
                break;
            }
            case 3: {
                this.doHandleTransferMessage(ctx, msg);
                break;
            }
            case 4: {
                this.doHandleLocalConnectedMessage(ctx, msg);
                break;
            }
            case 5: {
                this.doHandleLocalDisconnectMessage(ctx, msg);
                break;
            }
            case 6: {
                this.doHandleForcedOfflineReplyMessage(ctx, msg);
                break;
            }
        }
    }

    private final void doHandlePingMessage(ChannelHandlerContext ctx, ProtoMessage msg) throws Exception {
        this.getLogger().trace("doHandlePingMessage# {}, {}", (Object)ctx, (Object)msg);
        ctx.writeAndFlush((Object)new ProtoMessage(ProtoMessageType.PONG, null, null, 6, null));
    }

    private final void doHandleRequestMessage(ChannelHandlerContext ctx, ProtoMessage msg) throws Exception {
        this.getLogger().trace("doHandleRequestMessage# {}, {}", (Object)ctx, (Object)msg);
        try {
            TunnelRequest originalTunnelRequest = TunnelRequest.Companion.fromBytes(msg.getHead());
            TunnelRequest finalTunnelRequest = this.tunnelRequestInterceptor.handleTunnelRequest(originalTunnelRequest);
            this.getLogger().trace("originalTunnelRequest: {}, finalTunnelRequest: {}", (Object)originalTunnelRequest, (Object)finalTunnelRequest);
            switch (TunnelServerChannelHandler$WhenMappings.$EnumSwitchMapping$2[finalTunnelRequest.getType().ordinal()]) {
                case 1: {
                    TcpServer tcpServer = this.tcpServer;
                    if (tcpServer == null) {
                        throw (Throwable)new ProtoException("TCP\u534f\u8bae\u96a7\u9053\u672a\u5f00\u542f", null, 2, null);
                    }
                    TcpServer server = tcpServer;
                    this.handleTcpRequestMessage(server, ctx, finalTunnelRequest);
                    break;
                }
                case 2: {
                    HttpServer httpServer = this.httpServer;
                    if (httpServer == null) {
                        throw (Throwable)new ProtoException("HTTP\u534f\u8bae\u96a7\u9053\u672a\u5f00\u542f", null, 2, null);
                    }
                    HttpServer server = httpServer;
                    this.handleHttpRequestMessage(server, ctx, finalTunnelRequest);
                    break;
                }
                case 3: {
                    HttpServer httpServer = this.httpsServer;
                    if (httpServer == null) {
                        throw (Throwable)new ProtoException("HTTPS\u534f\u8bae\u96a7\u9053\u672a\u5f00\u542f", null, 2, null);
                    }
                    HttpServer server = httpServer;
                    this.handleHttpRequestMessage(server, ctx, finalTunnelRequest);
                    break;
                }
                default: {
                    throw (Throwable)new ProtoException("\u4e0d\u652f\u6301\u7684\u96a7\u9053\u7c7b\u578b", null, 2, null);
                }
            }
        }
        catch (Exception e) {
            String string = String.valueOf(e.getMessage());
            ProtoMessageType protoMessageType = ProtoMessageType.RESPONSE_ERR;
            Channel channel = ctx.channel();
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = byArray;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 4;
            byte[] byArray3 = null;
            byte[] byArray4 = byArray2;
            ProtoMessageType protoMessageType2 = protoMessageType;
            channel.writeAndFlush((Object)new ProtoMessage(protoMessageType2, byArray4, byArray3, n, defaultConstructorMarker)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private final void doHandleTransferMessage(ChannelHandlerContext ctx, ProtoMessage msg) throws Exception {
        block1: {
            Channel sessionChannel;
            this.getLogger().trace("doHandleTransferMessage# {}, {}", (Object)ctx, (Object)msg);
            SessionChannels sessionChannels = (SessionChannels)ctx.channel().attr(-ConstsKt.getAK_SESSION_CHANNELS()).get();
            if (sessionChannels == null) {
                return;
            }
            SessionChannels sessionChannels2 = sessionChannels;
            Channel channel = sessionChannel = sessionChannels2.getChannel(msg.getSessionId());
            if (channel == null) break block1;
            channel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])msg.getData()));
        }
    }

    private final void doHandleLocalConnectedMessage(ChannelHandlerContext ctx, ProtoMessage msg) throws Exception {
        this.getLogger().trace("doHandleLocalConnectedMessage# {}, {}", (Object)ctx, (Object)msg);
    }

    private final void doHandleLocalDisconnectMessage(ChannelHandlerContext ctx, ProtoMessage msg) throws Exception {
        block1: {
            this.getLogger().trace("doHandleLocalDisconnectMessage# {}, {}", (Object)ctx, (Object)msg);
            SessionChannels sessionChannels = (SessionChannels)ctx.channel().attr(-ConstsKt.getAK_SESSION_CHANNELS()).get();
            if (sessionChannels == null) {
                return;
            }
            SessionChannels sessionChannels2 = sessionChannels;
            Channel sessionChannel = sessionChannels2.removeChannel(msg.getSessionId());
            Channel channel = sessionChannel;
            if (channel == null || (channel = channel.writeAndFlush((Object)Unpooled.EMPTY_BUFFER)) == null) break block1;
            channel.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private final void doHandleForcedOfflineReplyMessage(ChannelHandlerContext ctx, ProtoMessage msg) throws Exception {
        block0: {
            this.getLogger().trace("doHandleForcedOfflineReplyMessage# {}, {}", (Object)ctx, (Object)msg);
            Channel channel = ctx.channel();
            if (channel == null) break block0;
            channel.close();
        }
    }

    private final void handleTcpRequestMessage(@NotNull TcpServer $this$handleTcpRequestMessage, ChannelHandlerContext ctx, TunnelRequest tunnelRequest) throws Exception {
        long tunnelId = this.tunnelIds.getNextId();
        Channel channel = ctx.channel();
        Intrinsics.checkExpressionValueIsNotNull((Object)channel, (String)"ctx.channel()");
        SessionChannels sessionChannels = new SessionChannels(tunnelId, tunnelRequest, channel);
        ctx.channel().attr(-ConstsKt.getAK_SESSION_CHANNELS()).set((Object)sessionChannels);
        TcpFd fd = $this$handleTcpRequestMessage.startTunnel(null, tunnelRequest.getRemotePort(), sessionChannels);
        OnChannelStateListener onChannelStateListener = this.onChannelStateListener;
        if (onChannelStateListener != null) {
            onChannelStateListener.onChannelConnected(ctx, fd);
        }
        byte[] head = LongUtil.INSTANCE.toBytes(new long[]{tunnelId, 0L});
        byte[] data = tunnelRequest.toBytes();
        ctx.channel().writeAndFlush((Object)new ProtoMessage(ProtoMessageType.RESPONSE_OK, head, data));
    }

    private final void handleHttpRequestMessage(@NotNull HttpServer $this$handleHttpRequestMessage, ChannelHandlerContext ctx, TunnelRequest tunnelRequest) throws Exception {
        long tunnelId = this.tunnelIds.getNextId();
        Channel channel = ctx.channel();
        Intrinsics.checkExpressionValueIsNotNull((Object)channel, (String)"ctx.channel()");
        SessionChannels sessionChannels = new SessionChannels(tunnelId, tunnelRequest, channel);
        ctx.channel().attr(-ConstsKt.getAK_SESSION_CHANNELS()).set((Object)sessionChannels);
        HttpFd fd = $this$handleHttpRequestMessage.startTunnel(tunnelRequest.getHost(), sessionChannels);
        OnChannelStateListener onChannelStateListener = this.onChannelStateListener;
        if (onChannelStateListener != null) {
            onChannelStateListener.onChannelConnected(ctx, fd);
        }
        byte[] head = LongUtil.INSTANCE.toBytes(new long[]{tunnelId, 0L});
        byte[] data = tunnelRequest.toBytes();
        ctx.channel().writeAndFlush((Object)new ProtoMessage(ProtoMessageType.RESPONSE_OK, head, data));
    }

    public TunnelServerChannelHandler(@NotNull TunnelRequestInterceptor tunnelRequestInterceptor, @NotNull IncIds tunnelIds, @Nullable TcpServer tcpServer, @Nullable HttpServer httpServer, @Nullable HttpServer httpsServer, @Nullable OnChannelStateListener onChannelStateListener) {
        Lazy lazy;
        Intrinsics.checkParameterIsNotNull((Object)tunnelRequestInterceptor, (String)"tunnelRequestInterceptor");
        Intrinsics.checkParameterIsNotNull((Object)tunnelIds, (String)"tunnelIds");
        this.tunnelRequestInterceptor = tunnelRequestInterceptor;
        this.tunnelIds = tunnelIds;
        this.tcpServer = tcpServer;
        this.httpServer = httpServer;
        this.httpsServer = httpsServer;
        this.onChannelStateListener = onChannelStateListener;
        TunnelServerChannelHandler tunnelServerChannelHandler = this;
        TunnelServerChannelHandler tunnelServerChannelHandler2 = this;
        boolean $i$f$loggerDelegate = false;
        tunnelServerChannelHandler2.logger$delegate = lazy = LazyKt.lazy((Function0)$special$$inlined$loggerDelegate$1.INSTANCE);
    }

    public /* synthetic */ TunnelServerChannelHandler(TunnelRequestInterceptor tunnelRequestInterceptor, IncIds incIds, TcpServer tcpServer, HttpServer httpServer, HttpServer httpServer2, OnChannelStateListener onChannelStateListener, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            tcpServer = null;
        }
        if ((n & 8) != 0) {
            httpServer = null;
        }
        if ((n & 0x10) != 0) {
            httpServer2 = null;
        }
        if ((n & 0x20) != 0) {
            onChannelStateListener = null;
        }
        this(tunnelRequestInterceptor, incIds, tcpServer, httpServer, httpServer2, onChannelStateListener);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b`\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u001a\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u001a\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u001a\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\u000b"}, d2={"Llighttunnel/server/TunnelServerChannelHandler$OnChannelStateListener;", "", "onChannelConnected", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "httpFd", "Llighttunnel/server/http/HttpFd;", "tcpFd", "Llighttunnel/server/tcp/TcpFd;", "onChannelInactive", "server"})
    public static interface OnChannelStateListener {
        public void onChannelInactive(@NotNull ChannelHandlerContext var1, @Nullable TcpFd var2);

        public void onChannelInactive(@NotNull ChannelHandlerContext var1, @Nullable HttpFd var2);

        public void onChannelConnected(@NotNull ChannelHandlerContext var1, @Nullable TcpFd var2);

        public void onChannelConnected(@NotNull ChannelHandlerContext var1, @Nullable HttpFd var2);

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            public static void onChannelInactive(OnChannelStateListener $this, @NotNull ChannelHandlerContext ctx, @Nullable TcpFd tcpFd) {
                Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            }

            public static void onChannelInactive(OnChannelStateListener $this, @NotNull ChannelHandlerContext ctx, @Nullable HttpFd httpFd) {
                Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            }

            public static void onChannelConnected(OnChannelStateListener $this, @NotNull ChannelHandlerContext ctx, @Nullable TcpFd tcpFd) {
                Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            }

            public static void onChannelConnected(OnChannelStateListener $this, @NotNull ChannelHandlerContext ctx, @Nullable HttpFd httpFd) {
                Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            }
        }
    }
}

