/*
 * Decompiled with CFR 0.152.
 */
package lighttunnel.server.http;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import lighttunnel.proto.TunnelRequest;
import lighttunnel.server.http.HttpRequestInterceptor;
import lighttunnel.util.HttpUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u0000 \n2\u00020\u0001:\u0002\n\u000bJ\"\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Llighttunnel/server/http/HttpRequestInterceptor;", "", "handleHttpRequest", "Lio/netty/handler/codec/http/FullHttpResponse;", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "tunnelRequest", "Llighttunnel/proto/TunnelRequest;", "httpRequest", "Lio/netty/handler/codec/http/FullHttpRequest;", "Companion", "DefaultImpl", "server"})
public interface HttpRequestInterceptor {
    public static final Companion Companion = lighttunnel.server.http.HttpRequestInterceptor$Companion.$$INSTANCE;

    @Nullable
    public FullHttpResponse handleHttpRequest(@NotNull ChannelHandlerContext var1, @NotNull TunnelRequest var2, @NotNull FullHttpRequest var3);

    @NotNull
    public static HttpRequestInterceptor getDefaultImpl() {
        return Companion.getDefaultImpl();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\"\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J0\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J(\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J(\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0016"}, d2={"Llighttunnel/server/http/HttpRequestInterceptor$DefaultImpl;", "Llighttunnel/server/http/HttpRequestInterceptor;", "()V", "handleHttpBasicAuth", "Lio/netty/handler/codec/http/FullHttpResponse;", "tunnelRequest", "Llighttunnel/proto/TunnelRequest;", "httpRequest", "Lio/netty/handler/codec/http/FullHttpRequest;", "handleHttpRequest", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "handleProxyHttpHeaders", "", "pxySet", "", "localAddress", "Ljava/net/SocketAddress;", "remoteAddress", "handleRewriteHttpHeaders", "handleWriteHttpHeaders", "Companion", "server"})
    private static final class DefaultImpl
    implements HttpRequestInterceptor {
        private static final String MAGIC_VALUE_REMOTE_ADDR = "$remote_addr";
        public static final Companion Companion = new Companion(null);

        @Override
        @Nullable
        public FullHttpResponse handleHttpRequest(@NotNull ChannelHandlerContext ctx, @NotNull TunnelRequest tunnelRequest, @NotNull FullHttpRequest httpRequest) {
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            Intrinsics.checkParameterIsNotNull((Object)tunnelRequest, (String)"tunnelRequest");
            Intrinsics.checkParameterIsNotNull((Object)httpRequest, (String)"httpRequest");
            SocketAddress localAddress = ctx.channel().localAddress();
            SocketAddress remoteAddress = ctx.channel().remoteAddress();
            SocketAddress socketAddress = localAddress;
            Intrinsics.checkExpressionValueIsNotNull((Object)socketAddress, (String)"localAddress");
            SocketAddress socketAddress2 = remoteAddress;
            Intrinsics.checkExpressionValueIsNotNull((Object)socketAddress2, (String)"remoteAddress");
            this.handleRewriteHttpHeaders(socketAddress, socketAddress2, tunnelRequest, httpRequest);
            this.handleWriteHttpHeaders(localAddress, remoteAddress, tunnelRequest, httpRequest);
            return tunnelRequest.getEnableBasicAuth() ? this.handleHttpBasicAuth(tunnelRequest, httpRequest) : null;
        }

        private final FullHttpResponse handleHttpBasicAuth(TunnelRequest tunnelRequest, FullHttpRequest httpRequest) {
            String[] account = HttpUtil.INSTANCE.getBasicAuthorization((HttpRequest)httpRequest);
            String username = tunnelRequest.getBasicAuthUsername();
            String password = tunnelRequest.getBasicAuthPassword();
            if (account == null || Intrinsics.areEqual((Object)username, (Object)account[0]) ^ true || Intrinsics.areEqual((Object)password, (Object)account[1]) ^ true) {
                DefaultFullHttpResponse httpResponse = new DefaultFullHttpResponse(httpRequest.protocolVersion(), HttpResponseStatus.UNAUTHORIZED);
                String string = HttpResponseStatus.UNAUTHORIZED.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"HttpResponseStatus.UNAUTHORIZED.toString()");
                String string2 = string;
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
                Charset charset2 = charset;
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string3.getBytes(charset2);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                byte[] content = byArray;
                httpResponse.headers().add((CharSequence)HttpHeaderNames.WWW_AUTHENTICATE, (Object)("Basic realm=\"" + tunnelRequest.getBasicAuthRealm() + '\"'));
                httpResponse.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)"keep-alive");
                httpResponse.headers().add((CharSequence)HttpHeaderNames.ACCEPT_RANGES, (Object)"bytes");
                httpResponse.headers().add((CharSequence)HttpHeaderNames.DATE, (Object)new Date().toString());
                httpResponse.headers().add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)content.length);
                httpResponse.content().writeBytes(content);
                return (FullHttpResponse)httpResponse;
            }
            return null;
        }

        private final void handleRewriteHttpHeaders(SocketAddress localAddress, SocketAddress remoteAddress, TunnelRequest tunnelRequest, FullHttpRequest httpRequest) {
            this.handleProxyHttpHeaders(true, localAddress, remoteAddress, tunnelRequest, httpRequest);
        }

        private final void handleWriteHttpHeaders(SocketAddress localAddress, SocketAddress remoteAddress, TunnelRequest tunnelRequest, FullHttpRequest httpRequest) {
            this.handleProxyHttpHeaders(false, localAddress, remoteAddress, tunnelRequest, httpRequest);
        }

        private final void handleProxyHttpHeaders(boolean pxySet, SocketAddress localAddress, SocketAddress remoteAddress, TunnelRequest tunnelRequest, FullHttpRequest httpRequest) {
            Map headers;
            Map map = headers = pxySet ? tunnelRequest.getPxySetHeaders() : tunnelRequest.getPxyAddHeaders();
            if (headers.isEmpty()) {
                return;
            }
            String remoteAddr = remoteAddress instanceof InetSocketAddress ? ((InetSocketAddress)remoteAddress).getAddress().toString() : null;
            for (Map.Entry it : headers.entrySet()) {
                String string;
                String name = (String)it.getKey();
                String string2 = (String)it.getValue();
                switch (string2.hashCode()) {
                    case -1717118554: {
                        if (string2.equals(MAGIC_VALUE_REMOTE_ADDR)) {
                            string = remoteAddr;
                            break;
                        }
                    }
                    default: {
                        string = (String)it.getValue();
                    }
                }
                if (string == null) {
                    continue;
                }
                String value = string;
                if (pxySet && httpRequest.headers().contains(name)) {
                    httpRequest.headers().set(name, (Object)value);
                    continue;
                }
                httpRequest.headers().add(name, (Object)value);
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Llighttunnel/server/http/HttpRequestInterceptor$DefaultImpl$Companion;", "", "()V", "MAGIC_VALUE_REMOTE_ADDR", "", "server"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Nullable
        public static FullHttpResponse handleHttpRequest(HttpRequestInterceptor $this, @NotNull ChannelHandlerContext ctx, @NotNull TunnelRequest tunnelRequest, @NotNull FullHttpRequest httpRequest) {
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            Intrinsics.checkParameterIsNotNull((Object)tunnelRequest, (String)"tunnelRequest");
            Intrinsics.checkParameterIsNotNull((Object)httpRequest, (String)"httpRequest");
            return null;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u00020\u00048FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\b\u0010\t\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Llighttunnel/server/http/HttpRequestInterceptor$Companion;", "", "()V", "defaultImpl", "Llighttunnel/server/http/HttpRequestInterceptor;", "defaultImpl$annotations", "getDefaultImpl", "()Llighttunnel/server/http/HttpRequestInterceptor;", "defaultImpl$delegate", "Lkotlin/Lazy;", "server"})
    public static final class Companion {
        @NotNull
        private static final Lazy defaultImpl$delegate;
        static final /* synthetic */ Companion $$INSTANCE;

        @JvmStatic
        public static /* synthetic */ void defaultImpl$annotations() {
        }

        @NotNull
        public final HttpRequestInterceptor getDefaultImpl() {
            Lazy lazy = defaultImpl$delegate;
            Object var2_2 = null;
            boolean bl = false;
            return (HttpRequestInterceptor)lazy.getValue();
        }

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
            defaultImpl$delegate = LazyKt.lazy((Function0)defaultImpl.2.INSTANCE);
        }
    }
}

