/*
 * Decompiled with CFR 0.152.
 */
package lighttunnel.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.ssl.SslContext;
import java.nio.charset.Charset;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import lighttunnel.proto.HeartbeatHandler;
import lighttunnel.proto.ProtoMessageDecoder;
import lighttunnel.proto.ProtoMessageEncoder;
import lighttunnel.server.TunnelRequestInterceptor;
import lighttunnel.server.TunnelServer$$special$;
import lighttunnel.server.TunnelServer$createWebServer$;
import lighttunnel.server.TunnelServerChannelHandler;
import lighttunnel.server.http.HttpFd;
import lighttunnel.server.http.HttpPlugin;
import lighttunnel.server.http.HttpRegistry;
import lighttunnel.server.http.HttpRequestInterceptor;
import lighttunnel.server.http.HttpServer;
import lighttunnel.server.tcp.TcpFd;
import lighttunnel.server.tcp.TcpRegistry;
import lighttunnel.server.tcp.TcpServer;
import lighttunnel.server.traffic.TrafficHandler;
import lighttunnel.util.IncIds;
import lighttunnel.web.server.RouterConfig;
import lighttunnel.web.server.WebServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001:\b9:;<=>?@Bk\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0002\u0010\u0013J\u0012\u0010/\u001a\u0004\u0018\u00010\u00192\u0006\u00100\u001a\u00020\u0017H\u0002J\u0012\u00101\u001a\u0004\u0018\u00010\u00192\u0006\u00100\u001a\u00020\u0017H\u0002J\u0010\u00102\u001a\u00020)2\u0006\u00100\u001a\u00020'H\u0002J\n\u00103\u001a\u0004\u0018\u00010-H\u0002J\u0006\u00104\u001a\u000205J\u0006\u00106\u001a\u000205J\b\u00107\u001a\u000205H\u0002J\b\u00108\u001a\u000205H\u0002R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001e\u001a\u00020\u001f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b \u0010!R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010,\u001a\u0004\u0018\u00010-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Llighttunnel/server/TunnelServer;", "", "bossThreads", "", "workerThreads", "tunnelServiceArgs", "Llighttunnel/server/TunnelServer$TunnelServiceArgs;", "sslTunnelServiceArgs", "Llighttunnel/server/TunnelServer$SslTunnelServiceArgs;", "httpServerArgs", "Llighttunnel/server/TunnelServer$HttpServerArgs;", "httpsServerArgs", "Llighttunnel/server/TunnelServer$HttpsServerArgs;", "webServerArgs", "Llighttunnel/server/TunnelServer$WebServerArgs;", "onTcpTunnelStateListener", "Llighttunnel/server/TunnelServer$OnTcpTunnelStateListener;", "onHttpTunnelStateListener", "Llighttunnel/server/TunnelServer$OnHttpTunnelStateListener;", "(IILlighttunnel/server/TunnelServer$TunnelServiceArgs;Llighttunnel/server/TunnelServer$SslTunnelServiceArgs;Llighttunnel/server/TunnelServer$HttpServerArgs;Llighttunnel/server/TunnelServer$HttpsServerArgs;Llighttunnel/server/TunnelServer$WebServerArgs;Llighttunnel/server/TunnelServer$OnTcpTunnelStateListener;Llighttunnel/server/TunnelServer$OnHttpTunnelStateListener;)V", "bossGroup", "Lio/netty/channel/nio/NioEventLoopGroup;", "httpRegistry", "Llighttunnel/server/http/HttpRegistry;", "httpServer", "Llighttunnel/server/http/HttpServer;", "httpsRegistry", "httpsServer", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "logger$delegate", "Lkotlin/Lazy;", "onChannelStateListener", "Llighttunnel/server/TunnelServer$OnChannelStateListenerImpl;", "tcpRegistry", "Llighttunnel/server/tcp/TcpRegistry;", "tcpServer", "Llighttunnel/server/tcp/TcpServer;", "tunnelIds", "Llighttunnel/util/IncIds;", "webServer", "Llighttunnel/web/server/WebServer;", "workerGroup", "createHttpServer", "registry", "createHttpsServer", "createTcpServer", "createWebServer", "depose", "", "start", "startSslTunnelService", "startTunnelService", "HttpServerArgs", "HttpsServerArgs", "OnChannelStateListenerImpl", "OnHttpTunnelStateListener", "OnTcpTunnelStateListener", "SslTunnelServiceArgs", "TunnelServiceArgs", "WebServerArgs", "server"})
public final class TunnelServer {
    private final Lazy logger$delegate;
    private final ReentrantLock lock;
    private final IncIds tunnelIds;
    private final NioEventLoopGroup bossGroup;
    private final NioEventLoopGroup workerGroup;
    private final TcpServer tcpServer;
    private final TcpRegistry tcpRegistry;
    private HttpServer httpServer;
    private final HttpRegistry httpRegistry;
    private HttpServer httpsServer;
    private final HttpRegistry httpsRegistry;
    private final WebServer webServer;
    private final OnChannelStateListenerImpl onChannelStateListener;
    private final TunnelServiceArgs tunnelServiceArgs;
    private final SslTunnelServiceArgs sslTunnelServiceArgs;
    private final HttpServerArgs httpServerArgs;
    private final HttpsServerArgs httpsServerArgs;
    private final WebServerArgs webServerArgs;

    private final Logger getLogger() {
        Lazy lazy = this.logger$delegate;
        TunnelServer tunnelServer = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() throws Exception {
        Lock lock = this.lock;
        boolean bl = false;
        lock.lock();
        try {
            boolean bl2 = false;
            HttpServer httpServer = this.httpServer;
            if (httpServer != null) {
                httpServer.start();
            }
            HttpServer httpServer2 = this.httpsServer;
            if (httpServer2 != null) {
                httpServer2.start();
            }
            WebServer webServer = this.webServer;
            if (webServer != null) {
                webServer.start();
            }
            this.startTunnelService();
            this.startSslTunnelService();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void depose() {
        Lock lock = this.lock;
        boolean bl = false;
        lock.lock();
        try {
            boolean bl2 = false;
            this.tcpRegistry.depose$server();
            this.httpRegistry.depose$server();
            this.httpsRegistry.depose$server();
            WebServer webServer = this.webServer;
            if (webServer != null) {
                webServer.depose();
            }
            this.bossGroup.shutdownGracefully();
            this.workerGroup.shutdownGracefully();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private final void startTunnelService() {
        TunnelServiceArgs args = this.tunnelServiceArgs;
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        ((ServerBootstrap)serverBootstrap.group((EventLoopGroup)this.bossGroup, (EventLoopGroup)this.workerGroup).channel(NioServerSocketChannel.class)).childOption(ChannelOption.AUTO_READ, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(this, args){
            final /* synthetic */ TunnelServer this$0;
            final /* synthetic */ TunnelServiceArgs $args;

            protected void initChannel(@Nullable SocketChannel ch) {
                if (ch == null) {
                    return;
                }
                ch.pipeline().addLast("traffic", (ChannelHandler)new TrafficHandler()).addLast("heartbeat", (ChannelHandler)new HeartbeatHandler(false, 0L, 0L, 0L, null, 31, null)).addLast("decoder", (ChannelHandler)new ProtoMessageDecoder()).addLast("encoder", (ChannelHandler)new ProtoMessageEncoder()).addLast("handler", (ChannelHandler)new TunnelServerChannelHandler(this.$args.getTunnelRequestInterceptor(), TunnelServer.access$getTunnelIds$p(this.this$0), TunnelServer.access$getTcpServer$p(this.this$0), TunnelServer.access$getHttpServer$p(this.this$0), TunnelServer.access$getHttpsServer$p(this.this$0), TunnelServer.access$getOnChannelStateListener$p(this.this$0)));
            }
            {
                this.this$0 = $outer;
                this.$args = $captured_local_variable$1;
            }
        });
        if (args.getBindAddr() == null) {
            serverBootstrap.bind(args.getBindPort()).get();
        } else {
            serverBootstrap.bind(args.getBindAddr(), args.getBindPort()).get();
        }
        Logger logger = this.getLogger();
        String string = args.getBindAddr();
        if (string == null) {
            string = "::";
        }
        logger.info("Serving tunnel on {} port {}", (Object)string, (Object)args.getBindPort());
    }

    private final void startSslTunnelService() {
        SslTunnelServiceArgs sslTunnelServiceArgs = this.sslTunnelServiceArgs;
        if (sslTunnelServiceArgs == null) {
            return;
        }
        SslTunnelServiceArgs args = sslTunnelServiceArgs;
        if (args.getBindPort() == null) {
            return;
        }
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        ((ServerBootstrap)serverBootstrap.group((EventLoopGroup)this.bossGroup, (EventLoopGroup)this.workerGroup).channel(NioServerSocketChannel.class)).childOption(ChannelOption.AUTO_READ, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(this, args){
            final /* synthetic */ TunnelServer this$0;
            final /* synthetic */ SslTunnelServiceArgs $args;

            protected void initChannel(@Nullable SocketChannel ch) {
                if (ch == null) {
                    return;
                }
                ch.pipeline().addFirst("ssl", (ChannelHandler)this.$args.getSslContext().newHandler(ch.alloc())).addLast("traffic", (ChannelHandler)new TrafficHandler()).addLast("heartbeat", (ChannelHandler)new HeartbeatHandler(false, 0L, 0L, 0L, null, 31, null)).addLast("decoder", (ChannelHandler)new ProtoMessageDecoder()).addLast("encoder", (ChannelHandler)new ProtoMessageEncoder()).addLast("handler", (ChannelHandler)new TunnelServerChannelHandler(this.$args.getTunnelRequestInterceptor(), TunnelServer.access$getTunnelIds$p(this.this$0), TunnelServer.access$getTcpServer$p(this.this$0), TunnelServer.access$getHttpServer$p(this.this$0), TunnelServer.access$getHttpsServer$p(this.this$0), TunnelServer.access$getOnChannelStateListener$p(this.this$0)));
            }
            {
                this.this$0 = $outer;
                this.$args = $captured_local_variable$1;
            }
        });
        if (args.getBindAddr() == null) {
            serverBootstrap.bind(args.getBindPort().intValue()).get();
        } else {
            serverBootstrap.bind(args.getBindAddr(), args.getBindPort().intValue()).get();
        }
        Logger logger = this.getLogger();
        String string = args.getBindAddr();
        if (string == null) {
            string = "::";
        }
        logger.info("Serving tunnel with ssl on {} port {}", (Object)string, (Object)args.getBindPort());
    }

    private final TcpServer createTcpServer(TcpRegistry registry) {
        return new TcpServer(this.bossGroup, this.workerGroup, registry);
    }

    private final HttpServer createHttpServer(HttpRegistry registry) {
        HttpServerArgs httpServerArgs = this.httpServerArgs;
        if (httpServerArgs == null) {
            return null;
        }
        HttpServerArgs args = httpServerArgs;
        Integer n = args.getBindPort();
        if (n == null) {
            return null;
        }
        HttpRegistry httpRegistry = registry;
        HttpPlugin httpPlugin = args.getHttpPlugin();
        int n2 = 0;
        HttpRequestInterceptor httpRequestInterceptor = args.getHttpRequestInterceptor();
        SslContext sslContext = null;
        int n3 = n;
        String string = args.getBindAddr();
        return new HttpServer(this.bossGroup, this.workerGroup, httpRegistry, string, n3, sslContext, n2, httpPlugin, httpRequestInterceptor, 64, null);
    }

    private final HttpServer createHttpsServer(HttpRegistry registry) {
        HttpsServerArgs httpsServerArgs = this.httpsServerArgs;
        if (httpsServerArgs == null) {
            return null;
        }
        HttpsServerArgs args = httpsServerArgs;
        if (args.getBindPort() == null) {
            return null;
        }
        HttpRegistry httpRegistry = registry;
        HttpPlugin httpPlugin = args.getHttpPlugin();
        int n = 0;
        HttpRequestInterceptor httpRequestInterceptor = args.getHttpRequestInterceptor();
        SslContext sslContext = args.getSslContext();
        int n2 = args.getBindPort();
        String string = args.getBindAddr();
        return new HttpServer(this.bossGroup, this.workerGroup, httpRegistry, string, n2, sslContext, n, httpPlugin, httpRequestInterceptor, 64, null);
    }

    private final WebServer createWebServer() {
        WebServerArgs webServerArgs = this.webServerArgs;
        if (webServerArgs == null) {
            return null;
        }
        WebServerArgs args = webServerArgs;
        Integer n = args.getBindPort();
        if (n == null) {
            return null;
        }
        WebServer webServer = new WebServer(this.bossGroup, this.workerGroup, args.getBindAddr(), n.intValue(), null, 0, 48, null);
        boolean bl = false;
        boolean bl2 = false;
        WebServer $this$apply = webServer;
        boolean bl3 = false;
        $this$apply.router((Function1)new Function1<RouterConfig, Unit>(this){
            final /* synthetic */ TunnelServer this$0;
            {
                this.this$0 = tunnelServer;
                super(1);
            }

            public final void invoke(@NotNull RouterConfig $this$router) {
                Intrinsics.checkParameterIsNotNull((Object)$this$router, (String)"$receiver");
                $this$router.route("/api/snapshot", (Function1)new Function1<FullHttpRequest, DefaultFullHttpResponse>(this){
                    final /* synthetic */ createWebServer$$inlined$apply$lambda$1 this$0;
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }

                    @NotNull
                    public final DefaultFullHttpResponse invoke(@NotNull FullHttpRequest it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        JSONObject obj = new JSONObject();
                        obj.put("tcp", (Object)TunnelServer.access$getTcpRegistry$p(this.this$0.this$0).getSnapshot());
                        obj.put("http", (Object)TunnelServer.access$getHttpRegistry$p(this.this$0.this$0).getSnapshot());
                        obj.put("https", (Object)TunnelServer.access$getHttpsRegistry$p(this.this$0.this$0).getSnapshot());
                        ByteBuf content = Unpooled.copiedBuffer((CharSequence)obj.toString(2), (Charset)Charsets.UTF_8);
                        DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, content);
                        boolean bl = false;
                        boolean bl2 = false;
                        DefaultFullHttpResponse it2 = defaultFullHttpResponse;
                        boolean bl3 = false;
                        it2.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_JSON).set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)content.readableBytes());
                        return defaultFullHttpResponse;
                    }
                });
            }
        });
        return webServer;
    }

    public TunnelServer(int bossThreads, int workerThreads, @NotNull TunnelServiceArgs tunnelServiceArgs, @Nullable SslTunnelServiceArgs sslTunnelServiceArgs, @Nullable HttpServerArgs httpServerArgs, @Nullable HttpsServerArgs httpsServerArgs, @Nullable WebServerArgs webServerArgs, @Nullable OnTcpTunnelStateListener onTcpTunnelStateListener, @Nullable OnHttpTunnelStateListener onHttpTunnelStateListener) {
        Lazy lazy;
        Intrinsics.checkParameterIsNotNull((Object)tunnelServiceArgs, (String)"tunnelServiceArgs");
        this.tunnelServiceArgs = tunnelServiceArgs;
        this.sslTunnelServiceArgs = sslTunnelServiceArgs;
        this.httpServerArgs = httpServerArgs;
        this.httpsServerArgs = httpsServerArgs;
        this.webServerArgs = webServerArgs;
        TunnelServer tunnelServer = this;
        TunnelServer tunnelServer2 = this;
        boolean $i$f$loggerDelegate = false;
        tunnelServer2.logger$delegate = lazy = LazyKt.lazy((Function0)$special$$inlined$loggerDelegate$1.INSTANCE);
        this.lock = new ReentrantLock();
        this.tunnelIds = new IncIds();
        this.bossGroup = bossThreads >= 0 ? new NioEventLoopGroup(bossThreads) : new NioEventLoopGroup();
        this.workerGroup = workerThreads >= 0 ? new NioEventLoopGroup(workerThreads) : new NioEventLoopGroup();
        this.tcpRegistry = new TcpRegistry();
        this.httpRegistry = new HttpRegistry();
        this.httpsRegistry = new HttpRegistry();
        this.onChannelStateListener = new OnChannelStateListenerImpl(onTcpTunnelStateListener, onHttpTunnelStateListener);
        this.tcpServer = this.createTcpServer(this.tcpRegistry);
        this.httpServer = this.createHttpServer(this.httpRegistry);
        this.httpsServer = this.createHttpsServer(this.httpsRegistry);
        this.webServer = this.createWebServer();
    }

    public /* synthetic */ TunnelServer(int n, int n2, TunnelServiceArgs tunnelServiceArgs, SslTunnelServiceArgs sslTunnelServiceArgs, HttpServerArgs httpServerArgs, HttpsServerArgs httpsServerArgs, WebServerArgs webServerArgs, OnTcpTunnelStateListener onTcpTunnelStateListener, OnHttpTunnelStateListener onHttpTunnelStateListener, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = -1;
        }
        if ((n3 & 2) != 0) {
            n2 = -1;
        }
        if ((n3 & 4) != 0) {
            tunnelServiceArgs = new TunnelServiceArgs(null, 0, null, 7, null);
        }
        if ((n3 & 8) != 0) {
            sslTunnelServiceArgs = null;
        }
        if ((n3 & 0x10) != 0) {
            httpServerArgs = null;
        }
        if ((n3 & 0x20) != 0) {
            httpsServerArgs = null;
        }
        if ((n3 & 0x40) != 0) {
            webServerArgs = null;
        }
        if ((n3 & 0x80) != 0) {
            onTcpTunnelStateListener = null;
        }
        if ((n3 & 0x100) != 0) {
            onHttpTunnelStateListener = null;
        }
        this(n, n2, tunnelServiceArgs, sslTunnelServiceArgs, httpServerArgs, httpsServerArgs, webServerArgs, onTcpTunnelStateListener, onHttpTunnelStateListener);
    }

    public TunnelServer() {
        this(0, 0, null, null, null, null, null, null, null, 511, null);
    }

    public static final /* synthetic */ IncIds access$getTunnelIds$p(TunnelServer $this) {
        return $this.tunnelIds;
    }

    public static final /* synthetic */ TcpServer access$getTcpServer$p(TunnelServer $this) {
        return $this.tcpServer;
    }

    public static final /* synthetic */ HttpServer access$getHttpServer$p(TunnelServer $this) {
        return $this.httpServer;
    }

    public static final /* synthetic */ void access$setHttpServer$p(TunnelServer $this, HttpServer httpServer) {
        $this.httpServer = httpServer;
    }

    public static final /* synthetic */ HttpServer access$getHttpsServer$p(TunnelServer $this) {
        return $this.httpsServer;
    }

    public static final /* synthetic */ void access$setHttpsServer$p(TunnelServer $this, HttpServer httpServer) {
        $this.httpsServer = httpServer;
    }

    public static final /* synthetic */ OnChannelStateListenerImpl access$getOnChannelStateListener$p(TunnelServer $this) {
        return $this.onChannelStateListener;
    }

    public static final /* synthetic */ TcpRegistry access$getTcpRegistry$p(TunnelServer $this) {
        return $this.tcpRegistry;
    }

    public static final /* synthetic */ HttpRegistry access$getHttpRegistry$p(TunnelServer $this) {
        return $this.httpRegistry;
    }

    public static final /* synthetic */ HttpRegistry access$getHttpsRegistry$p(TunnelServer $this) {
        return $this.httpsRegistry;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B%\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Llighttunnel/server/TunnelServer$TunnelServiceArgs;", "", "bindAddr", "", "bindPort", "", "tunnelRequestInterceptor", "Llighttunnel/server/TunnelRequestInterceptor;", "(Ljava/lang/String;ILlighttunnel/server/TunnelRequestInterceptor;)V", "getBindAddr", "()Ljava/lang/String;", "getBindPort", "()I", "getTunnelRequestInterceptor", "()Llighttunnel/server/TunnelRequestInterceptor;", "server"})
    public static final class TunnelServiceArgs {
        @Nullable
        private final String bindAddr;
        private final int bindPort;
        @NotNull
        private final TunnelRequestInterceptor tunnelRequestInterceptor;

        @Nullable
        public final String getBindAddr() {
            return this.bindAddr;
        }

        public final int getBindPort() {
            return this.bindPort;
        }

        @NotNull
        public final TunnelRequestInterceptor getTunnelRequestInterceptor() {
            return this.tunnelRequestInterceptor;
        }

        public TunnelServiceArgs(@Nullable String bindAddr, int bindPort, @NotNull TunnelRequestInterceptor tunnelRequestInterceptor) {
            Intrinsics.checkParameterIsNotNull((Object)tunnelRequestInterceptor, (String)"tunnelRequestInterceptor");
            this.bindAddr = bindAddr;
            this.bindPort = bindPort;
            this.tunnelRequestInterceptor = tunnelRequestInterceptor;
        }

        public /* synthetic */ TunnelServiceArgs(String string, int n, TunnelRequestInterceptor tunnelRequestInterceptor, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                string = null;
            }
            if ((n2 & 2) != 0) {
                n = 5080;
            }
            if ((n2 & 4) != 0) {
                tunnelRequestInterceptor = TunnelRequestInterceptor.Companion.getEmptyImpl();
            }
            this(string, n, tunnelRequestInterceptor);
        }

        public TunnelServiceArgs() {
            this(null, 0, null, 7, null);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B/\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Llighttunnel/server/TunnelServer$SslTunnelServiceArgs;", "", "bindAddr", "", "bindPort", "", "tunnelRequestInterceptor", "Llighttunnel/server/TunnelRequestInterceptor;", "sslContext", "Lio/netty/handler/ssl/SslContext;", "(Ljava/lang/String;Ljava/lang/Integer;Llighttunnel/server/TunnelRequestInterceptor;Lio/netty/handler/ssl/SslContext;)V", "getBindAddr", "()Ljava/lang/String;", "getBindPort", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getSslContext", "()Lio/netty/handler/ssl/SslContext;", "getTunnelRequestInterceptor", "()Llighttunnel/server/TunnelRequestInterceptor;", "server"})
    public static final class SslTunnelServiceArgs {
        @Nullable
        private final String bindAddr;
        @Nullable
        private final Integer bindPort;
        @NotNull
        private final TunnelRequestInterceptor tunnelRequestInterceptor;
        @NotNull
        private final SslContext sslContext;

        @Nullable
        public final String getBindAddr() {
            return this.bindAddr;
        }

        @Nullable
        public final Integer getBindPort() {
            return this.bindPort;
        }

        @NotNull
        public final TunnelRequestInterceptor getTunnelRequestInterceptor() {
            return this.tunnelRequestInterceptor;
        }

        @NotNull
        public final SslContext getSslContext() {
            return this.sslContext;
        }

        public SslTunnelServiceArgs(@Nullable String bindAddr, @Nullable Integer bindPort, @NotNull TunnelRequestInterceptor tunnelRequestInterceptor, @NotNull SslContext sslContext) {
            Intrinsics.checkParameterIsNotNull((Object)tunnelRequestInterceptor, (String)"tunnelRequestInterceptor");
            Intrinsics.checkParameterIsNotNull((Object)sslContext, (String)"sslContext");
            this.bindAddr = bindAddr;
            this.bindPort = bindPort;
            this.tunnelRequestInterceptor = tunnelRequestInterceptor;
            this.sslContext = sslContext;
        }

        public /* synthetic */ SslTunnelServiceArgs(String string, Integer n, TunnelRequestInterceptor tunnelRequestInterceptor, SslContext sslContext, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                string = null;
            }
            if ((n2 & 2) != 0) {
                n = null;
            }
            if ((n2 & 4) != 0) {
                tunnelRequestInterceptor = TunnelRequestInterceptor.Companion.getEmptyImpl();
            }
            this(string, n, tunnelRequestInterceptor, sslContext);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B3\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Llighttunnel/server/TunnelServer$HttpServerArgs;", "", "bindAddr", "", "bindPort", "", "httpRequestInterceptor", "Llighttunnel/server/http/HttpRequestInterceptor;", "httpPlugin", "Llighttunnel/server/http/HttpPlugin;", "(Ljava/lang/String;Ljava/lang/Integer;Llighttunnel/server/http/HttpRequestInterceptor;Llighttunnel/server/http/HttpPlugin;)V", "getBindAddr", "()Ljava/lang/String;", "getBindPort", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getHttpPlugin", "()Llighttunnel/server/http/HttpPlugin;", "getHttpRequestInterceptor", "()Llighttunnel/server/http/HttpRequestInterceptor;", "server"})
    public static final class HttpServerArgs {
        @Nullable
        private final String bindAddr;
        @Nullable
        private final Integer bindPort;
        @NotNull
        private final HttpRequestInterceptor httpRequestInterceptor;
        @Nullable
        private final HttpPlugin httpPlugin;

        @Nullable
        public final String getBindAddr() {
            return this.bindAddr;
        }

        @Nullable
        public final Integer getBindPort() {
            return this.bindPort;
        }

        @NotNull
        public final HttpRequestInterceptor getHttpRequestInterceptor() {
            return this.httpRequestInterceptor;
        }

        @Nullable
        public final HttpPlugin getHttpPlugin() {
            return this.httpPlugin;
        }

        public HttpServerArgs(@Nullable String bindAddr, @Nullable Integer bindPort, @NotNull HttpRequestInterceptor httpRequestInterceptor, @Nullable HttpPlugin httpPlugin) {
            Intrinsics.checkParameterIsNotNull((Object)httpRequestInterceptor, (String)"httpRequestInterceptor");
            this.bindAddr = bindAddr;
            this.bindPort = bindPort;
            this.httpRequestInterceptor = httpRequestInterceptor;
            this.httpPlugin = httpPlugin;
        }

        public /* synthetic */ HttpServerArgs(String string, Integer n, HttpRequestInterceptor httpRequestInterceptor, HttpPlugin httpPlugin, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                string = null;
            }
            if ((n2 & 2) != 0) {
                n = null;
            }
            if ((n2 & 4) != 0) {
                httpRequestInterceptor = HttpRequestInterceptor.Companion.getDefaultImpl();
            }
            if ((n2 & 8) != 0) {
                httpPlugin = null;
            }
            this(string, n, httpRequestInterceptor, httpPlugin);
        }

        public HttpServerArgs() {
            this(null, null, null, null, 15, null);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B;\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Llighttunnel/server/TunnelServer$HttpsServerArgs;", "", "bindAddr", "", "bindPort", "", "httpRequestInterceptor", "Llighttunnel/server/http/HttpRequestInterceptor;", "httpPlugin", "Llighttunnel/server/http/HttpPlugin;", "sslContext", "Lio/netty/handler/ssl/SslContext;", "(Ljava/lang/String;Ljava/lang/Integer;Llighttunnel/server/http/HttpRequestInterceptor;Llighttunnel/server/http/HttpPlugin;Lio/netty/handler/ssl/SslContext;)V", "getBindAddr", "()Ljava/lang/String;", "getBindPort", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getHttpPlugin", "()Llighttunnel/server/http/HttpPlugin;", "getHttpRequestInterceptor", "()Llighttunnel/server/http/HttpRequestInterceptor;", "getSslContext", "()Lio/netty/handler/ssl/SslContext;", "server"})
    public static final class HttpsServerArgs {
        @Nullable
        private final String bindAddr;
        @Nullable
        private final Integer bindPort;
        @NotNull
        private final HttpRequestInterceptor httpRequestInterceptor;
        @Nullable
        private final HttpPlugin httpPlugin;
        @NotNull
        private final SslContext sslContext;

        @Nullable
        public final String getBindAddr() {
            return this.bindAddr;
        }

        @Nullable
        public final Integer getBindPort() {
            return this.bindPort;
        }

        @NotNull
        public final HttpRequestInterceptor getHttpRequestInterceptor() {
            return this.httpRequestInterceptor;
        }

        @Nullable
        public final HttpPlugin getHttpPlugin() {
            return this.httpPlugin;
        }

        @NotNull
        public final SslContext getSslContext() {
            return this.sslContext;
        }

        public HttpsServerArgs(@Nullable String bindAddr, @Nullable Integer bindPort, @NotNull HttpRequestInterceptor httpRequestInterceptor, @Nullable HttpPlugin httpPlugin, @NotNull SslContext sslContext) {
            Intrinsics.checkParameterIsNotNull((Object)httpRequestInterceptor, (String)"httpRequestInterceptor");
            Intrinsics.checkParameterIsNotNull((Object)sslContext, (String)"sslContext");
            this.bindAddr = bindAddr;
            this.bindPort = bindPort;
            this.httpRequestInterceptor = httpRequestInterceptor;
            this.httpPlugin = httpPlugin;
            this.sslContext = sslContext;
        }

        public /* synthetic */ HttpsServerArgs(String string, Integer n, HttpRequestInterceptor httpRequestInterceptor, HttpPlugin httpPlugin, SslContext sslContext, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                string = null;
            }
            if ((n2 & 2) != 0) {
                n = null;
            }
            if ((n2 & 4) != 0) {
                httpRequestInterceptor = HttpRequestInterceptor.Companion.getDefaultImpl();
            }
            if ((n2 & 8) != 0) {
                httpPlugin = null;
            }
            this(string, n, httpRequestInterceptor, httpPlugin, sslContext);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Llighttunnel/server/TunnelServer$WebServerArgs;", "", "bindAddr", "", "bindPort", "", "(Ljava/lang/String;Ljava/lang/Integer;)V", "getBindAddr", "()Ljava/lang/String;", "getBindPort", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "server"})
    public static final class WebServerArgs {
        @Nullable
        private final String bindAddr;
        @Nullable
        private final Integer bindPort;

        @Nullable
        public final String getBindAddr() {
            return this.bindAddr;
        }

        @Nullable
        public final Integer getBindPort() {
            return this.bindPort;
        }

        public WebServerArgs(@Nullable String bindAddr, @Nullable Integer bindPort) {
            this.bindAddr = bindAddr;
            this.bindPort = bindPort;
        }

        public /* synthetic */ WebServerArgs(String string, Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                string = null;
            }
            if ((n2 & 2) != 0) {
                n = null;
            }
            this(string, n);
        }

        public WebServerArgs() {
            this(null, null, 3, null);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u001a\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u001a\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Llighttunnel/server/TunnelServer$OnChannelStateListenerImpl;", "Llighttunnel/server/TunnelServerChannelHandler$OnChannelStateListener;", "onTcpTunnelStateListener", "Llighttunnel/server/TunnelServer$OnTcpTunnelStateListener;", "onHttpTunnelStateListener", "Llighttunnel/server/TunnelServer$OnHttpTunnelStateListener;", "(Llighttunnel/server/TunnelServer$OnTcpTunnelStateListener;Llighttunnel/server/TunnelServer$OnHttpTunnelStateListener;)V", "onChannelConnected", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "httpFd", "Llighttunnel/server/http/HttpFd;", "tcpFd", "Llighttunnel/server/tcp/TcpFd;", "onChannelInactive", "server"})
    private static final class OnChannelStateListenerImpl
    implements TunnelServerChannelHandler.OnChannelStateListener {
        private final OnTcpTunnelStateListener onTcpTunnelStateListener;
        private final OnHttpTunnelStateListener onHttpTunnelStateListener;

        @Override
        public void onChannelConnected(@NotNull ChannelHandlerContext ctx, @Nullable TcpFd tcpFd) {
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
                TunnelServerChannelHandler.OnChannelStateListener.DefaultImpls.onChannelConnected((TunnelServerChannelHandler.OnChannelStateListener)this, ctx, tcpFd);
                if (tcpFd == null) break block1;
                OnTcpTunnelStateListener onTcpTunnelStateListener = this.onTcpTunnelStateListener;
                if (onTcpTunnelStateListener != null) {
                    onTcpTunnelStateListener.onConnected(tcpFd);
                }
            }
        }

        @Override
        public void onChannelInactive(@NotNull ChannelHandlerContext ctx, @Nullable TcpFd tcpFd) {
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
                TunnelServerChannelHandler.OnChannelStateListener.DefaultImpls.onChannelInactive((TunnelServerChannelHandler.OnChannelStateListener)this, ctx, tcpFd);
                if (tcpFd == null) break block1;
                OnTcpTunnelStateListener onTcpTunnelStateListener = this.onTcpTunnelStateListener;
                if (onTcpTunnelStateListener != null) {
                    onTcpTunnelStateListener.onDisconnect(tcpFd);
                }
            }
        }

        @Override
        public void onChannelConnected(@NotNull ChannelHandlerContext ctx, @Nullable HttpFd httpFd) {
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
                TunnelServerChannelHandler.OnChannelStateListener.DefaultImpls.onChannelConnected((TunnelServerChannelHandler.OnChannelStateListener)this, ctx, httpFd);
                if (httpFd == null) break block1;
                OnHttpTunnelStateListener onHttpTunnelStateListener = this.onHttpTunnelStateListener;
                if (onHttpTunnelStateListener != null) {
                    onHttpTunnelStateListener.onConnected(httpFd);
                }
            }
        }

        @Override
        public void onChannelInactive(@NotNull ChannelHandlerContext ctx, @Nullable HttpFd httpFd) {
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
                TunnelServerChannelHandler.OnChannelStateListener.DefaultImpls.onChannelInactive((TunnelServerChannelHandler.OnChannelStateListener)this, ctx, httpFd);
                if (httpFd == null) break block1;
                OnHttpTunnelStateListener onHttpTunnelStateListener = this.onHttpTunnelStateListener;
                if (onHttpTunnelStateListener != null) {
                    onHttpTunnelStateListener.onDisconnect(httpFd);
                }
            }
        }

        public OnChannelStateListenerImpl(@Nullable OnTcpTunnelStateListener onTcpTunnelStateListener, @Nullable OnHttpTunnelStateListener onHttpTunnelStateListener) {
            this.onTcpTunnelStateListener = onTcpTunnelStateListener;
            this.onHttpTunnelStateListener = onHttpTunnelStateListener;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Llighttunnel/server/TunnelServer$OnTcpTunnelStateListener;", "", "onConnected", "", "fd", "Llighttunnel/server/tcp/TcpFd;", "onDisconnect", "server"})
    public static interface OnTcpTunnelStateListener {
        public void onConnected(@NotNull TcpFd var1);

        public void onDisconnect(@NotNull TcpFd var1);

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            public static void onConnected(OnTcpTunnelStateListener $this, @NotNull TcpFd fd) {
                Intrinsics.checkParameterIsNotNull((Object)fd, (String)"fd");
            }

            public static void onDisconnect(OnTcpTunnelStateListener $this, @NotNull TcpFd fd) {
                Intrinsics.checkParameterIsNotNull((Object)fd, (String)"fd");
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Llighttunnel/server/TunnelServer$OnHttpTunnelStateListener;", "", "onConnected", "", "fd", "Llighttunnel/server/http/HttpFd;", "onDisconnect", "server"})
    public static interface OnHttpTunnelStateListener {
        public void onConnected(@NotNull HttpFd var1);

        public void onDisconnect(@NotNull HttpFd var1);

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            public static void onConnected(OnHttpTunnelStateListener $this, @NotNull HttpFd fd) {
                Intrinsics.checkParameterIsNotNull((Object)fd, (String)"fd");
            }

            public static void onDisconnect(OnHttpTunnelStateListener $this, @NotNull HttpFd fd) {
                Intrinsics.checkParameterIsNotNull((Object)fd, (String)"fd");
            }
        }
    }
}

