/*
 * Decompiled with CFR 0.152.
 */
package lighttunnel.internal.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.ssl.SslContext;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import lighttunnel.TunnelRequestInterceptor;
import lighttunnel.args.HttpTunnelArgs;
import lighttunnel.args.HttpsTunnelArgs;
import lighttunnel.args.SslTunnelDaemonArgs;
import lighttunnel.args.TunnelDaemonArgs;
import lighttunnel.http.HttpPlugin;
import lighttunnel.http.HttpTunnelRequestInterceptor;
import lighttunnel.internal.base.proto.HeartbeatHandler;
import lighttunnel.internal.base.proto.ProtoMessageDecoder;
import lighttunnel.internal.base.proto.ProtoMessageEncoder;
import lighttunnel.internal.base.util.IncIds;
import lighttunnel.internal.server.TunnelServerDaemon$$special$;
import lighttunnel.internal.server.TunnelServerDaemonChannelHandler;
import lighttunnel.internal.server.http.HttpFdDefaultImpl;
import lighttunnel.internal.server.http.HttpRegistry;
import lighttunnel.internal.server.http.HttpTunnel;
import lighttunnel.internal.server.tcp.TcpFdDefaultImpl;
import lighttunnel.internal.server.tcp.TcpRegistry;
import lighttunnel.internal.server.tcp.TcpTunnel;
import lighttunnel.internal.server.traffic.TrafficHandler;
import lighttunnel.listener.OnHttpTunnelStateListener;
import lighttunnel.listener.OnTcpTunnelStateListener;
import lighttunnel.listener.OnTrafficListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001Be\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\u0006\u00102\u001a\u000203J\u0018\u00104\u001a\u00020\u001d2\u0006\u00105\u001a\u00020\u00192\u0006\u00106\u001a\u00020\nH\u0002J\u0018\u00107\u001a\u00020\u001d2\u0006\u00105\u001a\u00020\u00192\u0006\u00106\u001a\u00020\fH\u0002J\u0010\u00108\u001a\u00020.2\u0006\u00105\u001a\u00020*H\u0002J\u0012\u00109\u001a\u00020:2\b\u0010;\u001a\u0004\u0018\u00010<H\u0002J\u0006\u0010=\u001a\u000203J\u0010\u0010>\u001a\u0002032\u0006\u00106\u001a\u00020\bH\u0002J\u0010\u0010?\u001a\u0002032\u0006\u00106\u001a\u00020\u0006H\u0002R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001bR\u0010\u0010 \u001a\u0004\u0018\u00010\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010#\u001a\u00020$8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b%\u0010&R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Llighttunnel/internal/server/TunnelServerDaemon;", "", "bossThreads", "", "workerThreads", "tunnelDaemonArgs", "Llighttunnel/args/TunnelDaemonArgs;", "sslTunnelDaemonArgs", "Llighttunnel/args/SslTunnelDaemonArgs;", "httpTunnelArgs", "Llighttunnel/args/HttpTunnelArgs;", "httpsTunnelArgs", "Llighttunnel/args/HttpsTunnelArgs;", "onTcpTunnelStateListener", "Llighttunnel/listener/OnTcpTunnelStateListener;", "onHttpTunnelStateListener", "Llighttunnel/listener/OnHttpTunnelStateListener;", "onTrafficListener", "Llighttunnel/listener/OnTrafficListener;", "isHttpAndHttpsShareRegistry", "", "(IILlighttunnel/args/TunnelDaemonArgs;Llighttunnel/args/SslTunnelDaemonArgs;Llighttunnel/args/HttpTunnelArgs;Llighttunnel/args/HttpsTunnelArgs;Llighttunnel/listener/OnTcpTunnelStateListener;Llighttunnel/listener/OnHttpTunnelStateListener;Llighttunnel/listener/OnTrafficListener;Z)V", "bossGroup", "Lio/netty/channel/nio/NioEventLoopGroup;", "httpRegistry", "Llighttunnel/internal/server/http/HttpRegistry;", "getHttpRegistry", "()Llighttunnel/internal/server/http/HttpRegistry;", "httpTunnel", "Llighttunnel/internal/server/http/HttpTunnel;", "httpsRegistry", "getHttpsRegistry", "httpsTunnel", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "logger$delegate", "Lkotlin/Lazy;", "tcpRegistry", "Llighttunnel/internal/server/tcp/TcpRegistry;", "getTcpRegistry", "()Llighttunnel/internal/server/tcp/TcpRegistry;", "tcpTunnel", "Llighttunnel/internal/server/tcp/TcpTunnel;", "tunnelIds", "Llighttunnel/internal/base/util/IncIds;", "workerGroup", "depose", "", "getHttpTunnel", "registry", "args", "getHttpsTunnel", "getTcpTunnel", "newTunnelServerChannelHandler", "Llighttunnel/internal/server/TunnelServerDaemonChannelHandler;", "tunnelRequestInterceptor", "Llighttunnel/TunnelRequestInterceptor;", "start", "startSslTunnelDaemon", "startTunnelDaemon", "server"})
public final class TunnelServerDaemon {
    private final Lazy logger$delegate;
    private final ReentrantLock lock;
    private final IncIds tunnelIds;
    private final NioEventLoopGroup bossGroup;
    private final NioEventLoopGroup workerGroup;
    @NotNull
    private final TcpRegistry tcpRegistry;
    @NotNull
    private final HttpRegistry httpRegistry;
    @NotNull
    private final HttpRegistry httpsRegistry;
    private final TcpTunnel tcpTunnel;
    private final HttpTunnel httpTunnel;
    private final HttpTunnel httpsTunnel;
    private final TunnelDaemonArgs tunnelDaemonArgs;
    private final SslTunnelDaemonArgs sslTunnelDaemonArgs;
    private final OnTcpTunnelStateListener onTcpTunnelStateListener;
    private final OnHttpTunnelStateListener onHttpTunnelStateListener;
    private final OnTrafficListener onTrafficListener;

    private final Logger getLogger() {
        Lazy lazy = this.logger$delegate;
        TunnelServerDaemon tunnelServerDaemon = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    @NotNull
    public final TcpRegistry getTcpRegistry() {
        return this.tcpRegistry;
    }

    @NotNull
    public final HttpRegistry getHttpRegistry() {
        return this.httpRegistry;
    }

    @NotNull
    public final HttpRegistry getHttpsRegistry() {
        return this.httpsRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() throws Exception {
        Lock lock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            Object it;
            boolean bl3;
            boolean bl4;
            Object object;
            boolean bl5 = false;
            HttpTunnel httpTunnel = this.httpTunnel;
            if (httpTunnel != null) {
                httpTunnel.start();
            }
            HttpTunnel httpTunnel2 = this.httpsTunnel;
            if (httpTunnel2 != null) {
                httpTunnel2.start();
            }
            TunnelDaemonArgs tunnelDaemonArgs = this.tunnelDaemonArgs;
            if (tunnelDaemonArgs != null) {
                object = tunnelDaemonArgs;
                bl4 = false;
                bl3 = false;
                it = object;
                boolean bl6 = false;
                this.startTunnelDaemon((TunnelDaemonArgs)it);
            }
            SslTunnelDaemonArgs sslTunnelDaemonArgs = this.sslTunnelDaemonArgs;
            if (sslTunnelDaemonArgs != null) {
                object = sslTunnelDaemonArgs;
                bl4 = false;
                bl3 = false;
                it = object;
                boolean bl7 = false;
                this.startSslTunnelDaemon((SslTunnelDaemonArgs)it);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void depose() {
        Lock lock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            this.tcpRegistry.depose();
            this.httpRegistry.depose();
            this.httpsRegistry.depose();
            this.bossGroup.shutdownGracefully();
            this.workerGroup.shutdownGracefully();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private final void startTunnelDaemon(TunnelDaemonArgs args) {
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        ((ServerBootstrap)serverBootstrap.group((EventLoopGroup)this.bossGroup, (EventLoopGroup)this.workerGroup).channel(NioServerSocketChannel.class)).childOption(ChannelOption.AUTO_READ, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(this, args){
            final /* synthetic */ TunnelServerDaemon this$0;
            final /* synthetic */ TunnelDaemonArgs $args;

            protected void initChannel(@Nullable SocketChannel ch) {
                if (ch == null) {
                    return;
                }
                ch.pipeline().addLast("traffic", (ChannelHandler)new TrafficHandler(TunnelServerDaemon.access$getOnTrafficListener$p(this.this$0))).addLast("heartbeat", (ChannelHandler)new HeartbeatHandler(false, 0L, 0L, 0L, null, 31, null)).addLast("decoder", (ChannelHandler)new ProtoMessageDecoder()).addLast("encoder", (ChannelHandler)new ProtoMessageEncoder()).addLast("handler", (ChannelHandler)TunnelServerDaemon.access$newTunnelServerChannelHandler(this.this$0, this.$args.getTunnelRequestInterceptor()));
            }
            {
                this.this$0 = this$0;
                this.$args = $captured_local_variable$1;
            }
        });
        if (args.getBindAddr() == null) {
            serverBootstrap.bind(args.getBindPort()).get();
        } else {
            serverBootstrap.bind(args.getBindAddr(), args.getBindPort()).get();
        }
        Logger logger = this.getLogger();
        String string = args.getBindAddr();
        if (string == null) {
            string = "::";
        }
        logger.info("Serving tunnel on {} port {}", (Object)string, (Object)args.getBindPort());
    }

    private final void startSslTunnelDaemon(SslTunnelDaemonArgs args) {
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        ((ServerBootstrap)serverBootstrap.group((EventLoopGroup)this.bossGroup, (EventLoopGroup)this.workerGroup).channel(NioServerSocketChannel.class)).childOption(ChannelOption.AUTO_READ, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(this, args){
            final /* synthetic */ TunnelServerDaemon this$0;
            final /* synthetic */ SslTunnelDaemonArgs $args;

            protected void initChannel(@Nullable SocketChannel ch) {
                if (ch == null) {
                    return;
                }
                ch.pipeline().addFirst("ssl", (ChannelHandler)this.$args.getSslContext().newHandler(ch.alloc())).addLast("traffic", (ChannelHandler)new TrafficHandler(TunnelServerDaemon.access$getOnTrafficListener$p(this.this$0))).addLast("heartbeat", (ChannelHandler)new HeartbeatHandler(false, 0L, 0L, 0L, null, 31, null)).addLast("decoder", (ChannelHandler)new ProtoMessageDecoder()).addLast("encoder", (ChannelHandler)new ProtoMessageEncoder()).addLast("handler", (ChannelHandler)TunnelServerDaemon.access$newTunnelServerChannelHandler(this.this$0, this.$args.getTunnelRequestInterceptor()));
            }
            {
                this.this$0 = this$0;
                this.$args = $captured_local_variable$1;
            }
        });
        if (args.getBindAddr() == null) {
            serverBootstrap.bind(args.getBindPort()).get();
        } else {
            serverBootstrap.bind(args.getBindAddr(), args.getBindPort()).get();
        }
        Logger logger = this.getLogger();
        String string = args.getBindAddr();
        if (string == null) {
            string = "::";
        }
        logger.info("Serving tunnel by ssl on {} port {}", (Object)string, (Object)args.getBindPort());
    }

    private final TcpTunnel getTcpTunnel(TcpRegistry registry) {
        return new TcpTunnel(this.bossGroup, this.workerGroup, registry);
    }

    private final HttpTunnel getHttpTunnel(HttpRegistry registry, HttpTunnelArgs args) {
        HttpRegistry httpRegistry = registry;
        HttpPlugin httpPlugin = args.getHttpPlugin();
        HttpTunnelRequestInterceptor httpTunnelRequestInterceptor = args.getHttpTunnelRequestInterceptor();
        SslContext sslContext = null;
        int n = args.getBindPort();
        String string = args.getBindAddr();
        return new HttpTunnel(this.bossGroup, this.workerGroup, httpRegistry, string, n, sslContext, httpPlugin, httpTunnelRequestInterceptor);
    }

    private final HttpTunnel getHttpsTunnel(HttpRegistry registry, HttpsTunnelArgs args) {
        HttpRegistry httpRegistry = registry;
        HttpPlugin httpPlugin = args.getHttpPlugin();
        HttpTunnelRequestInterceptor httpTunnelRequestInterceptor = args.getHttpTunnelRequestInterceptor();
        SslContext sslContext = args.getSslContext();
        int n = args.getBindPort();
        String string = args.getBindAddr();
        return new HttpTunnel(this.bossGroup, this.workerGroup, httpRegistry, string, n, sslContext, httpPlugin, httpTunnelRequestInterceptor);
    }

    private final TunnelServerDaemonChannelHandler newTunnelServerChannelHandler(TunnelRequestInterceptor tunnelRequestInterceptor) {
        return new TunnelServerDaemonChannelHandler(tunnelRequestInterceptor, this.tunnelIds, this.tcpTunnel, this.httpTunnel, this.httpsTunnel, new TunnelServerDaemonChannelHandler.Callback(this){
            final /* synthetic */ TunnelServerDaemon this$0;

            public void onChannelConnected(@NotNull ChannelHandlerContext ctx, @Nullable TcpFdDefaultImpl tcpFd) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    if (tcpFd == null) break block1;
                    OnTcpTunnelStateListener onTcpTunnelStateListener = TunnelServerDaemon.access$getOnTcpTunnelStateListener$p(this.this$0);
                    if (onTcpTunnelStateListener != null) {
                        onTcpTunnelStateListener.onTcpTunnelConnected(tcpFd);
                    }
                }
            }

            public void onChannelInactive(@NotNull ChannelHandlerContext ctx, @Nullable TcpFdDefaultImpl tcpFd) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    if (tcpFd == null) break block1;
                    OnTcpTunnelStateListener onTcpTunnelStateListener = TunnelServerDaemon.access$getOnTcpTunnelStateListener$p(this.this$0);
                    if (onTcpTunnelStateListener != null) {
                        onTcpTunnelStateListener.onTcpTunnelDisconnect(tcpFd);
                    }
                }
            }

            public void onChannelConnected(@NotNull ChannelHandlerContext ctx, @Nullable HttpFdDefaultImpl httpFd) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    if (httpFd == null) break block1;
                    OnHttpTunnelStateListener onHttpTunnelStateListener = TunnelServerDaemon.access$getOnHttpTunnelStateListener$p(this.this$0);
                    if (onHttpTunnelStateListener != null) {
                        onHttpTunnelStateListener.onHttpTunnelConnected(httpFd);
                    }
                }
            }

            public void onChannelInactive(@NotNull ChannelHandlerContext ctx, @Nullable HttpFdDefaultImpl httpFd) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    if (httpFd == null) break block1;
                    OnHttpTunnelStateListener onHttpTunnelStateListener = TunnelServerDaemon.access$getOnHttpTunnelStateListener$p(this.this$0);
                    if (onHttpTunnelStateListener != null) {
                        onHttpTunnelStateListener.onHttpTunnelDisconnect(httpFd);
                    }
                }
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    public TunnelServerDaemon(int bossThreads, int workerThreads, @Nullable TunnelDaemonArgs tunnelDaemonArgs, @Nullable SslTunnelDaemonArgs sslTunnelDaemonArgs, @Nullable HttpTunnelArgs httpTunnelArgs, @Nullable HttpsTunnelArgs httpsTunnelArgs, @Nullable OnTcpTunnelStateListener onTcpTunnelStateListener, @Nullable OnHttpTunnelStateListener onHttpTunnelStateListener, @Nullable OnTrafficListener onTrafficListener, boolean isHttpAndHttpsShareRegistry) {
        HttpTunnel httpTunnel;
        HttpTunnel httpTunnel2;
        HttpTunnel httpTunnel3;
        Object it;
        TunnelServerDaemon tunnelServerDaemon;
        boolean bl;
        boolean bl2;
        Object object;
        this.tunnelDaemonArgs = tunnelDaemonArgs;
        this.sslTunnelDaemonArgs = sslTunnelDaemonArgs;
        this.onTcpTunnelStateListener = onTcpTunnelStateListener;
        this.onHttpTunnelStateListener = onHttpTunnelStateListener;
        this.onTrafficListener = onTrafficListener;
        TunnelServerDaemon $this$loggerDelegate$iv = this;
        boolean $i$f$loggerDelegate = false;
        this.logger$delegate = LazyKt.lazy((Function0)$special$$inlined$loggerDelegate$1.INSTANCE);
        this.lock = new ReentrantLock();
        this.tunnelIds = new IncIds();
        this.bossGroup = bossThreads >= 0 ? new NioEventLoopGroup(bossThreads) : new NioEventLoopGroup();
        this.workerGroup = workerThreads >= 0 ? new NioEventLoopGroup(workerThreads) : new NioEventLoopGroup();
        this.tcpRegistry = new TcpRegistry();
        this.httpRegistry = new HttpRegistry();
        this.httpsRegistry = isHttpAndHttpsShareRegistry ? this.httpRegistry : new HttpRegistry();
        this.tcpTunnel = this.getTcpTunnel(this.tcpRegistry);
        TunnelServerDaemon tunnelServerDaemon2 = this;
        HttpTunnelArgs httpTunnelArgs2 = httpTunnelArgs;
        if (httpTunnelArgs2 != null) {
            object = httpTunnelArgs2;
            bl2 = false;
            bl = false;
            HttpTunnelArgs httpTunnelArgs3 = object;
            tunnelServerDaemon = tunnelServerDaemon2;
            boolean bl3 = false;
            httpTunnel3 = this.getHttpTunnel(this.httpRegistry, (HttpTunnelArgs)it);
            tunnelServerDaemon2 = tunnelServerDaemon;
            httpTunnel2 = httpTunnel3;
        } else {
            httpTunnel2 = null;
        }
        tunnelServerDaemon2.httpTunnel = httpTunnel2;
        TunnelServerDaemon tunnelServerDaemon3 = this;
        HttpsTunnelArgs httpsTunnelArgs2 = httpsTunnelArgs;
        if (httpsTunnelArgs2 != null) {
            object = httpsTunnelArgs2;
            bl2 = false;
            bl = false;
            it = object;
            tunnelServerDaemon = tunnelServerDaemon3;
            boolean bl4 = false;
            httpTunnel3 = this.getHttpsTunnel(this.httpsRegistry, (HttpsTunnelArgs)it);
            tunnelServerDaemon3 = tunnelServerDaemon;
            httpTunnel = httpTunnel3;
        } else {
            httpTunnel = null;
        }
        tunnelServerDaemon3.httpsTunnel = httpTunnel;
    }

    public /* synthetic */ TunnelServerDaemon(int n, int n2, TunnelDaemonArgs tunnelDaemonArgs, SslTunnelDaemonArgs sslTunnelDaemonArgs, HttpTunnelArgs httpTunnelArgs, HttpsTunnelArgs httpsTunnelArgs, OnTcpTunnelStateListener onTcpTunnelStateListener, OnHttpTunnelStateListener onHttpTunnelStateListener, OnTrafficListener onTrafficListener, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x200) != 0) {
            bl = false;
        }
        this(n, n2, tunnelDaemonArgs, sslTunnelDaemonArgs, httpTunnelArgs, httpsTunnelArgs, onTcpTunnelStateListener, onHttpTunnelStateListener, onTrafficListener, bl);
    }

    public static final /* synthetic */ OnTrafficListener access$getOnTrafficListener$p(TunnelServerDaemon $this) {
        return $this.onTrafficListener;
    }

    public static final /* synthetic */ TunnelServerDaemonChannelHandler access$newTunnelServerChannelHandler(TunnelServerDaemon $this, TunnelRequestInterceptor tunnelRequestInterceptor) {
        return $this.newTunnelServerChannelHandler(tunnelRequestInterceptor);
    }

    public static final /* synthetic */ OnTcpTunnelStateListener access$getOnTcpTunnelStateListener$p(TunnelServerDaemon $this) {
        return $this.onTcpTunnelStateListener;
    }

    public static final /* synthetic */ OnHttpTunnelStateListener access$getOnHttpTunnelStateListener$p(TunnelServerDaemon $this) {
        return $this.onHttpTunnelStateListener;
    }
}

