/*
 * Decompiled with CFR 0.152.
 */
package lighttunnel.internal.server;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.GenericFutureListener;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import lighttunnel.ProtoException;
import lighttunnel.TunnelRequest;
import lighttunnel.TunnelRequestInterceptor;
import lighttunnel.internal.base.proto.ProtoMessage;
import lighttunnel.internal.base.util.IncIds;
import lighttunnel.internal.server.TunnelServerDaemonChannelHandler$$special$;
import lighttunnel.internal.server.TunnelServerDaemonChannelHandler$WhenMappings;
import lighttunnel.internal.server.http.HttpFdDefaultImpl;
import lighttunnel.internal.server.http.HttpTunnel;
import lighttunnel.internal.server.tcp.TcpFdDefaultImpl;
import lighttunnel.internal.server.tcp.TcpTunnel;
import lighttunnel.internal.server.util.-ConstsKt;
import lighttunnel.internal.server.util.SessionChannels;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B5\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u001c\u0010\u0017\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u0002H\u0014J\u0018\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0002H\u0002J\u0018\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0002H\u0002J\u0018\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0002H\u0002J\u0018\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0002H\u0002J\u0018\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0002H\u0002J\u0018\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0002H\u0002J\u001c\u0010\u001f\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010 \u001a\u0004\u0018\u00010!H\u0016J\u001a\u0010\"\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010#\u001a\u0004\u0018\u00010$H&J\u001a\u0010\"\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010%\u001a\u0004\u0018\u00010&H&J\u001a\u0010'\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010#\u001a\u0004\u0018\u00010$H&J\u001a\u0010'\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010%\u001a\u0004\u0018\u00010&H&J\u001c\u0010(\u001a\u00020\u0014*\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010)\u001a\u00020*H\u0002J\u001c\u0010+\u001a\u00020\u0014*\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010)\u001a\u00020*H\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Llighttunnel/internal/server/TunnelServerDaemonChannelHandler;", "Lio/netty/channel/SimpleChannelInboundHandler;", "Llighttunnel/internal/base/proto/ProtoMessage;", "tunnelRequestInterceptor", "Llighttunnel/TunnelRequestInterceptor;", "tunnelIds", "Llighttunnel/internal/base/util/IncIds;", "tcpTunnel", "Llighttunnel/internal/server/tcp/TcpTunnel;", "httpTunnel", "Llighttunnel/internal/server/http/HttpTunnel;", "httpsTunnel", "(Llighttunnel/TunnelRequestInterceptor;Llighttunnel/internal/base/util/IncIds;Llighttunnel/internal/server/tcp/TcpTunnel;Llighttunnel/internal/server/http/HttpTunnel;Llighttunnel/internal/server/http/HttpTunnel;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "logger$delegate", "Lkotlin/Lazy;", "channelInactive", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "channelRead0", "msg", "doHandleForceOffReplyMessage", "doHandleLocalConnectedMessage", "doHandleLocalDisconnectMessage", "doHandlePingMessage", "doHandleRequestMessage", "doHandleTransferMessage", "exceptionCaught", "cause", "", "onChannelConnected", "httpFd", "Llighttunnel/internal/server/http/HttpFdDefaultImpl;", "tcpFd", "Llighttunnel/internal/server/tcp/TcpFdDefaultImpl;", "onChannelInactive", "handleHttpRequestMessage", "tunnelRequest", "Llighttunnel/TunnelRequest;", "handleTcpRequestMessage", "server"})
public abstract class TunnelServerDaemonChannelHandler
extends SimpleChannelInboundHandler<ProtoMessage> {
    private final Lazy logger$delegate;
    private final TunnelRequestInterceptor tunnelRequestInterceptor;
    private final IncIds tunnelIds;
    private final TcpTunnel tcpTunnel;
    private final HttpTunnel httpTunnel;
    private final HttpTunnel httpsTunnel;

    private final Logger getLogger() {
        Lazy lazy = this.logger$delegate;
        TunnelServerDaemonChannelHandler tunnelServerDaemonChannelHandler = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    public void channelInactive(@Nullable ChannelHandlerContext ctx) throws Exception {
        this.getLogger().trace("channelInactive: {}", (Object)ctx);
        if (ctx == null) {
            super.channelInactive(ctx);
            return;
        }
        SessionChannels sessionChannels = (SessionChannels)ctx.channel().attr(-ConstsKt.AK_SESSION_CHANNELS()).get();
        if (sessionChannels != null) {
            SessionChannels sessionChannels2 = sessionChannels;
            boolean bl = false;
            boolean bl2 = false;
            SessionChannels sc = sessionChannels2;
            boolean bl3 = false;
            switch (TunnelServerDaemonChannelHandler$WhenMappings.$EnumSwitchMapping$0[sc.getTunnelRequest().getTunnelType().ordinal()]) {
                case 1: {
                    TcpTunnel tcpTunnel = this.tcpTunnel;
                    this.onChannelInactive(ctx, tcpTunnel != null ? tcpTunnel.stopTunnel(sc.getTunnelRequest().getRemotePort()) : null);
                    break;
                }
                case 2: {
                    HttpTunnel httpTunnel = this.httpTunnel;
                    this.onChannelInactive(ctx, httpTunnel != null ? httpTunnel.stopTunnel(sc.getTunnelRequest().getHost()) : null);
                    break;
                }
                case 3: {
                    HttpTunnel httpTunnel = this.httpsTunnel;
                    this.onChannelInactive(ctx, httpTunnel != null ? httpTunnel.stopTunnel(sc.getTunnelRequest().getHost()) : null);
                    break;
                }
            }
        }
        ctx.channel().attr(-ConstsKt.AK_SESSION_CHANNELS()).set(null);
        super.channelInactive(ctx);
    }

    public void exceptionCaught(@Nullable ChannelHandlerContext ctx, @Nullable Throwable cause) throws Exception {
        this.getLogger().trace("exceptionCaught: {}", (Object)ctx, (Object)cause);
        if (ctx == null) {
            return;
        }
        ctx.channel().writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    protected void channelRead0(@Nullable ChannelHandlerContext ctx, @Nullable ProtoMessage msg) throws Exception {
        this.getLogger().trace("channelRead0: {}", (Object)ctx);
        if (ctx == null) {
            return;
        }
        if (msg == null) {
            return;
        }
        switch (TunnelServerDaemonChannelHandler$WhenMappings.$EnumSwitchMapping$1[msg.getType().ordinal()]) {
            case 1: {
                this.doHandlePingMessage(ctx, msg);
                break;
            }
            case 2: {
                this.doHandleRequestMessage(ctx, msg);
                break;
            }
            case 3: {
                this.doHandleTransferMessage(ctx, msg);
                break;
            }
            case 4: {
                this.doHandleLocalConnectedMessage(ctx, msg);
                break;
            }
            case 5: {
                this.doHandleLocalDisconnectMessage(ctx, msg);
                break;
            }
            case 6: {
                this.doHandleForceOffReplyMessage(ctx, msg);
                break;
            }
        }
    }

    private final void doHandlePingMessage(ChannelHandlerContext ctx, ProtoMessage msg) throws Exception {
        this.getLogger().trace("doHandlePingMessage# {}, {}", (Object)ctx, (Object)msg);
        ctx.writeAndFlush((Object)ProtoMessage.Companion.PONG());
    }

    private final void doHandleRequestMessage(ChannelHandlerContext ctx, ProtoMessage msg) throws Exception {
        this.getLogger().trace("doHandleRequestMessage# {}, {}", (Object)ctx, (Object)msg);
        try {
            TunnelRequest originalTunnelRequest = TunnelRequest.Factory.fromBytes(msg.getData());
            TunnelRequestInterceptor tunnelRequestInterceptor = this.tunnelRequestInterceptor;
            if (tunnelRequestInterceptor == null || (tunnelRequestInterceptor = tunnelRequestInterceptor.intercept(originalTunnelRequest)) == null) {
                tunnelRequestInterceptor = originalTunnelRequest;
            }
            TunnelRequestInterceptor finalTunnelRequest = tunnelRequestInterceptor;
            this.getLogger().trace("TunnelRequest=> original: {}, final: {}", (Object)originalTunnelRequest, (Object)finalTunnelRequest);
            switch (TunnelServerDaemonChannelHandler$WhenMappings.$EnumSwitchMapping$2[finalTunnelRequest.getTunnelType().ordinal()]) {
                case 1: {
                    TcpTunnel tcpTunnel = this.tcpTunnel;
                    if (tcpTunnel == null) {
                        throw (Throwable)new ProtoException("TCP\u534f\u8bae\u96a7\u9053\u672a\u5f00\u542f", null, 2, null);
                    }
                    TcpTunnel tcpTunnel2 = tcpTunnel;
                    this.handleTcpRequestMessage(tcpTunnel2, ctx, (TunnelRequest)finalTunnelRequest);
                    break;
                }
                case 2: {
                    HttpTunnel httpTunnel = this.httpTunnel;
                    if (httpTunnel == null) {
                        throw (Throwable)new ProtoException("HTTP\u534f\u8bae\u96a7\u9053\u672a\u5f00\u542f", null, 2, null);
                    }
                    HttpTunnel httpTunnel2 = httpTunnel;
                    this.handleHttpRequestMessage(httpTunnel2, ctx, (TunnelRequest)finalTunnelRequest);
                    break;
                }
                case 3: {
                    HttpTunnel httpTunnel = this.httpsTunnel;
                    if (httpTunnel == null) {
                        throw (Throwable)new ProtoException("HTTPS\u534f\u8bae\u96a7\u9053\u672a\u5f00\u542f", null, 2, null);
                    }
                    HttpTunnel httpsTunnel = httpTunnel;
                    this.handleHttpRequestMessage(httpsTunnel, ctx, (TunnelRequest)finalTunnelRequest);
                    break;
                }
                default: {
                    throw (Throwable)new ProtoException("\u4e0d\u652f\u6301\u7684\u96a7\u9053\u7c7b\u578b", null, 2, null);
                }
            }
        }
        catch (Exception e) {
            ctx.channel().writeAndFlush((Object)ProtoMessage.Companion.RESPONSE_ERR((Throwable)e)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private final void doHandleTransferMessage(ChannelHandlerContext ctx, ProtoMessage msg) throws Exception {
        block1: {
            Channel sessionChannel;
            this.getLogger().trace("doHandleTransferMessage# {}, {}", (Object)ctx, (Object)msg);
            SessionChannels sessionChannels = (SessionChannels)ctx.channel().attr(-ConstsKt.AK_SESSION_CHANNELS()).get();
            if (sessionChannels == null) {
                return;
            }
            SessionChannels sessionChannels2 = sessionChannels;
            Channel channel = sessionChannel = sessionChannels2.getChannel(msg.getSessionId());
            if (channel == null) break block1;
            channel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])msg.getData()));
        }
    }

    private final void doHandleLocalConnectedMessage(ChannelHandlerContext ctx, ProtoMessage msg) throws Exception {
        this.getLogger().trace("doHandleLocalConnectedMessage# {}, {}", (Object)ctx, (Object)msg);
    }

    private final void doHandleLocalDisconnectMessage(ChannelHandlerContext ctx, ProtoMessage msg) throws Exception {
        block1: {
            this.getLogger().trace("doHandleLocalDisconnectMessage# {}, {}", (Object)ctx, (Object)msg);
            SessionChannels sessionChannels = (SessionChannels)ctx.channel().attr(-ConstsKt.AK_SESSION_CHANNELS()).get();
            if (sessionChannels == null) {
                return;
            }
            SessionChannels sessionChannels2 = sessionChannels;
            Channel sessionChannel = sessionChannels2.removeChannel(msg.getSessionId());
            Channel channel = sessionChannel;
            if (channel == null || (channel = channel.writeAndFlush((Object)Unpooled.EMPTY_BUFFER)) == null) break block1;
            channel.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private final void doHandleForceOffReplyMessage(ChannelHandlerContext ctx, ProtoMessage msg) throws Exception {
        block0: {
            this.getLogger().trace("doHandleForceOffReplyMessage# {}, {}", (Object)ctx, (Object)msg);
            Channel channel = ctx.channel();
            if (channel == null) break block0;
            channel.close();
        }
    }

    private final void handleTcpRequestMessage(TcpTunnel $this$handleTcpRequestMessage, ChannelHandlerContext ctx, TunnelRequest tunnelRequest) throws Exception {
        $this$handleTcpRequestMessage.requireNotRegistered(tunnelRequest.getRemotePort());
        long tunnelId = this.tunnelIds.getNextId();
        Channel channel = ctx.channel();
        Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"ctx.channel()");
        SessionChannels sessionChannels = new SessionChannels(tunnelId, tunnelRequest, channel);
        ctx.channel().attr(-ConstsKt.AK_SESSION_CHANNELS()).set((Object)sessionChannels);
        this.onChannelConnected(ctx, $this$handleTcpRequestMessage.startTunnel(null, tunnelRequest.getRemotePort(), sessionChannels));
        ctx.channel().writeAndFlush((Object)ProtoMessage.Companion.RESPONSE_OK(tunnelId, tunnelRequest));
    }

    private final void handleHttpRequestMessage(HttpTunnel $this$handleHttpRequestMessage, ChannelHandlerContext ctx, TunnelRequest tunnelRequest) throws Exception {
        $this$handleHttpRequestMessage.requireNotRegistered(tunnelRequest.getHost());
        long tunnelId = this.tunnelIds.getNextId();
        Channel channel = ctx.channel();
        Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"ctx.channel()");
        SessionChannels sessionChannels = new SessionChannels(tunnelId, tunnelRequest, channel);
        ctx.channel().attr(-ConstsKt.AK_SESSION_CHANNELS()).set((Object)sessionChannels);
        this.onChannelConnected(ctx, $this$handleHttpRequestMessage.startTunnel(tunnelRequest.getHost(), sessionChannels));
        ctx.channel().writeAndFlush((Object)ProtoMessage.Companion.RESPONSE_OK(tunnelId, tunnelRequest));
    }

    public abstract void onChannelInactive(@NotNull ChannelHandlerContext var1, @Nullable TcpFdDefaultImpl var2);

    public abstract void onChannelInactive(@NotNull ChannelHandlerContext var1, @Nullable HttpFdDefaultImpl var2);

    public abstract void onChannelConnected(@NotNull ChannelHandlerContext var1, @Nullable TcpFdDefaultImpl var2);

    public abstract void onChannelConnected(@NotNull ChannelHandlerContext var1, @Nullable HttpFdDefaultImpl var2);

    public TunnelServerDaemonChannelHandler(@Nullable TunnelRequestInterceptor tunnelRequestInterceptor, @NotNull IncIds tunnelIds, @Nullable TcpTunnel tcpTunnel, @Nullable HttpTunnel httpTunnel, @Nullable HttpTunnel httpsTunnel) {
        Intrinsics.checkNotNullParameter((Object)tunnelIds, (String)"tunnelIds");
        this.tunnelRequestInterceptor = tunnelRequestInterceptor;
        this.tunnelIds = tunnelIds;
        this.tcpTunnel = tcpTunnel;
        this.httpTunnel = httpTunnel;
        this.httpsTunnel = httpsTunnel;
        TunnelServerDaemonChannelHandler $this$loggerDelegate$iv = this;
        boolean $i$f$loggerDelegate = false;
        this.logger$delegate = LazyKt.lazy((Function0)$special$$inlined$loggerDelegate$1.INSTANCE);
    }
}

