/*
 * Decompiled with CFR 0.152.
 */
package lighttunnel.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.ssl.SslContext;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import lighttunnel.base.proto.HeartbeatHandler;
import lighttunnel.base.proto.ProtoMessageDecoder;
import lighttunnel.base.proto.ProtoMessageEncoder;
import lighttunnel.base.util.IncIds;
import lighttunnel.openapi.TunnelRequestInterceptor;
import lighttunnel.openapi.args.HttpTunnelArgs;
import lighttunnel.openapi.args.HttpsTunnelArgs;
import lighttunnel.openapi.args.SslTunnelDaemonArgs;
import lighttunnel.openapi.args.TunnelDaemonArgs;
import lighttunnel.openapi.http.HttpPlugin;
import lighttunnel.openapi.http.HttpTunnelRequestInterceptor;
import lighttunnel.openapi.listener.OnHttpTunnelStateListener;
import lighttunnel.openapi.listener.OnTcpTunnelStateListener;
import lighttunnel.openapi.listener.OnTrafficListener;
import lighttunnel.server.TunnelServerDaemon$$special$;
import lighttunnel.server.TunnelServerDaemonChannelHandler;
import lighttunnel.server.http.HttpFdDefaultImpl;
import lighttunnel.server.http.HttpRegistry;
import lighttunnel.server.http.HttpTunnel;
import lighttunnel.server.tcp.TcpFdDefaultImpl;
import lighttunnel.server.tcp.TcpRegistry;
import lighttunnel.server.tcp.TcpTunnel;
import lighttunnel.server.traffic.TrafficHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001:\u0001:BY\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0002\u0010\u0013J\u0006\u00100\u001a\u000201J\u0018\u00102\u001a\u00020\u001b2\u0006\u00103\u001a\u00020\u00172\u0006\u00104\u001a\u00020\nH\u0002J\u0018\u00105\u001a\u00020\u001b2\u0006\u00103\u001a\u00020\u00172\u0006\u00104\u001a\u00020\fH\u0002J\u0010\u00106\u001a\u00020,2\u0006\u00103\u001a\u00020(H\u0002J\u0006\u00107\u001a\u000201J\u0010\u00108\u001a\u0002012\u0006\u00104\u001a\u00020\bH\u0002J\u0010\u00109\u001a\u0002012\u0006\u00104\u001a\u00020\u0006H\u0002R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0019R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010!\u001a\u00020\"8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b#\u0010$R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010'\u001a\u00020(\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Llighttunnel/server/TunnelServerDaemon;", "", "bossThreads", "", "workerThreads", "tunnelDaemonArgs", "Llighttunnel/openapi/args/TunnelDaemonArgs;", "sslTunnelDaemonArgs", "Llighttunnel/openapi/args/SslTunnelDaemonArgs;", "httpTunnelArgs", "Llighttunnel/openapi/args/HttpTunnelArgs;", "httpsTunnelArgs", "Llighttunnel/openapi/args/HttpsTunnelArgs;", "onTcpTunnelStateListener", "Llighttunnel/openapi/listener/OnTcpTunnelStateListener;", "onHttpTunnelStateListener", "Llighttunnel/openapi/listener/OnHttpTunnelStateListener;", "onTrafficListener", "Llighttunnel/openapi/listener/OnTrafficListener;", "(IILlighttunnel/openapi/args/TunnelDaemonArgs;Llighttunnel/openapi/args/SslTunnelDaemonArgs;Llighttunnel/openapi/args/HttpTunnelArgs;Llighttunnel/openapi/args/HttpsTunnelArgs;Llighttunnel/openapi/listener/OnTcpTunnelStateListener;Llighttunnel/openapi/listener/OnHttpTunnelStateListener;Llighttunnel/openapi/listener/OnTrafficListener;)V", "bossGroup", "Lio/netty/channel/nio/NioEventLoopGroup;", "httpRegistry", "Llighttunnel/server/http/HttpRegistry;", "getHttpRegistry", "()Llighttunnel/server/http/HttpRegistry;", "httpTunnel", "Llighttunnel/server/http/HttpTunnel;", "httpsRegistry", "getHttpsRegistry", "httpsTunnel", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "logger$delegate", "Lkotlin/Lazy;", "tcpRegistry", "Llighttunnel/server/tcp/TcpRegistry;", "getTcpRegistry", "()Llighttunnel/server/tcp/TcpRegistry;", "tcpTunnel", "Llighttunnel/server/tcp/TcpTunnel;", "tunnelIds", "Llighttunnel/base/util/IncIds;", "workerGroup", "depose", "", "getHttpTunnel", "registry", "args", "getHttpsTunnel", "getTcpTunnel", "start", "startSslTunnelDaemon", "startTunnelDaemon", "InnerTunnelServerChannelHandler", "server"})
public final class TunnelServerDaemon {
    private final Lazy logger$delegate;
    private final ReentrantLock lock;
    private final IncIds tunnelIds;
    private final NioEventLoopGroup bossGroup;
    private final NioEventLoopGroup workerGroup;
    @NotNull
    private final TcpRegistry tcpRegistry;
    @NotNull
    private final HttpRegistry httpRegistry;
    @NotNull
    private final HttpRegistry httpsRegistry;
    private final TcpTunnel tcpTunnel;
    private final HttpTunnel httpTunnel;
    private final HttpTunnel httpsTunnel;
    private final TunnelDaemonArgs tunnelDaemonArgs;
    private final SslTunnelDaemonArgs sslTunnelDaemonArgs;
    private final OnTcpTunnelStateListener onTcpTunnelStateListener;
    private final OnHttpTunnelStateListener onHttpTunnelStateListener;
    private final OnTrafficListener onTrafficListener;

    private final Logger getLogger() {
        Lazy lazy = this.logger$delegate;
        TunnelServerDaemon tunnelServerDaemon = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    @NotNull
    public final TcpRegistry getTcpRegistry() {
        return this.tcpRegistry;
    }

    @NotNull
    public final HttpRegistry getHttpRegistry() {
        return this.httpRegistry;
    }

    @NotNull
    public final HttpRegistry getHttpsRegistry() {
        return this.httpsRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() throws Exception {
        Lock lock = this.lock;
        boolean bl = false;
        lock.lock();
        try {
            boolean bl2 = false;
            HttpTunnel httpTunnel = this.httpTunnel;
            if (httpTunnel != null) {
                httpTunnel.start();
            }
            HttpTunnel httpTunnel2 = this.httpsTunnel;
            if (httpTunnel2 != null) {
                httpTunnel2.start();
            }
            this.startTunnelDaemon(this.tunnelDaemonArgs);
            SslTunnelDaemonArgs sslTunnelDaemonArgs = this.sslTunnelDaemonArgs;
            if (sslTunnelDaemonArgs != null) {
                SslTunnelDaemonArgs sslTunnelDaemonArgs2 = sslTunnelDaemonArgs;
                boolean bl3 = false;
                boolean bl4 = false;
                SslTunnelDaemonArgs it = sslTunnelDaemonArgs2;
                boolean bl5 = false;
                this.startSslTunnelDaemon(it);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void depose() {
        Lock lock = this.lock;
        boolean bl = false;
        lock.lock();
        try {
            boolean bl2 = false;
            this.tcpRegistry.depose();
            this.httpRegistry.depose();
            this.httpsRegistry.depose();
            this.bossGroup.shutdownGracefully();
            this.workerGroup.shutdownGracefully();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private final void startTunnelDaemon(TunnelDaemonArgs args) {
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        ((ServerBootstrap)serverBootstrap.group((EventLoopGroup)this.bossGroup, (EventLoopGroup)this.workerGroup).channel(NioServerSocketChannel.class)).childOption(ChannelOption.AUTO_READ, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(this, args){
            final /* synthetic */ TunnelServerDaemon this$0;
            final /* synthetic */ TunnelDaemonArgs $args;

            protected void initChannel(@Nullable SocketChannel ch) {
                if (ch == null) {
                    return;
                }
                ch.pipeline().addLast("traffic", (ChannelHandler)new TrafficHandler(TunnelServerDaemon.access$getOnTrafficListener$p(this.this$0))).addLast("heartbeat", (ChannelHandler)new HeartbeatHandler(false, 0L, 0L, 0L, null, 31, null)).addLast("decoder", (ChannelHandler)new ProtoMessageDecoder()).addLast("encoder", (ChannelHandler)new ProtoMessageEncoder()).addLast("handler", (ChannelHandler)this.this$0.new InnerTunnelServerChannelHandler(this.$args.getTunnelRequestInterceptor()));
            }
            {
                this.this$0 = $outer;
                this.$args = $captured_local_variable$1;
            }
        });
        if (args.getBindAddr() == null) {
            serverBootstrap.bind(args.getBindPort()).get();
        } else {
            serverBootstrap.bind(args.getBindAddr(), args.getBindPort()).get();
        }
        Logger logger = this.getLogger();
        String string = args.getBindAddr();
        if (string == null) {
            string = "::";
        }
        logger.info("Serving tunnel on {} port {}", (Object)string, (Object)args.getBindPort());
    }

    private final void startSslTunnelDaemon(SslTunnelDaemonArgs args) {
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        ((ServerBootstrap)serverBootstrap.group((EventLoopGroup)this.bossGroup, (EventLoopGroup)this.workerGroup).channel(NioServerSocketChannel.class)).childOption(ChannelOption.AUTO_READ, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(this, args){
            final /* synthetic */ TunnelServerDaemon this$0;
            final /* synthetic */ SslTunnelDaemonArgs $args;

            protected void initChannel(@Nullable SocketChannel ch) {
                if (ch == null) {
                    return;
                }
                ch.pipeline().addFirst("ssl", (ChannelHandler)this.$args.getSslContext().newHandler(ch.alloc())).addLast("traffic", (ChannelHandler)new TrafficHandler(TunnelServerDaemon.access$getOnTrafficListener$p(this.this$0))).addLast("heartbeat", (ChannelHandler)new HeartbeatHandler(false, 0L, 0L, 0L, null, 31, null)).addLast("decoder", (ChannelHandler)new ProtoMessageDecoder()).addLast("encoder", (ChannelHandler)new ProtoMessageEncoder()).addLast("handler", (ChannelHandler)this.this$0.new InnerTunnelServerChannelHandler(this.$args.getTunnelRequestInterceptor()));
            }
            {
                this.this$0 = $outer;
                this.$args = $captured_local_variable$1;
            }
        });
        if (args.getBindAddr() == null) {
            serverBootstrap.bind(args.getBindPort()).get();
        } else {
            serverBootstrap.bind(args.getBindAddr(), args.getBindPort()).get();
        }
        Logger logger = this.getLogger();
        String string = args.getBindAddr();
        if (string == null) {
            string = "::";
        }
        logger.info("Serving tunnel by ssl on {} port {}", (Object)string, (Object)args.getBindPort());
    }

    private final TcpTunnel getTcpTunnel(TcpRegistry registry) {
        return new TcpTunnel(this.bossGroup, this.workerGroup, registry);
    }

    private final HttpTunnel getHttpTunnel(HttpRegistry registry, HttpTunnelArgs args) {
        HttpRegistry httpRegistry = registry;
        HttpPlugin httpPlugin = args.getHttpPlugin();
        int n = 0;
        HttpTunnelRequestInterceptor httpTunnelRequestInterceptor = args.getHttpTunnelRequestInterceptor();
        SslContext sslContext = null;
        int n2 = args.getBindPort();
        String string = args.getBindAddr();
        return new HttpTunnel(this.bossGroup, this.workerGroup, httpRegistry, string, n2, sslContext, n, httpPlugin, httpTunnelRequestInterceptor, 64, null);
    }

    private final HttpTunnel getHttpsTunnel(HttpRegistry registry, HttpsTunnelArgs args) {
        HttpRegistry httpRegistry = registry;
        HttpPlugin httpPlugin = args.getHttpPlugin();
        int n = 0;
        HttpTunnelRequestInterceptor httpTunnelRequestInterceptor = args.getHttpTunnelRequestInterceptor();
        SslContext sslContext = args.getSslContext();
        int n2 = args.getBindPort();
        String string = args.getBindAddr();
        return new HttpTunnel(this.bossGroup, this.workerGroup, httpRegistry, string, n2, sslContext, n, httpPlugin, httpTunnelRequestInterceptor, 64, null);
    }

    public TunnelServerDaemon(int bossThreads, int workerThreads, @NotNull TunnelDaemonArgs tunnelDaemonArgs, @Nullable SslTunnelDaemonArgs sslTunnelDaemonArgs, @Nullable HttpTunnelArgs httpTunnelArgs, @Nullable HttpsTunnelArgs httpsTunnelArgs, @Nullable OnTcpTunnelStateListener onTcpTunnelStateListener, @Nullable OnHttpTunnelStateListener onHttpTunnelStateListener, @Nullable OnTrafficListener onTrafficListener) {
        Object object;
        Object object2;
        Object it;
        boolean bl;
        boolean bl2;
        Object object3;
        Intrinsics.checkParameterIsNotNull((Object)tunnelDaemonArgs, (String)"tunnelDaemonArgs");
        this.tunnelDaemonArgs = tunnelDaemonArgs;
        this.sslTunnelDaemonArgs = sslTunnelDaemonArgs;
        this.onTcpTunnelStateListener = onTcpTunnelStateListener;
        this.onHttpTunnelStateListener = onHttpTunnelStateListener;
        this.onTrafficListener = onTrafficListener;
        Object object4 = this;
        TunnelServerDaemon tunnelServerDaemon = this;
        boolean $i$f$loggerDelegate = false;
        tunnelServerDaemon.logger$delegate = object3 = LazyKt.lazy((Function0)$special$$inlined$loggerDelegate$1.INSTANCE);
        this.lock = new ReentrantLock();
        this.tunnelIds = new IncIds();
        this.bossGroup = bossThreads >= 0 ? new NioEventLoopGroup(bossThreads) : new NioEventLoopGroup();
        this.workerGroup = workerThreads >= 0 ? new NioEventLoopGroup(workerThreads) : new NioEventLoopGroup();
        this.tcpRegistry = new TcpRegistry();
        this.httpRegistry = new HttpRegistry();
        this.httpsRegistry = new HttpRegistry();
        this.tcpTunnel = this.getTcpTunnel(this.tcpRegistry);
        TunnelServerDaemon tunnelServerDaemon2 = this;
        HttpTunnelArgs httpTunnelArgs2 = httpTunnelArgs;
        if (httpTunnelArgs2 != null) {
            object4 = httpTunnelArgs2;
            tunnelServerDaemon = tunnelServerDaemon2;
            bl2 = false;
            bl = false;
            it = object4;
            boolean bl3 = false;
            object3 = this.getHttpTunnel(this.httpRegistry, (HttpTunnelArgs)it);
            tunnelServerDaemon2 = tunnelServerDaemon;
            object2 = object3;
        } else {
            object2 = null;
        }
        tunnelServerDaemon2.httpTunnel = object2;
        TunnelServerDaemon tunnelServerDaemon3 = this;
        HttpsTunnelArgs httpsTunnelArgs2 = httpsTunnelArgs;
        if (httpsTunnelArgs2 != null) {
            object4 = httpsTunnelArgs2;
            tunnelServerDaemon = tunnelServerDaemon3;
            bl2 = false;
            bl = false;
            it = object4;
            boolean bl4 = false;
            object3 = this.getHttpsTunnel(this.httpsRegistry, (HttpsTunnelArgs)it);
            tunnelServerDaemon3 = tunnelServerDaemon;
            object = object3;
        } else {
            object = null;
        }
        tunnelServerDaemon3.httpsTunnel = object;
    }

    public static final /* synthetic */ OnTrafficListener access$getOnTrafficListener$p(TunnelServerDaemon $this) {
        return $this.onTrafficListener;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u001a\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u001a\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016\u00a8\u0006\u000e"}, d2={"Llighttunnel/server/TunnelServerDaemon$InnerTunnelServerChannelHandler;", "Llighttunnel/server/TunnelServerDaemonChannelHandler;", "tunnelRequestInterceptor", "Llighttunnel/openapi/TunnelRequestInterceptor;", "(Llighttunnel/server/TunnelServerDaemon;Llighttunnel/openapi/TunnelRequestInterceptor;)V", "onChannelConnected", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "httpFd", "Llighttunnel/server/http/HttpFdDefaultImpl;", "tcpFd", "Llighttunnel/server/tcp/TcpFdDefaultImpl;", "onChannelInactive", "server"})
    private final class InnerTunnelServerChannelHandler
    extends TunnelServerDaemonChannelHandler {
        @Override
        public void onChannelConnected(@NotNull ChannelHandlerContext ctx, @Nullable TcpFdDefaultImpl tcpFd) {
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
                if (tcpFd == null) break block1;
                OnTcpTunnelStateListener onTcpTunnelStateListener = TunnelServerDaemon.this.onTcpTunnelStateListener;
                if (onTcpTunnelStateListener != null) {
                    onTcpTunnelStateListener.onTcpTunnelConnected(tcpFd);
                }
            }
        }

        @Override
        public void onChannelInactive(@NotNull ChannelHandlerContext ctx, @Nullable TcpFdDefaultImpl tcpFd) {
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
                if (tcpFd == null) break block1;
                OnTcpTunnelStateListener onTcpTunnelStateListener = TunnelServerDaemon.this.onTcpTunnelStateListener;
                if (onTcpTunnelStateListener != null) {
                    onTcpTunnelStateListener.onTcpTunnelDisconnect(tcpFd);
                }
            }
        }

        @Override
        public void onChannelConnected(@NotNull ChannelHandlerContext ctx, @Nullable HttpFdDefaultImpl httpFd) {
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
                if (httpFd == null) break block1;
                OnHttpTunnelStateListener onHttpTunnelStateListener = TunnelServerDaemon.this.onHttpTunnelStateListener;
                if (onHttpTunnelStateListener != null) {
                    onHttpTunnelStateListener.onHttpTunnelConnected(httpFd);
                }
            }
        }

        @Override
        public void onChannelInactive(@NotNull ChannelHandlerContext ctx, @Nullable HttpFdDefaultImpl httpFd) {
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
                if (httpFd == null) break block1;
                OnHttpTunnelStateListener onHttpTunnelStateListener = TunnelServerDaemon.this.onHttpTunnelStateListener;
                if (onHttpTunnelStateListener != null) {
                    onHttpTunnelStateListener.onHttpTunnelDisconnect(httpFd);
                }
            }
        }

        public InnerTunnelServerChannelHandler(TunnelRequestInterceptor tunnelRequestInterceptor) {
            super(tunnelRequestInterceptor, TunnelServerDaemon.this.tunnelIds, TunnelServerDaemon.this.tcpTunnel, TunnelServerDaemon.this.httpTunnel, TunnelServerDaemon.this.httpsTunnel);
        }
    }
}

