/*
 * Decompiled with CFR 0.152.
 */
package lighttunnel.server.tcp;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import lighttunnel.base.util.PortUtil;
import lighttunnel.openapi.ProtoException;
import lighttunnel.server.tcp.TcpFdDefaultImpl;
import lighttunnel.server.tcp.TcpRegistry;
import lighttunnel.server.tcp.TcpTunnelChannelHandler;
import lighttunnel.server.util.SessionChannels;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ \u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Llighttunnel/server/tcp/TcpTunnel;", "", "bossGroup", "Lio/netty/channel/nio/NioEventLoopGroup;", "workerGroup", "registry", "Llighttunnel/server/tcp/TcpRegistry;", "(Lio/netty/channel/nio/NioEventLoopGroup;Lio/netty/channel/nio/NioEventLoopGroup;Llighttunnel/server/tcp/TcpRegistry;)V", "serverBootstrap", "Lio/netty/bootstrap/ServerBootstrap;", "requireNotRegistered", "", "port", "", "startTunnel", "Llighttunnel/server/tcp/TcpFdDefaultImpl;", "addr", "", "sessionChannels", "Llighttunnel/server/util/SessionChannels;", "stopTunnel", "server"})
public final class TcpTunnel {
    private final ServerBootstrap serverBootstrap;
    private final TcpRegistry registry;

    public final void requireNotRegistered(int port) throws Exception {
        if (this.registry.isRegistered(port) || !PortUtil.INSTANCE.isAvailablePort(port)) {
            throw (Throwable)new ProtoException("port(" + port + ") already used", null, 2, null);
        }
    }

    @Nullable
    public final TcpFdDefaultImpl stopTunnel(int port) {
        return this.registry.unregister(port);
    }

    @NotNull
    public final TcpFdDefaultImpl startTunnel(@Nullable String addr, int port, @NotNull SessionChannels sessionChannels) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)sessionChannels, (String)"sessionChannels");
        this.requireNotRegistered(port);
        ChannelFuture bindChannelFuture = addr == null ? this.serverBootstrap.bind(port) : this.serverBootstrap.bind(addr, port);
        TcpFdDefaultImpl fd2 = new TcpFdDefaultImpl(sessionChannels, (Function0<Unit>)((Function0)new Function0<Unit>(bindChannelFuture){
            final /* synthetic */ ChannelFuture $bindChannelFuture;

            public final void invoke() {
                this.$bindChannelFuture.channel().close();
            }
            {
                this.$bindChannelFuture = channelFuture;
                super(0);
            }
        }));
        this.registry.register(port, fd2);
        return fd2;
    }

    public TcpTunnel(@NotNull NioEventLoopGroup bossGroup, @NotNull NioEventLoopGroup workerGroup, @NotNull TcpRegistry registry) {
        Intrinsics.checkParameterIsNotNull((Object)bossGroup, (String)"bossGroup");
        Intrinsics.checkParameterIsNotNull((Object)workerGroup, (String)"workerGroup");
        Intrinsics.checkParameterIsNotNull((Object)registry, (String)"registry");
        this.registry = registry;
        this.serverBootstrap = new ServerBootstrap();
        ((ServerBootstrap)this.serverBootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childOption(ChannelOption.AUTO_READ, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(@Nullable SocketChannel ch) {
                if (ch == null) {
                    return;
                }
                ch.pipeline().addLast("handler", (ChannelHandler)new TcpTunnelChannelHandler(registry));
            }
        });
    }
}

