/*
 * Decompiled with CFR 0.152.
 */
package lighttunnel.server.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import lighttunnel.base.proto.-ConstsKt;
import lighttunnel.base.proto.ProtoMessage;
import lighttunnel.base.util.-HttpUtilKt;
import lighttunnel.openapi.RemoteConnection;
import lighttunnel.openapi.http.HttpPlugin;
import lighttunnel.openapi.http.HttpTunnelRequestInterceptor;
import lighttunnel.server.http.HttpContextDefaultImpl;
import lighttunnel.server.http.HttpFdDefaultImpl;
import lighttunnel.server.http.HttpRegistry;
import lighttunnel.server.http.HttpTunnelChannelHandler$$special$;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0011H\u0016J\u0012\u0010\u0017\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0011H\u0016J\u001c\u0010\u0018\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u001c\u0010\u001b\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00112\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\u00020\u0010*\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0012R\u0018\u0010\u0013\u001a\u00020\u0010*\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0012\u00a8\u0006\u001e"}, d2={"Llighttunnel/server/http/HttpTunnelChannelHandler;", "Lio/netty/channel/ChannelInboundHandlerAdapter;", "registry", "Llighttunnel/server/http/HttpRegistry;", "httpPlugin", "Llighttunnel/openapi/http/HttpPlugin;", "httpTunnelRequestInterceptor", "Llighttunnel/openapi/http/HttpTunnelRequestInterceptor;", "(Llighttunnel/server/http/HttpRegistry;Llighttunnel/openapi/http/HttpPlugin;Llighttunnel/openapi/http/HttpTunnelRequestInterceptor;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "logger$delegate", "Lkotlin/Lazy;", "isInterceptorHandle", "", "Lio/netty/channel/ChannelHandlerContext;", "(Lio/netty/channel/ChannelHandlerContext;)Z", "isPluginHandle", "channelActive", "", "ctx", "channelInactive", "channelRead", "msg", "", "exceptionCaught", "cause", "", "server"})
public final class HttpTunnelChannelHandler
extends ChannelInboundHandlerAdapter {
    private final Lazy logger$delegate;
    private final HttpRegistry registry;
    private final HttpPlugin httpPlugin;
    private final HttpTunnelRequestInterceptor httpTunnelRequestInterceptor;

    private final Logger getLogger() {
        Lazy lazy = this.logger$delegate;
        HttpTunnelChannelHandler httpTunnelChannelHandler = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    public void channelActive(@Nullable ChannelHandlerContext ctx) throws Exception {
        this.getLogger().trace("channelActive: {}", (Object)ctx);
        super.channelActive(ctx);
    }

    public void channelInactive(@Nullable ChannelHandlerContext ctx) throws Exception {
        this.getLogger().trace("channelInactive: {}", (Object)ctx);
        if (ctx == null) {
            super.channelInactive(ctx);
            return;
        }
        String httpHost = (String)ctx.channel().attr(lighttunnel.server.util.-ConstsKt.AK_HTTP_HOST()).get();
        Long sessionId = (Long)ctx.channel().attr(lighttunnel.server.util.-ConstsKt.AK_SESSION_ID()).get();
        if (httpHost != null && sessionId != null) {
            HttpFdDefaultImpl httpFd = this.registry.getHttpFd(httpHost);
            HttpFdDefaultImpl httpFdDefaultImpl = httpFd;
            if (httpFdDefaultImpl != null && (httpFdDefaultImpl = httpFdDefaultImpl.getTunnelChannel()) != null) {
                long l = httpFd.getTunnelId();
                long l2 = sessionId;
                SocketAddress socketAddress = ctx.channel().remoteAddress();
                Intrinsics.checkExpressionValueIsNotNull((Object)socketAddress, (String)"ctx.channel().remoteAddress()");
                httpFdDefaultImpl.writeAndFlush(ProtoMessage.Companion.REMOTE_DISCONNECT(l, l2, new RemoteConnection(socketAddress)));
            }
            ctx.channel().attr(lighttunnel.server.util.-ConstsKt.AK_HTTP_HOST()).set(null);
            ctx.channel().attr(lighttunnel.server.util.-ConstsKt.AK_SESSION_ID()).set(null);
        }
        super.channelInactive(ctx);
    }

    public void exceptionCaught(@Nullable ChannelHandlerContext ctx, @Nullable Throwable cause) throws Exception {
        this.getLogger().trace("exceptionCaught: {}", (Object)ctx, (Object)cause);
        if (ctx == null) {
            return;
        }
        ctx.channel().writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public void channelRead(@Nullable ChannelHandlerContext ctx, @Nullable Object msg) throws Exception {
        block18: {
            byte[] byArray;
            HttpContextDefaultImpl httpContext;
            Object object;
            block17: {
                this.getLogger().trace("channelRead0: {}", (Object)ctx);
                if (ctx == null) {
                    return;
                }
                if (msg == null) {
                    return;
                }
                Object object2 = (HttpContextDefaultImpl)ctx.channel().attr(lighttunnel.server.util.-ConstsKt.AK_HTTP_CONTEXT()).get();
                if (object2 == null) {
                    object = new HttpContextDefaultImpl(ctx);
                    boolean bl = false;
                    boolean bl2 = false;
                    Object it = object;
                    boolean bl3 = false;
                    ctx.channel().attr(lighttunnel.server.util.-ConstsKt.AK_HTTP_CONTEXT()).set(it);
                    object2 = object;
                }
                httpContext = object2;
                object = msg;
                if (!(object instanceof HttpRequest)) break block17;
                HttpPlugin httpPlugin = this.httpPlugin;
                ctx.channel().attr(lighttunnel.server.util.-ConstsKt.AK_IS_PLUGIN_HANDLE()).set(httpPlugin != null ? Boolean.valueOf(httpPlugin.doHttpRequest(httpContext, (HttpRequest)msg)) : null);
                if (this.isPluginHandle(ctx)) {
                    return;
                }
                String httpHost = -HttpUtilKt.getHostExcludePort((HttpRequest)((HttpRequest)msg));
                if (httpHost == null) {
                    HttpResponseStatus httpResponseStatus = HttpResponseStatus.BAD_REQUEST;
                    Intrinsics.checkExpressionValueIsNotNull((Object)httpResponseStatus, (String)"HttpResponseStatus.BAD_REQUEST");
                    HttpContextDefaultImpl.writeTextHttpResponse$default(httpContext, httpResponseStatus, null, 2, null);
                    return;
                }
                ctx.channel().attr(lighttunnel.server.util.-ConstsKt.AK_HTTP_HOST()).set((Object)httpHost);
                HttpFdDefaultImpl httpFd = this.registry.getHttpFd(httpHost);
                if (httpFd == null) {
                    HttpResponseStatus httpResponseStatus = HttpResponseStatus.FORBIDDEN;
                    Intrinsics.checkExpressionValueIsNotNull((Object)httpResponseStatus, (String)"HttpResponseStatus.FORBIDDEN");
                    httpContext.writeTextHttpResponse(httpResponseStatus, "Tunnel(" + httpHost + ")Not Registered!");
                    return;
                }
                HttpTunnelRequestInterceptor httpTunnelRequestInterceptor = this.httpTunnelRequestInterceptor;
                ctx.channel().attr(lighttunnel.server.util.-ConstsKt.AK_IS_INTERCEPTOR_HANDLE()).set(httpTunnelRequestInterceptor != null ? Boolean.valueOf(httpTunnelRequestInterceptor.doHttpRequest(httpContext, (HttpRequest)msg, httpFd.getTunnelRequest())) : null);
                if (this.isInterceptorHandle(ctx)) {
                    return;
                }
                Channel channel = ctx.channel();
                Intrinsics.checkExpressionValueIsNotNull((Object)channel, (String)"ctx.channel()");
                long sessionId = httpFd.putChannel(channel);
                ctx.channel().attr(lighttunnel.server.util.-ConstsKt.AK_SESSION_ID()).set((Object)sessionId);
                Channel channel2 = httpFd.getTunnelChannel();
                long l = httpFd.getTunnelId();
                SocketAddress socketAddress = ctx.channel().remoteAddress();
                Intrinsics.checkExpressionValueIsNotNull((Object)socketAddress, (String)"ctx.channel().remoteAddress()");
                channel2.writeAndFlush((Object)ProtoMessage.Companion.REMOTE_CONNECTED(l, sessionId, new RemoteConnection(socketAddress)));
                byte[] byArray2 = ByteBufUtil.getBytes((ByteBuf)-HttpUtilKt.getByteBuf((HttpRequest)((HttpRequest)msg)));
                if (byArray2 == null) {
                    byArray2 = -ConstsKt.getEmptyBytes();
                }
                byte[] data = byArray2;
                httpFd.getTunnelChannel().writeAndFlush((Object)ProtoMessage.Companion.TRANSFER(httpFd.getTunnelId(), sessionId, data));
                break block18;
            }
            if (!(object instanceof HttpContent)) break block18;
            if (this.isPluginHandle(ctx)) {
                HttpPlugin httpPlugin = this.httpPlugin;
                if (httpPlugin != null) {
                    httpPlugin.doHttpContent(httpContext, (HttpContent)msg);
                }
                return;
            }
            String httpHost = (String)ctx.channel().attr(lighttunnel.server.util.-ConstsKt.AK_HTTP_HOST()).get();
            if (httpHost == null) {
                HttpResponseStatus httpResponseStatus = HttpResponseStatus.BAD_REQUEST;
                Intrinsics.checkExpressionValueIsNotNull((Object)httpResponseStatus, (String)"HttpResponseStatus.BAD_REQUEST");
                HttpContextDefaultImpl.writeTextHttpResponse$default(httpContext, httpResponseStatus, null, 2, null);
                return;
            }
            HttpFdDefaultImpl httpFdDefaultImpl = this.registry.getHttpFd(httpHost);
            if (httpFdDefaultImpl == null) {
                return;
            }
            HttpFdDefaultImpl httpFd = httpFdDefaultImpl;
            if (this.isInterceptorHandle(ctx)) {
                HttpTunnelRequestInterceptor httpTunnelRequestInterceptor = this.httpTunnelRequestInterceptor;
                if (httpTunnelRequestInterceptor != null) {
                    httpTunnelRequestInterceptor.doHttpContent(httpContext, (HttpContent)msg, httpFd.getTunnelRequest());
                }
                return;
            }
            Long sessionId = (Long)ctx.channel().attr(lighttunnel.server.util.-ConstsKt.AK_SESSION_ID()).get();
            if (sessionId == null) {
                ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                return;
            }
            Channel channel = httpFd.getTunnelChannel();
            long l = httpFd.getTunnelId();
            long l2 = sessionId;
            SocketAddress socketAddress = ctx.channel().remoteAddress();
            Intrinsics.checkExpressionValueIsNotNull((Object)socketAddress, (String)"ctx.channel().remoteAddress()");
            channel.writeAndFlush((Object)ProtoMessage.Companion.REMOTE_CONNECTED(l, l2, new RemoteConnection(socketAddress)));
            ByteBuf byteBuf = ((HttpContent)msg).content();
            if (byteBuf == null) {
                byteBuf = Unpooled.EMPTY_BUFFER;
            }
            if ((byArray = ByteBufUtil.getBytes((ByteBuf)byteBuf)) == null) {
                byArray = -ConstsKt.getEmptyBytes();
            }
            byte[] data = byArray;
            httpFd.getTunnelChannel().writeAndFlush((Object)ProtoMessage.Companion.TRANSFER(httpFd.getTunnelId(), sessionId.longValue(), data));
        }
    }

    private final boolean isPluginHandle(@NotNull ChannelHandlerContext $this$isPluginHandle) {
        return Intrinsics.areEqual((Object)((Boolean)$this$isPluginHandle.channel().attr(lighttunnel.server.util.-ConstsKt.AK_IS_PLUGIN_HANDLE()).get()), (Object)true);
    }

    private final boolean isInterceptorHandle(@NotNull ChannelHandlerContext $this$isInterceptorHandle) {
        return Intrinsics.areEqual((Object)((Boolean)$this$isInterceptorHandle.channel().attr(lighttunnel.server.util.-ConstsKt.AK_IS_INTERCEPTOR_HANDLE()).get()), (Object)true);
    }

    public HttpTunnelChannelHandler(@NotNull HttpRegistry registry, @Nullable HttpPlugin httpPlugin, @Nullable HttpTunnelRequestInterceptor httpTunnelRequestInterceptor) {
        Lazy lazy;
        Intrinsics.checkParameterIsNotNull((Object)registry, (String)"registry");
        this.registry = registry;
        this.httpPlugin = httpPlugin;
        this.httpTunnelRequestInterceptor = httpTunnelRequestInterceptor;
        HttpTunnelChannelHandler httpTunnelChannelHandler = this;
        HttpTunnelChannelHandler httpTunnelChannelHandler2 = this;
        boolean $i$f$loggerDelegate = false;
        httpTunnelChannelHandler2.logger$delegate = lazy = LazyKt.lazy((Function0)$special$$inlined$loggerDelegate$1.INSTANCE);
    }

    public /* synthetic */ HttpTunnelChannelHandler(HttpRegistry httpRegistry, HttpPlugin httpPlugin, HttpTunnelRequestInterceptor httpTunnelRequestInterceptor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            httpPlugin = null;
        }
        if ((n & 4) != 0) {
            httpTunnelRequestInterceptor = null;
        }
        this(httpRegistry, httpPlugin, httpTunnelRequestInterceptor);
    }
}

