/*
 * Decompiled with CFR 0.152.
 */
package lighttunnel.server.http;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import lighttunnel.openapi.ProtoException;
import lighttunnel.openapi.http.HttpPlugin;
import lighttunnel.openapi.http.HttpTunnelRequestInterceptor;
import lighttunnel.server.http.HttpFdDefaultImpl;
import lighttunnel.server.http.HttpRegistry;
import lighttunnel.server.http.HttpTunnel$$special$;
import lighttunnel.server.http.HttpTunnelChannelHandler;
import lighttunnel.server.util.SessionChannels;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\bJ\u0006\u0010 \u001a\u00020\u001eJ\u0016\u0010!\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010#\u001a\u00020$J\u0010\u0010%\u001a\u0004\u0018\u00010\"2\u0006\u0010\u001f\u001a\u00020\bR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u001b\u0010\u0015\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Llighttunnel/server/http/HttpTunnel;", "", "bossGroup", "Lio/netty/channel/nio/NioEventLoopGroup;", "workerGroup", "registry", "Llighttunnel/server/http/HttpRegistry;", "bindAddr", "", "bindPort", "", "sslContext", "Lio/netty/handler/ssl/SslContext;", "httpPlugin", "Llighttunnel/openapi/http/HttpPlugin;", "httpTunnelRequestInterceptor", "Llighttunnel/openapi/http/HttpTunnelRequestInterceptor;", "(Lio/netty/channel/nio/NioEventLoopGroup;Lio/netty/channel/nio/NioEventLoopGroup;Llighttunnel/server/http/HttpRegistry;Ljava/lang/String;ILio/netty/handler/ssl/SslContext;Llighttunnel/openapi/http/HttpPlugin;Llighttunnel/openapi/http/HttpTunnelRequestInterceptor;)V", "isHttps", "", "()Z", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "logger$delegate", "Lkotlin/Lazy;", "serverBootstrap", "Lio/netty/bootstrap/ServerBootstrap;", "requireNotRegistered", "", "host", "start", "startTunnel", "Llighttunnel/server/http/HttpFdDefaultImpl;", "sessionChannels", "Llighttunnel/server/util/SessionChannels;", "stopTunnel", "server"})
public final class HttpTunnel {
    private final Lazy logger$delegate;
    private final ServerBootstrap serverBootstrap;
    private final HttpRegistry registry;
    private final String bindAddr;
    private final int bindPort;
    private final SslContext sslContext;
    private final HttpPlugin httpPlugin;
    private final HttpTunnelRequestInterceptor httpTunnelRequestInterceptor;

    private final Logger getLogger() {
        Lazy lazy = this.logger$delegate;
        HttpTunnel httpTunnel = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    private final boolean isHttps() {
        return this.sslContext != null;
    }

    public final void start() {
        if (this.bindAddr == null) {
            this.serverBootstrap.bind(this.bindPort).get();
        } else {
            this.serverBootstrap.bind(this.bindAddr, this.bindPort).get();
        }
        Logger logger = this.getLogger();
        Object[] objectArray = new Object[3];
        objectArray[0] = this.isHttps() ? "https" : "http";
        String string = this.bindAddr;
        if (string == null) {
            string = "::";
        }
        objectArray[1] = string;
        objectArray[2] = this.bindPort;
        logger.info("Serving tunnel by {} on {} port {}", objectArray);
    }

    @Nullable
    public final HttpFdDefaultImpl stopTunnel(@NotNull String host) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        return this.registry.unregister(host);
    }

    public final void requireNotRegistered(@NotNull String host) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        if (this.registry.isRegistered(host)) {
            throw (Throwable)new ProtoException("host(" + host + ") already used", null, 2, null);
        }
    }

    @NotNull
    public final HttpFdDefaultImpl startTunnel(@NotNull String host, @NotNull SessionChannels sessionChannels) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        Intrinsics.checkParameterIsNotNull((Object)sessionChannels, (String)"sessionChannels");
        this.requireNotRegistered(host);
        return this.registry.register(this.isHttps(), host, sessionChannels);
    }

    public HttpTunnel(@NotNull NioEventLoopGroup bossGroup, @NotNull NioEventLoopGroup workerGroup, @NotNull HttpRegistry registry, @Nullable String bindAddr, int bindPort, @Nullable SslContext sslContext, @Nullable HttpPlugin httpPlugin, @Nullable HttpTunnelRequestInterceptor httpTunnelRequestInterceptor) {
        Lazy lazy;
        Intrinsics.checkParameterIsNotNull((Object)bossGroup, (String)"bossGroup");
        Intrinsics.checkParameterIsNotNull((Object)workerGroup, (String)"workerGroup");
        Intrinsics.checkParameterIsNotNull((Object)registry, (String)"registry");
        this.registry = registry;
        this.bindAddr = bindAddr;
        this.bindPort = bindPort;
        this.sslContext = sslContext;
        this.httpPlugin = httpPlugin;
        this.httpTunnelRequestInterceptor = httpTunnelRequestInterceptor;
        HttpTunnel httpTunnel = this;
        HttpTunnel httpTunnel2 = this;
        boolean $i$f$loggerDelegate = false;
        httpTunnel2.logger$delegate = lazy = LazyKt.lazy((Function0)$special$$inlined$loggerDelegate$1.INSTANCE);
        this.serverBootstrap = new ServerBootstrap();
        ((ServerBootstrap)this.serverBootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childOption(ChannelOption.AUTO_READ, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(@Nullable SocketChannel ch) {
                if (ch == null) {
                    return;
                }
                if (sslContext != null) {
                    ch.pipeline().addFirst("ssl", (ChannelHandler)new SslHandler(sslContext.newEngine(ch.alloc())));
                }
                ch.pipeline().addLast("decoder", (ChannelHandler)new HttpRequestDecoder()).addLast("handler", (ChannelHandler)new HttpTunnelChannelHandler(registry, httpPlugin, httpTunnelRequestInterceptor));
            }
        });
    }

    public /* synthetic */ HttpTunnel(NioEventLoopGroup nioEventLoopGroup, NioEventLoopGroup nioEventLoopGroup2, HttpRegistry httpRegistry, String string, int n, SslContext sslContext, HttpPlugin httpPlugin, HttpTunnelRequestInterceptor httpTunnelRequestInterceptor, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x20) != 0) {
            sslContext = null;
        }
        if ((n2 & 0x40) != 0) {
            httpPlugin = null;
        }
        if ((n2 & 0x80) != 0) {
            httpTunnelRequestInterceptor = null;
        }
        this(nioEventLoopGroup, nioEventLoopGroup2, httpRegistry, string, n, sslContext, httpPlugin, httpTunnelRequestInterceptor);
    }
}

