/*
 * Decompiled with CFR 0.152.
 */
package lighttunnel.server.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import lighttunnel.base.proto.-ConstsKt;
import lighttunnel.base.proto.ProtoMessage;
import lighttunnel.base.util.-HttpUtilKt;
import lighttunnel.openapi.RemoteConnection;
import lighttunnel.openapi.http.HttpChain;
import lighttunnel.openapi.http.HttpPlugin;
import lighttunnel.openapi.http.HttpTunnelRequestInterceptor;
import lighttunnel.server.http.HttpChainDefaultImpl;
import lighttunnel.server.http.HttpFdDefaultImpl;
import lighttunnel.server.http.HttpRegistry;
import lighttunnel.server.http.HttpTunnelChannelHandler$$special$;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0012\u0010\u0013\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u001c\u0010\u0014\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u001c\u0010\u0017\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J$\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u001f\u001a\u00020 H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Llighttunnel/server/http/HttpTunnelChannelHandler;", "Lio/netty/channel/ChannelInboundHandlerAdapter;", "registry", "Llighttunnel/server/http/HttpRegistry;", "httpPlugin", "Llighttunnel/openapi/http/HttpPlugin;", "httpTunnelRequestInterceptor", "Llighttunnel/openapi/http/HttpTunnelRequestInterceptor;", "(Llighttunnel/server/http/HttpRegistry;Llighttunnel/openapi/http/HttpPlugin;Llighttunnel/openapi/http/HttpTunnelRequestInterceptor;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "logger$delegate", "Lkotlin/Lazy;", "channelActive", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "channelInactive", "channelRead", "msg", "", "exceptionCaught", "cause", "", "writeSimpleHttpResponse", "chain", "Llighttunnel/openapi/http/HttpChain;", "status", "Lio/netty/handler/codec/http/HttpResponseStatus;", "content", "", "server"})
public final class HttpTunnelChannelHandler
extends ChannelInboundHandlerAdapter {
    private final Lazy logger$delegate;
    private final HttpRegistry registry;
    private final HttpPlugin httpPlugin;
    private final HttpTunnelRequestInterceptor httpTunnelRequestInterceptor;

    private final Logger getLogger() {
        Lazy lazy = this.logger$delegate;
        HttpTunnelChannelHandler httpTunnelChannelHandler = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    public void channelActive(@Nullable ChannelHandlerContext ctx) throws Exception {
        this.getLogger().trace("channelActive: {}", (Object)ctx);
        super.channelActive(ctx);
    }

    public void channelInactive(@Nullable ChannelHandlerContext ctx) throws Exception {
        this.getLogger().trace("channelInactive: {}", (Object)ctx);
        if (ctx == null) {
            super.channelInactive(ctx);
            return;
        }
        String httpHost = (String)ctx.channel().attr(lighttunnel.server.util.-ConstsKt.getAK_HTTP_HOST()).get();
        Long sessionId = (Long)ctx.channel().attr(lighttunnel.server.util.-ConstsKt.getAK_SESSION_ID()).get();
        if (httpHost != null && sessionId != null) {
            HttpFdDefaultImpl httpFd = this.registry.getHttpFd(httpHost);
            HttpFdDefaultImpl httpFdDefaultImpl = httpFd;
            if (httpFdDefaultImpl != null && (httpFdDefaultImpl = httpFdDefaultImpl.getTunnelChannel()) != null) {
                long l = httpFd.getTunnelId();
                long l2 = sessionId;
                SocketAddress socketAddress = ctx.channel().remoteAddress();
                Intrinsics.checkExpressionValueIsNotNull((Object)socketAddress, (String)"ctx.channel().remoteAddress()");
                httpFdDefaultImpl.writeAndFlush(ProtoMessage.Companion.REMOTE_DISCONNECT(l, l2, new RemoteConnection(socketAddress)));
            }
            ctx.channel().attr(lighttunnel.server.util.-ConstsKt.getAK_HTTP_HOST()).set(null);
            ctx.channel().attr(lighttunnel.server.util.-ConstsKt.getAK_SESSION_ID()).set(null);
        }
        super.channelInactive(ctx);
    }

    public void exceptionCaught(@Nullable ChannelHandlerContext ctx, @Nullable Throwable cause) throws Exception {
        this.getLogger().trace("exceptionCaught: {}", (Object)ctx, (Object)cause);
        if (ctx == null) {
            return;
        }
        ctx.channel().writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public void channelRead(@Nullable ChannelHandlerContext ctx, @Nullable Object msg) throws Exception {
        block18: {
            byte[] byArray;
            HttpFdDefaultImpl httpFd;
            HttpChain chain;
            Object object;
            block17: {
                this.getLogger().trace("channelRead0: {}", (Object)ctx);
                if (ctx == null) {
                    return;
                }
                if (msg == null) {
                    return;
                }
                HttpChain httpChain = (HttpChain)ctx.channel().attr(lighttunnel.server.util.-ConstsKt.getAK_HTTP_CHAIN()).get();
                if (httpChain == null) {
                    object = new HttpChainDefaultImpl(ctx);
                    boolean bl = false;
                    boolean bl2 = false;
                    Object it = object;
                    boolean bl3 = false;
                    ctx.channel().attr(lighttunnel.server.util.-ConstsKt.getAK_HTTP_CHAIN()).set(it);
                    httpChain = (HttpChain)object;
                }
                chain = httpChain;
                object = msg;
                if (!(object instanceof HttpRequest)) break block17;
                HttpPlugin httpPlugin = this.httpPlugin;
                Boolean isPluginHandle = httpPlugin != null ? Boolean.valueOf(httpPlugin.doHttpRequest(chain, (HttpRequest)msg)) : null;
                ctx.channel().attr(lighttunnel.server.util.-ConstsKt.getAK_IS_PLUGIN_HANDLE()).set((Object)isPluginHandle);
                if (Intrinsics.areEqual((Object)isPluginHandle, (Object)true)) {
                    return;
                }
                String httpHost = -HttpUtilKt.getHostExcludePort((HttpRequest)((HttpRequest)msg));
                if (httpHost == null) {
                    HttpResponseStatus httpResponseStatus = HttpResponseStatus.BAD_REQUEST;
                    Intrinsics.checkExpressionValueIsNotNull((Object)httpResponseStatus, (String)"HttpResponseStatus.BAD_REQUEST");
                    HttpTunnelChannelHandler.writeSimpleHttpResponse$default(this, chain, httpResponseStatus, null, 4, null);
                    return;
                }
                httpFd = this.registry.getHttpFd(httpHost);
                if (httpFd == null) {
                    HttpResponseStatus httpResponseStatus = HttpResponseStatus.FORBIDDEN;
                    Intrinsics.checkExpressionValueIsNotNull((Object)httpResponseStatus, (String)"HttpResponseStatus.FORBIDDEN");
                    this.writeSimpleHttpResponse(chain, httpResponseStatus, "Tunnel\uff08" + httpHost + "\uff09Not Registered!");
                    return;
                }
                ctx.channel().attr(lighttunnel.server.util.-ConstsKt.getAK_HTTP_HOST()).set((Object)httpHost);
                HttpTunnelRequestInterceptor httpTunnelRequestInterceptor = this.httpTunnelRequestInterceptor;
                Boolean isInterceptorHandle = httpTunnelRequestInterceptor != null ? Boolean.valueOf(httpTunnelRequestInterceptor.doHttpRequest(chain, (HttpRequest)msg, httpFd.getTunnelRequest())) : null;
                ctx.channel().attr(lighttunnel.server.util.-ConstsKt.getAK_IS_INTERCEPTOR_HANDLE()).set((Object)isInterceptorHandle);
                if (Intrinsics.areEqual((Object)isPluginHandle, (Object)true)) {
                    return;
                }
                Channel channel = ctx.channel();
                Intrinsics.checkExpressionValueIsNotNull((Object)channel, (String)"ctx.channel()");
                long sessionId = httpFd.putChannel(channel);
                ctx.channel().attr(lighttunnel.server.util.-ConstsKt.getAK_SESSION_ID()).set((Object)sessionId);
                Channel channel2 = httpFd.getTunnelChannel();
                long l = httpFd.getTunnelId();
                SocketAddress socketAddress = ctx.channel().remoteAddress();
                Intrinsics.checkExpressionValueIsNotNull((Object)socketAddress, (String)"ctx.channel().remoteAddress()");
                channel2.writeAndFlush((Object)ProtoMessage.Companion.REMOTE_CONNECTED(l, sessionId, new RemoteConnection(socketAddress)));
                byte[] byArray2 = ByteBufUtil.getBytes((ByteBuf)-HttpUtilKt.getByteBuf((HttpRequest)((HttpRequest)msg)));
                if (byArray2 == null) {
                    byArray2 = -ConstsKt.getEmptyBytes();
                }
                byte[] data = byArray2;
                httpFd.getTunnelChannel().writeAndFlush((Object)ProtoMessage.Companion.TRANSFER(httpFd.getTunnelId(), sessionId, data));
                break block18;
            }
            if (!(object instanceof HttpContent)) break block18;
            Boolean isPluginHandle = (Boolean)ctx.channel().attr(lighttunnel.server.util.-ConstsKt.getAK_IS_PLUGIN_HANDLE()).get();
            if (Intrinsics.areEqual((Object)isPluginHandle, (Object)true)) {
                HttpPlugin httpPlugin = this.httpPlugin;
                if (httpPlugin != null) {
                    httpPlugin.doHttpContent(chain, (HttpContent)msg);
                }
                return;
            }
            String httpHost = (String)ctx.channel().attr(lighttunnel.server.util.-ConstsKt.getAK_HTTP_HOST()).get();
            if (httpHost == null) {
                ctx.channel().writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                return;
            }
            HttpFdDefaultImpl httpFdDefaultImpl = this.registry.getHttpFd(httpHost);
            if (httpFdDefaultImpl == null) {
                return;
            }
            httpFd = httpFdDefaultImpl;
            Boolean isInterceptorHandle = (Boolean)ctx.channel().attr(lighttunnel.server.util.-ConstsKt.getAK_IS_INTERCEPTOR_HANDLE()).get();
            if (Intrinsics.areEqual((Object)isInterceptorHandle, (Object)true)) {
                HttpTunnelRequestInterceptor httpTunnelRequestInterceptor = this.httpTunnelRequestInterceptor;
                if (httpTunnelRequestInterceptor != null) {
                    httpTunnelRequestInterceptor.doHttpContent(chain, (HttpContent)msg, httpFd.getTunnelRequest());
                }
                return;
            }
            Long sessionId = (Long)ctx.channel().attr(lighttunnel.server.util.-ConstsKt.getAK_SESSION_ID()).get();
            if (sessionId == null) {
                ctx.channel().writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                return;
            }
            Channel channel = httpFd.getTunnelChannel();
            long l = httpFd.getTunnelId();
            long l2 = sessionId;
            SocketAddress socketAddress = ctx.channel().remoteAddress();
            Intrinsics.checkExpressionValueIsNotNull((Object)socketAddress, (String)"ctx.channel().remoteAddress()");
            channel.writeAndFlush((Object)ProtoMessage.Companion.REMOTE_CONNECTED(l, l2, new RemoteConnection(socketAddress)));
            ByteBuf byteBuf = ((HttpContent)msg).content();
            if (byteBuf == null) {
                byteBuf = Unpooled.EMPTY_BUFFER;
            }
            if ((byArray = ByteBufUtil.getBytes((ByteBuf)byteBuf)) == null) {
                byArray = -ConstsKt.getEmptyBytes();
            }
            byte[] data = byArray;
            httpFd.getTunnelChannel().writeAndFlush((Object)ProtoMessage.Companion.TRANSFER(httpFd.getTunnelId(), sessionId.longValue(), data));
        }
    }

    private final void writeSimpleHttpResponse(HttpChain chain, HttpResponseStatus status, String content) {
        ByteBuf contentByteBuf = Unpooled.copiedBuffer((CharSequence)content, (Charset)Charsets.UTF_8);
        DefaultHttpResponse defaultHttpResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
        HttpChain httpChain = chain;
        boolean bl = false;
        boolean bl2 = false;
        DefaultHttpResponse $this$apply = defaultHttpResponse;
        boolean bl3 = false;
        $this$apply.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain; charset=utf-8");
        $this$apply.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)contentByteBuf.readableBytes());
        DefaultHttpResponse defaultHttpResponse2 = defaultHttpResponse;
        HttpChain.DefaultImpls.writeHttpResponse$default(httpChain, (HttpResponse)defaultHttpResponse2, false, null, 6, null);
        HttpChain.DefaultImpls.writeHttpContent$default(chain, (HttpContent)new DefaultHttpContent(contentByteBuf), false, null, 6, null);
        LastHttpContent lastHttpContent = LastHttpContent.EMPTY_LAST_CONTENT;
        Intrinsics.checkExpressionValueIsNotNull((Object)lastHttpContent, (String)"LastHttpContent.EMPTY_LAST_CONTENT");
        chain.writeHttpContent((HttpContent)lastHttpContent, true, ChannelFutureListener.CLOSE);
    }

    static /* synthetic */ void writeSimpleHttpResponse$default(HttpTunnelChannelHandler httpTunnelChannelHandler, HttpChain httpChain, HttpResponseStatus httpResponseStatus, String string, int n, Object object) {
        if ((n & 2) != 0) {
            HttpResponseStatus httpResponseStatus2 = HttpResponseStatus.OK;
            Intrinsics.checkExpressionValueIsNotNull((Object)httpResponseStatus2, (String)"HttpResponseStatus.OK");
            httpResponseStatus = httpResponseStatus2;
        }
        if ((n & 4) != 0) {
            String string2 = httpResponseStatus.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"status.toString()");
            string = string2;
        }
        httpTunnelChannelHandler.writeSimpleHttpResponse(httpChain, httpResponseStatus, string);
    }

    public HttpTunnelChannelHandler(@NotNull HttpRegistry registry, @Nullable HttpPlugin httpPlugin, @Nullable HttpTunnelRequestInterceptor httpTunnelRequestInterceptor) {
        Lazy lazy;
        Intrinsics.checkParameterIsNotNull((Object)registry, (String)"registry");
        this.registry = registry;
        this.httpPlugin = httpPlugin;
        this.httpTunnelRequestInterceptor = httpTunnelRequestInterceptor;
        HttpTunnelChannelHandler httpTunnelChannelHandler = this;
        HttpTunnelChannelHandler httpTunnelChannelHandler2 = this;
        boolean $i$f$loggerDelegate = false;
        httpTunnelChannelHandler2.logger$delegate = lazy = LazyKt.lazy((Function0)$special$$inlined$loggerDelegate$1.INSTANCE);
    }

    public /* synthetic */ HttpTunnelChannelHandler(HttpRegistry httpRegistry, HttpPlugin httpPlugin, HttpTunnelRequestInterceptor httpTunnelRequestInterceptor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            httpPlugin = null;
        }
        if ((n & 4) != 0) {
            httpTunnelRequestInterceptor = null;
        }
        this(httpRegistry, httpPlugin, httpTunnelRequestInterceptor);
    }
}

