/*
 * Decompiled with CFR 0.152.
 */
package lighttunnel.client;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.SslContext;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import lighttunnel.base.proto.HeartbeatHandler;
import lighttunnel.base.proto.ProtoMessageDecoder;
import lighttunnel.base.proto.ProtoMessageEncoder;
import lighttunnel.client.TunnelClientDaemon$$special$;
import lighttunnel.client.TunnelClientDaemonChannelHandler;
import lighttunnel.client.conn.DefaultTunnelConnectionImpl;
import lighttunnel.client.conn.TunnelConnectionRegistry;
import lighttunnel.client.local.LocalTcpClient;
import lighttunnel.openapi.TunnelRequest;
import lighttunnel.openapi.listener.OnRemoteConnectionListener;
import lighttunnel.openapi.listener.OnTunnelConnectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u000256B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020\u001eJ*\u0010*\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00032\u0006\u0010.\u001a\u00020/2\n\b\u0002\u00100\u001a\u0004\u0018\u00010\u000fJ\u0006\u00101\u001a\u00020\u001fJ\u0018\u00102\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020\u001e2\u0006\u00103\u001a\u000204H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0014\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017R\u0012\u0010\u001a\u001a\u00060\u001bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\u00020\f*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u00067"}, d2={"Llighttunnel/client/TunnelClientDaemon;", "", "workerThreads", "", "retryConnectPolicy", "", "onTunnelConnectionListener", "Llighttunnel/openapi/listener/OnTunnelConnectionListener;", "onRemoteConnectionListener", "Llighttunnel/openapi/listener/OnRemoteConnectionListener;", "(IBLlighttunnel/openapi/listener/OnTunnelConnectionListener;Llighttunnel/openapi/listener/OnRemoteConnectionListener;)V", "bootstrap", "Lio/netty/bootstrap/Bootstrap;", "cachedSslBootstraps", "Ljava/util/concurrent/ConcurrentHashMap;", "Lio/netty/handler/ssl/SslContext;", "localTcpClient", "Llighttunnel/client/local/LocalTcpClient;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "logger$delegate", "Lkotlin/Lazy;", "onChannelStateListener", "Llighttunnel/client/TunnelClientDaemon$OnChannelStateListenerImpl;", "openFailureCallback", "Lkotlin/Function1;", "Llighttunnel/client/conn/DefaultTunnelConnectionImpl;", "", "tunnelConnectionRegistry", "Llighttunnel/client/conn/TunnelConnectionRegistry;", "getTunnelConnectionRegistry", "()Llighttunnel/client/conn/TunnelConnectionRegistry;", "workerGroup", "Lio/netty/channel/nio/NioEventLoopGroup;", "getBootstrap", "(Lio/netty/handler/ssl/SslContext;)Lio/netty/bootstrap/Bootstrap;", "close", "conn", "connect", "serverAddr", "", "serverPort", "tunnelRequest", "Llighttunnel/openapi/TunnelRequest;", "sslContext", "depose", "tryReconnect", "error", "", "InnerChannelInitializer", "OnChannelStateListenerImpl", "client"})
public final class TunnelClientDaemon {
    private final Lazy logger$delegate;
    private final NioEventLoopGroup workerGroup;
    private final ConcurrentHashMap<SslContext, Bootstrap> cachedSslBootstraps;
    private final Bootstrap bootstrap;
    private final LocalTcpClient localTcpClient;
    private final ReentrantLock lock;
    private final Function1<DefaultTunnelConnectionImpl, Unit> openFailureCallback;
    private final OnChannelStateListenerImpl onChannelStateListener;
    @NotNull
    private final TunnelConnectionRegistry tunnelConnectionRegistry;
    private final byte retryConnectPolicy;
    private final OnTunnelConnectionListener onTunnelConnectionListener;
    private final OnRemoteConnectionListener onRemoteConnectionListener;

    private final Logger getLogger() {
        Lazy lazy = this.logger$delegate;
        TunnelClientDaemon tunnelClientDaemon = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    @NotNull
    public final TunnelConnectionRegistry getTunnelConnectionRegistry() {
        return this.tunnelConnectionRegistry;
    }

    @NotNull
    public final DefaultTunnelConnectionImpl connect(@NotNull String serverAddr, int serverPort, @NotNull TunnelRequest tunnelRequest, @Nullable SslContext sslContext) {
        Intrinsics.checkParameterIsNotNull((Object)serverAddr, (String)"serverAddr");
        Intrinsics.checkParameterIsNotNull((Object)tunnelRequest, (String)"tunnelRequest");
        DefaultTunnelConnectionImpl conn = new DefaultTunnelConnectionImpl(serverAddr, serverPort, tunnelRequest, sslContext);
        SslContext sslContext2 = conn.getSslContext();
        if (sslContext2 == null || (sslContext2 = this.getBootstrap(sslContext2)) == null) {
            sslContext2 = this.bootstrap;
        }
        conn.open((Bootstrap)sslContext2, this.openFailureCallback);
        OnTunnelConnectionListener onTunnelConnectionListener = this.onTunnelConnectionListener;
        if (onTunnelConnectionListener != null) {
            onTunnelConnectionListener.onTunnelConnecting(conn, false);
        }
        this.tunnelConnectionRegistry.register(conn);
        return conn;
    }

    public static /* synthetic */ DefaultTunnelConnectionImpl connect$default(TunnelClientDaemon tunnelClientDaemon, String string, int n, TunnelRequest tunnelRequest, SslContext sslContext, int n2, Object object) {
        if ((n2 & 8) != 0) {
            sslContext = null;
        }
        return tunnelClientDaemon.connect(string, n, tunnelRequest, sslContext);
    }

    public final void close(@NotNull DefaultTunnelConnectionImpl conn) {
        Intrinsics.checkParameterIsNotNull((Object)conn, (String)"conn");
        conn.close();
        this.tunnelConnectionRegistry.unregister(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void depose() {
        Lock lock = this.lock;
        boolean bl = false;
        lock.lock();
        try {
            boolean bl2 = false;
            this.tunnelConnectionRegistry.depose();
            this.cachedSslBootstraps.clear();
            this.localTcpClient.depose();
            this.workerGroup.shutdownGracefully();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private final void tryReconnect(DefaultTunnelConnectionImpl conn, boolean error) {
        block2: {
            block4: {
                boolean bl;
                int n;
                byte by;
                block3: {
                    block1: {
                        if (!conn.isActiveClosed()) break block1;
                        this.close(conn);
                        break block2;
                    }
                    if (!error) break block3;
                    by = this.retryConnectPolicy;
                    n = 2;
                    bl = false;
                    if ((byte)(by & n) == 2) break block3;
                    this.close(conn);
                    break block2;
                }
                by = this.retryConnectPolicy;
                n = 1;
                bl = false;
                if ((byte)(by & n) == 1) break block4;
                this.close(conn);
                break block2;
            }
            TimeUnit.SECONDS.sleep(3L);
            SslContext sslContext = conn.getSslContext();
            if (sslContext == null || (sslContext = this.getBootstrap(sslContext)) == null) {
                sslContext = this.bootstrap;
            }
            conn.open((Bootstrap)sslContext, this.openFailureCallback);
            OnTunnelConnectionListener onTunnelConnectionListener = this.onTunnelConnectionListener;
            if (onTunnelConnectionListener == null) break block2;
            onTunnelConnectionListener.onTunnelConnecting(conn, true);
        }
    }

    private final Bootstrap getBootstrap(@NotNull SslContext $this$bootstrap) {
        Bootstrap bootstrap = this.cachedSslBootstraps.get($this$bootstrap);
        if (bootstrap == null) {
            AbstractBootstrap abstractBootstrap = ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)this.workerGroup)).channel(NioSocketChannel.class)).option(ChannelOption.AUTO_READ, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).handler((ChannelHandler)new InnerChannelInitializer($this$bootstrap));
            boolean bl = false;
            boolean bl2 = false;
            Bootstrap it = (Bootstrap)abstractBootstrap;
            boolean bl3 = false;
            Map map = this.cachedSslBootstraps;
            Bootstrap bootstrap2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)bootstrap2, (String)"it");
            map.put($this$bootstrap, bootstrap2);
            AbstractBootstrap abstractBootstrap2 = abstractBootstrap;
            Intrinsics.checkExpressionValueIsNotNull((Object)abstractBootstrap2, (String)"Bootstrap()\n            \u2026slBootstraps[this] = it }");
            bootstrap = (Bootstrap)abstractBootstrap2;
        }
        return bootstrap;
    }

    public TunnelClientDaemon(int workerThreads, byte retryConnectPolicy, @Nullable OnTunnelConnectionListener onTunnelConnectionListener, @Nullable OnRemoteConnectionListener onRemoteConnectionListener) {
        Lazy lazy;
        this.retryConnectPolicy = retryConnectPolicy;
        this.onTunnelConnectionListener = onTunnelConnectionListener;
        this.onRemoteConnectionListener = onRemoteConnectionListener;
        TunnelClientDaemon tunnelClientDaemon = this;
        TunnelClientDaemon tunnelClientDaemon2 = this;
        boolean $i$f$loggerDelegate = false;
        tunnelClientDaemon2.logger$delegate = lazy = LazyKt.lazy((Function0)$special$$inlined$loggerDelegate$1.INSTANCE);
        this.workerGroup = workerThreads >= 0 ? new NioEventLoopGroup(workerThreads) : new NioEventLoopGroup();
        this.cachedSslBootstraps = new ConcurrentHashMap();
        this.bootstrap = new Bootstrap();
        this.lock = new ReentrantLock();
        this.openFailureCallback = (Function1)new Function1<DefaultTunnelConnectionImpl, Unit>(this){
            final /* synthetic */ TunnelClientDaemon this$0;

            public final void invoke(@NotNull DefaultTunnelConnectionImpl conn) {
                Intrinsics.checkParameterIsNotNull((Object)conn, (String)"conn");
                TunnelClientDaemon.access$tryReconnect(this.this$0, conn, false);
            }
            {
                this.this$0 = tunnelClientDaemon;
                super(1);
            }
        };
        this.onChannelStateListener = new OnChannelStateListenerImpl();
        this.tunnelConnectionRegistry = new TunnelConnectionRegistry();
        this.localTcpClient = new LocalTcpClient(this.workerGroup);
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group((EventLoopGroup)this.workerGroup)).channel(NioSocketChannel.class)).option(ChannelOption.AUTO_READ, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).handler((ChannelHandler)new InnerChannelInitializer(null));
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0002H\u0014R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Llighttunnel/client/TunnelClientDaemon$InnerChannelInitializer;", "Lio/netty/channel/ChannelInitializer;", "Lio/netty/channel/socket/SocketChannel;", "sslContext", "Lio/netty/handler/ssl/SslContext;", "(Llighttunnel/client/TunnelClientDaemon;Lio/netty/handler/ssl/SslContext;)V", "initChannel", "", "ch", "client"})
    private final class InnerChannelInitializer
    extends ChannelInitializer<SocketChannel> {
        private final SslContext sslContext;

        protected void initChannel(@Nullable SocketChannel ch) {
            if (ch == null) {
                return;
            }
            if (this.sslContext != null) {
                ch.pipeline().addFirst("ssl", (ChannelHandler)this.sslContext.newHandler(ch.alloc()));
            }
            ch.pipeline().addLast("heartbeat", (ChannelHandler)new HeartbeatHandler(false, 0L, 0L, 0L, null, 31, null)).addLast("decoder", (ChannelHandler)new ProtoMessageDecoder()).addLast("encoder", (ChannelHandler)new ProtoMessageEncoder()).addLast("handler", (ChannelHandler)new TunnelClientDaemonChannelHandler(TunnelClientDaemon.this.localTcpClient, TunnelClientDaemon.this.onChannelStateListener, TunnelClientDaemon.this.onRemoteConnectionListener));
        }

        public InnerChannelInitializer(SslContext sslContext) {
            this.sslContext = sslContext;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J$\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\f"}, d2={"Llighttunnel/client/TunnelClientDaemon$OnChannelStateListenerImpl;", "Llighttunnel/client/TunnelClientDaemonChannelHandler$OnChannelStateListener;", "(Llighttunnel/client/TunnelClientDaemon;)V", "onChannelConnected", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "conn", "Llighttunnel/client/conn/DefaultTunnelConnectionImpl;", "onChannelInactive", "extra", "Llighttunnel/client/TunnelClientDaemonChannelHandler$ChannelInactiveExtra;", "client"})
    private final class OnChannelStateListenerImpl
    implements TunnelClientDaemonChannelHandler.OnChannelStateListener {
        @Override
        public void onChannelInactive(@NotNull ChannelHandlerContext ctx, @Nullable DefaultTunnelConnectionImpl conn, @Nullable TunnelClientDaemonChannelHandler.ChannelInactiveExtra extra) {
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            TunnelClientDaemonChannelHandler.OnChannelStateListener.DefaultImpls.onChannelInactive(this, ctx, conn, extra);
            if (conn != null) {
                OnTunnelConnectionListener onTunnelConnectionListener = TunnelClientDaemon.this.onTunnelConnectionListener;
                if (onTunnelConnectionListener != null) {
                    TunnelClientDaemonChannelHandler.ChannelInactiveExtra channelInactiveExtra = extra;
                    onTunnelConnectionListener.onTunnelDisconnect(conn, channelInactiveExtra != null ? channelInactiveExtra.getCause() : null);
                }
                TunnelClientDaemonChannelHandler.ChannelInactiveExtra channelInactiveExtra = extra;
                TunnelClientDaemon.this.getLogger().trace("onChannelInactive: ", channelInactiveExtra != null ? channelInactiveExtra.getCause() : null);
                TunnelClientDaemonChannelHandler.ChannelInactiveExtra channelInactiveExtra2 = extra;
                if (channelInactiveExtra2 == null || !channelInactiveExtra2.getForceOff()) {
                    TunnelClientDaemonChannelHandler.ChannelInactiveExtra channelInactiveExtra3 = extra;
                    TunnelClientDaemon.this.tryReconnect(conn, (channelInactiveExtra3 != null ? channelInactiveExtra3.getCause() : null) != null);
                }
            }
        }

        @Override
        public void onChannelConnected(@NotNull ChannelHandlerContext ctx, @Nullable DefaultTunnelConnectionImpl conn) {
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
                TunnelClientDaemonChannelHandler.OnChannelStateListener.DefaultImpls.onChannelConnected(this, ctx, conn);
                if (conn == null) break block1;
                OnTunnelConnectionListener onTunnelConnectionListener = TunnelClientDaemon.this.onTunnelConnectionListener;
                if (onTunnelConnectionListener != null) {
                    onTunnelConnectionListener.onTunnelConnected(conn);
                }
            }
        }
    }
}

