/*
 * Decompiled with CFR 0.152.
 */
package lighttunnel.client;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.ssl.SslContext;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import lighttunnel.client.TunnelClient;
import lighttunnel.client.TunnelClient$$special$;
import lighttunnel.client.TunnelClientChannelHandler;
import lighttunnel.client.conn.TunnelConnection;
import lighttunnel.client.conn.TunnelConnectionRegistry;
import lighttunnel.client.local.LocalTcpClient;
import lighttunnel.http.server.HttpServer;
import lighttunnel.http.server.RouterMappings;
import lighttunnel.proto.HeartbeatHandler;
import lighttunnel.proto.ProtoMessageDecoder;
import lighttunnel.proto.ProtoMessageEncoder;
import lighttunnel.proto.RemoteConnection;
import lighttunnel.proto.TunnelRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 <2\u00020\u0001:\u0005<=>?@BI\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u000e\u0010,\u001a\u00020%2\u0006\u0010-\u001a\u00020$J*\u0010.\u001a\u00020$2\u0006\u0010/\u001a\u00020\u00072\u0006\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u0002022\n\b\u0002\u00103\u001a\u0004\u0018\u00010\u0012J\u0006\u00104\u001a\u00020%J\u0010\u00105\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\u0003H\u0002J\f\u00106\u001a\b\u0012\u0004\u0012\u00020$07J\u0018\u00108\u001a\u00020%2\u0006\u0010-\u001a\u00020$2\u0006\u00109\u001a\u00020:H\u0002J\b\u0010;\u001a\u00020%H\u0002R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001a\u001a\u00020\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b\u001c\u0010\u001dR\u0012\u0010 \u001a\u00060!R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\u00020\u000f*\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u0006A"}, d2={"Llighttunnel/client/TunnelClient;", "", "workerThreads", "", "retryConnectPolicy", "", "httpRpcBindAddr", "", "httpRpcBindPort", "onTunnelConnectionListener", "Llighttunnel/client/TunnelClient$OnTunnelConnectionListener;", "onRemoteConnectionListener", "Llighttunnel/client/TunnelClient$OnRemoteConnectionListener;", "(IBLjava/lang/String;Ljava/lang/Integer;Llighttunnel/client/TunnelClient$OnTunnelConnectionListener;Llighttunnel/client/TunnelClient$OnRemoteConnectionListener;)V", "bootstrap", "Lio/netty/bootstrap/Bootstrap;", "cachedSslBootstraps", "Ljava/util/concurrent/ConcurrentHashMap;", "Lio/netty/handler/ssl/SslContext;", "Ljava/lang/Integer;", "httpRpcServer", "Llighttunnel/http/server/HttpServer;", "localTcpClient", "Llighttunnel/client/local/LocalTcpClient;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "logger$delegate", "Lkotlin/Lazy;", "onChannelStateListener", "Llighttunnel/client/TunnelClient$OnChannelStateListenerImpl;", "openFailureCallback", "Lkotlin/Function1;", "Llighttunnel/client/conn/TunnelConnection;", "", "tunnelConnectionRegistry", "Llighttunnel/client/conn/TunnelConnectionRegistry;", "workerGroup", "Lio/netty/channel/nio/NioEventLoopGroup;", "getBootstrap", "(Lio/netty/handler/ssl/SslContext;)Lio/netty/bootstrap/Bootstrap;", "close", "conn", "connect", "serverAddr", "serverPort", "tunnelRequest", "Llighttunnel/proto/TunnelRequest;", "sslContext", "depose", "getHttpRpcServer", "getTunnelConnectionList", "", "tryReconnect", "error", "", "tryStartHttpRpcServer", "Companion", "InnerChannelInitializer", "OnChannelStateListenerImpl", "OnRemoteConnectionListener", "OnTunnelConnectionListener", "client"})
public final class TunnelClient {
    private final Lazy logger$delegate;
    private final ConcurrentHashMap<SslContext, Bootstrap> cachedSslBootstraps;
    private final Bootstrap bootstrap;
    private final NioEventLoopGroup workerGroup;
    private final LocalTcpClient localTcpClient;
    private final TunnelConnectionRegistry tunnelConnectionRegistry;
    private final ReentrantLock lock;
    private HttpServer httpRpcServer;
    private final Function1<TunnelConnection, Unit> openFailureCallback;
    private final OnChannelStateListenerImpl onChannelStateListener;
    private final byte retryConnectPolicy;
    private final String httpRpcBindAddr;
    private final Integer httpRpcBindPort;
    private final OnTunnelConnectionListener onTunnelConnectionListener;
    private final OnRemoteConnectionListener onRemoteConnectionListener;
    public static final byte RETRY_CONNECT_POLICY_LOSE = 1;
    public static final byte RETRY_CONNECT_POLICY_ERROR = 2;
    public static final Companion Companion = new Companion(null);

    private final Logger getLogger() {
        Lazy lazy = this.logger$delegate;
        TunnelClient tunnelClient = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    @NotNull
    public final TunnelConnection connect(@NotNull String serverAddr, int serverPort, @NotNull TunnelRequest tunnelRequest, @Nullable SslContext sslContext) {
        Intrinsics.checkParameterIsNotNull((Object)serverAddr, (String)"serverAddr");
        Intrinsics.checkParameterIsNotNull((Object)tunnelRequest, (String)"tunnelRequest");
        this.tryStartHttpRpcServer();
        TunnelConnection conn = TunnelConnection.-Companion.newInstance(serverAddr, serverPort, tunnelRequest, sslContext);
        SslContext sslContext2 = conn.getSslContext$client();
        if (sslContext2 == null || (sslContext2 = this.getBootstrap(sslContext2)) == null) {
            sslContext2 = this.bootstrap;
        }
        conn.open$client((Bootstrap)sslContext2, this.openFailureCallback);
        OnTunnelConnectionListener onTunnelConnectionListener = this.onTunnelConnectionListener;
        if (onTunnelConnectionListener != null) {
            onTunnelConnectionListener.onTunnelConnecting(conn, false);
        }
        this.tunnelConnectionRegistry.register(conn);
        return conn;
    }

    public static /* synthetic */ TunnelConnection connect$default(TunnelClient tunnelClient, String string, int n, TunnelRequest tunnelRequest, SslContext sslContext, int n2, Object object) {
        if ((n2 & 8) != 0) {
            sslContext = null;
        }
        return tunnelClient.connect(string, n, tunnelRequest, sslContext);
    }

    public final void close(@NotNull TunnelConnection conn) {
        Intrinsics.checkParameterIsNotNull((Object)conn, (String)"conn");
        conn.close$client();
        this.tunnelConnectionRegistry.unregister(conn);
    }

    @NotNull
    public final List<TunnelConnection> getTunnelConnectionList() {
        return this.tunnelConnectionRegistry.getConns();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void depose() {
        Lock lock = this.lock;
        boolean bl = false;
        lock.lock();
        try {
            boolean bl2 = false;
            this.tunnelConnectionRegistry.depose();
            this.cachedSslBootstraps.clear();
            this.localTcpClient.depose();
            HttpServer httpServer = this.httpRpcServer;
            if (httpServer != null) {
                httpServer.depose();
            }
            this.workerGroup.shutdownGracefully();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private final void tryReconnect(TunnelConnection conn, boolean error) {
        block2: {
            block4: {
                boolean bl;
                int n;
                byte by;
                block3: {
                    block1: {
                        if (!conn.isActiveClosed$client()) break block1;
                        this.close(conn);
                        break block2;
                    }
                    if (!error) break block3;
                    by = this.retryConnectPolicy;
                    n = 2;
                    bl = false;
                    if ((byte)(by & n) == 2) break block3;
                    this.close(conn);
                    break block2;
                }
                by = this.retryConnectPolicy;
                n = 1;
                bl = false;
                if ((byte)(by & n) == 1) break block4;
                this.close(conn);
                break block2;
            }
            TimeUnit.SECONDS.sleep(3L);
            SslContext sslContext = conn.getSslContext$client();
            if (sslContext == null || (sslContext = this.getBootstrap(sslContext)) == null) {
                sslContext = this.bootstrap;
            }
            conn.open$client((Bootstrap)sslContext, this.openFailureCallback);
            OnTunnelConnectionListener onTunnelConnectionListener = this.onTunnelConnectionListener;
            if (onTunnelConnectionListener == null) break block2;
            onTunnelConnectionListener.onTunnelConnecting(conn, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void tryStartHttpRpcServer() {
        Lock lock = this.lock;
        boolean bl = false;
        lock.lock();
        try {
            boolean bl2 = false;
            if (this.httpRpcServer == null && this.httpRpcBindPort != null) {
                HttpServer httpServer = this.getHttpRpcServer(this.httpRpcBindPort);
                boolean bl3 = false;
                boolean bl4 = false;
                HttpServer it = httpServer;
                boolean bl5 = false;
                this.httpRpcServer = it;
                httpServer.start();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private final HttpServer getHttpRpcServer(int httpRpcBindPort) {
        return new HttpServer(this.workerGroup, this.workerGroup, this.httpRpcBindAddr, httpRpcBindPort, null, 0, (Function1)new Function1<RouterMappings, Unit>(this){
            final /* synthetic */ TunnelClient this$0;

            public final void invoke(@NotNull RouterMappings $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                $receiver.route("/api/version", (Function1)getHttpRpcServer.1.INSTANCE);
                $receiver.route("/api/snapshot", (Function1)new Function1<FullHttpRequest, DefaultFullHttpResponse>(this){
                    final /* synthetic */ getHttpRpcServer.1 this$0;

                    @NotNull
                    public final DefaultFullHttpResponse invoke(@NotNull FullHttpRequest it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        JSONArray jSONArray = TunnelClient.access$getTunnelConnectionRegistry$p(this.this$0.this$0).toJson();
                        boolean bl = false;
                        boolean bl2 = false;
                        JSONArray it2 = jSONArray;
                        boolean bl3 = false;
                        ByteBuf content = Unpooled.copiedBuffer((CharSequence)it2.toString(2), (Charset)Charsets.UTF_8);
                        jSONArray = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, content);
                        bl = false;
                        bl2 = false;
                        it2 = jSONArray;
                        boolean bl4 = false;
                        it2.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_JSON).set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)content.readableBytes());
                        return jSONArray;
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = tunnelClient;
                super(1);
            }
        }, 48, null);
    }

    private final Bootstrap getBootstrap(@NotNull SslContext $this$bootstrap) {
        Bootstrap bootstrap = this.cachedSslBootstraps.get($this$bootstrap);
        if (bootstrap == null) {
            AbstractBootstrap abstractBootstrap = ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)this.workerGroup)).channel(NioSocketChannel.class)).option(ChannelOption.AUTO_READ, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).handler((ChannelHandler)new InnerChannelInitializer($this$bootstrap));
            boolean bl = false;
            boolean bl2 = false;
            Bootstrap it = (Bootstrap)abstractBootstrap;
            boolean bl3 = false;
            Map map = this.cachedSslBootstraps;
            Bootstrap bootstrap2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)bootstrap2, (String)"it");
            map.put($this$bootstrap, bootstrap2);
            AbstractBootstrap abstractBootstrap2 = abstractBootstrap;
            Intrinsics.checkExpressionValueIsNotNull((Object)abstractBootstrap2, (String)"Bootstrap()\n            \u2026slBootstraps[this] = it }");
            bootstrap = (Bootstrap)abstractBootstrap2;
        }
        return bootstrap;
    }

    public TunnelClient(int workerThreads, byte retryConnectPolicy, @Nullable String httpRpcBindAddr, @Nullable Integer httpRpcBindPort, @Nullable OnTunnelConnectionListener onTunnelConnectionListener, @Nullable OnRemoteConnectionListener onRemoteConnectionListener) {
        Lazy lazy;
        this.retryConnectPolicy = retryConnectPolicy;
        this.httpRpcBindAddr = httpRpcBindAddr;
        this.httpRpcBindPort = httpRpcBindPort;
        this.onTunnelConnectionListener = onTunnelConnectionListener;
        this.onRemoteConnectionListener = onRemoteConnectionListener;
        TunnelClient tunnelClient = this;
        TunnelClient tunnelClient2 = this;
        boolean $i$f$loggerDelegate = false;
        tunnelClient2.logger$delegate = lazy = LazyKt.lazy((Function0)$special$$inlined$loggerDelegate$1.INSTANCE);
        this.cachedSslBootstraps = new ConcurrentHashMap();
        this.bootstrap = new Bootstrap();
        this.workerGroup = workerThreads >= 0 ? new NioEventLoopGroup(workerThreads) : new NioEventLoopGroup();
        this.tunnelConnectionRegistry = new TunnelConnectionRegistry();
        this.lock = new ReentrantLock();
        this.openFailureCallback = (Function1)new Function1<TunnelConnection, Unit>(this){
            final /* synthetic */ TunnelClient this$0;

            public final void invoke(@NotNull TunnelConnection conn) {
                Intrinsics.checkParameterIsNotNull((Object)conn, (String)"conn");
                TunnelClient.access$tryReconnect(this.this$0, conn, false);
            }
            {
                this.this$0 = tunnelClient;
                super(1);
            }
        };
        this.onChannelStateListener = new OnChannelStateListenerImpl();
        this.localTcpClient = new LocalTcpClient(this.workerGroup);
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group((EventLoopGroup)this.workerGroup)).channel(NioSocketChannel.class)).option(ChannelOption.AUTO_READ, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).handler((ChannelHandler)new InnerChannelInitializer(null));
    }

    public /* synthetic */ TunnelClient(int n, byte by, String string, Integer n2, OnTunnelConnectionListener onTunnelConnectionListener, OnRemoteConnectionListener onRemoteConnectionListener, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = -1;
        }
        if ((n3 & 2) != 0) {
            int n4 = 1;
            int n5 = 2;
            boolean bl = false;
            by = (byte)(n4 | n5);
        }
        if ((n3 & 4) != 0) {
            string = null;
        }
        if ((n3 & 8) != 0) {
            n2 = null;
        }
        if ((n3 & 0x10) != 0) {
            onTunnelConnectionListener = null;
        }
        if ((n3 & 0x20) != 0) {
            onRemoteConnectionListener = null;
        }
        this(n, by, string, n2, onTunnelConnectionListener, onRemoteConnectionListener);
    }

    public TunnelClient() {
        this(0, 0, null, null, null, null, 63, null);
    }

    public static final /* synthetic */ TunnelConnectionRegistry access$getTunnelConnectionRegistry$p(TunnelClient $this) {
        return $this.tunnelConnectionRegistry;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0002H\u0014R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Llighttunnel/client/TunnelClient$InnerChannelInitializer;", "Lio/netty/channel/ChannelInitializer;", "Lio/netty/channel/socket/SocketChannel;", "sslContext", "Lio/netty/handler/ssl/SslContext;", "(Llighttunnel/client/TunnelClient;Lio/netty/handler/ssl/SslContext;)V", "initChannel", "", "ch", "client"})
    private final class InnerChannelInitializer
    extends ChannelInitializer<SocketChannel> {
        private final SslContext sslContext;

        protected void initChannel(@Nullable SocketChannel ch) {
            if (ch == null) {
                return;
            }
            if (this.sslContext != null) {
                ch.pipeline().addFirst("ssl", (ChannelHandler)this.sslContext.newHandler(ch.alloc()));
            }
            ch.pipeline().addLast("heartbeat", (ChannelHandler)new HeartbeatHandler(false, 0L, 0L, 0L, null, 31, null)).addLast("decoder", (ChannelHandler)new ProtoMessageDecoder()).addLast("encoder", (ChannelHandler)new ProtoMessageEncoder()).addLast("handler", (ChannelHandler)new TunnelClientChannelHandler(TunnelClient.this.localTcpClient, TunnelClient.this.onChannelStateListener, TunnelClient.this.onRemoteConnectionListener));
        }

        public InnerChannelInitializer(SslContext sslContext) {
            this.sslContext = sslContext;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J$\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\f"}, d2={"Llighttunnel/client/TunnelClient$OnChannelStateListenerImpl;", "Llighttunnel/client/TunnelClientChannelHandler$OnChannelStateListener;", "(Llighttunnel/client/TunnelClient;)V", "onChannelConnected", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "conn", "Llighttunnel/client/conn/TunnelConnection;", "onChannelInactive", "extra", "Llighttunnel/client/TunnelClientChannelHandler$ChannelInactiveExtra;", "client"})
    private final class OnChannelStateListenerImpl
    implements TunnelClientChannelHandler.OnChannelStateListener {
        @Override
        public void onChannelInactive(@NotNull ChannelHandlerContext ctx, @Nullable TunnelConnection conn, @Nullable TunnelClientChannelHandler.ChannelInactiveExtra extra) {
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            TunnelClientChannelHandler.OnChannelStateListener.DefaultImpls.onChannelInactive(this, ctx, conn, extra);
            if (conn != null) {
                OnTunnelConnectionListener onTunnelConnectionListener = TunnelClient.this.onTunnelConnectionListener;
                if (onTunnelConnectionListener != null) {
                    TunnelClientChannelHandler.ChannelInactiveExtra channelInactiveExtra = extra;
                    onTunnelConnectionListener.onTunnelDisconnect(conn, channelInactiveExtra != null ? channelInactiveExtra.getCause() : null);
                }
                TunnelClientChannelHandler.ChannelInactiveExtra channelInactiveExtra = extra;
                TunnelClient.this.getLogger().trace("onChannelInactive: ", channelInactiveExtra != null ? channelInactiveExtra.getCause() : null);
                TunnelClientChannelHandler.ChannelInactiveExtra channelInactiveExtra2 = extra;
                if (channelInactiveExtra2 == null || !channelInactiveExtra2.getForceOff()) {
                    TunnelClientChannelHandler.ChannelInactiveExtra channelInactiveExtra3 = extra;
                    TunnelClient.this.tryReconnect(conn, (channelInactiveExtra3 != null ? channelInactiveExtra3.getCause() : null) != null);
                }
            }
        }

        @Override
        public void onChannelConnected(@NotNull ChannelHandlerContext ctx, @Nullable TunnelConnection conn) {
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
                TunnelClientChannelHandler.OnChannelStateListener.DefaultImpls.onChannelConnected(this, ctx, conn);
                if (conn == null) break block1;
                OnTunnelConnectionListener onTunnelConnectionListener = TunnelClient.this.onTunnelConnectionListener;
                if (onTunnelConnectionListener != null) {
                    onTunnelConnectionListener.onTunnelConnected(conn);
                }
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\f"}, d2={"Llighttunnel/client/TunnelClient$OnTunnelConnectionListener;", "", "onTunnelConnected", "", "conn", "Llighttunnel/client/conn/TunnelConnection;", "onTunnelConnecting", "retryConnect", "", "onTunnelDisconnect", "cause", "", "client"})
    public static interface OnTunnelConnectionListener {
        public void onTunnelConnecting(@NotNull TunnelConnection var1, boolean var2);

        public void onTunnelConnected(@NotNull TunnelConnection var1);

        public void onTunnelDisconnect(@NotNull TunnelConnection var1, @Nullable Throwable var2);

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            public static void onTunnelConnecting(OnTunnelConnectionListener $this, @NotNull TunnelConnection conn, boolean retryConnect) {
                Intrinsics.checkParameterIsNotNull((Object)conn, (String)"conn");
            }

            public static void onTunnelConnected(OnTunnelConnectionListener $this, @NotNull TunnelConnection conn) {
                Intrinsics.checkParameterIsNotNull((Object)conn, (String)"conn");
            }

            public static void onTunnelDisconnect(OnTunnelConnectionListener $this, @NotNull TunnelConnection conn, @Nullable Throwable cause) {
                Intrinsics.checkParameterIsNotNull((Object)conn, (String)"conn");
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Llighttunnel/client/TunnelClient$OnRemoteConnectionListener;", "", "onRemoteConnected", "", "conn", "Llighttunnel/proto/RemoteConnection;", "onRemoteDisconnect", "client"})
    public static interface OnRemoteConnectionListener {
        public void onRemoteConnected(@NotNull RemoteConnection var1);

        public void onRemoteDisconnect(@NotNull RemoteConnection var1);

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            public static void onRemoteConnected(OnRemoteConnectionListener $this, @NotNull RemoteConnection conn) {
                Intrinsics.checkParameterIsNotNull((Object)conn, (String)"conn");
            }

            public static void onRemoteDisconnect(OnRemoteConnectionListener $this, @NotNull RemoteConnection conn) {
                Intrinsics.checkParameterIsNotNull((Object)conn, (String)"conn");
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Llighttunnel/client/TunnelClient$Companion;", "", "()V", "RETRY_CONNECT_POLICY_ERROR", "", "RETRY_CONNECT_POLICY_LOSE", "client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

