/*
 * Decompiled with CFR 0.152.
 */
package lighttunnel.client;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import lighttunnel.client.TunnelClient;
import lighttunnel.client.TunnelClientChannelHandler$$special$;
import lighttunnel.client.TunnelClientChannelHandler$WhenMappings;
import lighttunnel.client.conn.TunnelConnection;
import lighttunnel.client.local.LocalTcpClient;
import lighttunnel.client.util.-ConstsKt;
import lighttunnel.proto.ProtoMessage;
import lighttunnel.proto.ProtoMessageType;
import lighttunnel.proto.RemoteInfo;
import lighttunnel.proto.TunnelRequest;
import lighttunnel.util.LongUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001 B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u001c\u0010\u0014\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0002H\u0014J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0002H\u0002J\u0018\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0002H\u0002J\u0018\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0002H\u0002J\u0018\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0002H\u0002J\u0018\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0002H\u0002J\u0018\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0002H\u0002J\u0018\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0002H\u0002J\u001c\u0010\u001d\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Llighttunnel/client/TunnelClientChannelHandler;", "Lio/netty/channel/SimpleChannelInboundHandler;", "Llighttunnel/proto/ProtoMessage;", "localTcpClient", "Llighttunnel/client/local/LocalTcpClient;", "onChannelStateListener", "Llighttunnel/client/TunnelClientChannelHandler$OnChannelStateListener;", "onRemoteConnectListener", "Llighttunnel/client/TunnelClient$OnRemoteConnectListener;", "(Llighttunnel/client/local/LocalTcpClient;Llighttunnel/client/TunnelClientChannelHandler$OnChannelStateListener;Llighttunnel/client/TunnelClient$OnRemoteConnectListener;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "logger$delegate", "Lkotlin/Lazy;", "channelInactive", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "channelRead0", "msg", "doHandleForcedOfflineMessage", "doHandlePingMessage", "doHandleRemoteConnectedMessage", "doHandleRemoteDisconnectMessage", "doHandleResponseErrMessage", "doHandleResponseOkMessage", "doHandleTransferMessage", "exceptionCaught", "cause", "", "OnChannelStateListener", "client"})
public final class TunnelClientChannelHandler
extends SimpleChannelInboundHandler<ProtoMessage> {
    private final Lazy logger$delegate;
    private final LocalTcpClient localTcpClient;
    private final OnChannelStateListener onChannelStateListener;
    private final TunnelClient.OnRemoteConnectListener onRemoteConnectListener;

    private final Logger getLogger() {
        Lazy lazy = this.logger$delegate;
        TunnelClientChannelHandler tunnelClientChannelHandler = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    public void channelInactive(@Nullable ChannelHandlerContext ctx) throws Exception {
        this.getLogger().trace("channelInactive: {}", (Object)ctx);
        if (ctx == null) {
            super.channelInactive(ctx);
            return;
        }
        Long tunnelId = (Long)ctx.channel().attr(-ConstsKt.getAK_TUNNEL_ID()).get();
        Long sessionId = (Long)ctx.channel().attr(-ConstsKt.getAK_SESSION_ID()).get();
        if (tunnelId != null && sessionId != null) {
            Channel channel = this.localTcpClient.removeLocalChannel(tunnelId, sessionId);
            if (channel != null) {
                channel.close();
            }
        }
        TunnelConnection fd = (TunnelConnection)ctx.channel().attr(-ConstsKt.getAK_TUNNEL_CONNECTION()).get();
        Throwable cause = (Throwable)ctx.channel().attr(-ConstsKt.getAK_ERROR_CAUSE()).get();
        Boolean bl = (Boolean)ctx.channel().attr(-ConstsKt.getAK_FORCED_OFFLINE()).get();
        boolean forcedOffline = bl != null ? bl : false;
        this.onChannelStateListener.onChannelInactive(ctx, fd, forcedOffline, cause);
        super.channelInactive(ctx);
    }

    public void exceptionCaught(@Nullable ChannelHandlerContext ctx, @Nullable Throwable cause) throws Exception {
        this.getLogger().trace("exceptionCaught: {}", (Object)ctx, (Object)cause);
        if (ctx == null) {
            return;
        }
        ctx.channel().writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    protected void channelRead0(@Nullable ChannelHandlerContext ctx, @Nullable ProtoMessage msg) throws Exception {
        this.getLogger().trace("channelRead0 : {}, {}", (Object)ctx, (Object)msg);
        if (ctx == null) {
            return;
        }
        if (msg == null) {
            return;
        }
        switch (TunnelClientChannelHandler$WhenMappings.$EnumSwitchMapping$0[msg.getType().ordinal()]) {
            case 1: {
                this.doHandlePingMessage(ctx, msg);
                break;
            }
            case 2: {
                this.doHandleResponseOkMessage(ctx, msg);
                break;
            }
            case 3: {
                this.doHandleResponseErrMessage(ctx, msg);
                break;
            }
            case 4: {
                this.doHandleTransferMessage(ctx, msg);
                break;
            }
            case 5: {
                this.doHandleRemoteConnectedMessage(ctx, msg);
                break;
            }
            case 6: {
                this.doHandleRemoteDisconnectMessage(ctx, msg);
                break;
            }
            case 7: {
                this.doHandleForcedOfflineMessage(ctx, msg);
                break;
            }
        }
    }

    private final void doHandlePingMessage(ChannelHandlerContext ctx, ProtoMessage msg) throws Exception {
        this.getLogger().trace("doHandlePingMessage : {}, {}", (Object)ctx, (Object)msg);
        ctx.writeAndFlush((Object)new ProtoMessage(ProtoMessageType.PONG, null, null, 6, null));
    }

    private final void doHandleResponseOkMessage(ChannelHandlerContext ctx, ProtoMessage msg) throws Exception {
        TunnelConnection fd;
        this.getLogger().trace("doHandleResponseOkMessage : {}, {}", (Object)ctx, (Object)msg);
        TunnelRequest request = TunnelRequest.Companion.fromBytes(msg.getData());
        ChannelHandlerContext channelHandlerContext = ctx;
        boolean bl = false;
        boolean bl2 = false;
        ChannelHandlerContext $this$run = channelHandlerContext;
        boolean bl3 = false;
        $this$run.channel().attr(-ConstsKt.getAK_TUNNEL_ID()).set((Object)msg.getTunnelId());
        $this$run.channel().attr(-ConstsKt.getAK_TUNNEL_REQUEST()).set((Object)request);
        $this$run.channel().attr(-ConstsKt.getAK_ERROR_CAUSE()).set(null);
        TunnelConnection tunnelConnection = fd = (TunnelConnection)ctx.channel().attr(-ConstsKt.getAK_TUNNEL_CONNECTION()).get();
        if (tunnelConnection != null) {
            tunnelConnection.setFinalTunnelRequest$client(request);
        }
        this.getLogger().debug("Opened Tunnel: {}", (Object)request);
        this.onChannelStateListener.onChannelConnected(ctx, fd);
    }

    private final void doHandleResponseErrMessage(ChannelHandlerContext ctx, ProtoMessage msg) throws Exception {
        this.getLogger().trace("doHandleResponseErrMessage : {}, {}", (Object)ctx, (Object)msg);
        byte[] byArray = msg.getHead();
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
        Charset charset2 = charset;
        boolean bl = false;
        String errMessage = new String(byArray, charset2);
        ctx.channel().attr(-ConstsKt.getAK_TUNNEL_ID()).set(null);
        ctx.channel().attr(-ConstsKt.getAK_TUNNEL_REQUEST()).set(null);
        ctx.channel().attr(-ConstsKt.getAK_ERROR_CAUSE()).set((Object)new Exception(errMessage));
        ctx.channel().close();
        this.getLogger().debug("Open Tunnel Error: {}", (Object)errMessage);
    }

    private final void doHandleTransferMessage(ChannelHandlerContext ctx, ProtoMessage msg) throws Exception {
        TunnelRequest tunnelRequest;
        this.getLogger().trace("doHandleTransferMessage : {}, {}", (Object)ctx, (Object)msg);
        ctx.channel().attr(-ConstsKt.getAK_TUNNEL_ID()).set((Object)msg.getTunnelId());
        ctx.channel().attr(-ConstsKt.getAK_SESSION_ID()).set((Object)msg.getSessionId());
        TunnelRequest tunnelRequest2 = tunnelRequest = (TunnelRequest)ctx.channel().attr(-ConstsKt.getAK_TUNNEL_REQUEST()).get();
        Object object = tunnelRequest2 != null ? tunnelRequest2.getType() : null;
        if (object != null) {
            switch (TunnelClientChannelHandler$WhenMappings.$EnumSwitchMapping$1[object.ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    String string = tunnelRequest.getLocalAddr();
                    int n = tunnelRequest.getLocalPort();
                    long l = msg.getTunnelId();
                    long l2 = msg.getSessionId();
                    Channel channel = ctx.channel();
                    Intrinsics.checkExpressionValueIsNotNull((Object)channel, (String)"ctx.channel()");
                    this.localTcpClient.acquireLocalChannel(string, n, l, l2, channel, new LocalTcpClient.OnArriveLocalChannelCallback(this, msg, ctx){
                        final /* synthetic */ TunnelClientChannelHandler this$0;
                        final /* synthetic */ ProtoMessage $msg;
                        final /* synthetic */ ChannelHandlerContext $ctx;

                        public void onArrived(@NotNull Channel localChannel) {
                            Intrinsics.checkParameterIsNotNull((Object)localChannel, (String)"localChannel");
                            TunnelClientChannelHandler.access$getLogger$p(this.this$0).trace("onArrived: {}", (Object)localChannel);
                            localChannel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])this.$msg.getData()));
                        }

                        public void onUnableArrive(@NotNull Throwable cause) {
                            Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
                            LocalTcpClient.OnArriveLocalChannelCallback.DefaultImpls.onUnableArrive(this, cause);
                            byte[] head = LongUtil.INSTANCE.toBytes(new long[]{this.$msg.getTunnelId(), this.$msg.getSessionId()});
                            this.$ctx.writeAndFlush((Object)new ProtoMessage(ProtoMessageType.LOCAL_DISCONNECT, head, null, 4, null));
                        }
                        {
                            this.this$0 = $outer;
                            this.$msg = $captured_local_variable$1;
                            this.$ctx = $captured_local_variable$2;
                        }
                    });
                    break;
                }
            }
        }
    }

    private final void doHandleRemoteConnectedMessage(ChannelHandlerContext ctx, ProtoMessage msg) throws Exception {
        RemoteInfo remoteInfo;
        this.getLogger().trace("doHandleRemoteConnectedMessage : {}, {}", (Object)ctx, (Object)msg);
        ctx.channel().attr(-ConstsKt.getAK_TUNNEL_ID()).set((Object)msg.getTunnelId());
        ctx.channel().attr(-ConstsKt.getAK_SESSION_ID()).set((Object)msg.getSessionId());
        try {
            remoteInfo = RemoteInfo.Companion.fromBytes(msg.getData());
        }
        catch (Exception e) {
            remoteInfo = null;
        }
        RemoteInfo remoteInfo2 = remoteInfo;
        TunnelClient.OnRemoteConnectListener onRemoteConnectListener = this.onRemoteConnectListener;
        if (onRemoteConnectListener != null) {
            onRemoteConnectListener.onRemoteConnected(remoteInfo2);
        }
        TunnelRequest tunnelRequest = (TunnelRequest)ctx.channel().attr(-ConstsKt.getAK_TUNNEL_REQUEST()).get();
        if (tunnelRequest != null) {
            String string = tunnelRequest.getLocalAddr();
            int n = tunnelRequest.getLocalPort();
            long l = msg.getTunnelId();
            long l2 = msg.getSessionId();
            Channel channel = ctx.channel();
            Intrinsics.checkExpressionValueIsNotNull((Object)channel, (String)"ctx.channel()");
            LocalTcpClient.acquireLocalChannel$default(this.localTcpClient, string, n, l, l2, channel, null, 32, null);
        }
    }

    private final void doHandleRemoteDisconnectMessage(ChannelHandlerContext ctx, ProtoMessage msg) throws Exception {
        block3: {
            Channel channel;
            RemoteInfo remoteInfo;
            this.getLogger().trace("doHandleRemoteDisconnectMessage : {}, {}", (Object)ctx, (Object)msg);
            try {
                remoteInfo = RemoteInfo.Companion.fromBytes(msg.getData());
            }
            catch (Exception e) {
                remoteInfo = null;
            }
            RemoteInfo remoteInfo2 = remoteInfo;
            TunnelClient.OnRemoteConnectListener onRemoteConnectListener = this.onRemoteConnectListener;
            if (onRemoteConnectListener != null) {
                onRemoteConnectListener.onRemoteDisconnect(remoteInfo2);
            }
            if ((channel = this.localTcpClient.removeLocalChannel(msg.getTunnelId(), msg.getSessionId())) == null || (channel = channel.writeAndFlush((Object)Unpooled.EMPTY_BUFFER)) == null) break block3;
            channel.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private final void doHandleForcedOfflineMessage(ChannelHandlerContext ctx, ProtoMessage msg) throws Exception {
        this.getLogger().trace("doHandleForcedOfflineMessage : {}, {}", (Object)ctx, (Object)msg);
        ctx.channel().attr(-ConstsKt.getAK_TUNNEL_ID()).set(null);
        ctx.channel().attr(-ConstsKt.getAK_TUNNEL_REQUEST()).set(null);
        ctx.channel().attr(-ConstsKt.getAK_FORCED_OFFLINE()).set((Object)true);
        ctx.channel().attr(-ConstsKt.getAK_ERROR_CAUSE()).set((Object)new Exception("ForcedOffline"));
        ctx.channel().writeAndFlush((Object)new ProtoMessage(ProtoMessageType.FORCED_OFFLINE_REPLY, null, null, 6, null)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public TunnelClientChannelHandler(@NotNull LocalTcpClient localTcpClient, @NotNull OnChannelStateListener onChannelStateListener2, @Nullable TunnelClient.OnRemoteConnectListener onRemoteConnectListener) {
        Lazy lazy;
        Intrinsics.checkParameterIsNotNull((Object)localTcpClient, (String)"localTcpClient");
        Intrinsics.checkParameterIsNotNull((Object)onChannelStateListener2, (String)"onChannelStateListener");
        this.localTcpClient = localTcpClient;
        this.onChannelStateListener = onChannelStateListener2;
        this.onRemoteConnectListener = onRemoteConnectListener;
        TunnelClientChannelHandler tunnelClientChannelHandler = this;
        TunnelClientChannelHandler tunnelClientChannelHandler2 = this;
        boolean $i$f$loggerDelegate = false;
        tunnelClientChannelHandler2.logger$delegate = lazy = LazyKt.lazy((Function0)$special$$inlined$loggerDelegate$1.INSTANCE);
    }

    public static final /* synthetic */ Logger access$getLogger$p(TunnelClientChannelHandler $this) {
        return $this.getLogger();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0003\n\u0000\b`\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J,\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016\u00a8\u0006\r"}, d2={"Llighttunnel/client/TunnelClientChannelHandler$OnChannelStateListener;", "", "onChannelConnected", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "conn", "Llighttunnel/client/conn/TunnelConnection;", "onChannelInactive", "forceOffline", "", "cause", "", "client"})
    public static interface OnChannelStateListener {
        public void onChannelInactive(@NotNull ChannelHandlerContext var1, @Nullable TunnelConnection var2, boolean var3, @Nullable Throwable var4);

        public void onChannelConnected(@NotNull ChannelHandlerContext var1, @Nullable TunnelConnection var2);

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            public static void onChannelInactive(OnChannelStateListener $this, @NotNull ChannelHandlerContext ctx, @Nullable TunnelConnection conn, boolean forceOffline, @Nullable Throwable cause) {
                Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            }

            public static void onChannelConnected(OnChannelStateListener $this, @NotNull ChannelHandlerContext ctx, @Nullable TunnelConnection conn) {
                Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            }
        }
    }
}

