/*
 * Decompiled with CFR 0.152.
 */
package lighttunnel.client;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.ssl.SslContext;
import io.netty.util.concurrent.Future;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import lighttunnel.client.TunnelClient;
import lighttunnel.client.TunnelClient$$special$;
import lighttunnel.client.TunnelClient$startWebServer$;
import lighttunnel.client.TunnelClientChannelHandler;
import lighttunnel.client.conn.TunnelConnection;
import lighttunnel.client.conn.TunnelConnectionRegistry;
import lighttunnel.client.local.LocalTcpClient;
import lighttunnel.proto.HeartbeatHandler;
import lighttunnel.proto.ProtoMessageDecoder;
import lighttunnel.proto.ProtoMessageEncoder;
import lighttunnel.proto.RemoteInfo;
import lighttunnel.proto.TunnelRequest;
import lighttunnel.web.server.RouterConfig;
import lighttunnel.web.server.WebServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u009f\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004*\u0001\u001e\u0018\u0000 ?2\u00020\u0001:\u0003?@ABI\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u000e\u0010-\u001a\u00020#2\u0006\u0010.\u001a\u00020\"J*\u0010/\u001a\u00020\"2\u0006\u00100\u001a\u00020\u00072\u0006\u00101\u001a\u00020\u00032\u0006\u00102\u001a\u0002032\n\b\u0002\u00104\u001a\u0004\u0018\u00010\u0012J\u0016\u00105\u001a\u0012\u0012\u0002\b\u0003 7*\b\u0012\u0002\b\u0003\u0018\u00010606J\u0018\u00108\u001a\b\u0012\u0004\u0012\u00020:092\b\u00104\u001a\u0004\u0018\u00010\u0012H\u0002J\b\u0010;\u001a\u00020#H\u0002J\u0018\u0010<\u001a\u00020#2\u0006\u0010.\u001a\u00020\"2\u0006\u0010=\u001a\u00020>H\u0002R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0017\u001a\u00020\u00188BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001aR\u0010\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001fR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010&R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\u00020\u000f*\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,\u00a8\u0006B"}, d2={"Llighttunnel/client/TunnelClient;", "", "workerThreads", "", "retryConnectPolicy", "", "webAddr", "", "webBindPort", "onTunnelStateListener", "Llighttunnel/client/TunnelClient$OnTunnelStateListener;", "onRemoteConnectListener", "Llighttunnel/client/TunnelClient$OnRemoteConnectListener;", "(IBLjava/lang/String;Ljava/lang/Integer;Llighttunnel/client/TunnelClient$OnTunnelStateListener;Llighttunnel/client/TunnelClient$OnRemoteConnectListener;)V", "bootstrap", "Lio/netty/bootstrap/Bootstrap;", "cachedSslBootstraps", "Ljava/util/concurrent/ConcurrentHashMap;", "Lio/netty/handler/ssl/SslContext;", "localTcpClient", "Llighttunnel/client/local/LocalTcpClient;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "logger$delegate", "Lkotlin/Lazy;", "onChannelStateListener", "lighttunnel/client/TunnelClient$onChannelStateListener$1", "Llighttunnel/client/TunnelClient$onChannelStateListener$1;", "openFailureCallback", "Lkotlin/Function1;", "Llighttunnel/client/conn/TunnelConnection;", "", "tunnelConnectRegistry", "Llighttunnel/client/conn/TunnelConnectionRegistry;", "Ljava/lang/Integer;", "webServer", "Llighttunnel/web/server/WebServer;", "workerGroup", "Lio/netty/channel/nio/NioEventLoopGroup;", "getBootstrap", "(Lio/netty/handler/ssl/SslContext;)Lio/netty/bootstrap/Bootstrap;", "close", "conn", "connect", "serverAddr", "serverPort", "tunnelRequest", "Llighttunnel/proto/TunnelRequest;", "sslContext", "depose", "Lio/netty/util/concurrent/Future;", "kotlin.jvm.PlatformType", "newChannelInitializer", "Lio/netty/channel/ChannelInitializer;", "Lio/netty/channel/socket/SocketChannel;", "startWebServer", "tryReconnect", "error", "", "Companion", "OnRemoteConnectListener", "OnTunnelStateListener", "client"})
public final class TunnelClient {
    private final Lazy logger$delegate;
    private final ConcurrentHashMap<SslContext, Bootstrap> cachedSslBootstraps;
    private final Bootstrap bootstrap;
    private final NioEventLoopGroup workerGroup;
    private final LocalTcpClient localTcpClient;
    private final TunnelConnectionRegistry tunnelConnectRegistry;
    private WebServer webServer;
    private final ReentrantLock lock;
    private final Function1<TunnelConnection, Unit> openFailureCallback;
    private final onChannelStateListener.1 onChannelStateListener;
    private final int workerThreads;
    private final byte retryConnectPolicy;
    private final String webAddr;
    private final Integer webBindPort;
    private final OnTunnelStateListener onTunnelStateListener;
    private final OnRemoteConnectListener onRemoteConnectListener;
    public static final byte RETRY_CONNECT_POLICY_LOSE = 1;
    public static final byte RETRY_CONNECT_POLICY_ERROR = 2;
    public static final Companion Companion = new Companion(null);

    private final Logger getLogger() {
        Lazy lazy = this.logger$delegate;
        TunnelClient tunnelClient = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    @NotNull
    public final TunnelConnection connect(@NotNull String serverAddr, int serverPort, @NotNull TunnelRequest tunnelRequest, @Nullable SslContext sslContext) {
        Intrinsics.checkParameterIsNotNull((Object)serverAddr, (String)"serverAddr");
        Intrinsics.checkParameterIsNotNull((Object)tunnelRequest, (String)"tunnelRequest");
        this.startWebServer();
        TunnelConnection conn = new TunnelConnection(serverAddr, serverPort, tunnelRequest, sslContext);
        SslContext sslContext2 = conn.getSslContext$client();
        if (sslContext2 == null || (sslContext2 = this.getBootstrap(sslContext2)) == null) {
            sslContext2 = this.bootstrap;
        }
        conn.open$client((Bootstrap)sslContext2, this.openFailureCallback);
        OnTunnelStateListener onTunnelStateListener = this.onTunnelStateListener;
        if (onTunnelStateListener != null) {
            onTunnelStateListener.onConnecting(conn, false);
        }
        this.tunnelConnectRegistry.register(conn);
        return conn;
    }

    public static /* synthetic */ TunnelConnection connect$default(TunnelClient tunnelClient, String string, int n, TunnelRequest tunnelRequest, SslContext sslContext, int n2, Object object) {
        if ((n2 & 8) != 0) {
            sslContext = null;
        }
        return tunnelClient.connect(string, n, tunnelRequest, sslContext);
    }

    public final void close(@NotNull TunnelConnection conn) {
        Intrinsics.checkParameterIsNotNull((Object)conn, (String)"conn");
        conn.close$client();
        this.tunnelConnectRegistry.unregister(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Future<?> depose() {
        Future future;
        Lock lock = this.lock;
        boolean bl = false;
        lock.lock();
        try {
            boolean bl2 = false;
            this.tunnelConnectRegistry.depose();
            this.cachedSslBootstraps.clear();
            this.localTcpClient.depose();
            WebServer webServer = this.webServer;
            if (webServer != null) {
                webServer.depose();
            }
            future = this.workerGroup.shutdownGracefully();
        }
        finally {
            lock.unlock();
        }
        return future;
    }

    private final void tryReconnect(TunnelConnection conn, boolean error) {
        if (conn.isActiveClosed()) {
            this.tunnelConnectRegistry.unregister(conn);
            return;
        }
        if (error) {
            byte by = this.retryConnectPolicy;
            int n = 2;
            boolean bl = false;
            if ((byte)(by & n) == 2) {
                TimeUnit.SECONDS.sleep(3L);
                SslContext sslContext = conn.getSslContext$client();
                if (sslContext == null || (sslContext = this.getBootstrap(sslContext)) == null) {
                    sslContext = this.bootstrap;
                }
                conn.open$client((Bootstrap)sslContext, this.openFailureCallback);
                OnTunnelStateListener onTunnelStateListener = this.onTunnelStateListener;
                if (onTunnelStateListener != null) {
                    onTunnelStateListener.onConnecting(conn, true);
                }
            } else {
                this.tunnelConnectRegistry.unregister(conn);
            }
        } else {
            byte by = this.retryConnectPolicy;
            byte by2 = 1;
            boolean bl = false;
            if ((byte)(by & by2) == 1) {
                TimeUnit.SECONDS.sleep(3L);
                SslContext sslContext = conn.getSslContext$client();
                if (sslContext == null || (sslContext = this.getBootstrap(sslContext)) == null) {
                    sslContext = this.bootstrap;
                }
                conn.open$client((Bootstrap)sslContext, this.openFailureCallback);
                OnTunnelStateListener onTunnelStateListener = this.onTunnelStateListener;
                if (onTunnelStateListener != null) {
                    onTunnelStateListener.onConnecting(conn, true);
                }
            } else {
                this.tunnelConnectRegistry.unregister(conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void startWebServer() {
        Lock lock = this.lock;
        boolean bl = false;
        lock.lock();
        try {
            boolean bl2 = false;
            if (this.webServer == null && this.webBindPort != null) {
                WebServer webServer = new WebServer(this.workerGroup, this.workerGroup, this.webAddr, this.webBindPort.intValue(), null, 0, 48, null);
                boolean bl3 = false;
                boolean bl4 = false;
                WebServer it = webServer;
                boolean bl5 = false;
                this.webServer = it;
                WebServer server = webServer;
                server.router((Function1)new Function1<RouterConfig, Unit>(this){
                    final /* synthetic */ TunnelClient this$0;
                    {
                        this.this$0 = tunnelClient;
                        super(1);
                    }

                    public final void invoke(@NotNull RouterConfig $this$router) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$router, (String)"$receiver");
                        $this$router.route("/api/snapshot", (Function1)new Function1<FullHttpRequest, DefaultFullHttpResponse>(this){
                            final /* synthetic */ startWebServer$$inlined$withLock$lambda$1 this$0;
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }

                            @NotNull
                            public final DefaultFullHttpResponse invoke(@NotNull FullHttpRequest it) {
                                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                ByteBuf content = Unpooled.copiedBuffer((CharSequence)TunnelClient.access$getTunnelConnectRegistry$p(this.this$0.this$0).getSnapshot().toString(2), (Charset)Charsets.UTF_8);
                                DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, content);
                                boolean bl = false;
                                boolean bl2 = false;
                                DefaultFullHttpResponse it2 = defaultFullHttpResponse;
                                boolean bl3 = false;
                                it2.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_JSON).set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)content.readableBytes());
                                return defaultFullHttpResponse;
                            }
                        });
                    }
                });
                server.start();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private final Bootstrap getBootstrap(@NotNull SslContext $this$bootstrap) {
        Bootstrap bootstrap = this.cachedSslBootstraps.get($this$bootstrap);
        if (bootstrap == null) {
            AbstractBootstrap abstractBootstrap = ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)this.workerGroup)).channel(NioSocketChannel.class)).option(ChannelOption.AUTO_READ, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).handler((ChannelHandler)this.newChannelInitializer($this$bootstrap));
            boolean bl = false;
            boolean bl2 = false;
            Bootstrap it = (Bootstrap)abstractBootstrap;
            boolean bl3 = false;
            Map map = this.cachedSslBootstraps;
            Bootstrap bootstrap2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)bootstrap2, (String)"it");
            map.put($this$bootstrap, bootstrap2);
            AbstractBootstrap abstractBootstrap2 = abstractBootstrap;
            Intrinsics.checkExpressionValueIsNotNull((Object)abstractBootstrap2, (String)"Bootstrap()\n            \u2026slBootstraps[this] = it }");
            bootstrap = (Bootstrap)abstractBootstrap2;
        }
        return bootstrap;
    }

    private final ChannelInitializer<SocketChannel> newChannelInitializer(SslContext sslContext) {
        return (ChannelInitializer)new ChannelInitializer<SocketChannel>(this, sslContext){
            final /* synthetic */ TunnelClient this$0;
            final /* synthetic */ SslContext $sslContext;

            protected void initChannel(@Nullable SocketChannel ch) {
                if (ch == null) {
                    return;
                }
                if (this.$sslContext != null) {
                    ch.pipeline().addFirst("ssl", (ChannelHandler)this.$sslContext.newHandler(ch.alloc()));
                }
                ch.pipeline().addLast("heartbeat", (ChannelHandler)new HeartbeatHandler(false, 0L, 0L, 0L, null, 31, null)).addLast("decoder", (ChannelHandler)new ProtoMessageDecoder()).addLast("encoder", (ChannelHandler)new ProtoMessageEncoder()).addLast("handler", (ChannelHandler)new TunnelClientChannelHandler(TunnelClient.access$getLocalTcpClient$p(this.this$0), TunnelClient.access$getOnChannelStateListener$p(this.this$0), TunnelClient.access$getOnRemoteConnectListener$p(this.this$0)));
            }
            {
                this.this$0 = $outer;
                this.$sslContext = $captured_local_variable$1;
            }
        };
    }

    public TunnelClient(int workerThreads, byte retryConnectPolicy, @Nullable String webAddr, @Nullable Integer webBindPort, @Nullable OnTunnelStateListener onTunnelStateListener, @Nullable OnRemoteConnectListener onRemoteConnectListener) {
        Lazy lazy;
        this.workerThreads = workerThreads;
        this.retryConnectPolicy = retryConnectPolicy;
        this.webAddr = webAddr;
        this.webBindPort = webBindPort;
        this.onTunnelStateListener = onTunnelStateListener;
        this.onRemoteConnectListener = onRemoteConnectListener;
        TunnelClient tunnelClient = this;
        TunnelClient tunnelClient2 = this;
        boolean $i$f$loggerDelegate = false;
        tunnelClient2.logger$delegate = lazy = LazyKt.lazy((Function0)$special$$inlined$loggerDelegate$1.INSTANCE);
        this.cachedSslBootstraps = new ConcurrentHashMap();
        this.bootstrap = new Bootstrap();
        this.workerGroup = this.workerThreads >= 0 ? new NioEventLoopGroup(this.workerThreads) : new NioEventLoopGroup();
        this.tunnelConnectRegistry = new TunnelConnectionRegistry();
        this.lock = new ReentrantLock();
        this.openFailureCallback = (Function1)new Function1<TunnelConnection, Unit>(this){
            final /* synthetic */ TunnelClient this$0;

            public final void invoke(@NotNull TunnelConnection conn) {
                Intrinsics.checkParameterIsNotNull((Object)conn, (String)"conn");
                TunnelClient.access$tryReconnect(this.this$0, conn, false);
            }
            {
                this.this$0 = tunnelClient;
                super(1);
            }
        };
        this.onChannelStateListener = new TunnelClientChannelHandler.OnChannelStateListener(this){
            final /* synthetic */ TunnelClient this$0;

            public void onChannelInactive(@NotNull ChannelHandlerContext ctx, @Nullable TunnelConnection conn, boolean forceOffline, @Nullable Throwable cause) {
                Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
                TunnelClientChannelHandler.OnChannelStateListener.DefaultImpls.onChannelInactive(this, ctx, conn, forceOffline, cause);
                if (conn != null) {
                    OnTunnelStateListener onTunnelStateListener = TunnelClient.access$getOnTunnelStateListener$p(this.this$0);
                    if (onTunnelStateListener != null) {
                        onTunnelStateListener.onDisconnect(conn, cause);
                    }
                    TunnelClient.access$getLogger$p(this.this$0).trace("onChannelInactive: ", cause);
                    if (!forceOffline) {
                        TunnelClient.access$tryReconnect(this.this$0, conn, cause != null);
                    }
                }
            }

            public void onChannelConnected(@NotNull ChannelHandlerContext ctx, @Nullable TunnelConnection conn) {
                block1: {
                    Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
                    TunnelClientChannelHandler.OnChannelStateListener.DefaultImpls.onChannelConnected(this, ctx, conn);
                    if (conn == null) break block1;
                    OnTunnelStateListener onTunnelStateListener = TunnelClient.access$getOnTunnelStateListener$p(this.this$0);
                    if (onTunnelStateListener != null) {
                        onTunnelStateListener.onConnected(conn);
                    }
                }
            }
            {
                this.this$0 = $outer;
            }
        };
        this.localTcpClient = new LocalTcpClient(this.workerGroup);
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group((EventLoopGroup)this.workerGroup)).channel(NioSocketChannel.class)).option(ChannelOption.AUTO_READ, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).handler((ChannelHandler)this.newChannelInitializer(null));
    }

    public /* synthetic */ TunnelClient(int n, byte by, String string, Integer n2, OnTunnelStateListener onTunnelStateListener, OnRemoteConnectListener onRemoteConnectListener, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = -1;
        }
        if ((n3 & 2) != 0) {
            int n4 = 1;
            int n5 = 2;
            boolean bl = false;
            by = (byte)(n4 | n5);
        }
        if ((n3 & 4) != 0) {
            string = null;
        }
        if ((n3 & 8) != 0) {
            n2 = null;
        }
        if ((n3 & 0x10) != 0) {
            onTunnelStateListener = null;
        }
        if ((n3 & 0x20) != 0) {
            onRemoteConnectListener = null;
        }
        this(n, by, string, n2, onTunnelStateListener, onRemoteConnectListener);
    }

    public TunnelClient() {
        this(0, 0, null, null, null, null, 63, null);
    }

    public static final /* synthetic */ TunnelConnectionRegistry access$getTunnelConnectRegistry$p(TunnelClient $this) {
        return $this.tunnelConnectRegistry;
    }

    public static final /* synthetic */ LocalTcpClient access$getLocalTcpClient$p(TunnelClient $this) {
        return $this.localTcpClient;
    }

    public static final /* synthetic */ onChannelStateListener.1 access$getOnChannelStateListener$p(TunnelClient $this) {
        return $this.onChannelStateListener;
    }

    public static final /* synthetic */ OnRemoteConnectListener access$getOnRemoteConnectListener$p(TunnelClient $this) {
        return $this.onRemoteConnectListener;
    }

    public static final /* synthetic */ void access$tryReconnect(TunnelClient $this, TunnelConnection conn, boolean error) {
        $this.tryReconnect(conn, error);
    }

    public static final /* synthetic */ OnTunnelStateListener access$getOnTunnelStateListener$p(TunnelClient $this) {
        return $this.onTunnelStateListener;
    }

    public static final /* synthetic */ Logger access$getLogger$p(TunnelClient $this) {
        return $this.getLogger();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\f"}, d2={"Llighttunnel/client/TunnelClient$OnTunnelStateListener;", "", "onConnected", "", "conn", "Llighttunnel/client/conn/TunnelConnection;", "onConnecting", "retryConnect", "", "onDisconnect", "cause", "", "client"})
    public static interface OnTunnelStateListener {
        public void onConnecting(@NotNull TunnelConnection var1, boolean var2);

        public void onConnected(@NotNull TunnelConnection var1);

        public void onDisconnect(@NotNull TunnelConnection var1, @Nullable Throwable var2);

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            public static void onConnecting(OnTunnelStateListener $this, @NotNull TunnelConnection conn, boolean retryConnect) {
                Intrinsics.checkParameterIsNotNull((Object)conn, (String)"conn");
            }

            public static void onConnected(OnTunnelStateListener $this, @NotNull TunnelConnection conn) {
                Intrinsics.checkParameterIsNotNull((Object)conn, (String)"conn");
            }

            public static void onDisconnect(OnTunnelStateListener $this, @NotNull TunnelConnection conn, @Nullable Throwable cause) {
                Intrinsics.checkParameterIsNotNull((Object)conn, (String)"conn");
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016J\u0012\u0010\u0006\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Llighttunnel/client/TunnelClient$OnRemoteConnectListener;", "", "onRemoteConnected", "", "remoteInfo", "Llighttunnel/proto/RemoteInfo;", "onRemoteDisconnect", "client"})
    public static interface OnRemoteConnectListener {
        public void onRemoteConnected(@Nullable RemoteInfo var1);

        public void onRemoteDisconnect(@Nullable RemoteInfo var1);

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            public static void onRemoteConnected(OnRemoteConnectListener $this, @Nullable RemoteInfo remoteInfo) {
            }

            public static void onRemoteDisconnect(OnRemoteConnectListener $this, @Nullable RemoteInfo remoteInfo) {
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Llighttunnel/client/TunnelClient$Companion;", "", "()V", "RETRY_CONNECT_POLICY_ERROR", "", "RETRY_CONNECT_POLICY_LOSE", "client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

