/*
 * Decompiled with CFR 0.152.
 */
package lighttunnel.internal.client;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import lighttunnel.RemoteConnection;
import lighttunnel.TunnelRequest;
import lighttunnel.internal.base.proto.ProtoMessage;
import lighttunnel.internal.base.proto.message.ForceOffMessage;
import lighttunnel.internal.base.proto.message.PingMessage;
import lighttunnel.internal.base.proto.message.RemoteConnectedMessage;
import lighttunnel.internal.base.proto.message.RemoteDisconnectMessage;
import lighttunnel.internal.base.proto.message.ResponseErrMessage;
import lighttunnel.internal.base.proto.message.ResponseOkMessage;
import lighttunnel.internal.base.proto.message.TransferMessage;
import lighttunnel.internal.client.TunnelClientDaemonChannelHandler$$special$;
import lighttunnel.internal.client.TunnelClientDaemonChannelHandler$WhenMappings;
import lighttunnel.internal.client.conn.TunnelConnectionDefaultImpl;
import lighttunnel.internal.client.local.LocalTcpClient;
import lighttunnel.internal.client.util.-ConstsKt;
import lighttunnel.listener.OnRemoteConnectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002'(B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001c\u0010\u0014\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0002H\u0014J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020!H\u0002J\u0018\u0010\"\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020#H\u0002J\u001c\u0010$\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010%\u001a\u0004\u0018\u00010&H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Llighttunnel/internal/client/TunnelClientDaemonChannelHandler;", "Lio/netty/channel/SimpleChannelInboundHandler;", "Llighttunnel/internal/base/proto/ProtoMessage;", "localTcpClient", "Llighttunnel/internal/client/local/LocalTcpClient;", "onChannelStateListener", "Llighttunnel/internal/client/TunnelClientDaemonChannelHandler$OnChannelStateListener;", "onRemoteConnectListener", "Llighttunnel/listener/OnRemoteConnectionListener;", "(Llighttunnel/internal/client/local/LocalTcpClient;Llighttunnel/internal/client/TunnelClientDaemonChannelHandler$OnChannelStateListener;Llighttunnel/listener/OnRemoteConnectionListener;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "logger$delegate", "Lkotlin/Lazy;", "channelInactive", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "channelRead0", "msg", "doHandleForceOffMessage", "Llighttunnel/internal/base/proto/message/ForceOffMessage;", "doHandlePingMessage", "Llighttunnel/internal/base/proto/message/PingMessage;", "doHandleRemoteConnectedMessage", "Llighttunnel/internal/base/proto/message/RemoteConnectedMessage;", "doHandleRemoteDisconnectMessage", "Llighttunnel/internal/base/proto/message/RemoteDisconnectMessage;", "doHandleResponseErrMessage", "Llighttunnel/internal/base/proto/message/ResponseErrMessage;", "doHandleResponseOkMessage", "Llighttunnel/internal/base/proto/message/ResponseOkMessage;", "doHandleTransferMessage", "Llighttunnel/internal/base/proto/message/TransferMessage;", "exceptionCaught", "cause", "", "ChannelInactiveExtra", "OnChannelStateListener", "client"})
public final class TunnelClientDaemonChannelHandler
extends SimpleChannelInboundHandler<ProtoMessage> {
    private final Lazy logger$delegate;
    private final LocalTcpClient localTcpClient;
    private final OnChannelStateListener onChannelStateListener;
    private final OnRemoteConnectionListener onRemoteConnectListener;

    private final Logger getLogger() {
        Lazy lazy = this.logger$delegate;
        TunnelClientDaemonChannelHandler tunnelClientDaemonChannelHandler = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    public void channelInactive(@NotNull ChannelHandlerContext ctx) throws Exception {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.getLogger().trace("channelInactive: {}", (Object)ctx);
        Long tunnelId = (Long)ctx.channel().attr(-ConstsKt.AK_TUNNEL_ID()).get();
        Long sessionId = (Long)ctx.channel().attr(-ConstsKt.AK_SESSION_ID()).get();
        if (tunnelId != null && sessionId != null) {
            Channel channel = this.localTcpClient.removeLocalChannel(tunnelId, sessionId);
            if (channel != null) {
                channel.close();
            }
        }
        TunnelConnectionDefaultImpl conn = (TunnelConnectionDefaultImpl)ctx.channel().attr(-ConstsKt.AK_TUNNEL_CONNECTION()).get();
        ChannelInactiveExtra extra = (ChannelInactiveExtra)ctx.channel().attr(-ConstsKt.AK_CHANNEL_INACTIVE_EXTRA()).get();
        this.onChannelStateListener.onChannelInactive(ctx, conn, extra);
        super.channelInactive(ctx);
    }

    public void exceptionCaught(@Nullable ChannelHandlerContext ctx, @Nullable Throwable cause) throws Exception {
        this.getLogger().trace("exceptionCaught: {}", (Object)ctx, (Object)cause);
        if (ctx == null) {
            return;
        }
        ctx.channel().writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    protected void channelRead0(@Nullable ChannelHandlerContext ctx, @Nullable ProtoMessage msg) throws Exception {
        this.getLogger().trace("channelRead0 : {}, {}", (Object)ctx, (Object)msg);
        if (ctx == null) {
            return;
        }
        if (msg == null) {
            return;
        }
        switch (TunnelClientDaemonChannelHandler$WhenMappings.$EnumSwitchMapping$0[msg.getType().ordinal()]) {
            case 1: {
                this.doHandlePingMessage(ctx, (PingMessage)msg);
                break;
            }
            case 2: {
                this.doHandleResponseOkMessage(ctx, (ResponseOkMessage)msg);
                break;
            }
            case 3: {
                this.doHandleResponseErrMessage(ctx, (ResponseErrMessage)msg);
                break;
            }
            case 4: {
                this.doHandleTransferMessage(ctx, (TransferMessage)msg);
                break;
            }
            case 5: {
                this.doHandleRemoteConnectedMessage(ctx, (RemoteConnectedMessage)msg);
                break;
            }
            case 6: {
                this.doHandleRemoteDisconnectMessage(ctx, (RemoteDisconnectMessage)msg);
                break;
            }
            case 7: {
                this.doHandleForceOffMessage(ctx, (ForceOffMessage)msg);
                break;
            }
        }
    }

    private final void doHandlePingMessage(ChannelHandlerContext ctx, PingMessage msg) throws Exception {
        this.getLogger().trace("doHandlePingMessage : {}, {}", (Object)ctx, (Object)msg);
        ctx.writeAndFlush((Object)ProtoMessage.Companion.PONG());
    }

    private final void doHandleResponseOkMessage(ChannelHandlerContext ctx, ResponseOkMessage msg) throws Exception {
        TunnelConnectionDefaultImpl conn;
        this.getLogger().trace("doHandleResponseOkMessage : {}, {}", (Object)ctx, (Object)msg);
        TunnelRequest tunnelRequest = TunnelRequest.Factory.fromBytes(msg.getData());
        ctx.channel().attr(-ConstsKt.AK_TUNNEL_ID()).set((Object)msg.getTunnelId());
        ctx.channel().attr(-ConstsKt.AK_TUNNEL_REQUEST()).set((Object)tunnelRequest);
        ctx.channel().attr(-ConstsKt.AK_CHANNEL_INACTIVE_EXTRA()).set(null);
        TunnelConnectionDefaultImpl tunnelConnectionDefaultImpl = conn = (TunnelConnectionDefaultImpl)ctx.channel().attr(-ConstsKt.AK_TUNNEL_CONNECTION()).get();
        if (tunnelConnectionDefaultImpl != null) {
            tunnelConnectionDefaultImpl.setFinalTunnelRequest(tunnelRequest);
        }
        this.getLogger().debug("Opened Tunnel: {}", (Object)tunnelRequest);
        this.onChannelStateListener.onChannelConnected(ctx, conn);
    }

    private final void doHandleResponseErrMessage(ChannelHandlerContext ctx, ResponseErrMessage msg) throws Exception {
        this.getLogger().trace("doHandleResponseErrMessage : {}, {}", (Object)ctx, (Object)msg);
        byte[] byArray = msg.getData();
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"StandardCharsets.UTF_8");
        Charset charset2 = charset;
        boolean bl = false;
        String errMsg = new String(byArray, charset2);
        ctx.channel().attr(-ConstsKt.AK_TUNNEL_ID()).set(null);
        ctx.channel().attr(-ConstsKt.AK_TUNNEL_REQUEST()).set(null);
        ctx.channel().attr(-ConstsKt.AK_CHANNEL_INACTIVE_EXTRA()).set((Object)new ChannelInactiveExtra(false, new Exception(errMsg)));
        ctx.channel().close();
        this.getLogger().debug("Open Tunnel Error: {}", (Object)errMsg);
    }

    private final void doHandleTransferMessage(ChannelHandlerContext ctx, TransferMessage msg) throws Exception {
        TunnelRequest tunnelRequest;
        this.getLogger().trace("doHandleTransferMessage : {}, {}", (Object)ctx, (Object)msg);
        ctx.channel().attr(-ConstsKt.AK_TUNNEL_ID()).set((Object)msg.getTunnelId());
        ctx.channel().attr(-ConstsKt.AK_SESSION_ID()).set((Object)msg.getSessionId());
        TunnelRequest tunnelRequest2 = tunnelRequest = (TunnelRequest)ctx.channel().attr(-ConstsKt.AK_TUNNEL_REQUEST()).get();
        Object object = tunnelRequest2 != null ? tunnelRequest2.getTunnelType() : null;
        if (object != null) {
            switch (TunnelClientDaemonChannelHandler$WhenMappings.$EnumSwitchMapping$1[object.ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    String string = tunnelRequest.getLocalAddr();
                    int n = tunnelRequest.getLocalPort();
                    long l = msg.getTunnelId();
                    long l2 = msg.getSessionId();
                    Channel channel = ctx.channel();
                    Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"ctx.channel()");
                    this.localTcpClient.acquireLocalChannel(string, n, l, l2, channel, new LocalTcpClient.OnArriveLocalChannelCallback(this, msg, ctx){
                        final /* synthetic */ TunnelClientDaemonChannelHandler this$0;
                        final /* synthetic */ TransferMessage $msg;
                        final /* synthetic */ ChannelHandlerContext $ctx;

                        public void onArrived(@NotNull Channel localChannel) {
                            Intrinsics.checkNotNullParameter((Object)localChannel, (String)"localChannel");
                            TunnelClientDaemonChannelHandler.access$getLogger$p(this.this$0).trace("onArrived: {}", (Object)localChannel);
                            localChannel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])this.$msg.getData()));
                        }

                        public void onUnableArrive(@NotNull Throwable cause) {
                            Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
                            LocalTcpClient.OnArriveLocalChannelCallback.DefaultImpls.onUnableArrive(this, cause);
                            this.$ctx.writeAndFlush((Object)ProtoMessage.Companion.LOCAL_DISCONNECT(this.$msg.getTunnelId(), this.$msg.getSessionId()));
                        }
                        {
                            this.this$0 = this$0;
                            this.$msg = $captured_local_variable$1;
                            this.$ctx = $captured_local_variable$2;
                        }
                    });
                    break;
                }
            }
        }
    }

    private final void doHandleRemoteConnectedMessage(ChannelHandlerContext ctx, RemoteConnectedMessage msg) throws Exception {
        TunnelRequest tunnelRequest;
        RemoteConnection remoteConnection;
        this.getLogger().trace("doHandleRemoteConnectedMessage : {}, {}", (Object)ctx, (Object)msg);
        ctx.channel().attr(-ConstsKt.AK_TUNNEL_ID()).set((Object)msg.getTunnelId());
        ctx.channel().attr(-ConstsKt.AK_SESSION_ID()).set((Object)msg.getSessionId());
        try {
            remoteConnection = RemoteConnection.Companion.fromBytes(msg.getData());
        }
        catch (Exception e) {
            remoteConnection = null;
        }
        RemoteConnection conn = remoteConnection;
        if (conn != null) {
            OnRemoteConnectionListener onRemoteConnectionListener = this.onRemoteConnectListener;
            if (onRemoteConnectionListener != null) {
                onRemoteConnectionListener.onRemoteConnected(conn);
            }
        }
        if ((tunnelRequest = (TunnelRequest)ctx.channel().attr(-ConstsKt.AK_TUNNEL_REQUEST()).get()) != null) {
            String string = tunnelRequest.getLocalAddr();
            int n = tunnelRequest.getLocalPort();
            long l = msg.getTunnelId();
            long l2 = msg.getSessionId();
            Channel channel = ctx.channel();
            Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"ctx.channel()");
            LocalTcpClient.acquireLocalChannel$default(this.localTcpClient, string, n, l, l2, channel, null, 32, null);
        }
    }

    private final void doHandleRemoteDisconnectMessage(ChannelHandlerContext ctx, RemoteDisconnectMessage msg) throws Exception {
        block4: {
            Channel channel;
            RemoteConnection remoteConnection;
            this.getLogger().trace("doHandleRemoteDisconnectMessage : {}, {}", (Object)ctx, (Object)msg);
            try {
                remoteConnection = RemoteConnection.Companion.fromBytes(msg.getData());
            }
            catch (Exception e) {
                remoteConnection = null;
            }
            RemoteConnection conn = remoteConnection;
            if (conn != null) {
                OnRemoteConnectionListener onRemoteConnectionListener = this.onRemoteConnectListener;
                if (onRemoteConnectionListener != null) {
                    onRemoteConnectionListener.onRemoteDisconnect(conn);
                }
            }
            if ((channel = this.localTcpClient.removeLocalChannel(msg.getTunnelId(), msg.getSessionId())) == null || (channel = channel.writeAndFlush((Object)Unpooled.EMPTY_BUFFER)) == null) break block4;
            channel.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private final void doHandleForceOffMessage(ChannelHandlerContext ctx, ForceOffMessage msg) throws Exception {
        this.getLogger().trace("doHandleForceOffMessage : {}, {}", (Object)ctx, (Object)msg);
        ctx.channel().attr(-ConstsKt.AK_TUNNEL_ID()).set(null);
        ctx.channel().attr(-ConstsKt.AK_TUNNEL_REQUEST()).set(null);
        ctx.channel().attr(-ConstsKt.AK_CHANNEL_INACTIVE_EXTRA()).set((Object)new ChannelInactiveExtra(true, new Exception("ForceOff")));
        ctx.channel().writeAndFlush((Object)ProtoMessage.Companion.FORCE_OFF_REPLY()).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public TunnelClientDaemonChannelHandler(@NotNull LocalTcpClient localTcpClient, @NotNull OnChannelStateListener onChannelStateListener, @Nullable OnRemoteConnectionListener onRemoteConnectListener) {
        Intrinsics.checkNotNullParameter((Object)localTcpClient, (String)"localTcpClient");
        Intrinsics.checkNotNullParameter((Object)onChannelStateListener, (String)"onChannelStateListener");
        this.localTcpClient = localTcpClient;
        this.onChannelStateListener = onChannelStateListener;
        this.onRemoteConnectListener = onRemoteConnectListener;
        TunnelClientDaemonChannelHandler $this$loggerDelegate$iv = this;
        boolean $i$f$loggerDelegate = false;
        this.logger$delegate = LazyKt.lazy((Function0)$special$$inlined$loggerDelegate$1.INSTANCE);
    }

    public static final /* synthetic */ Logger access$getLogger$p(TunnelClientDaemonChannelHandler $this) {
        return $this.getLogger();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J$\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000b"}, d2={"Llighttunnel/internal/client/TunnelClientDaemonChannelHandler$OnChannelStateListener;", "", "onChannelConnected", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "conn", "Llighttunnel/internal/client/conn/TunnelConnectionDefaultImpl;", "onChannelInactive", "extra", "Llighttunnel/internal/client/TunnelClientDaemonChannelHandler$ChannelInactiveExtra;", "client"})
    public static interface OnChannelStateListener {
        public void onChannelInactive(@NotNull ChannelHandlerContext var1, @Nullable TunnelConnectionDefaultImpl var2, @Nullable ChannelInactiveExtra var3);

        public void onChannelConnected(@NotNull ChannelHandlerContext var1, @Nullable TunnelConnectionDefaultImpl var2);

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            public static void onChannelInactive(@NotNull OnChannelStateListener $this, @NotNull ChannelHandlerContext ctx, @Nullable TunnelConnectionDefaultImpl conn, @Nullable ChannelInactiveExtra extra) {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            }

            public static void onChannelConnected(@NotNull OnChannelStateListener $this, @NotNull ChannelHandlerContext ctx, @Nullable TunnelConnectionDefaultImpl conn) {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Llighttunnel/internal/client/TunnelClientDaemonChannelHandler$ChannelInactiveExtra;", "", "forceOff", "", "cause", "", "(ZLjava/lang/Throwable;)V", "getCause", "()Ljava/lang/Throwable;", "getForceOff", "()Z", "client"})
    public static final class ChannelInactiveExtra {
        private final boolean forceOff;
        @Nullable
        private final Throwable cause;

        public final boolean getForceOff() {
            return this.forceOff;
        }

        @Nullable
        public final Throwable getCause() {
            return this.cause;
        }

        public ChannelInactiveExtra(boolean forceOff, @Nullable Throwable cause) {
            this.forceOff = forceOff;
            this.cause = cause;
        }
    }
}

