package library.android.adsengine.admob;

import android.content.Context;

import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.InterstitialAd;

import java.util.List;

import library.android.adsengine.AdsConfiguration;
import library.android.adsengine.AdsHandler;
import library.android.adsengine.IAdsInteractionComplete;

/**
 * Created by pankaj on 4/15/2018.
 */

public class AdmobInterstitial {
    Context mContext;
    InterstitialAd mInterstitialAd;
    private AdRequest.Builder builder;

    public AdmobInterstitial(Context mContext, List<String> testDeviceList) {
        this.mContext = mContext;
        builder = new AdRequest.Builder();
        if (testDeviceList != null && testDeviceList.size() > 0) {
            for (String deviceID : testDeviceList) {
                builder.addTestDevice(deviceID);

            }
        }
        loadInterstitial();
    }

    public void loadInterstitial() {
        mInterstitialAd = new InterstitialAd(mContext);
        mInterstitialAd.setAdUnitId(AdsConfiguration.getInstance().getAdmobInterstitial());


        mInterstitialAd.loadAd(builder.build());
        mInterstitialAd.setAdListener(new AdListener() {
            @Override
            public void onAdLoaded() {
            }

            @Override
            public void onAdFailedToLoad(int errorCode) {
            }

            @Override
            public void onAdClosed() {
                if (adsInteractionComplete != null) {
                    adsInteractionComplete.onAdsInteractionComplition(true);
                    AdsHandler.navigationCount = 0;
                }
                loadInterstitial();
            }
        });
    }

    IAdsInteractionComplete adsInteractionComplete;

    public void showAd(IAdsInteractionComplete adsInteractionComplete) {
        this.adsInteractionComplete = adsInteractionComplete;
        if (mInterstitialAd != null && mInterstitialAd.isLoaded()) {
            mInterstitialAd.show();
        } else {
            loadInterstitial();
            if (adsInteractionComplete != null) {
                adsInteractionComplete.onAdsInteractionComplition(false);
            }
        }
    }
}
