package library.android.adsengine.admob;

import android.content.Context;
import android.widget.LinearLayout;

import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;

import java.util.List;

import library.android.adsengine.AdsConfiguration;
import library.android.adsengine.AdsUnit;

/**
 * Created by pankaj on 4/15/2018.
 */

public class AdmobBanner {
    private Context mContext;
    private AdRequest.Builder builder;

    public AdmobBanner(Context mContext, List<String> testDeviceList) {
        this.mContext = mContext;
        builder = new AdRequest.Builder();
        if (testDeviceList != null && testDeviceList.size() > 0) {
            for (String deviceID : testDeviceList) {
                builder.addTestDevice(deviceID);

            }
        }
    }


    public void setBannerSmall(LinearLayout adsContainer) {
        AdView adView = new AdView(mContext);
        adView.setAdSize(AdSize.SMART_BANNER);
        adView.setAdUnitId(AdsConfiguration.getInstance().getAdmobBannerSmall());


        if (adsContainer != null) {
            if (adsContainer.getChildCount() > 0)
                adsContainer.removeAllViews();
            if (adView != null) {
                adsContainer.addView(adView);
            }
        }

        adView.loadAd(builder.build());
    }

    public void setBannerMedium(LinearLayout adsContainer) {
        AdView adView = new AdView(mContext);
        adView.setAdSize(AdSize.LARGE_BANNER);
        adView.setAdUnitId(AdsConfiguration.getInstance().getAdmobBannerMedium());


        if (adsContainer != null) {
            if (adsContainer.getChildCount() > 0)
                adsContainer.removeAllViews();
            if (adView != null) {
                adsContainer.addView(adView);
            }
        }

        adView.loadAd(builder.build());
    }

    public void setBannerLarge(LinearLayout adsContainer) {
        AdView adView = new AdView(mContext);
        adView.setAdSize(AdSize.FULL_BANNER);
        adView.setAdUnitId(AdsConfiguration.getInstance().getAdmobBannerLarge());


        if (adsContainer != null) {
            if (adsContainer.getChildCount() > 0)
                adsContainer.removeAllViews();
            if (adView != null) {
                adsContainer.addView(adView);
            }
        }

        adView.loadAd(builder.build());
    }
}
