package library.android.adsengine;

import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;


/**
 * Created by swift on 10/26/17.
 */

public class UpdateAppActivity extends AppCompatActivity implements View.OnClickListener {

    SharedPreferences sharedPreferences;

    Button updateApp;

    TextView notNow;

    TextView currentVersion;
    TextView versionOutdated;
    TextView newVersion;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_update_app);

        updateApp = findViewById(R.id.updateApp);
        notNow = findViewById(R.id.notNow);
        currentVersion = findViewById(R.id.currentVersion);
        versionOutdated = findViewById(R.id.tv_versionOutdated);
        newVersion = findViewById(R.id.tv_newVersion);

        try {
            PackageInfo pInfo = this.getPackageManager().getPackageInfo(getPackageName(), 0);
            String version = pInfo.versionName;
            currentVersion.setText(version);
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }


        boolean isCriticalUpdate = getIntent().getExtras().getBoolean("isCritical");
        String appName = getIntent().getExtras().getString("appName");

        versionOutdated.setText(getResources().getString(R.string.version_outdated, appName));
        newVersion.setText(getResources().getString(R.string.new_version_in_playstore, appName));


        if (isCriticalUpdate)
            notNow.setVisibility(View.INVISIBLE);

        notNow.setOnClickListener(this);

        updateApp.setOnClickListener(this);

        overridePendingTransition(R.anim.slide_in, R.anim.slide_out);
    }

    @Override
    public void onClick(View view) {

        int id = view.getId();
        if (id == notNow.getId()) {
            processedToDashboard();
        } else if (id == updateApp.getId()) {
            final String appPackageName = getIntent().getExtras().getString("packageName", getPackageName());
            try {
                startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("market://details?id=" + appPackageName)));
            } catch (android.content.ActivityNotFoundException anfe) {
                startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("https://play.google.com/store/apps/details?id=" + appPackageName)));
            }

        }

    }

    /**
     * Navigate user to Dashboard.
     */
    private void processedToDashboard() {
        String className = getIntent().getExtras().getString("className");
        try {
            Class naviagteClass = Class.forName(className);
            startActivity(new Intent(UpdateAppActivity.this, naviagteClass));
            finish();
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        }

    }
}
