package library.android.adsengine;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import android.widget.LinearLayout;

import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.remoteconfig.FirebaseRemoteConfig;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigSettings;

import java.util.ArrayList;
import java.util.List;

import library.android.adsengine.admob.AdmobBanner;
import library.android.adsengine.admob.AdmobInterstitial;
import library.android.adsengine.admob.AdmobRewardVideo;

/**
 * Created by pankaj on 4/15/2018.
 */

public class AdsHandler extends IAdsCaller {
    private Context mContext;
    AdmobInterstitial admobInterstitial;
    AdmobBanner admobBanner;
    AdmobRewardVideo rewardVideo;
    public static int navigationCount = 0;
    public static int navigationCountHouse = 0;
    private static List<String> testDeviceList;

    private AdsHandler init(Context mContext) {
        this.mContext = mContext;
        return this;
    }


    public AdsHandler(Context mContext) {
        this.mContext = mContext;
        initAllAds();
    }

    private void initAllAds() {
        if (!isAdsRemoved && testDeviceList != null) {
            admobInterstitial = new AdmobInterstitial(mContext, testDeviceList);
            admobBanner = new AdmobBanner(mContext, testDeviceList);
            rewardVideo = new AdmobRewardVideo(mContext, testDeviceList);
        }

    }

    public void showAds(AdsType adsType, IAdsInteractionComplete adsInteractionComplete) {
        if(admobInterstitial==null)
            return;

        if (isAdsRemoved) {
            adsInteractionComplete.onAdsInteractionComplition(false);
            return;
        }
        if (adsType == AdsType.FULL_ADS_INSTANT && AdsConfiguration.getInstance().isFullAdsEnabled())
            shouldFullAddInstant(adsInteractionComplete);
        else if (adsType == AdsType.FULL_ADS_NAVIGATION && AdsConfiguration.getInstance().isFullAdsEnabled()) {
            ++navigationCount;
            if (navigationCount >= AdsConfiguration.getInstance().getCountNavigationFullAds()) {
                shouldFullAddInstant(adsInteractionComplete);
                //todo make counter 0 only if the ads is shown
            } else {

                admobInterstitial.loadInterstitial();
                adsInteractionComplete.onAdsInteractionComplition(false);

            }
        } else if (adsType == AdsType.ENTRY_ADS && AdsConfiguration.getInstance().isEntryAdsEnabled()) {
            ++navigationCountHouse;
            if (AdsConfiguration.getInstance().isEntryHouseEnabled() &&
                    AdsConfiguration.getInstance().getJsonHouseAds() != null
                    && !isPackageExisted(AdsConfiguration.getInstance().getJsonHouseAds().getAdsPackageName())
                    && navigationCountHouse >= AdsConfiguration.getInstance().getCountNavigationEntryAds()) {
                navigationCountHouse = 0;

                Intent in = new Intent(mContext, HouseAdsActivity.class);
                mContext.startActivity(in);
            } else if (AdsConfiguration.getInstance().isEntryFullAdsEnabled()
                    && navigationCountHouse >= AdsConfiguration.getInstance().getCountNavigationEntryAds()) {
                navigationCountHouse = 0;
                shouldFullAddInstant(adsInteractionComplete);
            }
        } else if (adsType == AdsType.VIDEO_ADS && AdsConfiguration.getInstance().isVideoAdsEnabled()) {
            rewardVideo.showVideoAds(adsInteractionComplete);
        }

    }

    public void showBannerAds(AdsType adsType, LinearLayout adsContainer) {
        if(admobBanner==null)
            return;
        if (isAdsRemoved || !AdsConfiguration.getInstance().isBannerEnabled())
            return;
        if (adsType == AdsType.BANNER_SMALL && AdsConfiguration.getInstance().isBannerSmallEnabled())
            showBannerAdsSmall(adsContainer);
        else if (adsType == AdsType.BANNER_MEDIUM && AdsConfiguration.getInstance().isBannerMediumEnabled())
            showBannerAdsMedium(adsContainer);
        else if (adsType == AdsType.BANNER_LARGE && AdsConfiguration.getInstance().isBannerLargeEnabled())
            showBannerAdsLarge(adsContainer);
    }

    @Override
    protected void showFullAdsOnNavigation() {

    }

    @Override
    protected void shouldFullAddInstant(IAdsInteractionComplete adsInteractionComplete) {
        if(admobInterstitial==null)
            return;
        if (AdsConfiguration.getInstance().isFullAdsEnabled() && admobInterstitial != null)
            admobInterstitial.showAd(adsInteractionComplete);

    }

    @Override
    protected void showBannerAdsSmall(LinearLayout adsContainer) {
        if(admobBanner==null)
            return;
        admobBanner.setBannerSmall(adsContainer);

    }

    @Override
    protected void showBannerAdsMedium(LinearLayout adsContainer) {
        if(admobBanner==null)
            return;
        admobBanner.setBannerMedium(adsContainer);

    }

    @Override
    protected void showBannerAdsLarge(LinearLayout adsContainer) {
        if(admobBanner==null)
            return;
        admobBanner.setBannerLarge(adsContainer);
    }

    @Override
    protected void showVideoAds(IAdsInteractionComplete adsInteractionComplete) {
        if(rewardVideo==null)
            return;
        rewardVideo.showVideoAds(adsInteractionComplete);
    }

    @Override
    protected void showHouseAdsFull() {

    }

    @Override
    protected void showHouseAdsBanner(LinearLayout adsContainer) {

    }

    private boolean isPackageExisted(String packageName) {
        try {
            List<ApplicationInfo> packages;
            PackageManager pm;
            pm = mContext.getPackageManager();
            packages = pm.getInstalledApplications(0);
            for (ApplicationInfo packageInfo : packages) {
                if (packageInfo.packageName.equals(packageName))
                    return true;
            }
        } catch (Exception e) {

        }
        return false;
    }

    public boolean checkVersion(String appName, String fullClassName, int currentVersionCode) {


        String updateString = AdsConfiguration.getInstance().getUpdateApp();
        if (updateString != null && updateString.contains("_")) {
            String[] updateParams = updateString.split("_");
            int serverVersionCode = Integer.parseInt(updateParams[0]);
            boolean isCriticalUpdate = Boolean.parseBoolean(updateParams[1]);
            String packageName = null;
            if (updateParams.length > 2)
                packageName = updateParams[2];
            if (serverVersionCode > currentVersionCode) {
                Intent in = new Intent(mContext, UpdateAppActivity.class);
                in.putExtra("appName", appName);
                in.putExtra("isCritical", isCriticalUpdate);
                in.putExtra("className", fullClassName);
                if (packageName != null)
                    in.putExtra("packageName", packageName);

                mContext.startActivity(in);

                return true;
            }


        }
        return false;
    }

    private FirebaseRemoteConfig mFirebaseRemoteConfig;

    public void initRemoteConfig(List<String> testDeviceList) {
        if (testDeviceList != null) {
            this.testDeviceList = testDeviceList;
        } else {
            this.testDeviceList = new ArrayList<>();
        }

        mFirebaseRemoteConfig = BaseApplication.mFirebaseRemoteConfig;
        FirebaseRemoteConfigSettings configSettings = new FirebaseRemoteConfigSettings.Builder()
                .setDeveloperModeEnabled(BuildConfig.DEBUG)
                .build();
        mFirebaseRemoteConfig.setConfigSettings(configSettings);
        mFirebaseRemoteConfig.setDefaults(R.xml.remote_config_default);


        long cacheExpiration = 600; // 1 hour in seconds.
        if (mFirebaseRemoteConfig.getInfo().getConfigSettings().isDeveloperModeEnabled()) {
            cacheExpiration = 0;
        }

        mFirebaseRemoteConfig.fetch(cacheExpiration)
                .addOnCompleteListener(new OnCompleteListener<Void>() {
                    @Override
                    public void onComplete(@NonNull Task<Void> task) {
                        System.out.println("Remote config fetched ==");
                        if (task.isSuccessful()) {
                            mFirebaseRemoteConfig.activateFetched();
                            initAdsConfiguration();
                        }
                    }
                });
    }

    private void initAdsConfiguration() {
        AdsConfiguration adsConfig = AdsConfiguration.getInstance();

        adsConfig.setBannerEnabled(mFirebaseRemoteConfig.getBoolean("isBannerEnabled"));
        adsConfig.setBannerMediumEnabled(mFirebaseRemoteConfig.getBoolean("isBannerMediumEnabled"));
        adsConfig.setBannerSmallEnabled(mFirebaseRemoteConfig.getBoolean("isBannerSmallEnabled"));
        adsConfig.setBannerLargeEnabled(mFirebaseRemoteConfig.getBoolean("isBannerLargeEnabled"));
        adsConfig.setBannerHouseEnabled(mFirebaseRemoteConfig.getBoolean("isBannerHouseEnabled"));
        adsConfig.setFullAdsEnabled(mFirebaseRemoteConfig.getBoolean("isFullAdsEnabled"));
        adsConfig.setEntryHouseEnabled(mFirebaseRemoteConfig.getBoolean("isEntryHouseEnabled"));
        adsConfig.setEntryFullAdsEnabled(mFirebaseRemoteConfig.getBoolean("isEntryFullAdsEnabled"));
        adsConfig.setFullAdsProviderEnabled(mFirebaseRemoteConfig.getBoolean("isFullAdsProviderEnabled"));
        adsConfig.setVideoAdsEnabled(mFirebaseRemoteConfig.getBoolean("isVideoAdsEnabled"));
        adsConfig.setEntryAdsEnabled(mFirebaseRemoteConfig.getBoolean("isEntryAdsEnabled"));
        adsConfig.setCountNavigationFullAds((int) mFirebaseRemoteConfig.getLong("countNavigationFullAds"));
        adsConfig.setCountNavigationEntryAds((int) mFirebaseRemoteConfig.getLong("countNavigationEntryAds"));
        adsConfig.setJsonHouseAds(mFirebaseRemoteConfig.getString("jsonHouseAds"));
        adsConfig.setUpdateApp(mFirebaseRemoteConfig.getString("updateApp"));

        //======================ADMOB ADS ID INITIALIZATION=======================
        adsConfig.setAdmobInterstitial(mFirebaseRemoteConfig.getString("ID_ADMOB_INTERSTITIAL"));
        adsConfig.setAdmobRewardVideo(mFirebaseRemoteConfig.getString("ID_ADMOB_VIDEO"));
        adsConfig.setAdmobBannerSmall(mFirebaseRemoteConfig.getString("ID_ADMOB_BANNER_SMALL"));
        adsConfig.setAdmobBannerMedium(mFirebaseRemoteConfig.getString("ID_ADMOB_BANNER_MEDIUM"));
        adsConfig.setAdmobBannerLarge(mFirebaseRemoteConfig.getString("ID_ADMOB_BANNER_LARGE"));
        //======================ADMOB ADS ID INITIALIZATION=======================
        initAllAds();

    }

    private static boolean isAdsRemoved;

    public void removeAds() {
        isAdsRemoved = true;
    }
}
