package library.android.adsengine.admob;

import android.content.Context;

import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.reward.RewardItem;
import com.google.android.gms.ads.reward.RewardedVideoAd;
import com.google.android.gms.ads.reward.RewardedVideoAdListener;

import java.util.List;

import library.android.adsengine.AdsConfiguration;
import library.android.adsengine.AdsUnit;
import library.android.adsengine.IAdsInteractionComplete;

/**
 * Created by pankaj on 4/16/2018.
 */

public class AdmobRewardVideo {
    private Context mContext;
    private AdRequest.Builder builder;

    public AdmobRewardVideo(Context mContext, List<String> testDeviceList) {
        this.mContext = mContext;
        builder = new AdRequest.Builder();
        if (testDeviceList != null && testDeviceList.size() > 0) {
            for (String deviceID : testDeviceList) {
                builder.addTestDevice(deviceID);

            }
        }

        loadVideoAds();
    }

    private static RewardedVideoAd mAd;

    private void loadVideoAds() {
        mAd = MobileAds.getRewardedVideoAdInstance(mContext.getApplicationContext());
        mAd.setRewardedVideoAdListener(new RewardedVideoAdListener() {
            @Override
            public void onRewardedVideoAdLoaded() {

            }

            @Override
            public void onRewardedVideoAdOpened() {

            }

            @Override
            public void onRewardedVideoStarted() {

            }

            @Override
            public void onRewardedVideoAdClosed() {
                loadVideoAds();
            }

            @Override
            public void onRewarded(RewardItem rewardItem) {
                if (adsInteractionComplete != null) {
                    adsInteractionComplete.onAdsInteractionComplition(true);
                }

            }

            @Override
            public void onRewardedVideoAdLeftApplication() {
                if (adsInteractionComplete != null) {
                    adsInteractionComplete.onAdsInteractionComplition(false);
                }
            }

            @Override
            public void onRewardedVideoAdFailedToLoad(int i) {

            }

            @Override
            public void onRewardedVideoCompleted() {

            }
        });

        loadRewardedVideoAd();
    }

    private void loadRewardedVideoAd() {

        mAd.loadAd(AdsConfiguration.getInstance().getAdmobRewardVideo(), builder.build());
    }

    IAdsInteractionComplete adsInteractionComplete;

    public void showVideoAds(IAdsInteractionComplete adsInteractionComplete) {
        this.adsInteractionComplete = adsInteractionComplete;
        if (mAd.isLoaded()) {
            mAd.show();
        } else {

            loadVideoAds();
            adsInteractionComplete.onAdsInteractionComplition(false);
        }
    }
}
