package library.android.adsengine;

import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.support.v4.graphics.drawable.RoundedBitmapDrawable;
import android.support.v4.graphics.drawable.RoundedBitmapDrawableFactory;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.target.BitmapImageViewTarget;

import library.android.adsengine.model.HouseAdsEntity;

public class HouseAdsActivity extends AppCompatActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        overridePendingTransition(R.anim.slide_in, R.anim.slide_out);
        setContentView(R.layout.activity_house_ads);

        ImageView close = (ImageView) this.findViewById(R.id.iv_close);
        ImageView adsImage = (ImageView) this.findViewById(R.id.iv_adsImage);

        close.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                finish();
            }
        });


        final HouseAdsEntity houseAdsEntity = AdsConfiguration.getInstance().getJsonHouseAds();
        if (houseAdsEntity == null) {
            finish();
            return;
        }

        adsImage.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                openInPlayStore(houseAdsEntity.getAdsPackageName());
            }
        });


        Glide.with(this).load(houseAdsEntity.getAdsImage()).asBitmap().diskCacheStrategy(DiskCacheStrategy.SOURCE).into(adsImage);
       /*         .load(houseAdsEntity.getAdsImage())
                .asBitmap()
                .placeholder(R.drawable.sample_placeholder)
                .diskCacheStrategy(DiskCacheStrategy.SOURCE)
                .into(new BitmapImageViewTarget(img_document_front) {
                    @Override
                    protected void setResource(Bitmap resource) {
                        RoundedBitmapDrawable circularBitmapDrawable =
                                RoundedBitmapDrawableFactory.create(getActivity().getResources(), resource);
                        circularBitmapDrawable.setCornerRadius(Utils.dpToPx(8, getActivity()));
                        circularBitmapDrawable.setAntiAlias(true);
                        img_document_front.setImageDrawable(circularBitmapDrawable);
                    }
                });
    }*/

    }

    private void openInPlayStore(String packageName) {
        try {
            startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("market://details?id=" + packageName)));
        } catch (android.content.ActivityNotFoundException anfe) {
            startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("https://play.google.com/store/apps/details?id=" + packageName)));
        }
    }


}
