package library.android.adsengine;

import com.google.gson.Gson;

import library.android.adsengine.model.HouseAdsEntity;

/**
 * Created by pankaj on 4/15/2018.
 */

public class AdsConfiguration {
    private boolean isBannerEnabled;
    private boolean isBannerMediumEnabled;
    private boolean isBannerSmallEnabled;
    private boolean isBannerLargeEnabled;

    private boolean isBannerHouseEnabled;

    private boolean isFullAdsEnabled;
    private boolean isEntryHouseEnabled;
    private boolean isEntryFullAdsEnabled;
    private boolean isFullAdsProviderEnabled;

    private boolean isVideoAdsEnabled;

    private boolean isEntryAdsEnabled;
    private int countNavigationFullAds = 3;
    private int countNavigationEntryAds = 2;
    private String updateApp; //versioncode_boolean 11|_true
    private String jsonHouseAds;

    //=========================ADMOB ADS IDS======================
    private String admobInterstitial;
    private String admobRewardVideo;
    private String admobBannerSmall;
    private String admobBannerMedium;
    private String admobBannerLarge;
    //=========================ADMOB ADS IDS======================
    private static AdsConfiguration adsConfiguration;

    public static AdsConfiguration getInstance() {
        if (adsConfiguration == null)
            adsConfiguration = new AdsConfiguration();
        return adsConfiguration;
    }

    private AdsConfiguration() {

    }


    public boolean isBannerEnabled() {
        return isBannerEnabled;
    }

    public void setBannerEnabled(boolean bannerEnabled) {
        isBannerEnabled = bannerEnabled;
    }

    public boolean isBannerMediumEnabled() {
        return isBannerMediumEnabled;
    }

    public void setBannerMediumEnabled(boolean bannerMediumEnabled) {
        isBannerMediumEnabled = bannerMediumEnabled;
    }

    public boolean isBannerSmallEnabled() {
        return isBannerSmallEnabled;
    }

    public void setBannerSmallEnabled(boolean bannerSmallEnabled) {
        isBannerSmallEnabled = bannerSmallEnabled;
    }

    public boolean isBannerLargeEnabled() {
        return isBannerLargeEnabled;
    }

    public void setBannerLargeEnabled(boolean bannerLargeEnabled) {
        isBannerLargeEnabled = bannerLargeEnabled;
    }

    public boolean isBannerHouseEnabled() {
        return isBannerHouseEnabled;
    }

    public void setBannerHouseEnabled(boolean bannerHouseEnabled) {
        isBannerHouseEnabled = bannerHouseEnabled;
    }

    public boolean isFullAdsEnabled() {
        return isFullAdsEnabled;
    }

    public void setFullAdsEnabled(boolean fullAdsEnabled) {
        isFullAdsEnabled = fullAdsEnabled;
    }

    public boolean isFullAdsProviderEnabled() {
        return isFullAdsProviderEnabled;
    }

    public void setFullAdsProviderEnabled(boolean fullAdsProviderEnabled) {
        isFullAdsProviderEnabled = fullAdsProviderEnabled;
    }

    public int getCountNavigationFullAds() {
        return countNavigationFullAds;
    }

    public void setCountNavigationFullAds(int countNavigationFullAds) {
        this.countNavigationFullAds = countNavigationFullAds;
    }

    public boolean isEntryAdsEnabled() {
        return isEntryAdsEnabled;
    }

    public void setEntryAdsEnabled(boolean entryAdsEnabled) {
        isEntryAdsEnabled = entryAdsEnabled;
    }

    public HouseAdsEntity getJsonHouseAds() {
        HouseAdsEntity houseAdsEntity = null;
        try {
            houseAdsEntity = new Gson().fromJson(jsonHouseAds, HouseAdsEntity.class);
        } catch (Exception e) {
        }

        return houseAdsEntity;
    }

    public void setJsonHouseAds(String jsonHouseAds) {
        this.jsonHouseAds = jsonHouseAds;
    }


    public boolean isVideoAdsEnabled() {
        return isVideoAdsEnabled;
    }

    public void setVideoAdsEnabled(boolean videoAdsEnabled) {
        isVideoAdsEnabled = videoAdsEnabled;
    }

    public String getUpdateApp() {
        return updateApp;
    }

    public void setUpdateApp(String updateApp) {
        this.updateApp = updateApp;
    }

    public int getCountNavigationEntryAds() {
        return countNavigationEntryAds;
    }

    public void setCountNavigationEntryAds(int countNavigationEntryAds) {
        this.countNavigationEntryAds = countNavigationEntryAds;
    }

    public boolean isEntryHouseEnabled() {
        return isEntryHouseEnabled;
    }

    public void setEntryHouseEnabled(boolean entryHouseEnabled) {
        isEntryHouseEnabled = entryHouseEnabled;
    }

    public boolean isEntryFullAdsEnabled() {
        return isEntryFullAdsEnabled;
    }

    public void setEntryFullAdsEnabled(boolean entryFullAdsEnabled) {
        isEntryFullAdsEnabled = entryFullAdsEnabled;
    }

    public String getAdmobInterstitial() {
        return admobInterstitial;
    }

    public void setAdmobInterstitial(String admobInterstitial) {
        this.admobInterstitial = admobInterstitial;
    }

    public String getAdmobRewardVideo() {
        return admobRewardVideo;
    }

    public void setAdmobRewardVideo(String admobRewardVideo) {
        this.admobRewardVideo = admobRewardVideo;
    }

    public String getAdmobBannerSmall() {
        return admobBannerSmall;
    }

    public void setAdmobBannerSmall(String admobBannerSmall) {
        this.admobBannerSmall = admobBannerSmall;
    }

    public String getAdmobBannerMedium() {
        return admobBannerMedium;
    }

    public void setAdmobBannerMedium(String admobBannerMedium) {
        this.admobBannerMedium = admobBannerMedium;
    }

    public String getAdmobBannerLarge() {
        return admobBannerLarge;
    }

    public void setAdmobBannerLarge(String admobBannerLarge) {
        this.admobBannerLarge = admobBannerLarge;
    }
}
