/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.message;

import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.ldap.common.message.Message;
import org.apache.ldap.common.message.MessageException;
import org.apache.ldap.common.message.spi.EncoderSpi;
import org.apache.ldap.common.message.spi.Provider;
import org.apache.ldap.common.message.spi.TransformerSpi;

public final class MessageEncoder {
    private final Properties m_env;
    private final Provider m_provider;
    private final EncoderSpi m_encoder;
    private final TransformerSpi m_transformer;

    public MessageEncoder() throws MessageException {
        this(Provider.getEnvironment());
    }

    public MessageEncoder(Properties a_env) throws MessageException {
        this.m_env = (Properties)((Hashtable)a_env).clone();
        this.m_provider = Provider.getProvider(this.m_env);
        this.m_encoder = this.m_provider.getEncoder();
        this.m_transformer = this.m_provider.getTransformer();
    }

    public void encode(Object a_lock, OutputStream a_out, Message a_msg) throws MessageException {
        a_msg.setLocked(true);
        Object l_providerEnvelope = this.m_transformer.transform(a_msg);
        this.m_encoder.encode(a_lock, a_out, l_providerEnvelope);
    }

    public byte[] encode(Message a_msg) throws MessageException {
        a_msg.setLocked(true);
        Object l_providerEnvelope = this.m_transformer.transform(a_msg);
        return this.m_encoder.encode(l_providerEnvelope);
    }
}

