/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.common.message;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.DirContext;
import org.apache.ldap.common.AbstractLockable;
import org.apache.ldap.common.Lockable;
import org.apache.ldap.common.message.IteratorNamingEnumeration;
import org.apache.ldap.common.message.LockableAttribute;

public class LockableAttributeImpl
extends AbstractLockable
implements LockableAttribute {
    private final String m_id;
    private final ArrayList m_list;

    public LockableAttributeImpl(Lockable a_parent, String a_id) {
        super(a_parent, false);
        this.m_id = a_id;
        this.m_list = new ArrayList();
    }

    public LockableAttributeImpl(String a_id) {
        super(false);
        this.m_id = a_id;
        this.m_list = new ArrayList();
    }

    private LockableAttributeImpl(Lockable a_parent, String a_id, ArrayList a_list) {
        super(a_parent, false);
        this.m_id = a_id;
        this.m_list = a_list;
    }

    private LockableAttributeImpl(String a_id, ArrayList a_list) {
        super(false);
        this.m_id = a_id;
        this.m_list = a_list;
    }

    public NamingEnumeration getAll() {
        return new IteratorNamingEnumeration(((AbstractList)this.m_list).iterator());
    }

    public Object get() {
        if (this.m_list.isEmpty()) {
            return null;
        }
        return this.m_list.get(0);
    }

    public int size() {
        return this.m_list.size();
    }

    public String getID() {
        return this.m_id;
    }

    public boolean contains(Object a_attrVal) {
        return this.m_list.contains(a_attrVal);
    }

    public boolean add(Object a_attrVal) {
        super.lockCheck("Attempt to add value to locked Attribute!");
        return this.m_list.add(a_attrVal);
    }

    public boolean remove(Object a_attrVal) {
        super.lockCheck("Attempt to remove value from locked Attribute!");
        return ((AbstractCollection)this.m_list).remove(a_attrVal);
    }

    public void clear() {
        super.lockCheck("Attempt to clear values from locked Attribute!");
        this.m_list.clear();
    }

    public DirContext getAttributeSyntaxDefinition() throws NamingException {
        throw new OperationNotSupportedException("Extending subclasses may override this if they like!");
    }

    public DirContext getAttributeDefinition() throws NamingException {
        throw new OperationNotSupportedException("Extending subclasses may override this if they like!");
    }

    public Object clone() {
        ArrayList l_list = (ArrayList)this.m_list.clone();
        if (this.getParent() != null) {
            return new LockableAttributeImpl(this.getParent(), this.m_id, l_list);
        }
        return new LockableAttributeImpl(this.m_id, l_list);
    }

    public boolean isOrdered() {
        return true;
    }

    public Object get(int a_index) {
        return this.m_list.get(a_index);
    }

    public Object remove(int a_index) {
        super.lockCheck("Attempt to remove value from locked Attribute!");
        return this.m_list.remove(a_index);
    }

    public void add(int a_index, Object a_attrVal) {
        super.lockCheck("Attempt to add value to locked Attribute!");
        this.m_list.add(a_index, a_attrVal);
    }

    public Object set(int a_index, Object a_attrVal) {
        super.lockCheck("Attempt to set value in locked Attribute!");
        return this.m_list.set(a_index, a_attrVal);
    }
}

