package com.kevin.lib.quickble;

import android.app.Activity;
import android.app.Application;
import android.app.Fragment;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.util.Log;

import com.clj.fastble.BleManager;
import com.kevin.lib.quickble.callback.BleCallback;

/**
 * @author HeQinfu
 */

public class Ble {

    private static Ble singleton = SingletonHolder.instance;
    private static final String TAG = "Ble";
    private BleService mService = new BleService();
    private Config mConfig;

    private Ble() {
    }

    public void init(Config config) {
        if (this.mConfig != null)
            return;
        this.mConfig = config;
        mService.setFilterDuplicate(config.isFilterDuplicate);
        BleManager.getInstance().init(config.app);
        BleManager.getInstance()
                .setMaxConnectCount(config.maxConnectCount)
                .setOperateTimeout(config.operateTimeOut);
    }

    public static BleRequestHandler handler() {
        if (singleton.mConfig == null) {
            throw new NullPointerException("Ble is not init yet!");
        }
        return singleton.mService.handler();
    }


    public static void registerCallback(BleCallback callback) {
        singleton.mService.addBleCallback(callback);
    }

    public static void unregisterCallback(BleCallback callback) {
        singleton.mService.removeCallback(callback);
    }

    public static Ble get() {
        return singleton;
    }

    private static class SingletonHolder {
        private static final Ble instance = new Ble();
    }


    public static class Config {
        private int operateTimeOut = 5000;
        private int maxConnectCount = 7;
        private boolean isFilterDuplicate = false;
        private Application app;


        public Config maxConnection(int max) {
            this.maxConnectCount = max;
            return this;
        }

        public Config timeout(int millisecond) {
            this.operateTimeOut = millisecond;
            return this;
        }

        public Config isFilter(boolean isFilterDuplicate) {
            this.isFilterDuplicate = isFilterDuplicate;
            return this;
        }

        public Config(Application app) {
            this.app = app;
        }
    }


}

