package justbucket.familiar.extension.model

import justbucket.familiar.extension.image.ImageProvider

/**
 * An extendable model for master view
 * It is highly advised to override [equals]/[hashCode] in your subclass
 *
 * @constructor creates an instance of [DetailModel]
 * @property id should not be assigned
 * @property extensionName name of extension
 * @property imageProvider used to provide model image
 * @property title content title
 * @property description content description
 * @property detailViewLink url to detail information
 *
 * @author JustBucket on 2019-07-22
 */
open class MasterModel(
    val id: Long,
    val extensionName: String = "",
    val imageProvider: ImageProvider? = null,
    val title: String = "",
    val description: String = "",
    val detailViewLink: String? = null
)