package justbucket.familiar.extension.image

import android.graphics.Bitmap
import android.graphics.drawable.Drawable
import android.net.Uri
import androidx.annotation.DrawableRes
import java.io.File

/**
 * Image loading helper class
 */
sealed class ImageProvider

class StringAsImageProvider(val path: String) : ImageProvider()

class UriAsImageProvider(val uri: Uri) : ImageProvider()

class BitmapAsImageProvider(val bitmap: Bitmap) : ImageProvider()

class DrawableAsImageProvider(val drawable: Drawable) : ImageProvider()

class FileAsImageProvider(val file: File) : ImageProvider()

class ResourceIdAsImageProvider(@DrawableRes val resId: Int) : ImageProvider()

class ByteArrayAsImageProvider(val byteArray: ByteArray) : ImageProvider()
