/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.components;

import com.sun.faces.components.ProcessingContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessingContextViewRoot
extends UIViewRoot {
    private transient DelegateRootIterator delegateRootIter = null;
    private transient List<ProcessingContext> processingContexts;
    public static final String PROCESSING_CONTEXTS_REQUEST_PARAM_NAME = "com.sun.faces.PCtxt";

    public String getRendererType() {
        return "javax.faces.ViewRoot";
    }

    public List<ProcessingContext> getProcessingContexts() {
        String param = null;
        String[] pcs = null;
        Map requestMap = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap();
        if (null != this.processingContexts) {
            return this.processingContexts;
        }
        if (!requestMap.containsKey(PROCESSING_CONTEXTS_REQUEST_PARAM_NAME)) {
            return null;
        }
        this.processingContexts = new ArrayList<ProcessingContext>();
        param = requestMap.get(PROCESSING_CONTEXTS_REQUEST_PARAM_NAME).toString();
        pcs = param.split(",[ \t]*");
        if (null != pcs) {
            for (String cur : pcs) {
                if (!(cur = cur.trim()).startsWith(":")) continue;
                this.processingContexts.add(new ProcessingContext(cur.trim()));
            }
        }
        if (0 == this.processingContexts.size()) {
            this.processingContexts = null;
        }
        return this.processingContexts;
    }

    public void setProcessingContexts(List<ProcessingContext> processingContexts) {
        this.processingContexts = processingContexts;
    }

    private static UIComponent findProcessingContextComponent(UIComponent component, String pcId) {
        String[] componentIds = null;
        String curId = null;
        UIComponent result = component;
        for (String curPcId : componentIds = pcId.split(":")) {
            curId = result.getId();
            if (null != curId && curPcId.equals(curId)) {
                result = component;
                break;
            }
            UIComponent facet = null;
            facet = (UIComponent)result.getFacets().get(curPcId);
            if (null != facet) {
                result = facet;
                continue;
            }
            List children = result.getChildren();
            if (0 < children.size()) {
                UIComponent child;
                Iterator i$ = children.iterator();
                while (i$.hasNext() && null == (result = ProcessingContextViewRoot.findProcessingContextComponent(child = (UIComponent)i$.next(), curPcId))) {
                }
                continue;
            }
            result = null;
        }
        return result;
    }

    private List<UIComponent> getDelegateRoots() {
        UIComponent cur = null;
        String pcClientId = null;
        ArrayList<UIComponent> delegateRoots = new ArrayList<UIComponent>();
        List<ProcessingContext> pcs = this.getProcessingContexts();
        if (null == pcs) {
            return null;
        }
        Iterator<ProcessingContext> pcIter = pcs.iterator();
        while (pcIter.hasNext()) {
            pcClientId = pcIter.next().getClientId();
            assert (pcClientId.startsWith(":"));
            cur = ProcessingContextViewRoot.findProcessingContextComponent((UIComponent)this, pcClientId = pcClientId.substring(1));
            if (null == cur) continue;
            delegateRoots.add(cur);
        }
        return delegateRoots;
    }

    public Iterator<UIComponent> getFacetsAndChildren() {
        if (null == this.getProcessingContexts()) {
            return super.getFacetsAndChildren();
        }
        if (null == this.delegateRootIter) {
            this.delegateRootIter = new DelegateRootIterator();
            List<UIComponent> roots = this.getDelegateRoots();
            this.delegateRootIter.setRoots(roots);
        } else {
            this.delegateRootIter.reset();
        }
        assert (null != this.delegateRootIter);
        return this.delegateRootIter;
    }

    public void encodeAll(FacesContext context) throws IOException {
        List<UIComponent> roots = this.getDelegateRoots();
        if (null == roots) {
            super.encodeAll(context);
        } else {
            ExternalContext extContext = context.getExternalContext();
            if (extContext.getResponse() instanceof HttpServletResponse) {
                HttpServletResponse servletResponse = (HttpServletResponse)extContext.getResponse();
                servletResponse.setContentType("text/xml");
                servletResponse.setHeader("Cache-Control", "no-cache");
            }
            ResponseWriter responseWriter = context.getResponseWriter();
            responseWriter.startElement("processing-context-responses", (UIComponent)this);
            for (UIComponent curRoot : roots) {
                responseWriter.startElement("processing-context", curRoot);
                responseWriter.writeAttribute("id", (Object)curRoot.getClientId(context), "clientId");
                responseWriter.write("<![CDATA[");
                curRoot.encodeAll(context);
                responseWriter.write("]]>");
                responseWriter.endElement("processing-context");
            }
            responseWriter.endElement("processing-context-responses");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DelegateRootIterator
    implements Iterator<UIComponent> {
        private Iterator<UIComponent> curIter = null;
        private List<UIComponent> roots = null;
        private Iterator<UIComponent> rootsIter = null;

        DelegateRootIterator() {
        }

        public void setRoots(List<UIComponent> roots) {
            this.roots = roots;
            this.rootsIter = roots.iterator();
        }

        public void reset() {
            this.curIter = null;
            assert (null != this.roots);
            this.rootsIter = this.roots.iterator();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UIComponent next() {
            UIComponent result = null;
            if (this.hasNext()) {
                assert (null != this.curIter);
                result = this.curIter.next();
            }
            return result;
        }

        @Override
        public boolean hasNext() {
            boolean result = false;
            if (null == this.curIter && this.rootsIter.hasNext()) {
                this.curIter = this.rootsIter.next().getFacetsAndChildren();
            }
            if (null != this.curIter && !(result = this.curIter.hasNext())) {
                this.curIter = null;
                result = this.hasNext();
            }
            return result;
        }
    }
}

