package jonmerritt.optimalzoopertemplate;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import java.io.FileNotFoundException;

/**
 *
 * Original Code BY: Zooper Widget Pro/MyColorScreen
 * Modified BY: Jonathan Merritt.
 *
 * ContentProvider for Zooper.
 * Will make most assets available to Zooper.
 *
 */

@SuppressWarnings("ConstantConditions")
public class OZTBContentProvider extends ContentProvider {
    private static final String CURSOR_STRING_DESC = "string";
    private static final int CURSOR_STRING_INT = 1;

    @Override
    public boolean onCreate() {
        return false;
    }

    @Nullable
    @Override
    public Cursor query(@NonNull Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        MatrixCursor cursor = new MatrixCursor(new String[]{CURSOR_STRING_DESC});
        try {
            final String path = uri.getPath().substring(CURSOR_STRING_INT);
            for (String s : this.getContext().getApplicationContext().getAssets().list(path)) {
                cursor.newRow().add(s);
                cursor.moveToNext();
            }
            cursor.moveToFirst();
            Looper.prepare();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return cursor;
    }

    @Nullable
    public AssetFileDescriptor openAssetFile(@NonNull Uri uri, @NonNull String paramString) throws FileNotFoundException {
        if (uri.getPathSegments().size() > 0)
            try {
                final String name = uri.getPath().substring(CURSOR_STRING_INT);
                return this.getContext().getApplicationContext().getAssets().openFd(name);
            } catch (Throwable t) {
                t.printStackTrace();
                return null;
            }
        return null;
    }

    @Nullable
    @Override
    public String getType(@NonNull Uri uri) {
        return null;
    }

    @Nullable
    @Override
    public Uri insert(@NonNull Uri uri, ContentValues values) {
        return null;
    }

    @Override
    public int delete(@NonNull Uri uri, String selection, String[] selectionArgs) {
        return 0;
    }

    @Override
    public int update(@NonNull Uri uri, ContentValues values, String selection, String[] selectionArgs) {return 0;}
}
