/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.contrib.hibernate;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.Type;
import org.hibernate.usertype.CompositeUserType;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.contrib.hibernate.PersistentDateTime;

public class PersistentInterval
implements CompositeUserType {
    private static final String[] PROPERTY_NAMES = new String[]{"start", "end"};
    private static final Type[] TYPES = new Type[]{Hibernate.TIMESTAMP, Hibernate.TIMESTAMP};
    static /* synthetic */ Class class$org$joda$time$Interval;

    public Object assemble(Serializable cached, SessionImplementor session, Object owner) throws HibernateException {
        return cached;
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public Serializable disassemble(Object value, SessionImplementor session) throws HibernateException {
        return (Serializable)value;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        return x.equals(y);
    }

    public String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }

    public Type[] getPropertyTypes() {
        return TYPES;
    }

    public Object getPropertyValue(Object component, int property) throws HibernateException {
        Interval interval = (Interval)component;
        return property == 0 ? interval.getStart().toDate() : interval.getEnd().toDate();
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public boolean isMutable() {
        return false;
    }

    public Object nullSafeGet(ResultSet resultSet, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        if (resultSet == null) {
            return null;
        }
        PersistentDateTime pst = new PersistentDateTime();
        DateTime start = (DateTime)pst.nullSafeGet(resultSet, names[0]);
        DateTime end = (DateTime)pst.nullSafeGet(resultSet, names[1]);
        return new Interval((ReadableInstant)start, (ReadableInstant)end);
    }

    public void nullSafeSet(PreparedStatement statement, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        if (value == null) {
            statement.setNull(index, Hibernate.TIMESTAMP.sqlType());
            statement.setNull(index + 1, Hibernate.TIMESTAMP.sqlType());
            return;
        }
        Interval interval = (Interval)value;
        statement.setTimestamp(index, this.asTimeStamp(interval.getStart()));
        statement.setTimestamp(index + 1, this.asTimeStamp(interval.getEnd()));
    }

    private Timestamp asTimeStamp(DateTime time) {
        return new Timestamp(time.getMillis());
    }

    public Object replace(Object original, Object target, SessionImplementor session, Object owner) throws HibernateException {
        return original;
    }

    public Class returnedClass() {
        return class$org$joda$time$Interval == null ? (class$org$joda$time$Interval = PersistentInterval.class$("org.joda.time.Interval")) : class$org$joda$time$Interval;
    }

    public void setPropertyValue(Object component, int property, Object value) throws HibernateException {
        throw new UnsupportedOperationException("Immutable Interval");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

