/*
 * Decompiled with CFR 0.152.
 */
package jmfayard.github.io;

import com.squareup.kotlinpoet.FileSpec;
import com.squareup.moshi.JsonAdapter;
import java.io.File;
import java.util.List;
import jmfayard.github.io.Dependency;
import jmfayard.github.io.DependencyGraph;
import jmfayard.github.io.KotlinPoetry;
import jmfayard.github.io.KotlinPoetryKt;
import jmfayard.github.io.SyncLibsTask;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import okio.Okio;
import okio.Source;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0010H\u0007R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Ljmfayard/github/io/SyncLibsTask;", "Lorg/gradle/api/DefaultTask;", "()V", "jsonInputPath", "", "getJsonInputPath", "()Ljava/lang/String;", "setJsonInputPath", "(Ljava/lang/String;)V", "outputDir", "Ljava/io/File;", "getOutputDir", "()Ljava/io/File;", "setOutputDir", "(Ljava/io/File;)V", "createBasicStructureIfNeeded", "", "taskAction", "Companion", "gradle-kotlin-dsl-libs"})
public class SyncLibsTask
extends DefaultTask {
    @NotNull
    private String jsonInputPath;
    @NotNull
    private File outputDir;
    @NotNull
    private static final Lazy moshiAdapter$delegate;
    public static final Companion Companion;

    @NotNull
    public final String getJsonInputPath() {
        return this.jsonInputPath;
    }

    public final void setJsonInputPath(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.jsonInputPath = string;
    }

    @NotNull
    public final File getOutputDir() {
        return this.outputDir;
    }

    public final void setOutputDir(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"<set-?>");
        this.outputDir = file;
    }

    @TaskAction
    public final void taskAction() {
        File jsonInput = this.getProject().file((Object)this.jsonInputPath);
        File file = this.outputDir;
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"outputDir");
        File outputFile = FilesKt.resolve((File)file, (String)(KotlinPoetryKt.getLibsClassName() + ".kt"));
        boolean fileExisted = outputFile.canRead();
        File file2 = jsonInput;
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"jsonInput");
        String string = KotlinPoetryKt.helpMessageBefore(file2);
        System.out.println((Object)string);
        this.createBasicStructureIfNeeded();
        DependencyGraph dependencyGraph = Companion.readGraphFromJsonFile(jsonInput);
        List<Dependency> dependencies = KotlinPoetryKt.parseGraph(Companion, dependencyGraph);
        KotlinPoetry kotlinPoetry = KotlinPoetryKt.kotlinpoet(dependencies, dependencyGraph.getGradle());
        FileSpec fileSpec = kotlinPoetry.getLibs();
        File file3 = this.outputDir;
        Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"outputDir");
        fileSpec.writeTo(file3);
        FileSpec fileSpec2 = kotlinPoetry.getVersions();
        File file4 = this.outputDir;
        Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"outputDir");
        fileSpec2.writeTo(file4);
        String string2 = KotlinPoetryKt.helpMessageAfter(fileExisted, dependencies, outputFile);
        System.out.println((Object)string2);
    }

    public final void createBasicStructureIfNeeded() {
        File gitIgnore;
        File settingsGradleKts;
        File buildGradleKts;
        File file = this.outputDir;
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"outputDir");
        if (!file.isDirectory()) {
            this.outputDir.mkdirs();
        }
        if (!(buildGradleKts = this.getProject().file((Object)"buildSrc/build.gradle.kts")).exists()) {
            StringBuilder stringBuilder = new StringBuilder().append("Creating ");
            File file2 = buildGradleKts;
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"buildGradleKts");
            String string = stringBuilder.append(file2.getAbsolutePath()).toString();
            System.out.println((Object)string);
            FilesKt.writeText$default((File)buildGradleKts, (String)"\nplugins {\n    `kotlin-dsl`\n}\nrepositories {\n    jcenter()\n}\n        ", null, (int)2, null);
        }
        if (!(settingsGradleKts = this.getProject().file((Object)"buildSrc/settings.gradle.kts")).exists()) {
            StringBuilder stringBuilder = new StringBuilder().append("Creating empty ");
            File file3 = settingsGradleKts;
            Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"settingsGradleKts");
            String string = stringBuilder.append(file3.getAbsolutePath()).toString();
            System.out.println((Object)string);
            FilesKt.writeText$default((File)settingsGradleKts, (String)"", null, (int)2, null);
        }
        if (!(gitIgnore = this.getProject().file((Object)"buildSrc/.gitignore")).exists()) {
            File file4 = gitIgnore;
            Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"gitIgnore");
            FilesKt.writeText$default((File)file4, (String)KotlinPoetryKt.getGITIGNORE(), null, (int)2, null);
        }
    }

    public SyncLibsTask() {
        this.setDescription("Update buildSrc/src/main/kotlin/Libs.kt");
        this.setGroup("build");
        this.jsonInputPath = "build/dependencyUpdates/report.json";
        this.outputDir = this.getProject().file((Object)"buildSrc/src/main/kotlin");
    }

    static {
        Companion = new Companion(null);
        moshiAdapter$delegate = LazyKt.lazy((Function0)Companion.moshiAdapter.2.INSTANCE);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fR!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Ljmfayard/github/io/SyncLibsTask$Companion;", "", "()V", "moshiAdapter", "Lcom/squareup/moshi/JsonAdapter;", "Ljmfayard/github/io/DependencyGraph;", "getMoshiAdapter", "()Lcom/squareup/moshi/JsonAdapter;", "moshiAdapter$delegate", "Lkotlin/Lazy;", "readGraphFromJsonFile", "jsonInput", "Ljava/io/File;", "gradle-kotlin-dsl-libs"})
    public static final class Companion {
        static final /* synthetic */ KProperty[] $$delegatedProperties;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "moshiAdapter", "getMoshiAdapter()Lcom/squareup/moshi/JsonAdapter;"))};
        }

        @NotNull
        public final JsonAdapter<DependencyGraph> getMoshiAdapter() {
            Lazy lazy = moshiAdapter$delegate;
            Companion companion = this;
            KProperty kProperty = $$delegatedProperties[0];
            return (JsonAdapter)lazy.getValue();
        }

        @NotNull
        public final DependencyGraph readGraphFromJsonFile(@NotNull File jsonInput) {
            Intrinsics.checkParameterIsNotNull((Object)jsonInput, (String)"jsonInput");
            Object object = this.getMoshiAdapter().fromJson(Okio.buffer((Source)Okio.source((File)jsonInput)));
            if (object == null) {
                Intrinsics.throwNpe();
            }
            return (DependencyGraph)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

