/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.provider;

import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

public class ProviderManager {
    private static Map extensionProviders = new Hashtable();
    private static Map iqProviders = new Hashtable();
    static /* synthetic */ Class class$org$jivesoftware$smack$provider$IQProvider;
    static /* synthetic */ Class class$org$jivesoftware$smack$packet$IQ;
    static /* synthetic */ Class class$org$jivesoftware$smack$provider$PacketExtensionProvider;
    static /* synthetic */ Class class$org$jivesoftware$smack$packet$PacketExtension;

    public static Object getIQProvider(String elementName, String namespace) {
        String key = ProviderManager.getProviderKey(elementName, namespace);
        return iqProviders.get(key);
    }

    public static Iterator getIQProviders() {
        return Collections.unmodifiableCollection(new HashMap(iqProviders).values()).iterator();
    }

    public static void addIQProvider(String elementName, String namespace, Object provider) {
        if (!(provider instanceof IQProvider || provider instanceof Class && (class$org$jivesoftware$smack$packet$IQ == null ? (class$org$jivesoftware$smack$packet$IQ = ProviderManager.class$("org.jivesoftware.smack.packet.IQ")) : class$org$jivesoftware$smack$packet$IQ).isAssignableFrom((Class)provider))) {
            throw new IllegalArgumentException("Provider must be an IQProvider or a Class instance.");
        }
        String key = ProviderManager.getProviderKey(elementName, namespace);
        iqProviders.put(key, provider);
    }

    public static Object getExtensionProvider(String elementName, String namespace) {
        String key = ProviderManager.getProviderKey(elementName, namespace);
        return extensionProviders.get(key);
    }

    public static void addExtensionProvider(String elementName, String namespace, Object provider) {
        if (!(provider instanceof PacketExtensionProvider) && !(provider instanceof Class)) {
            throw new IllegalArgumentException("Provider must be a PacketExtensionProvider or a Class instance.");
        }
        String key = ProviderManager.getProviderKey(elementName, namespace);
        extensionProviders.put(key, provider);
    }

    public static Iterator getExtensionProviders() {
        return Collections.unmodifiableCollection(new HashMap(extensionProviders).values()).iterator();
    }

    private static String getProviderKey(String elementName, String namespace) {
        StringBuffer buf = new StringBuffer();
        buf.append("<").append(elementName).append("/><").append(namespace).append("/>");
        return buf.toString();
    }

    private static ClassLoader[] getClassLoaders() {
        ClassLoader[] classLoaders = new ClassLoader[]{new ProviderManager().getClass().getClassLoader(), Thread.currentThread().getContextClassLoader(), ClassLoader.getSystemClassLoader()};
        return classLoaders;
    }

    private ProviderManager() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        try {
            ClassLoader[] classLoaders = ProviderManager.getClassLoaders();
            for (int i = 0; i < classLoaders.length; ++i) {
                Enumeration<URL> providerEnum = classLoaders[i].getResources("META-INF/smack.providers");
                while (providerEnum.hasMoreElements()) {
                    URL url = providerEnum.nextElement();
                    InputStream providerStream = null;
                    try {
                        providerStream = url.openStream();
                        XmlPullParserFactory factory = XmlPullParserFactory.newInstance("org.xmlpull.mxp1.MXParserFactory", null);
                        factory.setNamespaceAware(true);
                        XmlPullParser parser = factory.newPullParser();
                        parser.setInput(providerStream, "UTF-8");
                        int eventType = parser.getEventType();
                        do {
                            Class<?> provider;
                            String key;
                            String className;
                            String namespace;
                            String elementName;
                            if (eventType != 2) continue;
                            if (parser.getName().equals("iqProvider")) {
                                parser.next();
                                parser.next();
                                elementName = parser.nextText();
                                parser.next();
                                parser.next();
                                namespace = parser.nextText();
                                parser.next();
                                parser.next();
                                className = parser.nextText();
                                key = ProviderManager.getProviderKey(elementName, namespace);
                                if (iqProviders.containsKey(key)) continue;
                                try {
                                    provider = Class.forName(className);
                                    if ((class$org$jivesoftware$smack$provider$IQProvider == null ? ProviderManager.class$("org.jivesoftware.smack.provider.IQProvider") : class$org$jivesoftware$smack$provider$IQProvider).isAssignableFrom(provider)) {
                                        iqProviders.put(key, provider.newInstance());
                                        continue;
                                    }
                                    if (!(class$org$jivesoftware$smack$packet$IQ == null ? ProviderManager.class$("org.jivesoftware.smack.packet.IQ") : class$org$jivesoftware$smack$packet$IQ).isAssignableFrom(provider)) continue;
                                    iqProviders.put(key, provider);
                                }
                                catch (ClassNotFoundException cnfe) {
                                    cnfe.printStackTrace();
                                }
                                continue;
                            }
                            if (!parser.getName().equals("extensionProvider")) continue;
                            parser.next();
                            parser.next();
                            elementName = parser.nextText();
                            parser.next();
                            parser.next();
                            namespace = parser.nextText();
                            parser.next();
                            parser.next();
                            className = parser.nextText();
                            key = ProviderManager.getProviderKey(elementName, namespace);
                            if (extensionProviders.containsKey(key)) continue;
                            try {
                                provider = Class.forName(className);
                                if ((class$org$jivesoftware$smack$provider$PacketExtensionProvider == null ? ProviderManager.class$("org.jivesoftware.smack.provider.PacketExtensionProvider") : class$org$jivesoftware$smack$provider$PacketExtensionProvider).isAssignableFrom(provider)) {
                                    extensionProviders.put(key, provider.newInstance());
                                    continue;
                                }
                                if (!(class$org$jivesoftware$smack$packet$PacketExtension == null ? ProviderManager.class$("org.jivesoftware.smack.packet.PacketExtension") : class$org$jivesoftware$smack$packet$PacketExtension).isAssignableFrom(provider)) continue;
                                extensionProviders.put(key, provider);
                            }
                            catch (ClassNotFoundException cnfe) {
                                cnfe.printStackTrace();
                            }
                        } while ((eventType = parser.next()) != 1);
                    }
                    finally {
                        try {
                            providerStream.close();
                        }
                        catch (Exception e) {}
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

