/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.detection.unreliable.slave;

import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnreliableSlaveDetection
implements Describable<UnreliableSlaveDetection> {
    private InternetAddress[] addresses;
    private int numberOfFailureInRow;

    public UnreliableSlaveDetection(String addresses, int numberOfFailureInRow) {
        this.parseAddresses(addresses);
        this.numberOfFailureInRow = numberOfFailureInRow;
    }

    @DataBoundConstructor
    public UnreliableSlaveDetection(String addresses, int tmpLow, int workspaceLow, int numberOfFailureInRow) {
        this.parseAddresses(addresses);
        this.numberOfFailureInRow = numberOfFailureInRow;
    }

    public UnreliableSlaveDetection() {
    }

    private boolean parseAddresses(String token) {
        try {
            this.addresses = InternetAddress.parse((String)token);
            return true;
        }
        catch (AddressException e) {
            return false;
        }
    }

    public InternetAddress[] getRecipientAddresses() {
        return this.addresses;
    }

    public String getAddresses() {
        StringBuilder builder = new StringBuilder();
        for (InternetAddress address : this.addresses) {
            builder.append(address.getAddress());
            builder.append(", ");
        }
        builder.deleteCharAt(builder.lastIndexOf(","));
        return builder.toString();
    }

    public int getNumberOfFailureInRow() {
        return this.numberOfFailureInRow;
    }

    public Descriptor<UnreliableSlaveDetection> getDescriptor() {
        return new DescriptorImpl();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<UnreliableSlaveDetection> {
        private UnreliableSlaveDetection settings = new UnreliableSlaveDetection();

        public DescriptorImpl() {
            this.load();
        }

        public UnreliableSlaveDetection getSettings() {
            return this.settings;
        }

        public String getDisplayName() {
            return "Unreliable slave plugin";
        }

        public FormValidation doCheckAddresses(@QueryParameter String value) {
            if (this.settings.parseAddresses(value)) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)"Please enter valid address");
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.settings = (UnreliableSlaveDetection)req.bindJSON(UnreliableSlaveDetection.class, json);
            this.save();
            return true;
        }
    }
}

