/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.detection.unreliable.slave;

import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlaveBuildFailureStatistic {
    private String slaveName;
    private Map<String, String> failedJobsInRow = new TreeMap<String, String>();
    private boolean reconnectedAndNotSuccess;

    public SlaveBuildFailureStatistic(String slaveName) {
        this.slaveName = slaveName;
    }

    public void failure(String jobName, String buildUrl) {
        this.failedJobsInRow.put(jobName, buildUrl);
    }

    public Map<String, String> getFailedJobs() {
        return this.failedJobsInRow;
    }

    public String getSlaveName() {
        return this.slaveName;
    }

    public boolean equals(Object o) {
        if (o instanceof SlaveBuildFailureStatistic && o != null) {
            return ((SlaveBuildFailureStatistic)o).getSlaveName().equals(this.slaveName);
        }
        return false;
    }

    public boolean wasReconnected() {
        return this.reconnectedAndNotSuccess;
    }

    public int getNumberOfFailuresInRow() {
        return this.failedJobsInRow.keySet().size();
    }

    public void success() {
        this.resetStatistic();
        this.reconnectedAndNotSuccess = false;
    }

    public void putOffline() {
        this.resetStatistic();
        this.reconnectedAndNotSuccess = false;
    }

    public void reconnect() {
        this.resetStatistic();
        this.reconnectedAndNotSuccess = true;
    }

    protected void resetStatistic() {
        this.failedJobsInRow.clear();
    }
}

