/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.detection.unreliable.slave;

import hudson.model.Describable;
import hudson.model.Descriptor;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.jenkinsci.plugins.detection.unreliable.slave.UnreliableSlaveDetection;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnreliableSlaveDetection
implements Describable<UnreliableSlaveDetection> {
    private InternetAddress[] addresses;
    private int numberOfFailureInRow;

    public UnreliableSlaveDetection(String addresses, int numberOfFailureInRow) {
        this.parseAddresses(addresses);
        this.numberOfFailureInRow = numberOfFailureInRow;
    }

    @DataBoundConstructor
    public UnreliableSlaveDetection(String addresses, int tmpLow, int workspaceLow, int numberOfFailureInRow) {
        this.parseAddresses(addresses);
        this.numberOfFailureInRow = numberOfFailureInRow;
    }

    public UnreliableSlaveDetection() {
    }

    private boolean parseAddresses(String token) {
        try {
            this.addresses = InternetAddress.parse((String)token);
            return true;
        }
        catch (AddressException e) {
            return false;
        }
    }

    public InternetAddress[] getRecipientAddresses() {
        return this.addresses;
    }

    public String getAddresses() {
        StringBuilder builder = new StringBuilder();
        for (InternetAddress address : this.addresses) {
            builder.append(address.getAddress());
            builder.append(", ");
        }
        builder.deleteCharAt(builder.lastIndexOf(","));
        return builder.toString();
    }

    public int getNumberOfFailureInRow() {
        return this.numberOfFailureInRow;
    }

    public Descriptor<UnreliableSlaveDetection> getDescriptor() {
        return new DescriptorImpl();
    }

    static /* synthetic */ boolean access$000(UnreliableSlaveDetection x0, String x1) {
        return x0.parseAddresses(x1);
    }
}

