/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.mqttnotification;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import java.io.PrintStream;
import org.apache.commons.lang.StringUtils;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;
import org.kohsuke.stapler.DataBoundConstructor;

public class MqttNotifier
extends Notifier {
    private static final String CLIENT_ID = MqttNotifier.class.getSimpleName();
    private static final String DISPLAY_NAME = "MQTT Notification";
    private static final String DEFAULT_TOPIC = "jenkins/$PROJECT_URL";
    private static final String DEFAULT_MESSAGE = "$BUILD_RESULT";
    private final String brokerUrl;
    private final String topic;
    private final String message;
    private final String qos;
    private final boolean retainMessage;

    @DataBoundConstructor
    public MqttNotifier(String brokerUrl, String topic, String message, String qos, boolean retainMessage) {
        this.brokerUrl = brokerUrl;
        this.topic = topic;
        this.message = message;
        this.qos = qos;
        this.retainMessage = retainMessage;
    }

    public String getBrokerUrl() {
        return this.brokerUrl;
    }

    public String getTopic() {
        return StringUtils.isEmpty((String)this.topic) ? DEFAULT_TOPIC : this.topic;
    }

    public String getMessage() {
        return StringUtils.isEmpty((String)this.message) ? DEFAULT_MESSAGE : this.message;
    }

    public int getQos() {
        return Integer.valueOf(this.qos);
    }

    public boolean isRetainMessage() {
        return this.retainMessage;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        PrintStream logger = listener.getLogger();
        try {
            String tmpDir = System.getProperty("java.io.tmpdir");
            MqttDefaultFilePersistence dataStore = new MqttDefaultFilePersistence(tmpDir);
            MqttClient mqtt = new MqttClient(this.getBrokerUrl(), CLIENT_ID, (MqttClientPersistence)dataStore);
            mqtt.connect();
            mqtt.publish(this.replaceVariables(this.getTopic(), build), this.replaceVariables(this.getMessage(), build).getBytes(), this.getQos(), this.isRetainMessage());
            mqtt.disconnect();
        }
        catch (MqttException me) {
            logger.println("ERROR: Caught MqttException while configuring MQTT connection: " + me.getMessage());
            me.printStackTrace(logger);
        }
        return true;
    }

    private String replaceVariables(String rawString, AbstractBuild build) {
        String result = rawString.replaceAll("\\$PROJECT_URL", build.getProject().getUrl());
        result = result.replaceAll("\\$BUILD_RESULT", build.getResult().toString());
        if (rawString.contains("$CULPRITS")) {
            StringBuilder culprits = new StringBuilder();
            String delim = "";
            for (Object userObject : build.getCulprits()) {
                culprits.append(delim).append(userObject.toString());
                delim = ",";
            }
            result = result.replaceAll("\\$CULPRITS", culprits.toString());
        }
        return result;
    }

    static /* synthetic */ String access$000() {
        return CLIENT_ID;
    }
}

